/*
**	ssh_proto.h	-- protocol handshaking for ssh v1.5
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_PROTO_H
#define __SSH_PROTO_H

#include "ssh_types.h"

#define SSH_PROTO_SEP		"-"	/* Sep fields in protocol */
#define SSH_PROTO_MMSEP		"."	/* Sep Major and Minor nums */
#define SSH_PROTO_END		"\n"	/* End of Protocol Specs */

#define SSH_VERSION_LEN		40	/* Version String Length */
#define SSH_PROTOCOL_LEN	100	/* Protocol Length + extra */

#ifdef __cplusplus
extern "C" {
#endif


/*
**	Protocol, initial handshaking functions functions.  ssh_proto.c
*/
int ssh_proto_get(socket_type sockfd, struct ssh_struct * ssh_info,
	int * major, int * minor, char * version);
int ssh_proto_put(socket_type sockfd, struct ssh_struct * ssh_info,
	int major, int minor, const char * version);

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_PROTO_H */

