/*********************************************************************
**
**     File name:               ssh_util.c
**
**                              Copyright 1997 Tadayoshi Kohno.
**				All rights reserved.
**                              See the LICENSE file.
**
**     Purpose:                 utilities (my_bcopy, ...) that might not
**				exist on all architectures (Windows 95, ...)
**
**     Author/Date:             Tadayoshi Kohno, 18 November 1997
**
**     Notes:
**	Couldn't find there functinos under Visual C++ 5.0 (didn't look
**	*that* hard either).  Anyway, here are some nice utilities.
**
**	On Unix boxes, my_bzero is #defined to bzero.
**	This is kind of backwards and I should have just used bzero
**	everywhere and defined these bzero/bcopy functions if
**	bzero/bcopy didn't exist on the system.  Oh well.
**
**     Functions:
**	my_bzero		my version of bzero
**	my_bcopy		my version of becopy
**
*********************************************************************/

#ifndef lint
static char *RCSid="$Header: /home/kohno/LibSSH/libssh.0.0.1beta/libssh/RCS/ssh_util.c,v 1.2 1998/05/09 17:39:23 kohno Exp $";
#endif

#include "ssh_util.h"

/*
** only use these if we're on a Windows box
*/
#ifdef USE_MY_BCOPY
/*********************************************************************
**
**     Function:                my_bzero
**
**     Purpose:                 zeros out everything in *mem
**
**     Entry (pre) conditions:  memory for *mem allocated
**
**     Parameters:              * mem		memory to zero
**				count		length of mem
**
**     Side effects:            *mem will point to all zeros
**
**     Author/Date:             Tadayoshi Kohno, 18 November 1997
**
*********************************************************************/

void my_bzero
(
	void * mem,		/* memory to zero */
	int count		/* number of bytes to zero */
)
{
	int index;

	for (index = 0; index < count; index++)
	{
		((char *) mem)[index] = 0;
	}
}

/*********************************************************************
**
**     Function:                my_bcopy
**
**     Purpose:                 binary copy from *src to *dest
**
**     Entry (pre) conditions:  memory for *src, *dest valid
**
**     Parameters:              * src		src memory
**				* dest		dest memory
**				count		bytes to copy
**
**     Side effects:            count bytes of *src copied to *dest
**
**     Author/Date:             Tadayoshi Kohno, 18 November 1997
**
*********************************************************************/

void my_bcopy
(
	const void * src,	/* source pointer */
	void * dest,		/* destination pointer */
	int count		/* number of bytes to copy */
)
{
	int index;

	for (index = 0; index < count; index++)
	{
		((char *) dest)[index] = ((char *) src)[index];
	}
}

#endif	/* USE_MY_BCOPY */

