/*
** ssh_util.h	-- utilities header file.
**
**	Copyright 1997 Tadayoshi Kohno.  All rights reserved.
**		See the LICENSE file.
*/

#ifndef __SSH_UTIL_H
#define __SSH_UTIL_H

#include "ssh_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef USE_MY_BCOPY

void my_bzero(void * mem, int count);	/* overwrite memory with zeros */
void my_bcopy(const void * src, void * dest, int count);/* copy memory */

#else

#include <string.h>

/*
**	Use the real bzero and bcopy if they exist
*/
#define my_bzero	bzero
#define my_bcopy	bcopy

#endif	/* USE_MY_BCOPY */

#ifdef __cplusplus
}
#endif

#endif	/* __SSH_UTIL_H */

