/***********************************************************
Copyright 1991-1995 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior permission.

STICHTING MATHEMATISCH CENTRUM DISCLAIMS ALL WARRANTIES WITH REGARD TO
THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH CENTRUM BE LIABLE
FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include <Python.h>

static PyObject* ErrorObject;

static PyObject* error( const char* msg )
  {
  PyErr_SetString( ErrorObject, (char*)msg );
  return 0;
  }

/* File containing module implementation macros */
#include "SSLeay_impl.i"

/* ----------------------------------------------------- */
#ifndef SSLeay_newSSLctx_impl
static PyObject * SSLeay_newSSLctx_(PyObject *self, PyObject *args);
#endif
#ifndef SSLeay_fromfd_impl
static PyObject * SSLeay_fromfd_(PyObject *self, PyObject *args);
#endif
#ifndef SSLeay_SSL_impl
static PyObject * SSLeay_SSL_(PyObject *self, PyObject *args);
#endif
#ifndef SSLeay_set_verify_callback_impl
static PyObject * SSLeay_set_verify_callback_(PyObject *self, PyObject *args);
#endif
/* File containing implementations for SSL context */
#include "SSLCTX_impl.i"

/* Declarations for objects of type SSL context */

typedef struct SSLCTXObject {
	PyObject_HEAD
	/* Add your own stuff with this macro */
#ifdef SSLCTX_struct
	SSLCTX_struct
#endif
} SSLCTXObject;

/* ---------------------------------------------------------------- */
staticforward PyObject* SSLCTX_use_certificate(SSLCTXObject *self, PyObject *args);
#ifndef SSLCTX_use_certificate_impl
staticforward PyObject* SSLCTX_use_certificate_(SSLCTXObject *self, PyObject *args);
#endif
staticforward PyObject* SSLCTX_use_certificate_ASN1(SSLCTXObject *self, PyObject *args);
#ifndef SSLCTX_use_certificate_ASN1_impl
staticforward PyObject* SSLCTX_use_certificate_ASN1_(SSLCTXObject *self, PyObject *args);
#endif
staticforward PyObject* SSLCTX_use_certificate_file(SSLCTXObject *self, PyObject *args);
#ifndef SSLCTX_use_certificate_file_impl
staticforward PyObject* SSLCTX_use_certificate_file_(SSLCTXObject *self, PyObject *args);
#endif
staticforward PyObject* SSLCTX_use_RSAPrivateKey_ASN1(SSLCTXObject *self, PyObject *args);
#ifndef SSLCTX_use_RSAPrivateKey_ASN1_impl
staticforward PyObject* SSLCTX_use_RSAPrivateKey_ASN1_(SSLCTXObject *self, PyObject *args);
#endif
staticforward PyObject* SSLCTX_use_RSAPrivateKey_file(SSLCTXObject *self, PyObject *args);
#ifndef SSLCTX_use_RSAPrivateKey_file_impl
staticforward PyObject* SSLCTX_use_RSAPrivateKey_file_(SSLCTXObject *self, PyObject *args);
#endif
staticforward SSLCTXObject* SSLCTX_New();
staticforward void SSLCTX_dealloc(SSLCTXObject *self);
staticforward PyObject * SSLCTX_getattr(SSLCTXObject *self, char *name);
#ifndef SSLCTX_getattr_impl
staticforward PyObject * SSLCTX_getattr_(SSLCTXObject *self, char *name);
#endif
staticforward int SSLCTX_setattr(SSLCTXObject *self, char *name, PyObject *v);
#ifndef SSLCTX_getattr_impl
staticforward int SSLCTX_setattr_(SSLCTXObject *self, char *name, PyObject *v);
#endif

static PyTypeObject SSLCTXType = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"SSL context",			/*tp_name*/
	sizeof(SSLCTXObject),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)SSLCTX_dealloc,	/*tp_dealloc*/
	(printfunc)0,		/*tp_print*/
	(getattrfunc)SSLCTX_getattr,	/*tp_getattr*/
	(setattrfunc)SSLCTX_setattr,	/*tp_setattr*/
	(cmpfunc)0,		/*tp_compare*/
	(reprfunc)0,		/*tp_repr*/
	0,			/*tp_as_number*/
	0,		/*tp_as_sequence*/
	0,		/*tp_as_mapping*/
	(hashfunc)0,		/*tp_hash*/
};

#define SSLCTX_Check(v)		((v)->ob_type == &SSLCTXType)

/* ---------------------------------------------------------------- */
/* File containing implementations for SSL connection */
#include "SSLconn_impl.i"

/* Declarations for objects of type SSL connection */

typedef struct SSLconnObject {
	PyObject_HEAD
	/* Add your own stuff with this macro */
#ifdef SSLconn_struct
	SSLconn_struct
#endif
} SSLconnObject;

/* ---------------------------------------------------------------- */
staticforward PyObject* SSLconn_accept(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_accept_impl
staticforward PyObject* SSLconn_accept_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_close(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_close_impl
staticforward PyObject* SSLconn_close_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_connect(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_connect_impl
staticforward PyObject* SSLconn_connect_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_fileno(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_fileno_impl
staticforward PyObject* SSLconn_fileno_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_flush(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_flush_impl
staticforward PyObject* SSLconn_flush_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_isatty(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_isatty_impl
staticforward PyObject* SSLconn_isatty_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_makefile(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_makefile_impl
staticforward PyObject* SSLconn_makefile_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_readline(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_readline_impl
staticforward PyObject* SSLconn_readline_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_readlines(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_readlines_impl
staticforward PyObject* SSLconn_readlines_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_read(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_read_impl
staticforward PyObject* SSLconn_read_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_recv(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_recv_impl
staticforward PyObject* SSLconn_recv_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_seek(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_seek_impl
staticforward PyObject* SSLconn_seek_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_set_verify(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_set_verify_impl
staticforward PyObject* SSLconn_set_verify_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_send(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_send_impl
staticforward PyObject* SSLconn_send_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_write(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_write_impl
staticforward PyObject* SSLconn_write_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_writelines(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_writelines_impl
staticforward PyObject* SSLconn_writelines_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_use_certificate(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_use_certificate_impl
staticforward PyObject* SSLconn_use_certificate_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_use_certificate_ASN1(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_use_certificate_ASN1_impl
staticforward PyObject* SSLconn_use_certificate_ASN1_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_use_certificate_file(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_use_certificate_file_impl
staticforward PyObject* SSLconn_use_certificate_file_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_use_RSAPrivateKey_ASN1(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_use_RSAPrivateKey_ASN1_impl
staticforward PyObject* SSLconn_use_RSAPrivateKey_ASN1_(SSLconnObject *self, PyObject *args);
#endif
staticforward PyObject* SSLconn_use_RSAPrivateKey_file(SSLconnObject *self, PyObject *args);
#ifndef SSLconn_use_RSAPrivateKey_file_impl
staticforward PyObject* SSLconn_use_RSAPrivateKey_file_(SSLconnObject *self, PyObject *args);
#endif
staticforward SSLconnObject* SSLconn_New();
staticforward void SSLconn_dealloc(SSLconnObject *self);
staticforward PyObject * SSLconn_getattr(SSLconnObject *self, char *name);
#ifndef SSLconn_getattr_impl
staticforward PyObject * SSLconn_getattr_(SSLconnObject *self, char *name);
#endif
staticforward int SSLconn_setattr(SSLconnObject *self, char *name, PyObject *v);
#ifndef SSLconn_getattr_impl
staticforward int SSLconn_setattr_(SSLconnObject *self, char *name, PyObject *v);
#endif

static PyTypeObject SSLconnType = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"SSL connection",			/*tp_name*/
	sizeof(SSLconnObject),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)SSLconn_dealloc,	/*tp_dealloc*/
	(printfunc)0,		/*tp_print*/
	(getattrfunc)SSLconn_getattr,	/*tp_getattr*/
	(setattrfunc)SSLconn_setattr,	/*tp_setattr*/
	(cmpfunc)0,		/*tp_compare*/
	(reprfunc)0,		/*tp_repr*/
	0,			/*tp_as_number*/
	0,		/*tp_as_sequence*/
	0,		/*tp_as_mapping*/
	(hashfunc)0,		/*tp_hash*/
};

#define SSLconn_Check(v)		((v)->ob_type == &SSLconnType)

/* ---------------------------------------------------------------- */
/* File containing implementations for X.509 certificate */
#include "X509_impl.i"

/* Declarations for objects of type X.509 certificate */

typedef struct X509Object {
	PyObject_HEAD
	/* Add your own stuff with this macro */
#ifdef X509_struct
	X509_struct
#endif
} X509Object;

/* ---------------------------------------------------------------- */
staticforward X509Object* X509_New();
staticforward void X509_dealloc(X509Object *self);
staticforward PyObject * X509_getattr(X509Object *self, char *name);
#ifndef X509_getattr_impl
staticforward PyObject * X509_getattr_(X509Object *self, char *name);
#endif
staticforward int X509_setattr(X509Object *self, char *name, PyObject *v);
#ifndef X509_getattr_impl
staticforward int X509_setattr_(X509Object *self, char *name, PyObject *v);
#endif

static PyTypeObject X509Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,				/*ob_size*/
	"X.509 certificate",			/*tp_name*/
	sizeof(X509Object),		/*tp_basicsize*/
	0,				/*tp_itemsize*/
	/* methods */
	(destructor)X509_dealloc,	/*tp_dealloc*/
	(printfunc)0,		/*tp_print*/
	(getattrfunc)X509_getattr,	/*tp_getattr*/
	(setattrfunc)X509_setattr,	/*tp_setattr*/
	(cmpfunc)0,		/*tp_compare*/
	(reprfunc)0,		/*tp_repr*/
	0,			/*tp_as_number*/
	0,		/*tp_as_sequence*/
	0,		/*tp_as_mapping*/
	(hashfunc)0,		/*tp_hash*/
};

#define X509_Check(v)		((v)->ob_type == &X509Type)

/* ---------------------------------------------------------------- */

static PyObject *
SSLCTX_use_certificate(SSLCTXObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLCTX_use_certificate_impl
        SSLCTX_use_certificate_impl(self, args);
#else
	return SSLCTX_use_certificate_(self, args);
#endif
}

static PyObject *
SSLCTX_use_certificate_ASN1(SSLCTXObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLCTX_use_certificate_ASN1_impl
        SSLCTX_use_certificate_ASN1_impl(self, args);
#else
	return SSLCTX_use_certificate_ASN1_(self, args);
#endif
}

static PyObject *
SSLCTX_use_certificate_file(SSLCTXObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLCTX_use_certificate_file_impl
        SSLCTX_use_certificate_file_impl(self, args);
#else
	return SSLCTX_use_certificate_file_(self, args);
#endif
}

static PyObject *
SSLCTX_use_RSAPrivateKey_ASN1(SSLCTXObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLCTX_use_RSAPrivateKey_ASN1_impl
        SSLCTX_use_RSAPrivateKey_ASN1_impl(self, args);
#else
	return SSLCTX_use_RSAPrivateKey_ASN1_(self, args);
#endif
}

static PyObject *
SSLCTX_use_RSAPrivateKey_file(SSLCTXObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLCTX_use_RSAPrivateKey_file_impl
        SSLCTX_use_RSAPrivateKey_file_impl(self, args);
#else
	return SSLCTX_use_RSAPrivateKey_file_(self, args);
#endif
}

static PyMethodDef SSLCTX_methods[] = {
	{"use_certificate",	(PyCFunction)SSLCTX_use_certificate,	1},
 {"use_certificate_ASN1",	(PyCFunction)SSLCTX_use_certificate_ASN1,	1},
 {"use_certificate_file",	(PyCFunction)SSLCTX_use_certificate_file,	1},
 {"use_RSAPrivateKey_ASN1",	(PyCFunction)SSLCTX_use_RSAPrivateKey_ASN1,	1},
 {"use_RSAPrivateKey_file",	(PyCFunction)SSLCTX_use_RSAPrivateKey_file,	1},
 
	{NULL,		NULL}		/* sentinel */
};

/* ---------- */

static SSLCTXObject *
SSLCTX_New()
{
	SSLCTXObject *self;
	
	self = PyObject_NEW(SSLCTXObject, &SSLCTXType);
	if (self == NULL)
		return NULL;
	/* Initialition macro */
#ifdef SSLCTX_New_impl
	SSLCTX_New_impl(self)
#else
	SSLCTX_New_(self)
#endif
	return self;
}

static void
SSLCTX_dealloc(SSLCTXObject *self)
{
	/* XXXX Add your own cleanup code here */
#ifdef SSLCTX_dealloc_impl
	SSLCTX_dealloc_impl(self)
#else
	SSLCTX_dealloc_(self)
#endif
	PyMem_DEL(self);
}

static PyObject *
SSLCTX_getattr(SSLCTXObject *self, char *name)
{
        PyObject *v;
	/* Add your own getattr in macro */
#ifdef SSLCTX_getattr_impl
	SSLCTX_getattr_impl(self, name)
#else
	v=SSLCTX_getattr_(self, name);
	if (v!=NULL) return v;
#endif
	return Py_FindMethod(SSLCTX_methods, (PyObject *)self, name);
}

static int
SSLCTX_setattr(SSLCTXObject *self, char *name, PyObject *v)
{
	/* Implementation macro */
#ifdef SSLCTX_setattr_impl
	SSLCTX_setattr_impl(self, name, v)
#else
	return SSLCTX_setattr_(self, name, v);
#endif
}
#ifdef SSLCTX_TAIL
#include "SSLCTX_tail.i"
#endif

/* End of code for SSL context objects */
/* -------------------------------------------------------- */

static PyObject *
SSLconn_accept(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_accept_impl
        SSLconn_accept_impl(self, args);
#else
	return SSLconn_accept_(self, args);
#endif
}

static PyObject *
SSLconn_close(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_close_impl
        SSLconn_close_impl(self, args);
#else
	return SSLconn_close_(self, args);
#endif
}

static PyObject *
SSLconn_connect(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_connect_impl
        SSLconn_connect_impl(self, args);
#else
	return SSLconn_connect_(self, args);
#endif
}

static PyObject *
SSLconn_fileno(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_fileno_impl
        SSLconn_fileno_impl(self, args);
#else
	return SSLconn_fileno_(self, args);
#endif
}

static PyObject *
SSLconn_flush(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_flush_impl
        SSLconn_flush_impl(self, args);
#else
	return SSLconn_flush_(self, args);
#endif
}

static PyObject *
SSLconn_isatty(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_isatty_impl
        SSLconn_isatty_impl(self, args);
#else
	return SSLconn_isatty_(self, args);
#endif
}

static PyObject *
SSLconn_makefile(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_makefile_impl
        SSLconn_makefile_impl(self, args);
#else
	return SSLconn_makefile_(self, args);
#endif
}

static PyObject *
SSLconn_readline(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_readline_impl
        SSLconn_readline_impl(self, args);
#else
	return SSLconn_readline_(self, args);
#endif
}

static PyObject *
SSLconn_readlines(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_readlines_impl
        SSLconn_readlines_impl(self, args);
#else
	return SSLconn_readlines_(self, args);
#endif
}

static PyObject *
SSLconn_read(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_read_impl
        SSLconn_read_impl(self, args);
#else
	return SSLconn_read_(self, args);
#endif
}

static PyObject *
SSLconn_recv(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_recv_impl
        SSLconn_recv_impl(self, args);
#else
	return SSLconn_recv_(self, args);
#endif
}

static PyObject *
SSLconn_seek(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_seek_impl
        SSLconn_seek_impl(self, args);
#else
	return SSLconn_seek_(self, args);
#endif
}

static PyObject *
SSLconn_set_verify(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_set_verify_impl
        SSLconn_set_verify_impl(self, args);
#else
	return SSLconn_set_verify_(self, args);
#endif
}

static PyObject *
SSLconn_send(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_send_impl
        SSLconn_send_impl(self, args);
#else
	return SSLconn_send_(self, args);
#endif
}

static PyObject *
SSLconn_write(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_write_impl
        SSLconn_write_impl(self, args);
#else
	return SSLconn_write_(self, args);
#endif
}

static PyObject *
SSLconn_writelines(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_writelines_impl
        SSLconn_writelines_impl(self, args);
#else
	return SSLconn_writelines_(self, args);
#endif
}

static PyObject *
SSLconn_use_certificate(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_use_certificate_impl
        SSLconn_use_certificate_impl(self, args);
#else
	return SSLconn_use_certificate_(self, args);
#endif
}

static PyObject *
SSLconn_use_certificate_ASN1(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_use_certificate_ASN1_impl
        SSLconn_use_certificate_ASN1_impl(self, args);
#else
	return SSLconn_use_certificate_ASN1_(self, args);
#endif
}

static PyObject *
SSLconn_use_certificate_file(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_use_certificate_file_impl
        SSLconn_use_certificate_file_impl(self, args);
#else
	return SSLconn_use_certificate_file_(self, args);
#endif
}

static PyObject *
SSLconn_use_RSAPrivateKey_ASN1(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_use_RSAPrivateKey_ASN1_impl
        SSLconn_use_RSAPrivateKey_ASN1_impl(self, args);
#else
	return SSLconn_use_RSAPrivateKey_ASN1_(self, args);
#endif
}

static PyObject *
SSLconn_use_RSAPrivateKey_file(SSLconnObject *self, PyObject *args)
{
        /* Implementation macro */
#ifdef SSLconn_use_RSAPrivateKey_file_impl
        SSLconn_use_RSAPrivateKey_file_impl(self, args);
#else
	return SSLconn_use_RSAPrivateKey_file_(self, args);
#endif
}

static PyMethodDef SSLconn_methods[] = {
	{"accept",	(PyCFunction)SSLconn_accept,	1},
 {"close",	(PyCFunction)SSLconn_close,	1},
 {"connect",	(PyCFunction)SSLconn_connect,	1},
 {"fileno",	(PyCFunction)SSLconn_fileno,	1},
 {"flush",	(PyCFunction)SSLconn_flush,	1},
 {"isatty",	(PyCFunction)SSLconn_isatty,	1},
 {"makefile",	(PyCFunction)SSLconn_makefile,	1},
 {"readline",	(PyCFunction)SSLconn_readline,	1},
 {"readlines",	(PyCFunction)SSLconn_readlines,	1},
 {"read",	(PyCFunction)SSLconn_read,	1},
 {"recv",	(PyCFunction)SSLconn_recv,	1},
 {"seek",	(PyCFunction)SSLconn_seek,	1},
 {"set_verify",	(PyCFunction)SSLconn_set_verify,	1},
 {"send",	(PyCFunction)SSLconn_send,	1},
 {"write",	(PyCFunction)SSLconn_write,	1},
 {"writelines",	(PyCFunction)SSLconn_writelines,	1},
 {"use_certificate",	(PyCFunction)SSLconn_use_certificate,	1},
 {"use_certificate_ASN1",	(PyCFunction)SSLconn_use_certificate_ASN1,	1},
 {"use_certificate_file",	(PyCFunction)SSLconn_use_certificate_file,	1},
 {"use_RSAPrivateKey_ASN1",	(PyCFunction)SSLconn_use_RSAPrivateKey_ASN1,	1},
 {"use_RSAPrivateKey_file",	(PyCFunction)SSLconn_use_RSAPrivateKey_file,	1},
 
	{NULL,		NULL}		/* sentinel */
};

/* ---------- */

static SSLconnObject *
SSLconn_New()
{
	SSLconnObject *self;
	
	self = PyObject_NEW(SSLconnObject, &SSLconnType);
	if (self == NULL)
		return NULL;
	/* Initialition macro */
#ifdef SSLconn_New_impl
	SSLconn_New_impl(self)
#else
	SSLconn_New_(self)
#endif
	return self;
}

static void
SSLconn_dealloc(SSLconnObject *self)
{
	/* XXXX Add your own cleanup code here */
#ifdef SSLconn_dealloc_impl
	SSLconn_dealloc_impl(self)
#else
	SSLconn_dealloc_(self)
#endif
	PyMem_DEL(self);
}

static PyObject *
SSLconn_getattr(SSLconnObject *self, char *name)
{
        PyObject *v;
	/* Add your own getattr in macro */
#ifdef SSLconn_getattr_impl
	SSLconn_getattr_impl(self, name)
#else
	v=SSLconn_getattr_(self, name);
	if (v!=NULL) return v;
#endif
	return Py_FindMethod(SSLconn_methods, (PyObject *)self, name);
}

static int
SSLconn_setattr(SSLconnObject *self, char *name, PyObject *v)
{
	/* Implementation macro */
#ifdef SSLconn_setattr_impl
	SSLconn_setattr_impl(self, name, v)
#else
	return SSLconn_setattr_(self, name, v);
#endif
}
#ifdef SSLconn_TAIL
#include "SSLconn_tail.i"
#endif

/* End of code for SSL connection objects */
/* -------------------------------------------------------- */

static PyMethodDef X509_methods[] = {
	
	{NULL,		NULL}		/* sentinel */
};

/* ---------- */

static X509Object *
X509_New()
{
	X509Object *self;
	
	self = PyObject_NEW(X509Object, &X509Type);
	if (self == NULL)
		return NULL;
	/* Initialition macro */
#ifdef X509_New_impl
	X509_New_impl(self)
#else
	X509_New_(self)
#endif
	return self;
}

static void
X509_dealloc(X509Object *self)
{
	/* XXXX Add your own cleanup code here */
#ifdef X509_dealloc_impl
	X509_dealloc_impl(self)
#else
	X509_dealloc_(self)
#endif
	PyMem_DEL(self);
}

static PyObject *
X509_getattr(X509Object *self, char *name)
{
        PyObject *v;
	/* Add your own getattr in macro */
#ifdef X509_getattr_impl
	X509_getattr_impl(self, name)
#else
	v=X509_getattr_(self, name);
	if (v!=NULL) return v;
#endif
	return Py_FindMethod(X509_methods, (PyObject *)self, name);
}

static int
X509_setattr(X509Object *self, char *name, PyObject *v)
{
	/* Implementation macro */
#ifdef X509_setattr_impl
	X509_setattr_impl(self, name, v)
#else
	return X509_setattr_(self, name, v);
#endif
}
#ifdef X509_TAIL
#include "X509_tail.i"
#endif

/* End of code for X.509 certificate objects */
/* -------------------------------------------------------- */

static PyObject *
SSLeay_newSSLctx(PyObject *self, PyObject *args)
{
	/* Either use macro or separate function */
#ifdef SSLeay_newSSLctx_impl
	SSLeay_newSSLctx_impl(args);
#else
	return SSLeay_newSSLctx_(self,args);
#endif
}

static PyObject *
SSLeay_fromfd(PyObject *self, PyObject *args)
{
	/* Either use macro or separate function */
#ifdef SSLeay_fromfd_impl
	SSLeay_fromfd_impl(args);
#else
	return SSLeay_fromfd_(self,args);
#endif
}

static PyObject *
SSLeay_SSL(PyObject *self, PyObject *args)
{
	/* Either use macro or separate function */
#ifdef SSLeay_SSL_impl
	SSLeay_SSL_impl(args);
#else
	return SSLeay_SSL_(self,args);
#endif
}

static PyObject *
SSLeay_set_verify_callback(PyObject *self, PyObject *args)
{
	/* Either use macro or separate function */
#ifdef SSLeay_set_verify_callback_impl
	SSLeay_set_verify_callback_impl(args);
#else
	return SSLeay_set_verify_callback_(self,args);
#endif
}

/* List of methods defined in the module */

static PyMethodDef SSLeay_methods[] = {
	{"newSSLctx",	(PyCFunction)SSLeay_newSSLctx,	1},
 {"fromfd",	(PyCFunction)SSLeay_fromfd,	1},
 {"SSL",	(PyCFunction)SSLeay_SSL,	1},
 {"set_verify_callback",	(PyCFunction)SSLeay_set_verify_callback,	1},
 
	{NULL,		NULL}		/* sentinel */
};

#ifdef SSLeay_TAIL
#include "SSLeay_tail.i"
#endif


/* Initialization function for the module (*must* be called initSSLeay) */

#ifdef __cplusplus
extern "C"
#endif
void
initSSLeay()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule("SSLeay", SSLeay_methods);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("SSLeay.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
#ifdef SSLeay_constants
	SSLeay_constants(d)
#endif
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module SSLeay");
}
