
import sys
sys.path.append('./mod2/')

import genmodule
SSLctx = genmodule.object()
SSLctx.name = 'SSL context'
SSLctx.abbrev = 'SSLCTX'
SSLctx.methodlist = ['use_certificate', 'use_certificate_ASN1', 'use_certificate_file',
		  'use_RSAPrivateKey_ASN1', 'use_RSAPrivateKey_file']
SSLctx.funclist = ['new', 'tp_dealloc', 'tp_getattr', 'tp_setattr']

SSLconn = genmodule.object()
SSLconn.name = 'SSL connection'
SSLconn.abbrev = 'SSLconn'
SSLconn.methodlist = ['accept', 'close', 'connect', 'fileno', 'flush', 'isatty',
		  'makefile', 'readline', 'readlines', 'read', 'recv',
		  'seek', 'set_verify', 
		  'send', 'write', 'writelines',
		  'use_certificate', 'use_certificate_ASN1', 'use_certificate_file',
		  'use_RSAPrivateKey_ASN1', 'use_RSAPrivateKey_file'
		  ]

SSLconn.funclist = ['new', 'tp_dealloc', 'tp_getattr', 'tp_setattr']

X509 = genmodule.object()
X509.name = 'X.509 certificate'
X509.abbrev = 'X509'
X509.funclist = ['new', 'tp_dealloc', 'tp_getattr', 'tp_setattr']

#
# Now generate code for a module that incorporates these object types.
# Also add the boilerplates for functions to create instances of each
# type.
#
m = genmodule.module()
m.name = 'SSLeay'
m.abbrev = 'SSLeay'
m.methodlist = ['X509_add_cert_dir']
m.methodlist=['newSSLctx', 'fromfd', 'SSL',
	      'set_verify_callback']
m.objects = [SSLctx, SSLconn, X509]

f=open('SSLeay.c', 'w')
genmodule.write(f, m)
f.close()

