#ifdef hpux_bla

#include "../config.h"

#include <sys/types.h>
#include <poll.h>
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_SYS_SELECT_H) && !defined(SCO)
# include <sys/select.h>
#endif

int select(int nfds,
		  fd_set *readfds,
		  fd_set *writefds,
		  fd_set *errorfds,
		  struct timeval *timeout)
{
  struct pollfd *fds;
  int fd, ret;

  fds = (struct pollfd *)malloc(nfds * sizeof(struct pollfd));
  for (fd = 0; fd < nfds; fd++)
    {
      fds[fd].fd = fd;
      fds[fd].events =
	(readfds == NULL ? 0 : (FD_ISSET(fd, readfds) ? POLLIN : 0)) |
	(writefds == NULL ? 0 : (FD_ISSET(fd, writefds) ? POLLOUT : 0)) | 
	(errorfds == NULL ? 0 : (FD_ISSET(fd, errorfds) ? POLLPRI : 0));
    }
  ret = poll(fds, nfds,
	     timeout == NULL ? -1 : timeout->tv_usec + 1000 * timeout->tv_sec);
  if (readfds != NULL) FD_ZERO(readfds);
  if (writefds != NULL) FD_ZERO(writefds);
  if (errorfds != NULL) FD_ZERO(errorfds);
  for (fd = 0; fd < nfds; fd++)
    {
      if ((readfds != NULL) && (fds[fd].revents & POLLIN))
	FD_SET(fd, readfds);
      if ((writefds != NULL) && (fds[fd].revents & POLLOUT))
	FD_SET(fd, writefds);
      if ((errorfds != NULL) && (fds[fd].revents & POLLPRI))
	FD_SET(fd, errorfds);
    }
  free(fds);
  
  return ret;
}
#endif
