#ifndef __DISPLAY_H__
#define __DISPLAY_H__

#include "display.h"

typedef struct {
    FieldPtr fld;
    FieldPtr sfld;
    VoidHand bufhandle;
    unsigned char *bufptr;
    UInt rows, cols, fldwidth, viscols, hscroll;
    int cursr, cursc, viscurs;
    int escstate;
    unsigned char standout;
} Display;

void display_init(Display *dpy, FieldPtr fld, FieldPtr sfld, FontPtr fnt,
    UInt width, void (*set_dpy)(Display *, void *), void *set_dpyp);
void display_init_ofld(Display *dpy, void (*set_dpy)(Display *, void *), 
    void *set_dpyp);
void display_show(Display *dpy);
void display_clear(Display *dpy);
void display_addtxt(Display *dpy, unsigned char *data, long amt);
void display_draw_hscroll(Display *dpy);
void display_status(Display *dpy, char *status);

#endif
