#include <stdio.h>

int main(int argc, char **argv)
{
    FILE *prc;
    char kind[5];

    if (argc < 2) {
	fprintf(stderr, "Usage: %s file.prc\n", argv[0]);
	exit(1);
    }

    prc = fopen(argv[1], "r+");
    if (!prc) {
	perror("fopen");
	exit(2);
    }
    if (fseek(prc, 0x3c, SEEK_SET)) {
	perror("fseek");
	exit(2);
    }
    kind[4] = '\0';
    if (fread(kind, 4, 1, prc) != 1) {
	perror("fread");
	exit(2);
    }
    if (strcmp(kind, "appl")) {
	fprintf(stderr, "%s is not an appl file\n", argv[1]);
	exit(3);
    }
    if (fseek(prc, 0x3c, SEEK_SET)) {
	perror("fseek");
	exit(2);
    }
    strcpy(kind, "GLib");
    if (fwrite(kind, 4, 1, prc) != 1) {
	perror("fwrite");
	exit(2);
    }
    if (fclose(prc)) {
	perror("fclose");
	exit(2);
    }
    return 0;
}
