#!/bin/sh

# Where should we get the pre-compiled program from ??
#
case `uname -s` in
OSF*)		myarch=alpha-dec-osf2.0
		;;
[Ll]inux)	myarch=x86-unknown-linux-elf
		;;
*BSD*)		myarch=x86-unknown-bsd
		;;
IRIX*)		case `uname -r` in
		6*)	myarch=mips-sgi-irix6.2
			;;
		5.3*)	myarch=mips-sgi-irix5.3
			;;
		*)	myarch=mips-sgi-irix5.2
			;;
		esac
		;;
SunOS)		case `uname -r` in
		5.3)	myarch=sparc-sun-solaris2.3
			;;
		5.*)	myarch=sparc-sun-solaris2.4
			;;
		*)	myarch=sparc-sun-sunos4.1.3_U1
			;;
		esac
		;;
*)		myarch=src
		;;
esac

# Change directory to the top level Fortify directory, so that
# the various support files and architecture dirs can be found.
#
if expr "$0" : '.*/' > /dev/null
then
	cd `dirname $0`
else
	for d in `echo $PATH | sed -e 's/:/ /g'`
	do
		if [ -f "$d/Fortify.sh" -a -x "$d/Fortify.sh" ]
		then
			cd $d
			break
		fi
	done
fi

PATH=./$myarch/bin:./src:$PATH
export PATH

exec fortify $*
