#! /bin/csh -f

set tmpfile=/tmp/butmpf.$$

if (! $?BACKUP_HOME) then
  set pnam=$0
  set pnam = $pnam:t
  if ($pnam == $0) then
    foreach dir ($path)
      if (-x $dir/$0) then
	set p=$dir/$0
	break
      endif
    end
    if ($p == ./$pnam) then
      set p=`pwd`
      setenv BACKUP_HOME  $p:h
    else
      set p=$p:h
      setenv BACKUP_HOME  $p:h
    endif
  else
    if (./$pnam == $0) then
      set p=`pwd`/$pnam
    else
      if (`echo $0|cut -c1` != "/") then
        set p=`pwd`/$0
      else
        set p=$0
      endif
    endif
    set p=$p:h
    setenv BACKUP_HOME $p:h
  endif
endif

set path=($BACKUP_HOME/bin $path)
rehash

unsetenv AWK

# the solaris awk is doin' dawn f...... BS
foreach awk (nawk gawk awk)
  foreach dir ($path)
    if (-x $dir/$awk) then
      setenv AWK $dir/$awk
      break
    endif
  end
  if ($?AWK) break
end

if (! $?AWK) then
  echo 'No awk ? Is this really a lovely UNIX ?'
  echo 'Sorry. I have to exit.'
  exit 1
endif

set configfile=$BACKUP_HOME/lib/backup.conf

alias getparam $AWK' '"'"'/^[ 	]*'"'"'\!:1'"'"'/{split($0,a,"'"'"'\!:1'"'"'[ 	]*"); print a[2]}'"' $configfile"

set host="`getparam 'BackupHost:?'`"
set rootdir="`getparam 'RootDirectory:?'`"
set filestoskip="`getparam 'FilesToSkip:?'`"
set dirstoskip="`getparam 'DirsToSkip:?'`"
set indexfilepart="`getparam 'IndexFilePart:?'`"
set numindexestostore="`getparam 'NumIndexesToStore:?'`"
set compresscmd="`getparam 'CompressCmd:?'`"
set uncompresscmd="`getparam 'UncompressCmd:?'`"
set logfile="`getparam 'LoggingFile:?'`"
set numparts="`getparam 'NumBackupParts:?'`"
set startupinfoprog="`getparam 'StartupInfoProgram:?'`"
set compresslogfiles="`getparam 'CompressLogfiles:?'`"

if ("$compresslogfiles" != "0" && $compresslogfiles != "1") then
  set compresslogfiles=0
endif

if ($numparts == "") set numparts=1

if ("$compresscmd" != "" && "$uncompresscmd" != "") then
  set compressoption=-z
else
  set compresscmd="-v"
  set uncompresscmd="-v"
  set compressoption="-v"
endif

if ("$logfile" == "") then
  set logfile=$BACKUP_HOME/var/backup.log
endif

touch $logfile
echo `date`: starting incremental backup >> $logfile

unalias cd

cd $rootdir
if ($numparts > 1) then
  set i=1
  set dirstobackup=""
  while ($i <= $numparts)
    set nam="DirsToBackup"$i
    set moredirs="`getparam '${nam}:?'`"
    set dirstobackup=($dirstobackup $moredirs)
    @ i++
  end
else
  set dirstobackup="`getparam 'DirsToBackup:?'`"
endif

set dirstobackup=(`echo $dirstobackup|awk '{for(i=1;i<=NF;i++) print $i,$i}'|tsort`)

if ( -r $BACKUP_HOME/var/num ) then
  set num=`cat $BACKUP_HOME/var/num`
else
  set num=1
endif

if (`echo $num|grep '^[1-9][0-9]*$'|wc -l` < 1) then
  set num=1		# num doesn't contain a number
endif

echo $num >! $BACKUP_HOME/var/num

touch $BACKUP_HOME/var/newmark

# if the logfile is compressed, uncompress it
if (-e "$indexfilepart"$num".z" && ! -e "$indexfilepart"$num) then
  if ("$uncompresscmd" == "") then
    set uncompresscmd=gunzip		# assume gunzip can unzip anything
  endif

  set ok=0
  foreach tmplogf ("$indexfilepart"$num /tmp/`basename "$indexfilepart"$num` \
				/var/tmp/`basename "$indexfilepart"$num`)
    cat "$indexfilepart"$num".z" | $uncompresscmd >! $tmplogf
    if ($status == 0) then
	set ok=1
	break
    endif

    \rm -f $tmplogf
  end

  if ($ok) then
    if ($tmplogf != "$indexfilepart"$num) then
      cp $tmplogf "$indexfilepart"$num
      \rm -f $tmplogf
    endif
    \rm -f "$indexfilepart"$num".z"
  else
    echo Warning: filename logging file cannot be uncompressed.
  endif
endif

touch "$indexfilepart"$num

onintr emexit

# get startup information
if ("$startupinfoprog" != "") then
  backup -Q -h $host >! $tmpfile
  (echo 'Backup:    '$num ; \
	grep -i cartridge $tmpfile; grep -i file $tmpfile) | \
	awk '{printf "~~%s\n",$0}' | sh -c "$startupinfoprog"
  \rm -f $tmpfile
endif

# because the C-shell is so stupid we have to produce a find
# command script
set findcmd=/tmp/bufindcmd.$$
\rm -f $findcmd
echo "#! /bin/sh" >! $findcmd
echo -n exec find $dirstobackup >> $findcmd
if ($#dirstoskip > 0) then
  echo $dirstoskip | \
	awk 'BEGIN{printf " \\("}{for(i=1;i<=NF;i++) \
		{ printf " -name \"%s\" ",$i; if (i<NF) printf "-o"}} \
		END{printf "\\) -prune -o "}' >> $findcmd
endif
echo "$filestoskip" | \
		awk '{for(i=1;i<=NF;i++) printf " ! -name \"%s\"",$i}' \
			>> $findcmd
echo " -newer $BACKUP_HOME/var/oldmark -print" >> $findcmd
chmod +x $findcmd

# list all names, substitute \ by \\ and " by \" (the program backup
# needs this), put the whole thing into hyphens, pipe it into backup

$findcmd		\
	| sed 's/\\/\\\\/g;s/\"/\\\"/g'					\
	| awk '{printf "\"%s\"\n", $0}'					\
	| backup -cvn $compressoption "$compresscmd" "$uncompresscmd"	\
		-h $host		>>& "$indexfilepart"$num
set bus=$status

# compress the logfile, if requested
if ($compresslogfiles && "$compresscmd" != "" && "$uncompresscmd" != "") then
  set ok=0
  foreach tmplf ("$indexfilepart"$num".z" \
			/tmp/`basename "$indexfilepart"$num".z"`\
			/var/tmp/`basename "$indexfilepart"$num".z"`)
    cat "$indexfilepart"$num | $compresscmd >! $tmplf
    if ($status == 0) then
	set ok=1
	break
    endif

    \rm -f $tmplf
  end

  if ($ok) then
    if ($tmplf != "$indexfilepart"$num".z") then
      cp $tmplf "$indexfilepart"$num".z"
      \rm -f $tmplf
    endif

    \rm -f "$indexfilepart"$num
  endif
endif

if ($bus != 0) then
  echo `date`: incremental backup failed. >>$logfile
  goto failexit
endif

\mv -f $BACKUP_HOME/var/newmark $BACKUP_HOME/var/oldmark

echo `date`: incremental backup finished >> $logfile

\rm -f $findcmd $tmpfile

exit 0

emexit:
echo `date`: incremental backup interrupted. >>$logfile

failexit:
\rm -f $BACKUP_HOME/var/newmark $findcmd $tmpfile

exit 1
