#define MAXKEYBYTES 56		/* 448 bits */
#define ORDER_DCBA       1
#define bf_N             16
#define noErr            0
#define DATAERROR         -1
#define KEYBYTES         16

#define UWORD_32bits  unsigned long
#define UWORD_16bits  unsigned short
#define UBYTE_08bits  unsigned char

/* choose a byte order for your hardware */
/* ABCD - big endian - motorola */
#ifdef ORDER_ABCD
union aword {
  UWORD_32bits word;
  UBYTE_08bits byte [4];
  struct {
    unsigned int byte0:8;
    unsigned int byte1:8;
    unsigned int byte2:8;
    unsigned int byte3:8;
  } w;
};
#endif	/* ORDER_ABCD */

/* DCBA - little endian - intel */
#ifdef ORDER_DCBA
union aword {
  UWORD_32bits word;
  UBYTE_08bits byte [4];
  struct {
    unsigned int byte3:8;
    unsigned int byte2:8;
    unsigned int byte1:8;
    unsigned int byte0:8;
  } w;
};
#endif	/* ORDER_DCBA */

/* BADC - vax */
#ifdef ORDER_BADC
union aword {
  UWORD_32bits word;
  UBYTE_08bits byte [4];
  struct {
    unsigned int byte1:8;
    unsigned int byte0:8;
    unsigned int byte3:8;
    unsigned int byte2:8;
  } w;
};
#endif	/* ORDER_BADC */

typedef struct bfkey {
	UWORD_32bits bf_P[bf_N + 2];
	UWORD_32bits bf_S[4][256];
} bfkey; 


void Blowfish_encipher(UWORD_32bits blk[], bfkey *tbl);
void Blowfish_decipher(UWORD_32bits blk[], bfkey *tbl);
void Blowfish_Initialize(UBYTE_08bits key[], short keybytes, bfkey *tbl);

