/* ssl/ssl_stat.c */
/* Copyright (C) 1995-1997 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 *
 * This package is an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL.
 * 
 * This library is free for commercial and non-commercial use as long as
 * the following conditions are aheared to.  The following conditions
 * apply to all code found in this distribution, be it the RC4, RSA,
 * lhash, DES, etc., code; not just the SSL code.  The SSL documentation
 * included with this distribution is covered by the same copyright terms
 * except that the holder is Tim Hudson (tjh@mincom.oz.au).
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * If this package is used in a product, Eric Young should be given attribution
 * as the author of the parts of the library used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    "This product includes cryptographic software written by
 *     Eric Young (eay@mincom.oz.au)"
 *    The word 'cryptographic' can be left out if the rouines from the library
 *    being used are not cryptographic related :-).
 * 4. If you include any Windows specific code (or a derivative thereof) from 
 *    the apps directory (application code) you must include an acknowledgement:
 *    "This product includes software written by Tim Hudson (tjh@mincom.oz.au)"
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

#include <stdio.h>
#include "ssl_locl.h"

char *SSL_state_string_long(s)
SSL *s;
	{
	char *str;

	switch (s->state)
		{
case SSL_ST_BEFORE: str="before SSL initalisation"; break;
case SSL_ST_ACCEPT: str="before accept initalisation"; break;
case SSL_ST_CONNECT: str="before connect initalisation"; break;
case SSL_ST_OK: str="SSL negotiation finished successfully"; break;
case SSL2_ST_CLIENT_START_ENCRYPTION: str="client start encryption"; break;
case SSL2_ST_SERVER_START_ENCRYPTION: str="server start encryption"; break;
case SSL2_ST_SEND_CLIENT_HELLO_A: str="send client hello A"; break;
case SSL2_ST_SEND_CLIENT_HELLO_B: str="send client hello B"; break;
case SSL2_ST_GET_SERVER_HELLO_A: str="get server hello A"; break;
case SSL2_ST_GET_SERVER_HELLO_B: str="get server hello B"; break;
case SSL2_ST_SEND_CLIENT_MASTER_KEY_A: str="send client master key A"; break;
case SSL2_ST_SEND_CLIENT_MASTER_KEY_B: str="send client master key B"; break;
case SSL2_ST_SEND_CLIENT_FINISHED_A: str="send client finished A"; break;
case SSL2_ST_SEND_CLIENT_FINISHED_B: str="send client finished B"; break;
case SSL2_ST_SEND_CLIENT_CERTIFICATE_A: str="send client certificate A"; break;
case SSL2_ST_SEND_CLIENT_CERTIFICATE_B: str="send client certificate B"; break;
case SSL2_ST_SEND_CLIENT_CERTIFICATE_C: str="send client certificate C"; break;
case SSL2_ST_SEND_CLIENT_CERTIFICATE_D: str="send client certificate D"; break;
case SSL2_ST_GET_SERVER_VERIFY_A: str="get server verify A"; break;
case SSL2_ST_GET_SERVER_VERIFY_B: str="get server verify B"; break;
case SSL2_ST_GET_SERVER_FINISHED_A: str="get server finished A"; break;
case SSL2_ST_GET_SERVER_FINISHED_B: str="get server finished B"; break;
case SSL2_ST_GET_CLIENT_HELLO_A: str="get client hello A"; break;
case SSL2_ST_GET_CLIENT_HELLO_B: str="get client hello B"; break;
case SSL2_ST_SEND_SERVER_HELLO_A: str="send server hello A"; break;
case SSL2_ST_SEND_SERVER_HELLO_B: str="send server hello B"; break;
case SSL2_ST_GET_CLIENT_MASTER_KEY_A: str="get client master key A"; break;
case SSL2_ST_GET_CLIENT_MASTER_KEY_B: str="get client master key B"; break;
case SSL2_ST_SEND_SERVER_VERIFY_A: str="send server verify A"; break;
case SSL2_ST_SEND_SERVER_VERIFY_B: str="send server verify B"; break;
case SSL2_ST_SEND_SERVER_VERIFY_C: str="send server verify C"; break;
case SSL2_ST_GET_CLIENT_FINISHED_A: str="get client finished A"; break;
case SSL2_ST_GET_CLIENT_FINISHED_B: str="get client finished B"; break;
case SSL2_ST_SEND_SERVER_FINISHED_A: str="send server finished A"; break;
case SSL2_ST_SEND_SERVER_FINISHED_B: str="send server finished B"; break;
case SSL2_ST_SEND_REQUEST_CERTIFICATE_A: str="send request certificate A"; break;
case SSL2_ST_SEND_REQUEST_CERTIFICATE_B: str="send request certificate B"; break;
case SSL2_ST_SEND_REQUEST_CERTIFICATE_C: str="send request certificate C"; break;
case SSL2_ST_SEND_REQUEST_CERTIFICATE_D: str="send request certificate D"; break;
case SSL2_ST_X509_GET_SERVER_CERTIFICATE: str="X509 get server certificate"; break;
case SSL2_ST_X509_GET_CLIENT_CERTIFICATE: str="X509 get client certificate"; break;
default:	str="unknown state"; break;
		}
	return(str);
	}

char *SSL_rstate_string_long(s)
SSL *s;
	{
	char *str;

	switch (s->rstate)
		{
	case SSL_ST_READ_HEADER: str="read header"; break;
	case SSL_ST_READ_BODY: str="read body"; break;
	default: str="unknown"; break;
		}
	return(str);
	}

char *SSL_state_string(s)
SSL *s;
	{
	char *str;

	switch (s->state)
		{
case SSL_ST_BEFORE:				str="PINIT "; break;
case SSL_ST_ACCEPT:				str="AINIT "; break;
case SSL_ST_CONNECT:				str="CINIT "; break;
case SSL_ST_OK:			 		str="SSLOK "; break;
case SSL2_ST_CLIENT_START_ENCRYPTION:		str="2CSENC"; break;
case SSL2_ST_SERVER_START_ENCRYPTION:		str="2SSENC"; break;
case SSL2_ST_SEND_CLIENT_HELLO_A:		str="2SCH_A"; break;
case SSL2_ST_SEND_CLIENT_HELLO_B:		str="2SCH_B"; break;
case SSL2_ST_GET_SERVER_HELLO_A:		str="2GSH_A"; break;
case SSL2_ST_GET_SERVER_HELLO_B:		str="2GSH_B"; break;
case SSL2_ST_SEND_CLIENT_MASTER_KEY_A:		str="2SCMKA"; break;
case SSL2_ST_SEND_CLIENT_MASTER_KEY_B:		str="2SCMKB"; break;
case SSL2_ST_SEND_CLIENT_FINISHED_A:		str="2SCF_A"; break;
case SSL2_ST_SEND_CLIENT_FINISHED_B:		str="2SCF_B"; break;
case SSL2_ST_SEND_CLIENT_CERTIFICATE_A:		str="2SCC_A"; break;
case SSL2_ST_SEND_CLIENT_CERTIFICATE_B:		str="2SCC_B"; break;
case SSL2_ST_SEND_CLIENT_CERTIFICATE_C:		str="2SCC_C"; break;
case SSL2_ST_SEND_CLIENT_CERTIFICATE_D:		str="2SCC_D"; break;
case SSL2_ST_GET_SERVER_VERIFY_A:		str="2GSV_A"; break;
case SSL2_ST_GET_SERVER_VERIFY_B:		str="2GSV_B"; break;
case SSL2_ST_GET_SERVER_FINISHED_A:		str="2GSF_A"; break;
case SSL2_ST_GET_SERVER_FINISHED_B:		str="2GSF_B"; break;
case SSL2_ST_GET_CLIENT_HELLO_A:		str="2GCH_A"; break;
case SSL2_ST_GET_CLIENT_HELLO_B:		str="2GCH_B"; break;
case SSL2_ST_SEND_SERVER_HELLO_A:		str="2SSH_A"; break;
case SSL2_ST_SEND_SERVER_HELLO_B:		str="2SSH_B"; break;
case SSL2_ST_GET_CLIENT_MASTER_KEY_A:		str="2GCMKA"; break;
case SSL2_ST_GET_CLIENT_MASTER_KEY_B:		str="2GCMKA"; break;
case SSL2_ST_SEND_SERVER_VERIFY_A:		str="2SSV_A"; break;
case SSL2_ST_SEND_SERVER_VERIFY_B:		str="2SSV_B"; break;
case SSL2_ST_SEND_SERVER_VERIFY_C:		str="2SSV_C"; break;
case SSL2_ST_GET_CLIENT_FINISHED_A:		str="2GCF_A"; break;
case SSL2_ST_GET_CLIENT_FINISHED_B:		str="2GCF_B"; break;
case SSL2_ST_SEND_SERVER_FINISHED_A:		str="2SSF_A"; break;
case SSL2_ST_SEND_SERVER_FINISHED_B:		str="2SSF_B"; break;
case SSL2_ST_SEND_REQUEST_CERTIFICATE_A:	str="2SRC_A"; break;
case SSL2_ST_SEND_REQUEST_CERTIFICATE_B:	str="2SRC_B"; break;
case SSL2_ST_SEND_REQUEST_CERTIFICATE_C:	str="2SRC_C"; break;
case SSL2_ST_SEND_REQUEST_CERTIFICATE_D:	str="2SRC_D"; break;
case SSL2_ST_X509_GET_SERVER_CERTIFICATE:	str="2X9GSC"; break;
case SSL2_ST_X509_GET_CLIENT_CERTIFICATE:	str="2X9GCC"; break;
default:					str="UNKWN"; break;
		}
	return(str);
	}

char *SSL_rstate_string(s)
SSL *s;
	{
	char *str;

	switch (s->rstate)
		{
	case SSL_ST_READ_HEADER:str="RH"; break;
	case SSL_ST_READ_BODY:	str="RB"; break;
	case SSL_ST_READ_DONE:	str="RD"; break;
	default: str="unknown"; break;
		}
	return(str);
	}
