#! /bin/csh -f

set full=0

if ($#argv > 0) then
  if ("$1" == "-f") then
    set full=1;
  else
    echo 'usage: '$0' [ -f ]'
    exit 1
  endif
endif

if (! $?BACKUP_HOME) then
  set pnam=$0
  set pnam = $pnam:t
  if ($pnam == $0 || ./$pnam == $0) then
    set p=`which $0`
    if ($p == ./$pnam) then
      set p=`pwd`
      setenv BACKUP_HOME  $p:h
    else
      set p=$p:h
      setenv BACKUP_HOME  $p:h
    endif
  else
    if (`echo $0|cut -c1` != "/") then
      set p=`pwd`/$0
    else
      set p=$0
    endif
    set p=$p:h
    setenv BACKUP_HOME $p:h
  endif
endif

set path=($BACKUP_HOME/bin $path)
rehash

set logfile="`getparam LoggingFile`"

touch $logfile
echo `date`: starting backup >> $logfile

set d=`date|awk '{print $1}'`
set n=`date|awk '{print $3}'`

if (! -e $BACKUP_HOME/var/oldmark || $full) then
  full_backup
else
  if (($n >= 1 && $n <= 7) || ($n >= 15 && $n <= 21)) then
    switch ($d)
      case F*:
	full_backup
	breaksw
      case Mo*:
      case T*:
      case W*:
	incr_backup
	breaksw
    endsw
  else
    incr_backup
  endif
endif

echo `date`: backup finished >> $logfile
