# Sample SpecTcl main program for testing GUI

package VPS::routeDialog;

use strict;
use VPS;
use VPS::simpleAlert;
use Tk;
use Tk::Menu;
use Tk::DialogBox;

use Exporter;

@VPS::routeDialog::ISA = qw(Exporter);
@VPS::routeDialog::EXPORT    = qw(route_ui);

# interface generated by SpecTcl (Perl enabled) version 1.1 
# from route.ui
# For use with Tk402.002, using the grid geometry manager

local $VPS::routeDialog::root;

my $entRouteDestination;
my $entRouteNetmask;

sub route_ui {
    my ($callType,$index,$dest,$mask,$lbref) = @_;

    if (windowOpen('simpleAlert')) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    return 0 if (openWindow("route_ui"));

    $VPS::routeDialog::root = MainWindow->new();
    $VPS::routeDialog::root->title("VPS $VPS::VPSversion Administrator - Route Builder");
    
    # widget creation 
    
    my($frame_2) = $VPS::routeDialog::root->Frame (
				 );
    my($frame_1) = $VPS::routeDialog::root->Frame (
				 );
    my($label_1) = $VPS::routeDialog::root->Label (
				 -text => 'Destination',
				 );
    $entRouteDestination = $VPS::routeDialog::root->Entry (
					 );
    $entRouteDestination->insert(0,$dest);
    my($label_2) = $VPS::routeDialog::root->Label (
				 -text => 'Netmask',
				 );
    $entRouteNetmask = $VPS::routeDialog::root->Entry (			
				     );
    $entRouteNetmask->insert(0,$mask);
    my $butRouteOK;
    if ($callType == 1) { # Add Route
	$butRouteOK = $VPS::routeDialog::root->Button (
				     -text => 'OK',
				     -command => [\&addRouteCommand,$index,$lbref],
				     );
    }
    else { # Modify Route
	$butRouteOK = $VPS::routeDialog::root->Button (
				     -text => 'OK',
				     -command => [\&modifyRouteCommand,$index,$lbref],
				     );
    }

    my($butRouteCancel) = $VPS::routeDialog::root->Button (
					 -text => 'Cancel',
					 -command => \&cancelRouteCommand
					 );
    $VPS::routeDialog::root->protocol("WM_DELETE_WINDOW" => \&cancelRouteCommand);
    
    # Geometry management
    
    $frame_2->grid(
		   -in => $VPS::routeDialog::root,
		   -column => '1',
		   -row => '2',
		   -sticky => 'nesw',
		   -pady => 5
		   );
    $frame_1->grid(
		   -in => $VPS::routeDialog::root,
		   -column => '1',
		   -row => '1',
		   -sticky => 'nesw',
		   -padx => 5
		   );
    $label_1->grid(
		   -in => $frame_1,
		   -column => '1',
		   -row => '1'
		   );
    $entRouteDestination->grid(
			       -in => $frame_1,
			       -column => '2',
			       -row => '1'
			       );
    $label_2->grid(
		   -in => $frame_1,
		   -column => '1',
		   -row => '2'
		   );
    $entRouteNetmask->grid(
			   -in => $frame_1,
			   -column => '2',
			   -row => '2'
			   );
    $butRouteOK->grid(
		      -in => $frame_2,
		      -column => '1',
		      -row => '1'
		      );
    $butRouteCancel->grid(
			  -in => $frame_2,
			  -column => '2',
			  -row => '1'
			  );
    
    # Resize behavior management
    
    # container $frame_2 (rows)
    $frame_2->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    
    # container $frame_2 (columns)
    $frame_2->gridColumnconfigure(1, -weight => 0, -minsize => 30);
    $frame_2->gridColumnconfigure(2, -weight => 0, -minsize => 30);
    
    # container $root (rows)
    $VPS::routeDialog::root->gridRowconfigure(1, -weight  => 1, -minsize  => 30);
    $VPS::routeDialog::root->gridRowconfigure(2, -weight  => 0, -minsize  => 30);
    
    # container $root (columns)
    $VPS::routeDialog::root->gridColumnconfigure(1, -weight => 0, -minsize => 30);
    
    # container $frame_1 (rows)
    $frame_1->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    $frame_1->gridRowconfigure(2, -weight  => 0, -minsize  => 30);
    
    # container $frame_1 (columns)
    $frame_1->gridColumnconfigure(1, -weight => 0, -minsize => 30);
    $frame_1->gridColumnconfigure(2, -weight => 0, -minsize => 30);
    
    # additional interface code

    # end additional interface code
}

sub addRouteCommand {
    my ($index,$lbref) = @_;

    if (!closeWindow("route_ui")) {
	fileDirty(1);
	my $dest = $entRouteDestination->get;
	my $mask = $entRouteNetmask->get;
	if (($dest eq '') || ($mask eq '')) {
	    openWindow("route_ui");
	    simpleAlert($VPS::routeDialog::root,"Enter Destination and Netmask.");
	}
	else {
	    &VPS::tunnelBuilder::tunnelAddRoute($dest,$mask,$index,$lbref);
	    $VPS::routeDialog::root->destroy;
	    message("Route Added");
	}
    }
}

sub modifyRouteCommand {
    my ($index,$lbref) = @_;

    if (!closeWindow("route_ui")) {
	fileDirty(1);
	my $dest = $entRouteDestination->get;
	my $mask = $entRouteNetmask->get;
	if (($dest eq '') || ($mask eq '')) {
	    message("Enter Destination and Netmask.");
	    openWindow("route_ui");
	}
	else {
	    &VPS::tunnelBuilder::tunnelModifyRoute($dest,$mask,$index,$lbref);
	    $VPS::routeDialog::root->destroy;
	    message("Route modified");
	}
    }
}

sub cancelRouteCommand {
    if (!closeWindow("route_ui")) {
	$VPS::routeDialog::root->destroy;
    }
}

1;
