# Sample SpecTcl main program for testing GUI

package VPS::tunnelBuilder;

use strict;
use VPS;
use VPS::routeDialog;
use VPS::simpleAlert;

use Tk;
use Tk::Menu;

use Exporter;

@VPS::tunnelBuilder::ISA = qw(Exporter);
@VPS::tunnelBuilder::EXPORT = qw(tunnelBuilder tunnelAddRoute);

# interface generated by SpecTcl (Perl enabled) version 1.1 
# from tunnelBuilder.ui
# For use with Tk402.002, using the grid geometry manager

local $VPS::tunnelBuilder::root;
local $VPS::tunnelBuilder::lbTunnelLocalRoute;

my($entTunnelName,$entTunnelLocalAddr,$entTunnelRemoteAddr,$entTunnelGatewayAddr,$lbTunnelRouteDestination,$lbTunnelRouteNetmask,$sbTunnelRoute);
sub tunnelBuilder {
    my ($command,$index,$refData) = @_;

    if ((windowOpen("key_ui")) || (windowOpen('tunnelBuilder')) || (windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return 0;
    }
    return 0 if (VPS::openWindow("tunnelBuilder"));

    $VPS::tunnelBuilder::root = MainWindow->new();
    $VPS::tunnelBuilder::root->title("VPS $main::VPSversion Administrator - Tunnel Builder");
    # widget creation 
    
    my($frame_2) = $VPS::tunnelBuilder::root->Frame (
				 );
    my($frame_3) = $VPS::tunnelBuilder::root->Frame (
				 );
    my($frame_4) = $VPS::tunnelBuilder::root->Frame (
				 );
    my($frame_1) = $VPS::tunnelBuilder::root->Frame (
				 );
    my($frame_5) = $VPS::tunnelBuilder::root->Frame (
				 );
    my($frame_6) = $VPS::tunnelBuilder::root->Frame (
				 );
    my($label_1) = $VPS::tunnelBuilder::root->Label (
				 -anchor => 'sw',
				 -justify => 'left',
				 -text => 'Tunnel Name',
				 );
    my($label_2) = $VPS::tunnelBuilder::root->Label (
				 -anchor => 'sw',
				 -justify => 'left',
				 -text => 'Local IP Address',
				 );
    my($label_3) = $VPS::tunnelBuilder::root->Label (
				 -anchor => 'sw',
				 -justify => 'left',
				 -text => 'Remote IP Address',
				 );
    my($label_4) = $VPS::tunnelBuilder::root->Label (
				 -anchor => 'sw',
				 -justify => 'left',
				 -text => 'Gateway Address',
				 );
    ($entTunnelName) = $VPS::tunnelBuilder::root->Entry (
				       );
    
    ($entTunnelLocalAddr) = $VPS::tunnelBuilder::root->Entry (
					    );

    ($entTunnelRemoteAddr) = $VPS::tunnelBuilder::root->Entry (
					     );

    ($entTunnelGatewayAddr) = $VPS::tunnelBuilder::root->Entry (
					     );

    my($label_7) = $VPS::tunnelBuilder::root->Label (
				 -anchor => 'sw',
				 -justify => 'left',
				 -foreground => 'red',
				 -text => 'Local Routes',
				 );
    my($label_8) = $VPS::tunnelBuilder::root->Label (
				 -anchor => 'sw',
				 -justify => 'left',
				 -font => "-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*",
				 -text => buildTunnelRouteString('Destination','Netmask'),
				 );
    $VPS::tunnelBuilder::lbTunnelLocalRoute = $VPS::tunnelBuilder::root->Scrolled ('Listbox',
					-scrollbars => 'e',
					-font => "-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*",
					-height => '5',
					-width => '0',
					);
    $VPS::tunnelBuilder::lbTunnelLocalRoute->bind('<Double-1>' => [\&modifyRoute,$VPS::tunnelBuilder::lbTunnelLocalRoute]);
    my($butTunnelAddLocalRoute) = $VPS::tunnelBuilder::root->Button (
					    -text => 'Add Route...',
					    -command => [\&addRoute,$VPS::tunnelBuilder::lbTunnelLocalRoute]
					    );
    my($butTunnelModifyLocalRoute) = $VPS::tunnelBuilder::root->Button (
					       -text => 'Modify Route...',
					       -command => [\&modifyRoute,$VPS::tunnelBuilder::lbTunnelLocalRoute]
					       );
    my($butTunnelDeleteLocalRoute) = $VPS::tunnelBuilder::root->Button (
					       -text => 'Delete Route...',
					       -command => [\&deleteRoute,$VPS::tunnelBuilder::lbTunnelLocalRoute]
					       );
    
    my($label_9) = $VPS::tunnelBuilder::root->Label (
				 -anchor => 'sw',
				 -justify => 'left',
				 -foreground => 'red',
				 -text => 'Remote Routes',
				 );
    my($label_10) = $VPS::tunnelBuilder::root->Label (
				  -anchor => 'sw',
				  -justify => 'left',
				  -font => "-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*",
				  -text => buildTunnelRouteString('Destination','Netmask'),
				  );
    $VPS::tunnelBuilder::lbTunnelRemoteRoute = $VPS::tunnelBuilder::root->Scrolled ('Listbox',
										    -scrollbars => 'e',
										    -font => "-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*",
										    -height => '5',
										    -width => '0',
										    );
    $VPS::tunnelBuilder::lbTunnelRemoteRoute->bind('<Double-1>' => [\&modifyRoute,$VPS::tunnelBuilder::lbTunnelRemoteRoute]);
    my($butTunnelAddRemoteRoute) = $VPS::tunnelBuilder::root->Button (
					    -text => 'Add Route...',
					    -command => [\&addRoute,$VPS::tunnelBuilder::lbTunnelRemoteRoute]
					    );
    my($butTunnelModifyRemoteRoute) = $VPS::tunnelBuilder::root->Button (
					       -text => 'Modify Route...',
					       -command => [\&modifyRoute,$VPS::tunnelBuilder::lbTunnelRemoteRoute]
					       );
    my($butTunnelDeleteRemoteRoute) = $VPS::tunnelBuilder::root->Button (
					       -text => 'Delete Route...',
					       -command => [\&deleteRoute,$VPS::tunnelBuilder::lbTunnelRemoteRoute]
					       );

    my($butTunnelOK)= $VPS::tunnelBuilder::root->Button (
				     -text => 'OK',
				     -command => [\&updateTunnelCommand,$index,$refData,$command]
				      );
    my($butTunnelCancel) = $VPS::tunnelBuilder::root->Button (
					  -text => 'Cancel',
					  -command => \&cancelTunnelCommand
					  );
    $VPS::tunnelBuilder::root->protocol("WM_DELETE_WINDOW" => \&cancelTunnelCommand);
    
    # Geometry management
    
    $frame_1->grid(
		   -in => $VPS::tunnelBuilder::root,
		   -column => '1',
		   -row => '1',
		   -sticky => 'n'
		   );
    $frame_2->grid(
		   -in => $VPS::tunnelBuilder::root,
		   -column => '1',
		   -row => '2',
		   -sticky => 'nesw'
		   );
    $frame_3->grid(
		   -in => $VPS::tunnelBuilder::root,
		   -column => '1',
		   -row => '3',
		   -sticky => 'nesw',
		   -pady => 10
		   );
    $frame_4->grid(
		   -in => $VPS::tunnelBuilder::root,
		   -column => '1',
		   -row => '4',
		   -sticky => 'nesw'
		   );
    $frame_5->grid(
		   -in => $frame_2,
		   -column => '1',
		   -row => '4',
		   -sticky => 'nesw'
		   );
    $frame_6->grid(
		   -in => $frame_3,
		   -column => '1',
		   -row => '4',
		   -sticky => 'nesw'
		   );
    $label_1->grid(
		   -in => $frame_1,
		   -column => '1',
		   -row => '1',
		   -sticky => 'sw'
		   );
    $entTunnelName->grid(
			 -in => $frame_1,
			 -column => '1',
			 -row => '2'
			 );
    $label_2->grid(
		   -in => $frame_1,
		   -column => '2',
		   -row => '1',
		   -sticky => 'sw'
		   );
    $entTunnelLocalAddr->grid(
			      -in => $frame_1,
			      -column => '2',
			      -row => '2'
			      );
    $label_3->grid(
		   -in => $frame_1,
		   -column => '3',
		   -row => '1',
		   -sticky => 'sw'
		   );
    $entTunnelRemoteAddr->grid(
			       -in => $frame_1,
			       -column => '3',
			       -row => '2'
			       );
    $label_4->grid(
		   -in => $frame_1,
		   -column => '4',
		   -row => '1',
		   -sticky => 'sw'
		   );
    $entTunnelGatewayAddr->grid(
			       -in => $frame_1,
			       -column => '4',
			       -row => '2'
			       );
    $label_7->grid(
		   -in => $frame_2,
		   -column => '1',
		   -row => '1',
		   -sticky => 's',
		   -pady => 10
		   );
    $label_8->grid(
		   -in => $frame_2,
		   -column => '1',
		   -row => '2',
		   -sticky => 'sw'
		   );
    $VPS::tunnelBuilder::lbTunnelLocalRoute->grid(
			 -in => $frame_2,
			 -column => '1',
			 -row => '3',
			 -sticky => 'nesw'
			 );
    $butTunnelAddLocalRoute->grid(
			     -in => $frame_5,
			     -column => '1',
			     -row => '1',
			     -sticky => 'n'
			     );
    $butTunnelModifyLocalRoute->grid(
				-in => $frame_5,
				-column => '2',
				-row => '1',
				-sticky => 'n'
				);
    $butTunnelDeleteLocalRoute->grid(
				-in => $frame_5,
				-column => '3',
				-row => '1',
				-sticky => 'n'
				);
    $label_9->grid(
		   -in => $frame_3,
		   -column => '1',
		   -row => '1',
		   -sticky => 's',
		   -pady => 10
		   );
    $label_10->grid(
		   -in => $frame_3,
		   -column => '1',
		   -row => '2',
		   -sticky => 'sw'
		   );
    $VPS::tunnelBuilder::lbTunnelRemoteRoute->grid(
			 -in => $frame_3,
			 -column => '1',
			 -row => '3',
			 -sticky => 'nesw'
			 );
    $butTunnelAddRemoteRoute->grid(
			     -in => $frame_6,
			     -column => '1',
			     -row => '1',
			     -sticky => 'n'
			     );
    $butTunnelModifyRemoteRoute->grid(
				-in => $frame_6,
				-column => '2',
				-row => '1',
				-sticky => 'n'
				);
    $butTunnelDeleteRemoteRoute->grid(
				-in => $frame_6,
				-column => '3',
				-row => '1',
				-sticky => 'n'
				);
    $butTunnelOK->grid(
		       -in => $frame_4,
		       -column => '1',
		       -row => '1',
		       );
    $butTunnelCancel->grid(
			   -in => $frame_4,
			   -column => '2',
			   -row => '1',
			   );
    
    # Resize behavior management
    
    # container $frame_1 (rows)
    $frame_1->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    $frame_1->gridRowconfigure(2, -weight  => 0, -minsize  => 34);
    
    # container $frame_1 (columns)
    $frame_1->gridColumnconfigure(1, -weight => 0, -minsize => 30);
    $frame_1->gridColumnconfigure(2, -weight => 0, -minsize => 30);
    $frame_1->gridColumnconfigure(3, -weight => 0, -minsize => 30);
    $frame_1->gridColumnconfigure(4, -weight => 0, -minsize => 30);
    
    # container $frame_2 (rows)
    $frame_2->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    $frame_2->gridRowconfigure(2, -weight  => 0, -minsize  => 30);
    $frame_2->gridRowconfigure(3, -weight  => 1, -minsize  => 30);
    $frame_2->gridRowconfigure(4, -weight  => 0, -minsize  => 30);
    
    # container $frame_2 (columns)
    $frame_2->gridColumnconfigure(1, -weight => 1, -minsize => 2);
    
    # container $frame_3 (rows)
    $frame_3->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    $frame_3->gridRowconfigure(2, -weight  => 0, -minsize  => 30);
    $frame_3->gridRowconfigure(3, -weight  => 1, -minsize  => 30);
    $frame_3->gridRowconfigure(4, -weight  => 0, -minsize  => 30);
    
    # container $frame_3 (columns)
    $frame_3->gridColumnconfigure(1, -weight => 1, -minsize => 2);
    
    # container $frame_4 (rows)
    $frame_4->gridRowconfigure(1, -weight  => 0, -minsize  => 30);
    
    # container $frame_4 (columns)
    $frame_4->gridColumnconfigure(1, -weight => 0, -minsize => 30);
    $frame_4->gridColumnconfigure(2, -weight => 0, -minsize => 30);
    
    # container $frame_5 (columns)    
    $frame_5->gridRowconfigure(1, -weight  => 0, -minsize  => 30);

    # container $frame_5 (rows)
    $frame_5->gridColumnconfigure(1, -weight => 0, -minsize => 30);
    $frame_5->gridColumnconfigure(2, -weight => 0, -minsize => 30);
    $frame_5->gridColumnconfigure(3, -weight => 0, -minsize => 30);

    # container $frame_6 (columns)    
    $frame_6->gridRowconfigure(1, -weight  => 0, -minsize  => 30);

    # container $frame_5 (rows)
    $frame_6->gridColumnconfigure(1, -weight => 0, -minsize => 30);
    $frame_6->gridColumnconfigure(2, -weight => 0, -minsize => 30);
    $frame_6->gridColumnconfigure(3, -weight => 0, -minsize => 30);

    # container $VPS::tunnelBuilder::root (rows)
    $VPS::tunnelBuilder::root->gridRowconfigure(1, -weight  => 0, -minsize  => 72);
    $VPS::tunnelBuilder::root->gridRowconfigure(2, -weight  => 1, -minsize  => 30);
    $VPS::tunnelBuilder::root->gridRowconfigure(3, -weight  => 1, -minsize  => 30);
    $VPS::tunnelBuilder::root->gridRowconfigure(4, -weight  => 0, -minsize  => 30);
    
    # container $VPS::tunnelBuilder::root (columns)
    $VPS::tunnelBuilder::root->gridColumnconfigure(1, -weight => 1, -minsize => 30);
    
    # additional interface code (Make this a dialog box)
    if (($command == 2) && ($refData)) {
	$entTunnelName->insert(0,$$refData[$index]{'tunnelName'});
	$entTunnelLocalAddr->insert(0,$$refData[$index]{'tunnelLocalAddr'});
	$entTunnelRemoteAddr->insert(0,$$refData[$index]{'tunnelRemoteAddr'});
	$entTunnelGatewayAddr->insert(0,$$refData[$index]{'tunnelGatewayAddr'});
	if ($$refData[$index]{'tunnelLocalRoute'}) {
	    my $numroutes = @{ $$refData[$index]{'tunnelLocalRoute'} };
	    my $i;
	    for ($i=0;$i<$numroutes;$i++) {
		$VPS::tunnelBuilder::lbTunnelLocalRoute->insert($i,$$refData[$index]{'tunnelLocalRoute'}[$i]);
	    }
	}
	if ($$refData[$index]{'tunnelRemoteRoute'}) {
	    my $numroutes = @{ $$refData[$index]{'tunnelRemoteRoute'} };
	    my $i;
	    for ($i=0;$i<$numroutes;$i++) {
		$VPS::tunnelBuilder::lbTunnelRemoteRoute->insert($i,$$refData[$index]{'tunnelRemoteRoute'}[$i]);
	    }
	}
    }
    # end additional interface code
}

sub updateTunnelCommand {
    my ($index,$refData,$command) = @_;

    if ((windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    if (!closeWindow("tunnelBuilder")) {
	my %tunnelInfo = &saveTunnelInfo;
	my ($ok,$err) = &verifyTunnelConfig(%tunnelInfo);
	if (!$ok) {
	    &updateTunnel($index,$refData,$command,%tunnelInfo);
	    $VPS::tunnelBuilder::root->destroy;
	}
	else {
	    openWindow("tunnelBuilder");
	    simpleAlert($VPS::tunnelBuilder::root,$err);
	}
    }
}

sub cancelTunnelCommand {
    if ((windowOpen('route_ui')) || (windowOpen('simpleAlert'))) {
	message("Function currently inaccessable.");
	return (1,\@VPS::data);
    }
    if (!closeWindow("tunnelBuilder")) {
	$VPS::tunnelBuilder::root->destroy;
    }
}

sub verifyTunnelConfig {
    my (%ret) = @_;

    if (($ret{'tunnelName'}) &&
	($ret{'tunnelLocalAddr'}) &&
	($ret{'tunnelRemoteAddr'}) &&
	($ret{'tunnelGatewayAddr'})) {
	return (0,"OK");
    }
    else {
	return (1,"The Tunnel Name, Local IP Address, Remote Address and Gateway must be filled in.");
    }
}

sub saveTunnelInfo {
    my %ret;
    
    $ret{'tunnelName'} = $entTunnelName->get;
    $ret{'tunnelLocalAddr'} = $entTunnelLocalAddr->get;
    $ret{'tunnelRemoteAddr'} = $entTunnelRemoteAddr->get;
    $ret{'tunnelGatewayAddr'} = $entTunnelGatewayAddr->get;
    $ret{'tunnelLocalRoute'} = [ $VPS::tunnelBuilder::lbTunnelLocalRoute->get(0,"end") ];
    $ret{'tunnelRemoteRoute'} = [ $VPS::tunnelBuilder::lbTunnelRemoteRoute->get(0,"end") ];

    return %ret;
}

sub addRoute {
    my ($lbref) = @_;

    &VPS::routeDialog::route_ui(1,"end",'','',$lbref);
}

sub modifyRoute {
    my ($lbref) = @_;

    my $index;
    if (windowOpen('route_ui')) {
	message("Function currently inaccessable.");
	return 0;
    }
    $index = $lbref->curselection if (defined($lbref));
    if (length($index) == 0) {
      VPS::simpleAlert::simpleAlert($VPS::mainWindow::root,"No Route Selected.");
	return 1;
    }
    my $string = $lbref->get($index,$index);
    my ($dest,$mask) = split(' ',$string);
    &VPS::routeDialog::route_ui(2,$index,$dest,$mask,$lbref);
}

sub deleteRoute {
    my ($lbref) = @_;

    my $index;
    if (windowOpen('route_ui')) {
	message("Function currently inaccessable.");
	return 0;
    }
    $index = $lbref->curselection if (defined($lbref));
    if (length($index) == 0) {
      simpleAlert($VPS::mainWindow::root,"No Route Selected.");
	return 1;
    }
    if (simpleAlert($VPS::mainWindow::root,"Delete Selected Route?")) {
	$lbref->delete($index);
	message("Route Deleted.");
    }
}

1;
