/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "term.h"
#include "types.h"
#include "ctypes.h"

ccolumnar::ccolumnar(){
  *cipher = '\0';
  ocipher = NULL;
  key = NULL;
  clen = 0;
  period = 0;
  period_set = FALSE;
}

int ccolumnar::execute_option(char option){
  switch(option){
    case CHANGEPERIOD:
      change_period();
      break;
    case MOVE:
      move_stuff();
      break;
    case UNDO:
      undo();
      vert2horiz();
      break;
    default:
      base_exec_option(option);
      break;
  }

  return TRUE;
}

int ccolumnar::period_valid(){
  if(length%period == 0)
    return TRUE;
  else
    return FALSE;
}

void ccolumnar::setup_key(){
  int i;

  key = new int[period];
  for(i = 0; i < period; i++)
    key[i] = i+1;
}

void ccolumnar::init_cipher(){
  if(ocipher == NULL){

    clen = length / period;
    length = strlen(cipher);
  
    ocipher = strdup(cipher);
  
    vert2horiz();
  }
}

void ccolumnar::change_period(){
  char temp_str[STRINGLENGTH];
  int temp_period;

  period_set = FALSE;
  set_period();
  clr_scr();
}

void ccolumnar::show_menu(){
  menu(1, "(M)ove columns  (U)ndo changes  (C)hange period  (W)rite   (Q)uit");
}

void ccolumnar::show_cipher(){
  int i;

  /* Print the row/column numbers
  */

  for(i = 0; i < period; i++)
    (void)put_char((i+1)%10 + '0', 2*i+3, 0);
  
  if(clen > 17)
    for(i = 0; i < period; i++)
      (void)put_char((i+1)%10 + '0', 2*i+2*period+8, 0);

  /* Print the cipher
  */

  for(i = 0; i < length; i++){
    if(i < 17*period)
      (void)put_char(cipher[i], (i%period)*2+3, (i/period) + 2);
    else
      (void)put_char(cipher[i], (i%period)*2+8+2*period, (i/period) + 2-17);
  }
}

void ccolumnar::show_key(){ }

void ccolumnar::move_stuff(){
  char temp_str[STRINGLENGTH];
  int column1, column2, i;

  prompt("Interchange which two columns/rows? (ex: 1,2) ");
  read_line(temp_str);
  if(sscanf(temp_str, "%d,%d", &column1, &column2) != 2);
  else if(column1 <= period && column2 <= period && column1 > 0 && column2 > 0){
    column1--, column2--;
    interchange_columns(column1, column2);

    i = key[column1];
    key[column1] = key[column2];
    key[column2] = i;
  }
  
  else{
    msgerror("Bad column number.");
  }
}

void ccolumnar::decipher(char *string){
  strcpy(string, cipher);
}

void ccolumnar::copy_key(char *string){
  int i;

  for(i = 0; i < period; i++)
    string[i] = (char) (key[i] + '0');
  
  string[period] = '\0';
}

void ccolumnar::read_key(FILE *fptr){
  char temp_str[STRINGLENGTH];
  int i;

  fgets(temp_str, STRINGLENGTH, fptr);

  for(i = 0; i < period; i++)
    key[i] = temp_str[i] - '0';
}

void ccolumnar::get_cipher(char *string){
  horiz2vert();
  strcpy(string, cipher);
  vert2horiz();
}
