/* This is one of the cipher files for the cipher interface written
** by wart@ugcs.caltech.edu
**
** Please don't steal my code without my permission.
**
*/

/* This is the location of all the cute terminal stuff so that we don't
** have to put up with that scrolling crap.
*/

#ifndef _CURSES_INCLUDED
#include <curses.h>
# ifndef _CURSES_INCLUDED
# define _CURSES_INCLUDED
# endif
#endif
#include <string.h>
#include <stdarg.h>
#include "term.h"

int promptline, errorline;

void
ready_term(){
  initscr();
  promptline = LINES-2;
  errorline = promptline+1;
  refresh();
}

void
unready_term(){
  endwin();
}

void
set_input_mode(int nl_allowed, int cbreak_on, int echo_on){
  if(nl_allowed)
    nl();
  else
    nonl();
  
  if(cbreak_on)
    cbreak();
  else
    nocbreak();
  
  if(echo_on)
    echo();
  else
    noecho();
}
  

void
msgprint(int column, int row, char *fmt, ...){
  va_list ap;
  char temp_str[4096];
  
  move(row, column);

  va_start(ap, fmt);
  vsprintf(temp_str, fmt, ap);
  va_end(ap);
  addstr(temp_str);

  refresh();
}

void
put_char(char letter, int column, int row){
  mvaddch(row, column, letter);
}

void
prompt(char *fmt, ...) {
  va_list ap;
  char temp_str[4096];

  move(promptline, 0);
  clrtoeol();

  va_start(ap, fmt);
  vsprintf(temp_str, fmt, ap);
  va_end(ap);
  addstr(temp_str);

  move(promptline, strlen(temp_str));
  refresh();
}

void
msgerror(char *fmt, ...) {
  va_list ap;
  char temp_str[4096];

  move(errorline, 0);
  clrtoeol();

  va_start(ap, fmt);
  vsprintf(temp_str, fmt, ap);
  va_end(ap);
  addstr(temp_str);

  refresh();
}

void
menu(int row, char *fmt, ...){
  va_list ap;
  char temp_str[4096];

  if(row < MAX_MENU_LENGTH){
    move(promptline-row, 0);
    clrtoeol();

    va_start(ap, fmt);
    vsprintf(temp_str, fmt, ap);
    va_end(ap);
    addstr(temp_str);
  }
  refresh();
}

void
clear_menu(){
  int i;

  for(i = 0; i < MAX_MENU_LENGTH; i++){
    move(promptline-i, 0);
    clrtoeol();
  }
  refresh();
}

void
clear_after_prompt(){
  move(promptline+1, 0);
  clrtobot();
  refresh();
}

void
clear_to_prompt(){
  int i;

  for(i = 0; i < promptline; i++){
    move(i, 0);
    clrtoeol();
  }
}

void
clear_line(int column, int row){
  move(row, column);
  clrtoeol();
}

void
read_line(char *word){
  int position=0;

  while( (word[position] = getch()) != '\r' && word[position] != '\n'){
    if(word[position] == erasechar() ||
       word[position] == '\177' ||
       word[position] == '\010'){
      if(position > 0){
	position--;
	addch('\b');
	delch();
      }
    }
    else if(word[position] == '\025'){
      if(position > 0){
	do{
	  addch('\b');
	  delch();
	} while(--position);
      }
    }
    else{
      addch(word[position]);
      position++;
    }
    refresh();
  }
  word[position] = '\0';
}
