/*
 * This Java version of Eric Young's code created from the
 * original source by Jeremy Allison. <jra@cygnus.com>.
 */

/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 * 
 * This file is part of an SSL implementation written
 * by Eric Young (eay@mincom.oz.au).
 * The implementation was written so as to conform with Netscapes SSL
 * specification.  This library and applications are
 * FREE FOR COMMERCIAL AND NON-COMMERCIAL USE
 * as long as the following conditions are aheared to.
 * 
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.  If this code is used in a product,
 * Eric Young should be given attribution as the author of the parts used.
 * This can be in the form of a textual message at program startup or
 * in documentation (online or textual) provided with the package.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by Eric Young (eay@mincom.oz.au)
 * 
 * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 * The licence and distribution terms for any publically available version or
 * derivative of this code cannot be changed.  i.e. this code cannot simply be
 * copied and put under another distribution licence
 * [including the GNU Public Licence.]
 */

import java.io.*;

class DesTest {
  public static byte key_data[][] = {
	{(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00},
	{(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,
	 (byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF},
	{(byte)0x30,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00},
	{(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
	 (byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11},
	{(byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
	 (byte)0x89,(byte)0xAB,(byte)0xCD,(byte)0xEF},
	{(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
	 (byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11},
	{(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00},
	{(byte)0xFE,(byte)0xDC,(byte)0xBA,(byte)0x98,
	 (byte)0x76,(byte)0x54,(byte)0x32,(byte)0x10},
	{(byte)0x7C,(byte)0xA1,(byte)0x10,(byte)0x45,
	 (byte)0x4A,(byte)0x1A,(byte)0x6E,(byte)0x57},
	{(byte)0x01,(byte)0x31,(byte)0xD9,(byte)0x61,
	 (byte)0x9D,(byte)0xC1,(byte)0x37,(byte)0x6E},
	{(byte)0x07,(byte)0xA1,(byte)0x13,(byte)0x3E,
	 (byte)0x4A,(byte)0x0B,(byte)0x26,(byte)0x86},
	{(byte)0x38,(byte)0x49,(byte)0x67,(byte)0x4C,
	 (byte)0x26,(byte)0x02,(byte)0x31,(byte)0x9E},
	{(byte)0x04,(byte)0xB9,(byte)0x15,(byte)0xBA,
	 (byte)0x43,(byte)0xFE,(byte)0xB5,(byte)0xB6},
	{(byte)0x01,(byte)0x13,(byte)0xB9,(byte)0x70,
	 (byte)0xFD,(byte)0x34,(byte)0xF2,(byte)0xCE},
	{(byte)0x01,(byte)0x70,(byte)0xF1,(byte)0x75,
	 (byte)0x46,(byte)0x8F,(byte)0xB5,(byte)0xE6},
	{(byte)0x43,(byte)0x29,(byte)0x7F,(byte)0xAD,
	 (byte)0x38,(byte)0xE3,(byte)0x73,(byte)0xFE},
	{(byte)0x07,(byte)0xA7,(byte)0x13,(byte)0x70,
	 (byte)0x45,(byte)0xDA,(byte)0x2A,(byte)0x16},
	{(byte)0x04,(byte)0x68,(byte)0x91,(byte)0x04,
	 (byte)0xC2,(byte)0xFD,(byte)0x3B,(byte)0x2F},
	{(byte)0x37,(byte)0xD0,(byte)0x6B,(byte)0xB5,
	 (byte)0x16,(byte)0xCB,(byte)0x75,(byte)0x46},
	{(byte)0x1F,(byte)0x08,(byte)0x26,(byte)0x0D,
	 (byte)0x1A,(byte)0xC2,(byte)0x46,(byte)0x5E},
	{(byte)0x58,(byte)0x40,(byte)0x23,(byte)0x64,
	 (byte)0x1A,(byte)0xBA,(byte)0x61,(byte)0x76},
	{(byte)0x02,(byte)0x58,(byte)0x16,(byte)0x16,
	 (byte)0x46,(byte)0x29,(byte)0xB0,(byte)0x07},
	{(byte)0x49,(byte)0x79,(byte)0x3E,(byte)0xBC,
	 (byte)0x79,(byte)0xB3,(byte)0x25,(byte)0x8F},
	{(byte)0x4F,(byte)0xB0,(byte)0x5E,(byte)0x15,
	 (byte)0x15,(byte)0xAB,(byte)0x73,(byte)0xA7},
	{(byte)0x49,(byte)0xE9,(byte)0x5D,(byte)0x6D,
	 (byte)0x4C,(byte)0xA2,(byte)0x29,(byte)0xBF},
	{(byte)0x01,(byte)0x83,(byte)0x10,(byte)0xDC,
	 (byte)0x40,(byte)0x9B,(byte)0x26,(byte)0xD6},
	{(byte)0x1C,(byte)0x58,(byte)0x7F,(byte)0x1C,
	 (byte)0x13,(byte)0x92,(byte)0x4F,(byte)0xEF},
	{(byte)0x01,(byte)0x01,(byte)0x01,(byte)0x01,
	 (byte)0x01,(byte)0x01,(byte)0x01,(byte)0x01},
	{(byte)0x1F,(byte)0x1F,(byte)0x1F,(byte)0x1F,
	 (byte)0x0E,(byte)0x0E,(byte)0x0E,(byte)0x0E},
	{(byte)0xE0,(byte)0xFE,(byte)0xE0,(byte)0xFE,
	 (byte)0xF1,(byte)0xFE,(byte)0xF1,(byte)0xFE},
	{(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00},
	{(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,
	 (byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF},
	{(byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
	 (byte)0x89,(byte)0xAB,(byte)0xCD,(byte)0xEF},
	{(byte)0xFE,(byte)0xDC,(byte)0xBA,(byte)0x98,
	 (byte)0x76,(byte)0x54,(byte)0x32,(byte)0x10}};

  public static byte plain_data[][] = {
	{(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00},
	{(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,
	 (byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF},
	{(byte)0x10,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x01},
	{(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
	 (byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11},
	{(byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11,
	 (byte)0x11,(byte)0x11,(byte)0x11,(byte)0x11},
	{(byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
	 (byte)0x89,(byte)0xAB,(byte)0xCD,(byte)0xEF},
	{(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00},
	{(byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
	 (byte)0x89,(byte)0xAB,(byte)0xCD,(byte)0xEF},
	{(byte)0x01,(byte)0xA1,(byte)0xD6,(byte)0xD0,
	 (byte)0x39,(byte)0x77,(byte)0x67,(byte)0x42},
	{(byte)0x5C,(byte)0xD5,(byte)0x4C,(byte)0xA8,
	 (byte)0x3D,(byte)0xEF,(byte)0x57,(byte)0xDA},
	{(byte)0x02,(byte)0x48,(byte)0xD4,(byte)0x38,
	 (byte)0x06,(byte)0xF6,(byte)0x71,(byte)0x72},
	{(byte)0x51,(byte)0x45,(byte)0x4B,(byte)0x58,
	 (byte)0x2D,(byte)0xDF,(byte)0x44,(byte)0x0A},
	{(byte)0x42,(byte)0xFD,(byte)0x44,(byte)0x30,
	 (byte)0x59,(byte)0x57,(byte)0x7F,(byte)0xA2},
	{(byte)0x05,(byte)0x9B,(byte)0x5E,(byte)0x08,
	 (byte)0x51,(byte)0xCF,(byte)0x14,(byte)0x3A},
	{(byte)0x07,(byte)0x56,(byte)0xD8,(byte)0xE0,
	 (byte)0x77,(byte)0x47,(byte)0x61,(byte)0xD2},
	{(byte)0x76,(byte)0x25,(byte)0x14,(byte)0xB8,
	 (byte)0x29,(byte)0xBF,(byte)0x48,(byte)0x6A},
	{(byte)0x3B,(byte)0xDD,(byte)0x11,(byte)0x90,
	 (byte)0x49,(byte)0x37,(byte)0x28,(byte)0x02},
	{(byte)0x26,(byte)0x95,(byte)0x5F,(byte)0x68,
	 (byte)0x35,(byte)0xAF,(byte)0x60,(byte)0x9A},
	{(byte)0x16,(byte)0x4D,(byte)0x5E,(byte)0x40,
	 (byte)0x4F,(byte)0x27,(byte)0x52,(byte)0x32},
	{(byte)0x6B,(byte)0x05,(byte)0x6E,(byte)0x18,
	 (byte)0x75,(byte)0x9F,(byte)0x5C,(byte)0xCA},
	{(byte)0x00,(byte)0x4B,(byte)0xD6,(byte)0xEF,
	 (byte)0x09,(byte)0x17,(byte)0x60,(byte)0x62},
	{(byte)0x48,(byte)0x0D,(byte)0x39,(byte)0x00,
	 (byte)0x6E,(byte)0xE7,(byte)0x62,(byte)0xF2},
	{(byte)0x43,(byte)0x75,(byte)0x40,(byte)0xC8,
	 (byte)0x69,(byte)0x8F,(byte)0x3C,(byte)0xFA},
	{(byte)0x07,(byte)0x2D,(byte)0x43,(byte)0xA0,
	 (byte)0x77,(byte)0x07,(byte)0x52,(byte)0x92},
	{(byte)0x02,(byte)0xFE,(byte)0x55,(byte)0x77,
	 (byte)0x81,(byte)0x17,(byte)0xF1,(byte)0x2A},
	{(byte)0x1D,(byte)0x9D,(byte)0x5C,(byte)0x50,
	 (byte)0x18,(byte)0xF7,(byte)0x28,(byte)0xC2},
	{(byte)0x30,(byte)0x55,(byte)0x32,(byte)0x28,
	 (byte)0x6D,(byte)0x6F,(byte)0x29,(byte)0x5A},
	{(byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
	 (byte)0x89,(byte)0xAB,(byte)0xCD,(byte)0xEF},
	{(byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
	 (byte)0x89,(byte)0xAB,(byte)0xCD,(byte)0xEF},
	{(byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
	 (byte)0x89,(byte)0xAB,(byte)0xCD,(byte)0xEF},
	{(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,
	 (byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF},
	{(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00},
	{(byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00,
	 (byte)0x00,(byte)0x00,(byte)0x00,(byte)0x00},
	{(byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF,
	 (byte)0xFF,(byte)0xFF,(byte)0xFF,(byte)0xFF}};

  public static byte cipher_data[][] = {
	{(byte)0x8C,(byte)0xA6,(byte)0x4D,(byte)0xE9,
	 (byte)0xC1,(byte)0xB1,(byte)0x23,(byte)0xA7},
	{(byte)0x73,(byte)0x59,(byte)0xB2,(byte)0x16,
	 (byte)0x3E,(byte)0x4E,(byte)0xDC,(byte)0x58},
	{(byte)0x95,(byte)0x8E,(byte)0x6E,(byte)0x62,
	 (byte)0x7A,(byte)0x05,(byte)0x55,(byte)0x7B},
	{(byte)0xF4,(byte)0x03,(byte)0x79,(byte)0xAB,
	 (byte)0x9E,(byte)0x0E,(byte)0xC5,(byte)0x33},
	{(byte)0x17,(byte)0x66,(byte)0x8D,(byte)0xFC,
	 (byte)0x72,(byte)0x92,(byte)0x53,(byte)0x2D},
	{(byte)0x8A,(byte)0x5A,(byte)0xE1,(byte)0xF8,
	 (byte)0x1A,(byte)0xB8,(byte)0xF2,(byte)0xDD},
	{(byte)0x8C,(byte)0xA6,(byte)0x4D,(byte)0xE9,
	 (byte)0xC1,(byte)0xB1,(byte)0x23,(byte)0xA7},
	{(byte)0xED,(byte)0x39,(byte)0xD9,(byte)0x50,
	 (byte)0xFA,(byte)0x74,(byte)0xBC,(byte)0xC4},
	{(byte)0x69,(byte)0x0F,(byte)0x5B,(byte)0x0D,
	 (byte)0x9A,(byte)0x26,(byte)0x93,(byte)0x9B},
	{(byte)0x7A,(byte)0x38,(byte)0x9D,(byte)0x10,
	 (byte)0x35,(byte)0x4B,(byte)0xD2,(byte)0x71},
	{(byte)0x86,(byte)0x8E,(byte)0xBB,(byte)0x51,
	 (byte)0xCA,(byte)0xB4,(byte)0x59,(byte)0x9A},
	{(byte)0x71,(byte)0x78,(byte)0x87,(byte)0x6E,
	 (byte)0x01,(byte)0xF1,(byte)0x9B,(byte)0x2A},
	{(byte)0xAF,(byte)0x37,(byte)0xFB,(byte)0x42,
	 (byte)0x1F,(byte)0x8C,(byte)0x40,(byte)0x95},
	{(byte)0x86,(byte)0xA5,(byte)0x60,(byte)0xF1,
	 (byte)0x0E,(byte)0xC6,(byte)0xD8,(byte)0x5B},
	{(byte)0x0C,(byte)0xD3,(byte)0xDA,(byte)0x02,
	 (byte)0x00,(byte)0x21,(byte)0xDC,(byte)0x09},
	{(byte)0xEA,(byte)0x67,(byte)0x6B,(byte)0x2C,
	 (byte)0xB7,(byte)0xDB,(byte)0x2B,(byte)0x7A},
	{(byte)0xDF,(byte)0xD6,(byte)0x4A,(byte)0x81,
	 (byte)0x5C,(byte)0xAF,(byte)0x1A,(byte)0x0F},
	{(byte)0x5C,(byte)0x51,(byte)0x3C,(byte)0x9C,
	 (byte)0x48,(byte)0x86,(byte)0xC0,(byte)0x88},
	{(byte)0x0A,(byte)0x2A,(byte)0xEE,(byte)0xAE,
	 (byte)0x3F,(byte)0xF4,(byte)0xAB,(byte)0x77},
	{(byte)0xEF,(byte)0x1B,(byte)0xF0,(byte)0x3E,
	 (byte)0x5D,(byte)0xFA,(byte)0x57,(byte)0x5A},
	{(byte)0x88,(byte)0xBF,(byte)0x0D,(byte)0xB6,
	 (byte)0xD7,(byte)0x0D,(byte)0xEE,(byte)0x56},
	{(byte)0xA1,(byte)0xF9,(byte)0x91,(byte)0x55,
	 (byte)0x41,(byte)0x02,(byte)0x0B,(byte)0x56},
	{(byte)0x6F,(byte)0xBF,(byte)0x1C,(byte)0xAF,
	 (byte)0xCF,(byte)0xFD,(byte)0x05,(byte)0x56},
	{(byte)0x2F,(byte)0x22,(byte)0xE4,(byte)0x9B,
	 (byte)0xAB,(byte)0x7C,(byte)0xA1,(byte)0xAC},
	{(byte)0x5A,(byte)0x6B,(byte)0x61,(byte)0x2C,
	 (byte)0xC2,(byte)0x6C,(byte)0xCE,(byte)0x4A},
	{(byte)0x5F,(byte)0x4C,(byte)0x03,(byte)0x8E,
	 (byte)0xD1,(byte)0x2B,(byte)0x2E,(byte)0x41},
	{(byte)0x63,(byte)0xFA,(byte)0xC0,(byte)0xD0,
	 (byte)0x34,(byte)0xD9,(byte)0xF7,(byte)0x93},
	{(byte)0x61,(byte)0x7B,(byte)0x3A,(byte)0x0C,
	 (byte)0xE8,(byte)0xF0,(byte)0x71,(byte)0x00},
	{(byte)0xDB,(byte)0x95,(byte)0x86,(byte)0x05,
	 (byte)0xF8,(byte)0xC8,(byte)0xC6,(byte)0x06},
	{(byte)0xED,(byte)0xBF,(byte)0xD1,(byte)0xC6,
	 (byte)0x6C,(byte)0x29,(byte)0xCC,(byte)0xC7},
	{(byte)0x35,(byte)0x55,(byte)0x50,(byte)0xB2,
	 (byte)0x15,(byte)0x0E,(byte)0x24,(byte)0x51},
	{(byte)0xCA,(byte)0xAA,(byte)0xAF,(byte)0x4D,
	 (byte)0xEA,(byte)0xF1,(byte)0xDB,(byte)0xAE},
	{(byte)0xD5,(byte)0xD4,(byte)0x4F,(byte)0xF7,
	 (byte)0x20,(byte)0x68,(byte)0x3D,(byte)0x0D},
	{(byte)0x2A,(byte)0x2B,(byte)0xB0,(byte)0x08,
	 (byte)0xDF,(byte)0x97,(byte)0xC2,(byte)0xF2}};

  public static byte cipher_ecb2[][] = {
	{(byte)0x92,(byte)0x95,(byte)0xB5,(byte)0x9B,
	 (byte)0xB3,(byte)0x84,(byte)0x73,(byte)0x6E},
	{(byte)0x19,(byte)0x9E,(byte)0x9D,(byte)0x6D,
	 (byte)0xF3,(byte)0x9A,(byte)0xA8,(byte)0x16},
	{(byte)0x2A,(byte)0x4B,(byte)0x4D,(byte)0x24,
	 (byte)0x52,(byte)0x43,(byte)0x84,(byte)0x27},
	{(byte)0x35,(byte)0x84,(byte)0x3C,(byte)0x01,
	 (byte)0x9D,(byte)0x18,(byte)0xC5,(byte)0xB6},
	{(byte)0x4A,(byte)0x5B,(byte)0x2F,(byte)0x42,
	 (byte)0xAA,(byte)0x77,(byte)0x19,(byte)0x25},
	{(byte)0xA0,(byte)0x6B,(byte)0xA9,(byte)0xB8,
	 (byte)0xCA,(byte)0x5B,(byte)0x17,(byte)0x8A},
	{(byte)0xAB,(byte)0x9D,(byte)0xB7,(byte)0xFB,
	 (byte)0xED,(byte)0x95,(byte)0xF2,(byte)0x74},
	{(byte)0x3D,(byte)0x25,(byte)0x6C,(byte)0x23,
	 (byte)0xA7,(byte)0x25,(byte)0x2F,(byte)0xD6},
	{(byte)0xB7,(byte)0x6F,(byte)0xAB,(byte)0x4F,
	 (byte)0xBD,(byte)0xBD,(byte)0xB7,(byte)0x67},
	{(byte)0x8F,(byte)0x68,(byte)0x27,(byte)0xD6,
	 (byte)0x9C,(byte)0xF4,(byte)0x1A,(byte)0x10},
	{(byte)0x82,(byte)0x57,(byte)0xA1,(byte)0xD6,
	 (byte)0x50,(byte)0x5E,(byte)0x81,(byte)0x85},
	{(byte)0xA2,(byte)0x0F,(byte)0x0A,(byte)0xCD,
	 (byte)0x80,(byte)0x89,(byte)0x7D,(byte)0xFA},
	{(byte)0xCD,(byte)0x2A,(byte)0x53,(byte)0x3A,
	 (byte)0xDB,(byte)0x0D,(byte)0x7E,(byte)0xF3},
	{(byte)0xD2,(byte)0xC2,(byte)0xBE,(byte)0x27,
	 (byte)0xE8,(byte)0x1B,(byte)0x68,(byte)0xE3},
	{(byte)0xE9,(byte)0x24,(byte)0xCF,(byte)0x4F,
	 (byte)0x89,(byte)0x3C,(byte)0x5B,(byte)0x0A},
	{(byte)0xA7,(byte)0x18,(byte)0xC3,(byte)0x9F,
	 (byte)0xFA,(byte)0x9F,(byte)0xD7,(byte)0x69},
	{(byte)0x77,(byte)0x2C,(byte)0x79,(byte)0xB1,
	 (byte)0xD2,(byte)0x31,(byte)0x7E,(byte)0xB1},
	{(byte)0x49,(byte)0xAB,(byte)0x92,(byte)0x7F,
	 (byte)0xD0,(byte)0x22,(byte)0x00,(byte)0xB7},
	{(byte)0xCE,(byte)0x1C,(byte)0x6C,(byte)0x7D,
	 (byte)0x85,(byte)0xE3,(byte)0x4A,(byte)0x6F},
	{(byte)0xBE,(byte)0x91,(byte)0xD6,(byte)0xE1,
	 (byte)0x27,(byte)0xB2,(byte)0xE9,(byte)0x87},
	{(byte)0x70,(byte)0x28,(byte)0xAE,(byte)0x8F,
	 (byte)0xD1,(byte)0xF5,(byte)0x74,(byte)0x1A},
	{(byte)0xAA,(byte)0x37,(byte)0x80,(byte)0xBB,
	 (byte)0xF3,(byte)0x22,(byte)0x1D,(byte)0xDE},
	{(byte)0xA6,(byte)0xC4,(byte)0xD2,(byte)0x5E,
	 (byte)0x28,(byte)0x93,(byte)0xAC,(byte)0xB3},
	{(byte)0x22,(byte)0x07,(byte)0x81,(byte)0x5A,
	 (byte)0xE4,(byte)0xB7,(byte)0x1A,(byte)0xAD},
	{(byte)0xDC,(byte)0xCE,(byte)0x05,(byte)0xE7,
	 (byte)0x07,(byte)0xBD,(byte)0xF5,(byte)0x84},
	{(byte)0x26,(byte)0x1D,(byte)0x39,(byte)0x2C,
	 (byte)0xB3,(byte)0xBA,(byte)0xA5,(byte)0x85},
	{(byte)0xB4,(byte)0xF7,(byte)0x0F,(byte)0x72,
	 (byte)0xFB,(byte)0x04,(byte)0xF0,(byte)0xDC},
	{(byte)0x95,(byte)0xBA,(byte)0xA9,(byte)0x4E,
	 (byte)0x87,(byte)0x36,(byte)0xF2,(byte)0x89},
	{(byte)0xD4,(byte)0x07,(byte)0x3A,(byte)0xF1,
	 (byte)0x5A,(byte)0x17,(byte)0x82,(byte)0x0E},
	{(byte)0xEF,(byte)0x6F,(byte)0xAF,(byte)0xA7,
	 (byte)0x66,(byte)0x1A,(byte)0x7E,(byte)0x89},
	{(byte)0xC1,(byte)0x97,(byte)0xF5,(byte)0x58,
	 (byte)0x74,(byte)0x8A,(byte)0x20,(byte)0xE7},
	{(byte)0x43,(byte)0x34,(byte)0xCF,(byte)0xDA,
	 (byte)0x22,(byte)0xC4,(byte)0x86,(byte)0xC8},
	{(byte)0x08,(byte)0xD7,(byte)0xB4,(byte)0xFB,
	 (byte)0x62,(byte)0x9D,(byte)0x08,(byte)0x85}};

  public static byte cbc_key[] = {
    (byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
    (byte)0x89,(byte)0xab,(byte)0xcd,(byte)0xef};
  public static byte cbc2_key[] = {
    (byte)0xf0,(byte)0xe1,(byte)0xd2,(byte)0xc3,
    (byte)0xb4,(byte)0xa5,(byte)0x96,(byte)0x87};
  public static byte cbc3_key[] = {
    (byte)0xfe,(byte)0xdc,(byte)0xba,(byte)0x98,
    (byte)0x76,(byte)0x54,(byte)0x32,(byte)0x10};

  public static byte cbc_iv[] = {
    (byte)0xfe,(byte)0xdc,(byte)0xba,(byte)0x98,
    (byte)0x76,(byte)0x54,(byte)0x32,(byte)0x10};

  static byte cbc_data[] = new byte [40];
  static String cbc_string = "7654321 Now is the time for ";

  public static byte cbc_ok[] = {
	(byte)0xcc,(byte)0xd1,(byte)0x73,(byte)0xff,
	(byte)0xab,(byte)0x20,(byte)0x39,(byte)0xf4,
	(byte)0xac,(byte)0xd8,(byte)0xae,(byte)0xfd,
	(byte)0xdf,(byte)0xd8,(byte)0xa1,(byte)0xeb,
	(byte)0x46,(byte)0x8e,(byte)0x91,(byte)0x15,
	(byte)0x78,(byte)0x88,(byte)0xba,(byte)0x68,
	(byte)0x1d,(byte)0x26,(byte)0x93,(byte)0x97,
	(byte)0xf7,(byte)0xfe,(byte)0x62,(byte)0xb4};

  public static byte cbc3_ok[] = {
	(byte)0x3F,(byte)0xE3,(byte)0x01,(byte)0xC9,
	(byte)0x62,(byte)0xAC,(byte)0x01,(byte)0xD0,
	(byte)0x22,(byte)0x13,(byte)0x76,(byte)0x3C,
	(byte)0x1C,(byte)0xBD,(byte)0x4C,(byte)0xDC,
	(byte)0x79,(byte)0x96,(byte)0x57,(byte)0xC0,
	(byte)0x64,(byte)0xEC,(byte)0xF5,(byte)0xD4,
	(byte)0x1C,(byte)0x67,(byte)0x38,(byte)0x12,
	(byte)0xCF,(byte)0xDE,(byte)0x96,(byte)0x75};

  public static byte pcbc_ok[] = {
	(byte)0xcc,(byte)0xd1,(byte)0x73,(byte)0xff,
	(byte)0xab,(byte)0x20,(byte)0x39,(byte)0xf4,
	(byte)0x6d,(byte)0xec,(byte)0xb4,(byte)0x70,
	(byte)0xa0,(byte)0xe5,(byte)0x6b,(byte)0x15,
	(byte)0xae,(byte)0xa6,(byte)0xbf,(byte)0x61,
	(byte)0xed,(byte)0x7d,(byte)0x9c,(byte)0x9f,
	(byte)0xf7,(byte)0x17,(byte)0x46,(byte)0x3b,
	(byte)0x8a,(byte)0xb3,(byte)0xcc,(byte)0x88};

  public static byte cfb_key[] = {
    (byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
    (byte)0x89,(byte)0xab,(byte)0xcd,(byte)0xef};
  public static byte cfb_iv[] = {
    (byte)0x12,(byte)0x34,(byte)0x56,(byte)0x78,
    (byte)0x90,(byte)0xab,(byte)0xcd,(byte)0xef};

  public static byte cfb_buf1[] = new byte [40];
  public static byte cfb_buf2[] = new byte [40];
  public static byte cfb_tmp[] = new byte [8];

  public static byte plain[] = {
	(byte)0x4e,(byte)0x6f,(byte)0x77,(byte)0x20,
	(byte)0x69,(byte)0x73,(byte)0x20,(byte)0x74,
	(byte)0x68,(byte)0x65,(byte)0x20,(byte)0x74,
	(byte)0x69,(byte)0x6d,(byte)0x65,(byte)0x20,
	(byte)0x66,(byte)0x6f,(byte)0x72,(byte)0x20,
	(byte)0x61,(byte)0x6c,(byte)0x6c,(byte)0x20
	};

  public static byte cfb_cipher8[]= {
	(byte)0xf3,(byte)0x1f,(byte)0xda,(byte)0x07,
	(byte)0x01,(byte)0x14,(byte)0x62,(byte)0xee,
	(byte)0x18,(byte)0x7f,(byte)0x43,(byte)0xd8,
	(byte)0x0a,(byte)0x7c,(byte)0xd9,(byte)0xb5,
	(byte)0xb0,(byte)0xd2,(byte)0x90,(byte)0xda,
	(byte)0x6e,(byte)0x5b,(byte)0x9a,(byte)0x87 };

  public static byte cfb_cipher16[] = {
	(byte)0xF3,(byte)0x09,(byte)0x87,(byte)0x87,
	(byte)0x7F,(byte)0x57,(byte)0xF7,(byte)0x3C,
	(byte)0x36,(byte)0xB6,(byte)0xDB,(byte)0x70,
	(byte)0xD8,(byte)0xD5,(byte)0x34,(byte)0x19,
	(byte)0xD3,(byte)0x86,(byte)0xB2,(byte)0x23,
	(byte)0xB7,(byte)0xB2,(byte)0xAD,(byte)0x1B };

  public static byte cfb_cipher32[] = {
	(byte)0xF3,(byte)0x09,(byte)0x62,(byte)0x49,
	(byte)0xA4,(byte)0xDF,(byte)0xA4,(byte)0x9F,
	(byte)0x33,(byte)0xDC,(byte)0x7B,(byte)0xAD,
	(byte)0x4C,(byte)0xC8,(byte)0x9F,(byte)0x64,
	(byte)0xE4,(byte)0x53,(byte)0xE5,(byte)0xEC,
	(byte)0x67,(byte)0x20,(byte)0xDA,(byte)0xB6 };

  public static byte cfb_cipher48[] = {
	(byte)0xF3,(byte)0x09,(byte)0x62,(byte)0x49,
	(byte)0xC7,(byte)0xF4,(byte)0x30,(byte)0xB5,
	(byte)0x15,(byte)0xEC,(byte)0xBB,(byte)0x85,
	(byte)0x97,(byte)0x5A,(byte)0x13,(byte)0x8C,
	(byte)0x68,(byte)0x60,(byte)0xE2,(byte)0x38,
	(byte)0x34,(byte)0x3C,(byte)0xDC,(byte)0x1F };

  public static byte cfb_cipher64[] = {
	(byte)0xF3,(byte)0x09,(byte)0x62,(byte)0x49,
	(byte)0xC7,(byte)0xF4,(byte)0x6E,(byte)0x51,
	(byte)0xA6,(byte)0x9E,(byte)0x83,(byte)0x9B,
	(byte)0x1A,(byte)0x92,(byte)0xF7,(byte)0x84,
	(byte)0x03,(byte)0x46,(byte)0x71,(byte)0x33,
	(byte)0x89,(byte)0x8E,(byte)0xA6,(byte)0x22 };

  public static byte ofb_key[] = {
    (byte)0x01,(byte)0x23,(byte)0x45,(byte)0x67,
    (byte)0x89,(byte)0xab,(byte)0xcd,(byte)0xef};

  public static byte ofb_iv[] = {
    (byte)0x12,(byte)0x34,(byte)0x56,(byte)0x78,
    (byte)0x90,(byte)0xab,(byte)0xcd,(byte)0xef};

  public static byte ofb_buf1[] = new byte[24];
  public static byte ofb_buf2[] = new byte[24];
  public static byte ofb_tmp[] = new byte[8];

  public static byte ofb_cipher[] = {
	(byte)0xf3,(byte)0x09,(byte)0x62,(byte)0x49,
	(byte)0xc7,(byte)0xf4,(byte)0x6e,(byte)0x51,
	(byte)0x35,(byte)0xf2,(byte)0x4a,(byte)0x24,
	(byte)0x2e,(byte)0xeb,(byte)0x3d,(byte)0x3f,
	(byte)0x3d,(byte)0x6d,(byte)0x5b,(byte)0xe3,
	(byte)0x25,(byte)0x5a,(byte)0xf8,(byte)0xc3
	};

  static int cbc_cksum_ret = 0xB462FEF7;

  public static byte cbc_cksum_data[] = {
    (byte)0x1D,(byte)0x26,(byte)0x93,(byte)0x97,
    (byte)0xf7,(byte)0xfe,(byte)0x62,(byte)0xb4};


  public static void memcpy(byte [] out, byte [] in, int len) {
    System.arraycopy( in, 0, out, 0, len);
  }

  public static void memset(byte [] out, byte c, int len) {
    int i;
    for(i = 0; i < len; i++) {
      out[i] = c;
    }
  }

  public static boolean memcmp(byte [] out, byte [] in, int len) {
    int i;
    for(i = 0; i < len; i++) {
      if(out[i] != in[i]) {
	return true;
      }
    }
    return false;
  }

  public static void printhex(byte [] array) {

    if((array.length % 8) != 0) {
      System.out.print("array not multiple of 8 bytes\n");
      return;
    }
    int i;
    for( i = 0; i < array.length / 8; i++) {
      int j;
      for( j = 0; j < 8; j++) {
        byte hival = (byte)((array[(i*8) + j]&0xf0) >>> 4);
        byte loval = (byte)(array[(i*8) + j] & 0xf);
        char ch;
        System.out.print("0x");
        if(hival < 10) {
          ch = (char)((byte)'0' + hival);
        } else {
          ch = (char)((byte)'A' + hival - 10);
        }
        System.out.print(ch);
        if(loval < 10) {
          ch = (char)((byte)'0' + loval);
        } else {
          ch = (char)((byte)'A' + loval - 10);
        }
        System.out.print(ch);
        System.out.print(" ");
      }
      System.out.println();
    }
  }
  
  public static boolean cfb_test(int bits, byte [] cfb_cipher) {
    boolean err = false;
    Des des = new Des(new DesKey(cfb_key, false));

    memcpy(cfb_tmp, cfb_iv, cfb_iv.length);
    des.cfb_encrypt(plain, 0, plain.length, 
		    cfb_buf1, 0,
		    bits,
		    cfb_tmp,
		    Des.ENCRYPT);
    if (memcmp(cfb_cipher,cfb_buf1, plain.length) != false) {
      err = true;
      System.out.println("cfb_encrypt encrypt error");
      printhex(cfb_buf1);
    }
    memcpy(cfb_tmp, cfb_iv, cfb_iv.length);
    des.cfb_encrypt(cfb_buf1, 0, plain.length, 
		    cfb_buf2, 0, 
		    bits,
		    cfb_tmp,
		    Des.DECRYPT);
    if (memcmp(plain, cfb_buf2, plain.length) != false) {
	err = true;
	System.out.println("cfb_encrypt decrypt error");	
	System.out.println("plain buf = ");
	printhex(plain);
	System.out.println("cfb_buf2 = ");
	printhex(cfb_buf2);
      }
    return(err);
  }

  public static boolean cfb64_test(byte [] cfb_cipher) {
    Des des = new Des(new DesKey(cfb_key, false));
    boolean err = false;
    int [] n = new int [ 1 ];
    
    memcpy(cfb_tmp,cfb_iv, cfb_iv.length);
    n[0] = 0;
    des.cfb64_encrypt(plain, 0, 12, 
		      cfb_buf1, 0,
		      cfb_tmp,
		      n,
		      Des.ENCRYPT);
    des.cfb64_encrypt(plain, 12, plain.length - 12,
		      cfb_buf1, 12,
		      cfb_tmp,
		      n,
		      Des.ENCRYPT);
    if (memcmp(cfb_cipher,cfb_buf1, plain.length) != false) {
      err = true;
      System.out.println("cfb_encrypt encrypt error");
      printhex(cfb_cipher);
      printhex(cfb_buf1);
      return err;
    }
    memcpy(cfb_tmp, cfb_iv, cfb_iv.length);
    n[0] = 0;
    des.cfb64_encrypt(cfb_buf1, 0, 17,
		      cfb_buf2, 0,
		      cfb_tmp,
		      n,
		      Des.DECRYPT);
    des.cfb64_encrypt(cfb_buf1, 17, plain.length - 17,
		      cfb_buf2, 17,
		      cfb_tmp,
		      n,
		      Des.DECRYPT);
    if (memcmp(plain,cfb_buf2,plain.length) != false) {
      err = true;
      System.out.println("cfb_encrypt decrypt error");
      printhex(plain);
      printhex(cfb_buf2);
    }
    return(err);
  }

  public static boolean ede_cfb64_test(byte [] cfb_cipher) {
    DesKey ks = new DesKey(cfb_key, false);
    TripleDes des3 = new TripleDes(ks, ks, ks);
    boolean err = false;
    int i;
    int [] ref_to_n = new int [1];
    
    memcpy(cfb_tmp, cfb_iv, cfb_iv.length);
    ref_to_n[0] = 0;

    des3.cfb64_encrypt(plain,0, 12,
		       cfb_buf1, 0,
		       cfb_tmp,
		       ref_to_n,Des.ENCRYPT);
    des3.cfb64_encrypt(plain, 12, plain.length - 12,
		       cfb_buf1, 12,
		       cfb_tmp,
		       ref_to_n,Des.ENCRYPT);
    if (memcmp(cfb_cipher,cfb_buf1, plain.length) != false) {
	err= true;
	System.out.println("ede_cfb_encrypt encrypt error");
	printhex(cfb_buf1);
    }
    memcpy(cfb_tmp, cfb_iv, cfb_iv.length);
    ref_to_n[0] = 0;
    des3.cfb64_encrypt(cfb_buf1, 0, 17,
		       cfb_buf2, 0,
		       cfb_tmp,
		       ref_to_n,Des.DECRYPT);
    des3.cfb64_encrypt(cfb_buf1, 17, plain.length - 17,
		       cfb_buf2, 17,
		       cfb_tmp,
		       ref_to_n,Des.DECRYPT);
    if (memcmp(plain,cfb_buf2, plain.length) != false) {
	err = true;
	System.out.println("ede_cfb_encrypt decrypt error");
	printhex(cfb_buf2);
    }
    return(err);
  }

  public static final int NUM_TESTS = 34;

  public static void main(String[] args) {
    // Setup cbc_data
    memset(cbc_data, (byte)0, 40);
    cbc_string.getBytes(0, cbc_string.length(), cbc_data, 0);

    int i;
    int err;
    byte [] in = new byte [8];
    byte [] out = new byte [8];
    byte [] outin = new byte [8];

    System.out.println("Doing ecb");
    for (i=0; i < DesTest.NUM_TESTS; i++) {

      System.out.println("Doing ecb " + i);

      DesKey ks = new DesKey( key_data[i], false);
      Des des = new Des(ks);

      memcpy(in, plain_data[i], 8);
      memset(out,(byte)0,8);
      memset(outin,(byte)0,8);
      des.ecb_encrypt(in, 0, out, 0, Des.ENCRYPT);
      des.ecb_encrypt(out,0, outin, 0, Des.DECRYPT);

      if (memcmp(out,cipher_data[i],8) != false) {
	System.out.println("Encryption error " + Integer.toString(i+1));
	System.out.println("Key data :");
	printhex(key_data[i]);
	System.out.println("in :");
	printhex(in);
	System.out.println("cipher_data :");
	printhex(cipher_data[i]);
	System.out.println("out :");
	printhex(out);
	err=1;
      }
      if (memcmp(in,outin,8) != false) {
	System.out.println("Decryption error " + Integer.toString(i+1));
	System.out.println("Key data :");
	printhex(key_data[i]);
	System.out.println("out :");
	printhex(out);
	System.out.println("in :");
	printhex(in);
	System.out.println("outin :");
	printhex(outin);
	err=1;
      }
    }

    System.out.println("Doing (tripledes) ede ecb");
    for (i=0; i<(NUM_TESTS-1); i++) {

      System.out.println("Doing (tripledes) ede ecb " + i);

      DesKey ks = new DesKey(key_data[i], false);
      DesKey ks2 = new DesKey(key_data[i+1], false);

      memcpy(in,plain_data[i],8);
      memset(out,(byte)0,8);
      memset(outin,(byte)0,8);

      TripleDes tdes = new TripleDes(ks, ks2);

      tdes.ecb_encrypt(in, 0, out, 0, TripleDes.ENCRYPT);
      tdes.ecb_encrypt(out, 0, outin, 0, TripleDes.DECRYPT);

      if (memcmp(out,cipher_ecb2[i],8) != false) {
	System.out.println("Encryption error " + Integer.toString(i+1));
	printhex(key_data[i]);
	printhex(in);
	printhex(cipher_ecb2[i]);
	printhex(out);
	err=1;
      }
      if (memcmp(in,outin,8) != false) {
	System.out.println("Decryption error " + Integer.toString(i+1));
	printhex(key_data[i]);
	printhex(out);
	printhex(in);
	printhex(outin);
	err=1;
      }
    }

    {
      System.out.println("Doing cbc");
      DesKey ks = new DesKey(cbc_key, false);
      Des des = new Des(ks);
      
      byte [] cbc_in;
      byte [] cbc_out;
      byte [] cbc_modivec = new byte [ cbc_iv.length ];

      cbc_in = new byte [ ((cbc_string.length()+1)+7)&~7 ];
      cbc_out = new byte [ ((cbc_string.length()+1)+7)&~7 ];

      memset(cbc_out,(byte)0,cbc_out.length);
      memset(cbc_in,(byte)0,cbc_in.length);

      memcpy(cbc_in, cbc_data, cbc_in.length);
      memcpy(cbc_modivec, cbc_iv, cbc_modivec.length);
      des.cbc_encrypt(cbc_in, 0, cbc_in.length, 
		      cbc_out, 0, cbc_modivec, Des.ENCRYPT);

      if (memcmp(cbc_out,cbc_ok,32) != false)
	System.out.println("cbc_encrypt encrypt error");
      memcpy(cbc_modivec, cbc_iv, cbc_modivec.length);
      des.cbc_encrypt(cbc_out, 0, cbc_out.length, 
		      cbc_in, 0, cbc_modivec, Des.DECRYPT);
      if (memcmp(cbc_in,cbc_data,32) != false) {
	System.out.println("cbc_encrypt decrypt error");
      }

    }
    {
      System.out.println("Doing (TripleDes) ede cbc");
      DesKey ks = new DesKey(cbc_key,false);
      DesKey ks2 = new DesKey(cbc2_key, false);
      DesKey ks3 = new DesKey(cbc3_key, false);
      
      TripleDes des3 = new TripleDes(ks, ks2, ks3);

      i = cbc_string.length() + 1;
      i=((i+7)/8)*8;

      byte [] iv3 = new byte [ 8 ];
      byte [] cbc_out = new byte [ i ];
      byte [] cbc_in = new byte [ i ];

      memset(cbc_out, (byte)0, cbc_out.length);
      memset(cbc_in, (byte)0, cbc_in.length);

      memcpy(iv3, cbc_iv, cbc_iv.length);

      memcpy(cbc_in, cbc_data, 16);
      des3.cbc_encrypt(cbc_in, 0, 16, cbc_out, 0, iv3, Des.ENCRYPT);

      System.arraycopy(cbc_data, 16, cbc_in, 16, i - 16);
      des3.cbc_encrypt(cbc_in, 16, i - 16, cbc_out, 16, iv3, Des.ENCRYPT);

      if (memcmp(cbc_out,cbc3_ok, i) != false)
	System.out.println("des_ede3_cbc_encrypt encrypt error");

      memcpy(iv3, cbc_iv, cbc_iv.length);

      des3.cbc_encrypt(cbc_out, 0, i, cbc_in, 0, iv3, Des.DECRYPT);
      if (memcmp(cbc_in, cbc_data, cbc_string.length()+1) != false)
	System.out.println("des_ede3_cbc_encrypt decrypt error");
    }

    {
	System.out.println("Doing pcbc");
	DesKey ks = new DesKey(cbc_key, false);
	Des des = new Des(ks);

	byte [] cbc_smalldata = new byte [ ((cbc_string.length()+1)+7)&~7 ];
	byte [] cbc_out = new byte [ ((cbc_string.length()+1)+7)&~7 ];
	byte [] cbc_in = new byte [ ((cbc_string.length()+1)+7)&~7 ];

	memset(cbc_smalldata,(byte)0,cbc_smalldata.length);
	memset(cbc_out,(byte)0,cbc_out.length);
	memset(cbc_in,(byte)0,cbc_in.length);

	memcpy(cbc_smalldata, cbc_data, cbc_string.length()+1);

	/* CHECK if cbc_iv should be modified here..... */

	des.pcbc_encrypt(cbc_smalldata, 0, cbc_smalldata.length, 
			 cbc_out, 0, cbc_iv, Des.ENCRYPT);
	if (memcmp(cbc_out,pcbc_ok,32) != false)
	  System.out.println("pcbc_encrypt encrypt error");

	des.pcbc_encrypt(cbc_out, 0, cbc_out.length, 
			 cbc_in, 0, cbc_iv, Des.DECRYPT);
	if (memcmp(cbc_in,cbc_data,32) != false)
	  System.out.println("pcbc_encrypt decrypt error");
    }

    System.out.print("Doing ");
    System.out.println("cfb8 ");
    if(cfb_test(8,cfb_cipher8) != false)
      return;
    System.out.println("cfb16 ");
    if(cfb_test(16,cfb_cipher16) != false)
      return;
    System.out.println("cfb32 ");
    if(cfb_test(32,cfb_cipher32) != false)
      return;
    System.out.println("cfb48 ");
    if(cfb_test(48,cfb_cipher48) != false)
      return;
    System.out.println("cfb64 ");
    if(cfb_test(64,cfb_cipher64) != false)
      return;
    System.out.println("cb64() ");
    if(cfb64_test(cfb_cipher64) != false)
      return;

    System.out.println("Doing small encrypt/decrypts");

    Des des = new Des(new DesKey(cbc_key, false));

    memcpy(cfb_tmp, cfb_iv, cfb_iv.length);
    for (i = 0; i < plain.length; i++) {
      des.cfb_encrypt(plain, i, 1,
		      cfb_buf1, i,
		      8,
		      cfb_tmp,Des.ENCRYPT);
    }

    if (memcmp(cfb_cipher8,cfb_buf1, plain.length) != false) {
      System.out.println("cfb_encrypt small encrypt error");
      return;
    }

    memcpy(cfb_tmp,cfb_iv, cfb_iv.length);
    for (i=0; i < plain.length; i++) {
      des.cfb_encrypt(cfb_buf1, i, 1,
		      cfb_buf2, i,
		      8,
		      cfb_tmp,Des.DECRYPT);
    }
    if (memcmp(plain,cfb_buf2,plain.length) != false) {
      System.out.println("cfb_encrypt small decrypt error");
      return;
    }

    System.out.println("Small encrypt/decrypts ok !");

    System.out.println("(TripleDes) ede_cfb64() ");
    if(ede_cfb64_test(cfb_cipher64) != false)
      return;

    System.out.println("(TripleDes) ede_cfb64() ok !");

    System.out.println("Doing ofb");

    des = new Des(new DesKey(ofb_key, false));
    memcpy(ofb_tmp, ofb_iv, ofb_iv.length);
    des.ofb_encrypt(plain, 0, plain.length/8,
		    ofb_buf1, 0,
		    64, ofb_tmp);
    if (memcmp(ofb_cipher,ofb_buf1,ofb_buf1.length) != false) {
      System.out.println("ofb_encrypt encrypt error");
      return;
    }
    memcpy(ofb_tmp, ofb_iv, ofb_iv.length);
    des.ofb_encrypt(ofb_buf1, 0, ofb_buf1.length /8,
		    ofb_buf2, 0, 64,
		    ofb_tmp);
    if (memcmp(plain,ofb_buf2,ofb_buf2.length) != false) {
      System.out.println("ofb_encrypt decrypt error");
      return;
    }

    System.out.println("Doing ofb64");

    des = new Des(new DesKey(ofb_key,false));
    memcpy(ofb_tmp,ofb_iv,ofb_iv.length);
    memset(ofb_buf1,(byte)0,ofb_buf1.length);
    memset(ofb_buf2,(byte)0,ofb_buf1.length);

    int [] ref_to_num= new int [1];
    ref_to_num[0] = 0;
    for (i=0; i< plain.length; i++) {
      des.ofb64_encrypt(plain, i, 1,
			ofb_buf1, i,
			ofb_tmp, ref_to_num);
    }
    if (memcmp(ofb_cipher,ofb_buf1,ofb_buf1.length) != false) {
      System.out.println("ofb64_encrypt encrypt error");
      return;
    }
    memcpy(ofb_tmp,ofb_iv,ofb_iv.length);
    ref_to_num[0] = 0;
    des.ofb64_encrypt(ofb_buf1, 0, ofb_buf1.length,
		      ofb_buf2, 0,
		      ofb_tmp,ref_to_num);
    if (memcmp(plain,ofb_buf2,ofb_buf2.length) != false) {
      System.out.println("ofb64_encrypt decrypt error");
      return;
    }

    {
      System.out.println("Doing ede_ofb64");
      DesKey ks = new DesKey(ofb_key,false);
      TripleDes des3 = new TripleDes(ks, ks, ks);

      memcpy(ofb_tmp, ofb_iv, ofb_iv.length);
      memset(ofb_buf1,(byte)0,ofb_buf1.length);
      memset(ofb_buf2,(byte)0,ofb_buf1.length);
      ref_to_num[0] = 0;
      for (i=0; i< plain.length; i++) {
	des3.ofb64_encrypt(plain, i, 1,
			   ofb_buf1, i,
			   ofb_tmp,ref_to_num);
      }
      if (memcmp(ofb_cipher,ofb_buf1,ofb_buf1.length) != false ) {
	System.out.println("ede_ofb64_encrypt encrypt error");
	return;
      }
      memcpy(ofb_tmp,ofb_iv,ofb_iv.length);
      ref_to_num[0] = 0;
      des3.ofb64_encrypt(ofb_buf1, 0, ofb_buf1.length,
			 ofb_buf2, 0,
			 ofb_tmp,ref_to_num);
      if (memcmp(plain,ofb_buf2,ofb_buf2.length) != false) {
	System.out.println("ede_ofb64_encrypt decrypt error");
	return;
      }
    }

    {
      System.out.println("Doing cbc_cksum");
      byte [] cret = new byte [8];
      des = new Des(new DesKey(cbc_key, false));
      int cs = des.cbc_cksum(cbc_data, 0, cbc_string.length(),
			     cret, 0,
			     cbc_iv);
      if (cs != cbc_cksum_ret) {
	System.out.println("bad return value " + Integer.toString(cs) +
			   " should be " + Integer.toString(cbc_cksum_ret));
	return;
      }
      if (memcmp(cret,cbc_cksum_data,8) != false)	{
	System.out.println("bad cbc_cksum block returned");
      }
    }

    System.out.println("All tests passed !");
  }
}
