.\" admin/edit/afs_edit.M
.\"
.\" Copyright 1990 by the Massachusetts Institute of Technology.
.\"
.\" Export of this software from the United States of America may
.\"   require a specific license from the United States Government.
.\"   It is the responsibility of any person or organization contemplating
.\"   export to obtain such a license before exporting.
.\" 
.\" WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
.\" distribute this software and its documentation for any purpose and
.\" without fee is hereby granted, provided that the above copyright
.\" notice appear in all copies and that both that copyright notice and
.\" this permission notice appear in supporting documentation, and that
.\" the name of M.I.T. not be used in advertising or publicity pertaining
.\" to distribution of the software without specific, written prior
.\" permission.  M.I.T. makes no representations about the suitability of
.\" this software for any purpose.  It is provided "as is" without express
.\" or implied warranty.
.\" 
.\"
.ds h ""KerbNet -- Kerberos V5" "Cygnus Solutions""
.TH AFS_EDIT 8 \*h
.SH NAME
afs_edit \- edit a Kerberos V5 principal database
.SH SYNOPSIS
.B afs_edit
[
.B \-r
.I realm
] [
.B \-d
.I dbname
] [
.B \-k
.I keytype
] [
.B \-M
.I mkeyname
] [
.B \-e
.I enctype
] [
.B \-m
] [
.B \-R
.I command
] [
.B \-s
.I script
] [
.B \-f
.I stashfile
]
.br
.SH DESCRIPTION
.I afs_edit
allows an administrator to add, delete, and edit entries in a Kerberos
version 5 principal database.
After themaster key is verified, commands are to
.I afs_edit
are issued using one of three mechanisms.  If a single command is supplied 
using the
.B \-R
.I command
argument, then that single command is processed and execution ceases.  If a
script file is provided using the 
.B \-s
.I script
argument, then commands are read from this file until either an error occurs
or an end of file is detected.  Finally, if neither a command or a script is
specified, the invoker is placed into a shell-like command loop, from which
[s]he may issue commands to modify the
database.  
.PP
The
.B \-r
.I realm
option specifies the realm of the database;
by default the realm returned by
.IR krb5_default_local_realm (3)
is used.
.PP
The
.B \-d
.I dbname
option specifies the name under which the principal database is stored; by
default the database is in DEFAULT_DBM_FILE (defined in <krb5/osconf.h>).
.PP
The
.B \-k
.I keytype
option specifies the key type of the master key in the database; the default is
the string representation of DEFAULT_KDC_KEYTYPE (defined in <krb5/osconf.h>).
.PP
The
.B \-f
.I stashfile
option specifies the filename of the stashed V5 master key. The default is
defined as DEFAULT_KEYFILE_STUB in <krb5/osconf.h> and is 
typically $(prefix)/lib/krb5kdc/.k5.REALMNAME. (In previous
releases, this would have been /.k5.REALMNAME.)
.PP
The
.B \-M
.I mkeyname
option specifies the principal name for the master key in the database;
the default is KRB5_KDB_M_NAME (defined in <krb5/kdb.h>).
.PP
The
.B \-e
.I enctype
option specifies the encryption type to be used when placing entries in
the database; the default is the string representation of DEFAULT_KDC_ETYPE
(defined in <krb5/osconf.h>).
.PP
The
.B \-m
option specifies that the master database password should be fetched
from the keyboard rather than from a file on disk.
.SH AVAILABLE COMMANDS

The following is a list of commands and their aliases that the system
administrator may use to manipulate the database:

.IP add_afs_keys,aak,kascvt
Add the output of a kaserver list output file to a V5 database. It takes
a collection of options:
.PP
.B kascvt
[
.B \-a
.I kas list file name
] [
.B \-v
] [
.B \-4
.I V4 realm/cell name
]
.br
To obtain the needed key list, run the
.I kas list
program with authentication disabled, so it includes key values 
rather than hashes. The invocation on the server 
.br 
.B bos setauth
.I server
.B off
.br
.B kas list -l 
.I server
.B >
.I listfile
.br
generates the needed input.
.PP
The 
.B \-v
flag specifies how verbose the converter is. By default, it runs quietly. 
With one 
.B \-v
argument, it prints a line for each entry it converts. 
With two, it prints the entire record as parsed, which is useful for 
finding parsing problems, and also prints the actual key values found
in the file.
.PP

.IP set_dbname,sdbn         
Change database name

.IP enter_master_key,emk    
Enter the master key for a database

.IP change_working_directory,cwd,cd
Change working directory

.IP print_working_direcotry,pwd
Print working directory

.IP list_requests,lr,?     
List available requests.

.IP quit,exit,q            
Exit program.

.SH SEE ALSO
kdb5_edit(8), krb5(3), krb5kdc(8), ss(3)
.SH BUGS

