/*
 *	appl/bsd/krsh.c
 */

/*
 * Copyright (c) 1983 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
  "@(#) Copyright (c) 1983 The Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

/* based on @(#)rsh.c	5.7 (Berkeley) 9/20/88 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/time.h>

#include <netinet/in.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <pwd.h>
#include <netdb.h>

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef HAVE_SYS_FILIO_H
/* get FIONBIO from sys/filio.h, so what if it is a compatibility feature */
#include <sys/filio.h>
#endif

#ifdef KERBEROS
#include "krb5.h"
#include "getopt.h"
#include "com_err.h"
#include "defines.h"
#endif /* KERBEROS */
     
/*
 * rsh - remote shell
 */
#define SECURE_MESSAGE "This rsh session is using DES encryption for all data transmissions.\r\n"

int	error();
     
int	options;
int	rfd2;
int	nflag;
krb5_sigtype  sendsig();

#ifdef KERBEROS

#ifndef UCB_RSH
#define UCB_RSH "/usr/ucb/rsh"
#endif

#define RSH_BUFSIZ 4096

char des_inbuf[2*RSH_BUFSIZ];       /* needs to be > largest read size */
char des_outbuf[2*RSH_BUFSIZ];      /* needs to be > largest write size */
krb5_data desinbuf,desoutbuf;
krb5_encrypt_block eblock;      /* eblock for encrypt/decrypt */
krb5_context bsd_context;
krb5_creds *cred;

void	try_normal();
profile_t profile;
int do_not_fb = 0;              /* If set then we do not fall back on failure */
int encrypt_flag = 0;
int forward_flag = 0;
int forwardable_flag = 0;
profile_options option[] = {
        { "forwardable", &forwardable_flag, 0 },
        { "forward", &forward_flag, 0 },
        { "encrypt", &encrypt_flag, 0 },
        { NULL, NULL, 0 }
};
char * realmdef[] = { "realms", NULL, "rsh", NULL };
char * appdef[] = { "appdefaults", "rsh", NULL };
#define forwardable_done option[0].found
#define forward_done option[1].found
#define encrypt_done option[2].found
#define krb_realm (*(realmdef + 1))
char ** realms;

#else /* KERBEROS */

#define des_read read
#define des_write write

#endif /* KERBEROS */

#ifndef RLOGIN_PROGRAM
#ifdef KERBEROS
#define RLOGIN_PROGRAM KRB5_PATH_RLOGIN
#else /* KERBEROS */
#ifndef UCB_RLOGIN
#define UCB_RLOGIN "/usr/ucb/rlogin"
#endif
#define RLOGIN_PROGRAM UCB_RLOGIN
#endif  /* KERBEROS */
#endif /* !RLOGIN_PROGRAM */

/* Variables for getopt() */
int off_option;
struct option long_options[] = {
    { "noforwardable", 0, &off_option, 'F' },
    { "noForwardable", 0, &off_option, 'F' },
    { "noforward", 0, &off_option, 'f' },
    { "noencrypt", 0, &off_option, 'x' },
    { "forwardable", 0, NULL, 'F' },
    { "Forwardable", 0, NULL, 'F' },
    { "forward", 0, NULL, 'f' },
    { "encrypt", 0, NULL, 'x' },
    { "noflow", 0, NULL, 0 },
    { "version", 0, NULL, 0x01 },
    { NULL, 0, NULL, 0 },
};
extern char *optarg;
extern int optind;
     
#ifndef POSIX_SIGNALS
#define	mask(s)	(1 << ((s) - 1))
#endif /* POSIX_SIGNALS */
     
main(argc, argv)
     int argc;
     char **argv;
{
    int rem, pid, i;
    char *host=0, *cp, **ap, buf[RSH_BUFSIZ], *args, *user = 0;
    register int cc;
    struct passwd *pwd;
    fd_set readfrom, ready;
    int one = 1;
    struct servent *sp;
    struct servent defaultservent;

#ifdef POSIX_SIGNALS
    sigset_t omask, igmask;
    struct sigaction sa, osa;
#else
    int omask;
#endif
#ifdef KERBEROS
    krb5_flags authopts;
    krb5_error_code status;
#endif  /* KERBEROS */
    int debug_port = 0;

    memset(&defaultservent, 0, sizeof(struct servent));
    if (strrchr(argv[0], '/'))
      argv[0] = strrchr(argv[0], '/')+1; 

    if ( argc < 2 ) goto usage;

    /*
     * Because we use getopt_long() now. the -noflow is no longer supported,
     * (use --noflow) but we keep this for contined backwards compatibility.
     * AT some point in 1997 or 1998, this hack should go away. --proven
     */
    /* Look for -noflow because getopt() can't handle it. */
    for (i = 1; argv[i]; i++) {
        if (!strcmp(argv[i], "-noflow")) {
            printf("rsh: -noflow is obsolete, use --noflow instead.\n");
            while(argv[i++]) argv[i - 1] = argv[i];
            argc--;
            break;
        }
    }

another:
    while ((i = getopt_long(argc, argv, "D:dl:nLacenw78t:k:xfFA",
      long_options, NULL)) != EOF) {
	switch(i) {
        case 0:
            switch(off_option) {
            default:
                goto usage;
                break;
            case 0: /* Ignore flow control */
                break;
#ifdef KERBEROS
            case 'x':
                encrypt_flag = 0;
                encrypt_done = 1;
		do_not_fb = 1;
                break;
            case 'f':
                forward_flag = 0;
                forward_done = 1;
		do_not_fb = 1;
            case 'F':
                forwardable_flag = 0;
                forwardable_done = 1;
		do_not_fb = 1;
                break;
#endif
	    }
	    break;
#ifdef KERBEROS
	case 'k':
	    if(!(krb_realm = (char *)malloc(strlen(optarg) + 1))) {
	    	fprintf(stderr, "rsh: Cannot malloc.\n");
	    	exit(1);
	    }
	    strcpy(krb_realm, optarg);
	    do_not_fb = 1;
	    break;
	case 'x':
	    encrypt_flag = 1;
	    encrypt_done = 1;
	    do_not_fb = 1;
	    break;
	case 'f':
            if (forward_done) {
                fprintf(stderr, "rsh: Only one of -f and -F allowed\n");
                goto usage;
            }
            forwardable_flag = 0;
            forwardable_done = 1;
            forward_flag = 1;
            forward_done = 1;
	    do_not_fb = 1;
            break;
        case 'F':
            if (forward_done) {
                fprintf(stderr, "rsh: Only one of -f and -F allowed\n");
                goto usage;
            }
            forwardable_flag = 1;
            forwardable_done = 1;
            forward_flag = 1;
            forward_done = 1;
	    do_not_fb = 1;
            break;
	case 'A':
	    /* 
	     * The -A option specifies that rsh should use any port.
	     * This option is now always on and is no longer necessary.
	     * At some point in 1997 or 1998 this option should go away.
	     */
	    printf("rsh: The -A option is always on, don't use it.\n");
	    do_not_fb = 1;
	    break;
	case 1: /* Print the version */
            printf("%s\n", krb5_version);
            exit(0);
#endif
        case 'D':
            debug_port = htons(atoi(optarg));
            break;
        case 'd':
            options |= SO_DEBUG;
            break;
	case 'l':
	    user = optarg;
	    break;
	case 'n':
	    nflag++;
	    break;
    	/*
      	 * Ignore the -L, -a, -c, -e, -n, -w, -7 and -8 flags to allow 
	 * aliases with rlogin to work. Also ignore -t ttytype.
     	 *
     	 * There must be a better way to do this! -jmb
     	 */
	case 'L':
	case 'a':
	case 'c':
	case 'e':
	/* case 'n': Someone was a bonehead when they chose to use the -n
	 * option above. Fortuanately it will just work */
	case 'w':
	case '7':
	case '8':
	case 't':
	    break;
	default:
	    goto usage;
	    break;
	}
    }

    if (host == NULL) {
	if (optind < argc) {
	    host = argv[optind++];
	    goto another;
	} else {
	    goto usage;
	}
    }

    if (argv[optind] == NULL) {
	execv(RLOGIN_PROGRAM, argv);
	perror(RLOGIN_PROGRAM);
	exit(1);
    }

    if ((pwd = getpwuid(getuid())) == 0) {
	fprintf(stderr, "who are you?\n");
	exit(1);
    }

#ifdef KERBEROS
    krb5_init_context(&bsd_context);
    krb5_init_ets(bsd_context);

    if (!krb_realm) {
        /* Get realm of machine we are connecting to */
	status = krb5_get_host_realm(bsd_context, host, &realms);
	if (status) {
	    fprintf (stderr, "rsh: can't determine realm of host %s: %s\n",
		     host, error_message (status));
	    exit (1);
	}
        krb_realm = realms[0];
    }
    /* Get any application defaults from the config file */
    krb5_context_get_profile(bsd_context, &profile);
    profile_get_options_boolean(profile, realmdef, option);
    profile_get_options_boolean(profile, appdef, option);
#endif

    cc = 0;
    for (ap = argv + optind; *ap; ap++)
      cc += strlen(*ap) + 1;
    if (encrypt_flag)
      cc += 3;
    cp = args = (char *) malloc(cc);
    if (encrypt_flag) {
      strcpy(args, "-x ");
      cp += 3;
    }
    for (ap = argv + optind; *ap; ap++) {
	(void) strcpy(cp, *ap);
	while (*cp)
	  cp++;
	if (ap[1])
	  *cp++ = ' ';
    }

    if(debug_port == 0) {
#ifdef KERBEROS
      sp = getservbyname("kshell", "tcp");
#else 
      sp = getservbyname("shell", "tcp");
#endif  /* KERBEROS */
      if (sp == 0) {
#ifdef KERBEROS
	sp = &defaultservent;
	sp->s_port = htons(544);
#else 
	fprintf(stderr, "rsh: shell/tcp: unknown service\n");
#endif /* KERBEROS */
	exit(1);
      }

      debug_port = sp->s_port;
    }

#ifdef KERBEROS
    authopts = AP_OPTS_MUTUAL_REQUIRED;

    /* Piggy-back forwarding flags on top of authopts; */
    /* they will be reset in kcmd */
    if (forward_flag)
      authopts |= OPTS_FORWARD_CREDS;
    if (forwardable_flag)
      authopts |= OPTS_FORWARDABLE_CREDS;    

    status = kcmd(&rem, &host, debug_port,
		  pwd->pw_name,
		  user ? user : pwd->pw_name,
		  args, &rfd2, "host", krb_realm,
		  &cred,
		  0,           /* No need for sequence number */
		  0,           /* No need for server seq # */
		  (struct sockaddr_in *) 0,
		  (struct sockaddr_in *) 0,
		  authopts,
		  1);	/* Always set anyport, there is no need not to. --proven */
    if (status) {
        /* check NO_TKT_FILE or equivalent... */
	if (status != -1)
	    fprintf(stderr,
		    "%s: kcmd to host %s failed - %s\n",argv[0], host,
		    error_message(status));
	try_normal(argv);
    }

    /* Setup for des_read and write */
    desinbuf.data = des_inbuf;
    desoutbuf.data = des_outbuf;
    krb5_use_enctype(bsd_context, &eblock,cred->keyblock.enctype);
    if (status = krb5_process_key(bsd_context, &eblock,&cred->keyblock)) {
        fprintf(stderr, "%s: Cannot process session key : %s.\n",
                argv, error_message(status));
        exit(1);
    }
#ifdef HAVE_ISATTY
    if(encrypt_flag&&isatty(2)) {
	write(2,SECURE_MESSAGE, strlen(SECURE_MESSAGE));
    }
#endif
    
#else /* !KERBEROS */
    rem = rcmd(&host, debug_port, pwd->pw_name,
	       user ? user : pwd->pw_name, args, &rfd2);
    if (rem < 0)
      exit(1);
#endif /* KERBEROS */
    if (rfd2 < 0) {
	fprintf(stderr, "rsh: can't establish stderr\n");
	exit(2);
    }
    if (options & SO_DEBUG) {
	if (setsockopt(rem, SOL_SOCKET, SO_DEBUG,
		       (const char *) &one, sizeof (one)) < 0)
	  perror("setsockopt (stdin)");
	if (setsockopt(rfd2, SOL_SOCKET, SO_DEBUG,
		       (const char *) &one, sizeof (one)) < 0)
	  perror("setsockopt (stderr)");
    }
    (void) setuid(getuid());
#ifdef POSIX_SIGNALS
    sigemptyset(&igmask);
    sigaddset(&igmask, SIGINT);
    sigaddset(&igmask, SIGQUIT);
    sigaddset(&igmask, SIGTERM);
    sigprocmask(SIG_BLOCK, &igmask, &omask);

    (void)sigemptyset(&sa.sa_mask);
    sa.sa_flags = 0;
    sa.sa_handler = sendsig;

    (void)sigaction(SIGINT, (struct sigaction *)0, &osa);
    if (osa.sa_handler != SIG_IGN)
	(void)sigaction(SIGINT, &sa, (struct sigaction *)0);

    (void)sigaction(SIGQUIT, (struct sigaction *)0, &osa);
    if (osa.sa_handler != SIG_IGN)
	(void)sigaction(SIGQUIT, &sa, (struct sigaction *)0);

    (void)sigaction(SIGTERM, (struct sigaction *)0, &osa);
    if (osa.sa_handler != SIG_IGN)
	(void)sigaction(SIGTERM, &sa, (struct sigaction *)0);
#else
#ifdef sgi
    omask = sigignore(mask(SIGINT)|mask(SIGQUIT)|mask(SIGTERM));
#else
    omask = sigblock(mask(SIGINT)|mask(SIGQUIT)|mask(SIGTERM));
#endif
    if (signal(SIGINT, SIG_IGN) != SIG_IGN)
      signal(SIGINT, sendsig);
    if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
      signal(SIGQUIT, sendsig);
    if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
      signal(SIGTERM, sendsig);
#endif /* POSIX_SIGNALS */
    if (nflag == 0) {
	pid = fork();
	if (pid < 0) {
	    perror("fork");
	    exit(1);
	}
    }
    if (!encrypt_flag) {
	ioctl(rfd2, FIONBIO, &one);
	ioctl(rem, FIONBIO, &one);
    }
    if (nflag == 0 && pid == 0) {
	char *bp;
	int wc;
	fd_set rembits;
	
	(void) close(rfd2);
      reread:
	errno = 0;
	cc = read(0, buf, sizeof buf);
	if (cc <= 0)
	  goto done;
	bp = buf;
      rewrite:
	FD_ZERO(&rembits);
	FD_SET(rem, &rembits);
	if (select(8*sizeof(rembits), 0, &rembits, 0, 0) < 0) {
	    if (errno != EINTR) {
		perror("select");
		exit(1);
	    }
	    goto rewrite;
	}
	if (FD_ISSET(rem, &rembits) == 0)
	  goto rewrite;
	wc = des_write(rem, bp, cc);
	if (wc < 0) {
	    if ((errno == EWOULDBLOCK) || (errno == EAGAIN))
	      goto rewrite;
	    goto done;
	}
	cc -= wc; bp += wc;
	if (cc == 0)
	  goto reread;
	goto rewrite;
      done:
	(void) shutdown(rem, 1);
	exit(0);
    }
#ifdef POSIX_SIGNALS
    sigprocmask(SIG_SETMASK, &omask, (sigset_t*)0);
#else
#ifndef sgi
    sigsetmask(omask);
#endif
#endif /* POSIX_SIGNALS */
    FD_ZERO(&readfrom);
    FD_SET(rfd2, &readfrom);
    FD_SET(rem, &readfrom);
    do {
	ready = readfrom;
	if (select(8*sizeof(ready), &ready, 0, 0, 0) < 0) {
	    if (errno != EINTR) {
		perror("select");
		exit(1);
	    }
	    continue;
	}
	if (FD_ISSET(rfd2, &ready)) {
	    errno = 0;
	    cc = des_read(rfd2, buf, sizeof buf);
	    if (cc <= 0) {
		if ((errno != EWOULDBLOCK) && (errno != EAGAIN))
		    FD_CLR(rfd2, &readfrom);
	    } else
	      (void) write(2, buf, cc);
	}
	if (FD_ISSET(rem, &ready)) {
	    errno = 0;
	    cc = des_read(rem, buf, sizeof buf);
	    if (cc <= 0) {
		if ((errno != EWOULDBLOCK) && (errno != EAGAIN))
		    FD_CLR(rem, &readfrom);
	    } else
	      (void) write(1, buf, cc);
	}
    } while (FD_ISSET(rem, &readfrom) || FD_ISSET(rfd2, &readfrom));
    if (nflag == 0)
      (void) kill(pid, SIGKILL);
    exit(0);
  usage:
    fprintf(stderr,
	    "usage: \trsh host [ -l login ] [ -n ] [ -x ] [ -f / -F] command\n");
    fprintf(stderr,
	    "OR \trsh [ -l login ] [-n ] [ -x ] [ -f / -F ] host command\n");
    exit(1);
}



krb5_sigtype sendsig(signo)
     char signo;
{
    (void) des_write(rfd2, &signo, 1);
}



#ifdef KERBEROS
void try_normal(pargv)
     char **pargv;
{
    char *host;
    
    if (do_not_fb)
	exit(1);

    fprintf(stderr,"trying normal rsh (%s)\n", UCB_RSH);
    fflush(stderr);
    /*
     * if we were invoked as 'rsh host mumble', strip off the rsh
     * from arglist.
     *
     * We always want to call the Berkeley rsh as 'host mumble'
     */
    host = strrchr(pargv[0], '/');
    if (host)
      host++;
    else
      host = pargv[0];
    
    if (!strcmp(host, "rsh"))
      pargv++;
    
    execv(UCB_RSH, pargv);
    perror("exec");
    exit(1);
}


char storage[2*RSH_BUFSIZ];
int nstored = 0;
char *store_ptr = storage;

int des_read(fd, buf, len)
     int fd;
     register char *buf;
     int len;
{
    int nreturned = 0;
    long net_len,rd_len;
    int cc;
    unsigned char len_buf[4];
    
    if (!encrypt_flag)
      return(read(fd, buf, len));
    
    if (nstored >= len) {
	memcpy(buf, store_ptr, len);
	store_ptr += len;
	nstored -= len;
	return(len);
    } else if (nstored) {
	memcpy(buf, store_ptr, nstored);
	nreturned += nstored;
	buf += nstored;
	len -= nstored;
	nstored = 0;
    }
    
    if ((cc = krb5_net_read(bsd_context, fd, len_buf, 4)) != 4) {
	/* XXX can't read enough, pipe must have closed */
	return(0);
    }
    rd_len =
	((len_buf[0]<<24) | (len_buf[1]<<16) | (len_buf[2]<<8) | len_buf[3]);
    net_len = krb5_encrypt_size(rd_len,eblock.crypto_entry);
    if ((net_len <= 0) || (net_len > sizeof(des_inbuf))) {
	/* preposterous length; assume out-of-sync; only
	   recourse is to close connection, so return 0 */
	fprintf(stderr,"Read size problem.\n");
	return(0);
    }
    if ((cc = krb5_net_read(bsd_context, fd, desinbuf.data, net_len)) != net_len) {
	/* pipe must have closed, return 0 */
	fprintf(stderr, "Read error: length received %d != expected %d.\n",
		cc, net_len);
	return(0);
    }
    /* decrypt info */
    if (cc = krb5_decrypt(bsd_context, desinbuf.data, (krb5_pointer) storage,
			  net_len, &eblock, 0)) {
	fprintf(stderr,"Cannot decrypt data from network\n");
	return(0);
    }
    store_ptr = storage;
    nstored = rd_len;
    if (nstored > len) {
	memcpy(buf, store_ptr, len);
	nreturned += len;
	store_ptr += len;
	nstored -= len;
    } else {
	memcpy(buf, store_ptr, nstored);
	nreturned += nstored;
	nstored = 0;
    }
    
    return(nreturned);
}



int des_write(fd, buf, len)
     int fd;
     char *buf;
     int len;
{
    unsigned char len_buf[4];
    
    if (!encrypt_flag)
      return(write(fd, buf, len));
    
    desoutbuf.length = krb5_encrypt_size(len, eblock.crypto_entry);
    if (desoutbuf.length > sizeof(des_outbuf)){
	fprintf(stderr,"Write size problem.\n");
	return(-1);
    }
    if (( krb5_encrypt(bsd_context, (krb5_pointer)buf,
		       desoutbuf.data,
		       len,
		       &eblock,
		       0))){
	fprintf(stderr,"Write encrypt problem.\n");
	return(-1);
    }
    
    len_buf[0] = (len & 0xff000000) >> 24;
    len_buf[1] = (len & 0xff0000) >> 16;
    len_buf[2] = (len & 0xff00) >> 8;
    len_buf[3] = (len & 0xff);
    (void) write(fd, len_buf, 4);
    if (write(fd, desoutbuf.data,desoutbuf.length) != desoutbuf.length){
	fprintf(stderr,"Could not write out all data.\n");
	return(-1);
    }
    else return(len); 
}
#endif /* KERBEROS */
