
#include "base/pblock.h"
#include "base/session.h"
#include "frame/req.h"
#include "frame/log.h"
#include "frame/http.h"
#include <errno.h>
#include <sys/un.h>
#include <sys/types.h>
#include <sys/socket.h>

/*
   Usage:
   At the beginning of obj.conf:
      Init fn=load-modules shlib=example.<ext> funcs=hardcoded-auth
   Inside an object in obj.conf:
      AuthTrans fn=basic-auth auth-type="basic" userdb=garbage
                userfn=hardcoded-auth
   <ext> = so on UNIX
   <ext> = dll on NT.
 */

#ifdef XP_WIN32
#define NSAPI_PUBLIC __declspec(dllexport)
#else /* !XP_WIN32 */
#define NSAPI_PUBLIC
#endif /* !XP_WIN32 */

/* The maximum number of digits to represent an integer plus 2 for the two : */
#define MAX_PAD 	25

NSAPI_PUBLIC int hardcoded_auth(pblock *param, Session *sn, Request *rq)
{
    /* Parameters given to us by auth-basic */
    char *userdb = pblock_findval("userdb", param);
    char *user = pblock_findval("user", param);
    char *pw = pblock_findval("pw", param);                                    
	struct sockaddr_un auth_addr;
	char *buf, *alloced_buf;
	int fd, len;

	if (strlen(userdb) > sizeof(auth_addr.sun_path)) {
		log_error(LOG_MISCONFIG, "hardcoded-auth", sn, rq,
		  "Error pathname to kauthd(%s) is to long.\n", userdb);
		return REQ_ABORTED;
	}

    log_error(LOG_INFORM, "hardcoded-auth", sn, rq,
	      "hardcoded_auth request: user=%s", user);

	if ((pw == NULL) || (strlen(pw) == 0)) {
		log_error(LOG_SECURITY, "hardcoded-auth", sn, rq,
   		  "hardcoded_auth failed (user=%s): no password given", user);
    	return REQ_NOACTION;
	}

	auth_addr.sun_family = AF_UNIX;
	strcpy(auth_addr.sun_path, userdb);
	len = strlen(user) + strlen(pw) + MAX_PAD;
	if ((alloced_buf = (char *)malloc(len <= 1024 ? 1024 : len)) == NULL) {
		log_error(LOG_SECURITY, "hardcoded-auth", sn, rq,
   		  "hardcoded_auth failed (user=%s): Cannot get buffer of size %d\n",
		   user, len);
    	return REQ_ABORTED;
	}
	buf = alloced_buf;

	if ((fd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
		log_error(LOG_SECURITY, "hardcoded-auth", sn, rq,
   		  "hardcoded_auth failed (user=%s): Cannot get new socket", user);
		free(alloced_buf);
    	return REQ_ABORTED;
	}

	if (connect(fd, &auth_addr, sizeof(auth_addr)) < 0) {
		log_error(LOG_SECURITY, "hardcoded-auth", sn, rq,
   		  "hardcoded_auth failed (user=%s): Cannot connect to kauthd", user);
		free(alloced_buf);
    	return REQ_ABORTED;
	}

	sprintf(buf, "%d:%s:%s", len, user, pw);
	write(fd, buf, len);

	if ((len = read(fd, buf, 1022)) > 0) {
		buf[len] = '\0';
		if ((strncmp("pass", buf, 4) == 0)) {
			log_error(LOG_SECURITY, "hardcoded-auth", sn, rq,
			  "hardcoded_auth succeeded (user=%s)", user);
			free(alloced_buf);

        	/* If we return REQ_PROCEED, the username will be accepted */
        	return REQ_PROCEED;
		}
	} else {
		buf = "reason unknown";
	}

	log_error(LOG_SECURITY, "hardcoded-auth", sn, rq,
   	  "hardcoded_auth failed (user=%s):%d : %s", user, len, buf);
	free(alloced_buf);
    return REQ_NOACTION;
}

