.ds h ""KerbNet -- Kerberos V5" "Cygnus Solutions"
.TH TKADMIN 8 \*h
.SH NAME
tkadmin \- GUI for admin commands to Kerberos database
.SH SYNOPSIS
.B tkadmin
[\fB\-p PRINC\fP | \fB\-\-principal PRINC\fP] [\fB\-w PASWWORD\fP |
\fB\-\-password PASSWORD\fP] [\fB\-r REALM\fP | \fB\-\-realm REALM\fP]
[\fB\-g FILE\fP] [\fB\-d\fP | \fB\-\-debug\fP] [\fB\-d\fP |
\fB\-\-debug\fP]
.SH DESCRIPTION
The 
.B tkadmin
command starts the Admin GUI, an interface that allows you to
manipulate information in the Kerberos database using windows and
menus, rather than the command line.
.SH OPTIONS
.TP
\fB\-p PRINC\fP | \fB\-\-principal PRINC\fP
Use PRINCIPAL as Kerberos administrator.
.TP
\fB\-w PASWWORD\fP | \fB\-\-password PASSWORD\fP
Use PASSWORD as Kerberos admin password.
.TP
\fB\-r REALM\fP | \fB\-\-realm REALM\fP
Administer Kerberos realm REALM.
.TP
\fB\-d\fP | \fB\-\-debug\fP
Send debugging information to stdout.
.TP
\fB\-d\fP | \fB\-\-debug\fP
Print a help message with the \fB\tkadmin\fP options list.
.PP
.SH The Principal List Window
The Principal List window displays all the principals in the Kerberos
database.  You can select principals from the list by clicking on them
with the mouse.  Double-clicking on a principal opens the Principal
Information window, in which you can view and edit information about
the principal.
.PP
By default, the principal list shows all the principals in the database.
However, you can view a subset of the principals by selecting an
appropriate @i{filter}.  A filter is a string of characters that all the
principals you want to view have in common; the Principal List window
displays all the principals in the database that contain that string.
.PP
The wildcard `*' stands for any number of characters.  Thus, the filter
`*/admin' causes the principal list to display any principal with the
instance `admin'; the filter `host/*' matches any principal with the
primary `host'.  The filter `host*' would also retrieve all principals
with the primary `host', as well as principals such as `host@@BLEEP.COM' and
`hostess/admin@@BLEEP.COM'.  The filter `host' would retrieve only the
principal `host@@BLEEP.COM' (the exact match to the filter string).
.PP
The `*' filter shows all principals.
.PP
To change the current filter, click on the Filter button and select a
filter from the drop-down list, or type the desired filter into the
text box beside the Filter button.
.SH MENU COMMANDS
The following menus allow you to perform administrative tasks using
the Admin GUI.
.TP
.B The File Menu
.RS
.TP
.B Quit 
exits the Admin GUI.
.RE
.TP
.B The Principal Menu
The commands on the Principals menu allow you to manipulate entries in the
Kerberos database.
.RS
.TP
.B Add New 
Creates a new principal; this command opens a dialog in which you can
enter information about the principal.
.TP
.B Delete
Removes the selected principal(s) from the database.
.TP
.B Edit
Opens a dialog displaying information about the selected principal.
You can modify the information in this dialog by typing in the text
boxes.
.TP
.B Rename
Lets you enter a new name for the selected principal and updates the
entry in the Kerberos database accordingly.
.TP
.B Copy
Creates a new principal that is identical to the selected
principal, except in name and password; this command opens a dialog in
which you can enter the new name and password.
.TP
.B Change Password
Opens a window in which you can change the password of
the selected principal.
.TP
.B Deactivate
Deactivates the selected principal(s). 
.TP
.B Reactivate
Reactivates the selected principal(s).
.RE
.TP
.B The Policy Menu
.RS
.TP
.B Show List
Opens the Policy List window
.TP
.B Add New (Policy List window command)
Adds a new policy to the database.  This command opens a
window into which you can enter information about the policy.
.TP
.B Delete (Policy List window command)
Deletes the selected policy(s) from the policy database.  You
must remove the policy from all principals before attempting to delete
it.
.RS
.TP
The Keytab Menu
.RS
.TP
.B Create
Creates a new keytab and allows you to enter principals in the keytab.
.PP
The Fileselect dialog opens with the Create command.  In the File text
box, enter the keytab name.  Specify the path for where you want the
keytab to be stored, if you want to use a directory other than the
current one (the current directory is listed above the File text box).
.PP
Click OK to create the keytab, or Cancel to close the Fileselect
dialog without creating a keytab.
.PP
The Keytab Editing dialog appears.  To add a principal to the keytab,
select that principal in the Principal List window, and click the Add
Principals button in the Keytab Editing dialog.  To delete one or more
pricipals from the keytab, select the principal(s) in the Keytab
Editing dialog and click the Delete Principals button.
.TP
.B Modify
Opens an existing keytab for modification.  Select the keytab from the
list in the Fileselect dialog, which opens with the Modify command.
.PP
The dialog lists all files in the directory displayed above the list.
Enter a directory path in the File text box to view a different
directory.
.PP
Choose an appropriate Mask (filter) to display a subsection of the
directory's contents.  The wildcard `*' stands for any number of characters.
.PP
Click OK to open the keytab, or Cancel to close the Fileselect dialog
without editing a keytab.
.PP
The Keytab Editing dialog opens.  Edit the keytab as described above
for the Create command.
.RE
.SH The Password Entry Dialog 
Clicking the Set Password button in the Principal Information window
or selecting Change Password from the Principal menu opens this
dialog.
.PP 
To set a password, type the password in each of the two text boxes.
If you select the Force checkbox, the system forces the user to change the
password the first time he or she logs in using this principal.
.SH Principal Information
The following principal information is modifyable; change it by
entering the desired values in the text boxes.
.TP
.B Principal
The principal (name).
.TP
.B Principal Expires 
The date and time when the principal will expire.
.TP
.B Password Expires
The date and time when the principal's password will expire.
.TP
.BMax Ticket Lifetime
The maximum amount of time for which the principal's tickets can be valid. 
.TP
.B Max Renewable Life
The time span during which the principal's tickets (if renewable) may
be renewed.
.TP
.B Password Policy
The policy governing the principal's password.  To change the policy,
click in the text box and select a policy from the drop-down list.
.TP
.B Key Version Number (kvno)
The kvno for a principal records how many times the key has been
changed; the kvno of a newly-created principal is 0.  Every time the
principal is extracted from the database to a keytab, its key changes,
and its kvno increments by 1.  Unless you have an explicit reason to
do so, you should not manually change the kvno.
.PP
The information in the fields whose titles have black backgrounds is
historical information about the principal; you cannot modify these
values.
.TP
.B Last Password Change
The time when the principal's password was last changed.
.TP
.B Last Modification
The time when the principal's administrative information was last modified.
.TP
.B Last Modification By
The principal responsible for the last modification of this
principal's administrative information.
.PP
The following fields relate to preauthentication features that have not
been fully  implemented yet.
.TP
.B Last Successful Auth
.TP
.B Last Failed Auth
.TP
.B Failed Password Attempts
.TP
.B Attributes
Set the attribute flags for the principal by selecting and deselecting the
checkboxes at the bottom of the Principal Information dialog.
.RS
.TP
.B Disallow TGT Based
Checking this checkbox sets the KRB5_KDB_DISALLOW_TGT_BASED flag
on the principal in the database, specifying that a Ticket-Granting
Service (TGS) request for a service ticket for this principal is not
permitted.
.TP
.B Disallow Forwardable
Checking this checkbox sets the KRB5_KDB_DISALLOW_FORWARDABLE
flag on the principal in the database, prohibiting the principal from
obtaining forwardable tickets.
.TP
.B Disallow Postdated
Checking this checkbox sets the KRB5_KDB_DISALLOW_POSTDATED flag
on the principal in the database, prohibiting the principal from
obtaining postdated tickets.
.TP
.B Disallow Duplicate SKey
Checking this checkbox sets the KRB5_KDB_DISALLOW_DUP_SKEY
flag on the principal in the database, prohibiting the principal from
obtaining a session key for another user.
.TP
.B Disallow Proxiable
Checking this checkbox sets the KRB5_KDB_DISALLOW_PROXIABLE
flag. on the principal in the database, prohibiting the principal from
obtaining proxiable tickets.
.TP
.B Disallow Renewable
Checking this checkbox sets the KRB5_KDB_DISALLOW_RENEWABLE
flag on the principal in the database, prohibiting this principal from
obtaining renewable tickets.
.TP
.B Requires Hardware Auth
Checking this checkbox sets the KRB5_KDB_REQUIRES_HW_AUTH flag on
the principal in the database, requiring the principal to
preauthenticate using a hardware device before being allowed to kinit.
.TP
.B Requires Preauth
Checking this checkbox sets the KRB5_KDB_REQUIRES_PRE_AUTH
flag on the principal in the database, requiring the principal to
preauthenticate before being allowed to kinit.
.TP
.B Disallow All Tickets
Checking this checkbox sets the KRB5_KDB_DISALLOW_ALL_TIX flag on the
principal in the database, forbiding the issuance of any tickets for
this principal.
.TP
.B Password Changing Service
Checking this checkbox sets the KRB5_KDB_PWCHANGE_SERVICE flag on
the principal in the database, marking this principal as a password
change service.
.TP
.B Disallow SVR
Checking this checkbox sets the KRB5_KDB_DISALLOW_SVR flag on the
principal in the database, prohibiting the the principal from obtaining
service tickets.
.TP
.B Requires Password Change
Checking this checkbox the KRB5_KDB_REQUIRES_PWCHANGE flag on the
principal in the database, forcing a password change the next time the
principal requests a TGT.  You can also set this flag as part of the
process of changing a principal's password.
.RE
.SH Policy Information
A 
.B policy 
is a set of rules governing passwords.  Each principal can have only one
policy (or none); a policy may be used by any number of principals.
.PP
The Principals Using Policy field in the Policy Information window tells
you how many principals currently have the policy.
.PP
You can modify the following information by entering the desired
values in the text boxes.  
.TP 
.B Policy 
The policy name 
.TP 
.B Min Lifetime 
The minimum password lifetime 
.TP 
.B Max Lifetime 
The maximum password lifetime 
.TP 
.B Min Password Length 
The minimum number of characters a password must contain 
.TP 
.B Old Keys 
The number of previous passwords to be stored for a principal
.TP
.B Min Character Classes
The minimum number of character classes a password must use 
.SH ``SEE ALSO''























