/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "krb5.h"
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <krb.h>

#include "krb524.h"

int krb524_convert_creds_plain
	PROTOTYPE((krb5_context context, krb5_creds *v5creds, 
		   CREDENTIALS *v4creds));


int krb524_convert_creds_addr(context, v5creds, v4creds, saddr)
     krb5_context context;
     krb5_creds *v5creds;
     CREDENTIALS *v4creds;
     struct sockaddr *saddr;
{
     int ret;

     if ((ret = krb524_convert_creds_plain(context, v5creds, v4creds)))
	  return ret;

     return krb524_convert_tkt(v5creds->server, &v5creds->ticket,
			       &v4creds->ticket_st,
			       &v4creds->kvno,
			       (struct sockaddr_in *) saddr);
}

int krb524_convert_creds_kdc(context, v5creds, v4creds)
     krb5_context context;
     krb5_creds *v5creds;
     CREDENTIALS *v4creds;
{
     struct sockaddr_in *addrs;
     int ret, naddrs, i;

     if ((ret = krb5_locate_kdc(context, &v5creds->server->realm, &addrs,
				&naddrs, NULL, NULL)))
	  return ret;
     if (naddrs == 0)
	  ret = KRB5_KDC_UNREACH;
     else {
          for (i = 0; i<naddrs; i++) {
	    addrs[i].sin_port = 0; /* use krb524 default port */
	    ret = krb524_convert_creds_addr(context, v5creds, v4creds,
					    (struct sockaddr *) &addrs[i]);
	    /* stop trying on success */
	    if (!ret) break;
	    switch(ret) {
	    case ECONNREFUSED:
	    case ENETUNREACH:
	    case ENETDOWN:
	    case ETIMEDOUT:
	    case EHOSTDOWN:
	    case EHOSTUNREACH:
	      continue;
	    default:
	      break;		/* out of switch */
	    }
	    /* if we fall through to here, it wasn't an "ok" error */
	    break;
	  }
     }
     
     free(addrs);
     return ret;
}

int krb524_convert_creds_plain(context, v5creds, v4creds)
     krb5_context context;
     krb5_creds *v5creds;
     CREDENTIALS *v4creds;
{
     krb5_ui_4 addr;
     int ret;
     
     memset((char *) v4creds, 0, sizeof(CREDENTIALS));

     if ((ret = krb524_convert_princs(context, v5creds->client, 
				      v5creds->server,
				      v4creds->pname, v4creds->pinst,
				      v4creds->realm, v4creds->service,
				      v4creds->instance)))
	  return ret;

     /* Check enctype too */
     if (v5creds->keyblock.length != sizeof(C_Block)) {
	  if (krb524_debug)
	       fprintf(stderr, "v5 session keyblock length %d != C_Block size %d\n",
		       v5creds->keyblock.length,
		       sizeof(C_Block));
	  return KRB524_BADKEY;
     } else
	  memcpy(v4creds->session, (char *) v5creds->keyblock.contents,
		 sizeof(C_Block));

     /* V4 has no concept of authtime or renew_till, so ignore them */
     /* V4 lifetime is 1 byte, in 5 minute increments */
     v4creds->lifetime = calculate_cmu_seconds(v5creds->times.endtime - 
					       v5creds->times.starttime);
     /* If it fails then klist will print funny values, oh well */
     krb5_timeofday(context, &v4creds->issue_date);

/*
     lifetime = 
	  ((v5creds->times.endtime - v5creds->times.starttime) / 300);
     v4creds->lifetime =
	  ((lifetime > 0xff) ? 0xff : lifetime);
     v4creds->issue_date = v5creds->times.starttime;
*/

     /* XXX perhaps we should use the addr of the client host if */
     /* v5creds contains more than one addr.  Q: Does V4 support */
     /* non-INET addresses? */
     if (!v5creds->addresses || !v5creds->addresses[0] ||
	 v5creds->addresses[0]->addrtype != ADDRTYPE_INET ||
	 v5creds->addresses[0]->length != sizeof(addr)) {
	  if (krb524_debug)
	       fprintf(stderr, "Invalid v5creds address information.\n");
	  return KRB524_BADADDR;
     } else
	  memcpy((char *) &addr, v5creds->addresses[0]->contents,
		 sizeof(addr));

     return 0;
}
