/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#ifndef __KRB524_H__
#define __KRB524_H__

#define KRB524_SERVICE "krb524"
#define KRB524_PORT 4444

#include "krb524_err.h"

extern int krb524_debug;

int krb524_convert_tkt_skey
	PROTOTYPE((krb5_context context, krb5_ticket *v5tkt, KTEXT_ST *v4tkt, 
		   krb5_keyblock *v5_skey, krb5_keyblock *v4_skey));

/* conv_princ.c */

int krb524_convert_princs
	PROTOTYPE((krb5_context context, krb5_principal client, 
		   krb5_principal server, char *pname, 
		   char *pinst, char *prealm, char *sname, char *sinst));

/* conv_creds.c */

int krb524_convert_creds_addr
	PROTOTYPE((krb5_context context, krb5_creds *v5creds, 
		   CREDENTIALS *v4creds, struct sockaddr *saddr));

int krb524_convert_creds_kdc
	PROTOTYPE((krb5_context context, krb5_creds *v5creds, 
		   CREDENTIALS *v4creds));

/* conv_tkt.c */

int krb524_convert_tkt
	PROTOTYPE((krb5_principal server, krb5_data *v5tkt, KTEXT_ST *v4tkt,
		   int *kvno, struct sockaddr_in *saddr));

/* encode.c */

int encode_v4tkt
	PROTOTYPE((KTEXT_ST *v4tkt, char *buf, int *encoded_len));

int decode_v4tkt
	PROTOTYPE((KTEXT_ST *v4tkt, char *buf, int *encoded_len));


/* misc.c */

void krb524_init_ets
	PROTOTYPE((krb5_context context));

/* sendmsg.c */

int krb524_send_message 
	PROTOTYPE((const struct sockaddr * addr, const krb5_data * message,
		   krb5_data * reply));

#endif /* __KRB524_H__ */
