/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

/*
 * $Id: import_name.c,v 1.11 1996/07/22 20:34:00 marc Exp $
 */

#include "gssapiP_krb5.h"

#ifdef __vxworks
#define NO_PASSWORD
#endif

#ifndef NO_PASSWORD
#include <pwd.h>
#endif

#ifdef USE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

/*
 * errors:
 * GSS_S_BAD_NAMETYPE	if the type is bogus
 * GSS_S_BAD_NAME	if the type is good but the name is bogus
 * GSS_S_FAILURE	if memory allocation fails
 */

OM_uint32
krb5_gss_import_name(minor_status, input_name_buffer, 
		     input_name_type, output_name)
     OM_uint32 *minor_status;
     gss_buffer_t input_name_buffer;
     gss_OID input_name_type;
     gss_name_t *output_name;
{
   krb5_context context;
   krb5_principal princ;
   krb5_error_code code;
   char *stringrep, *tmp;
#ifndef NO_PASSWORD
   struct passwd *pw;
#endif

   if (GSS_ERROR(kg_get_context(minor_status, &context)))
      return(GSS_S_FAILURE);

   /* set up default returns */

   *output_name = NULL;
   *minor_status = 0;

   /* Go find the appropriate string rep to pass into parse_name */

   if ((input_name_type != GSS_C_NULL_OID) &&
       g_OID_equal(input_name_type, gss_nt_service_name)) {
      char *service, *host;

      if ((tmp =
	   (char *) xmalloc(input_name_buffer->length + 1)) == NULL) {
	 *minor_status = ENOMEM;
	 return(GSS_S_FAILURE);
      }

      memcpy(tmp, input_name_buffer->value, input_name_buffer->length);
      tmp[input_name_buffer->length] = 0;

      service = tmp;
      if (host = strchr(tmp, '@')) {
	 *host = '\0';
	 host++;
      }

      code = krb5_sname_to_principal(context, host, service, KRB5_NT_SRV_HST,
				     &princ);

      xfree(tmp);
   } else if ((input_name_type != GSS_C_NULL_OID) &&
	      (g_OID_equal(input_name_type, gss_nt_krb5_principal))) {
      krb5_principal input;

      if (input_name_buffer->length != sizeof(krb5_principal)) {
	 *minor_status = (OM_uint32) G_WRONG_SIZE;
	 return(GSS_S_BAD_NAME);
      }

      input = *((krb5_principal *) input_name_buffer->value);

      if ((code = krb5_copy_principal(context, input, &princ))) {
	 *minor_status = code;
	 return(GSS_S_FAILURE);
      }
   } else {
      stringrep = NULL;

      if ((tmp =
	   (char *) xmalloc(input_name_buffer->length + 1)) == NULL) {
	 *minor_status = ENOMEM;
	 return(GSS_S_FAILURE);
      }

      memcpy(tmp, input_name_buffer->value, input_name_buffer->length);
      tmp[input_name_buffer->length] = 0;

      if ((input_name_type == GSS_C_NULL_OID) ||
	  g_OID_equal(input_name_type, gss_nt_krb5_name) ||
	  g_OID_equal(input_name_type, gss_nt_user_name)) {
	 stringrep = (char *) tmp;
#ifndef NO_PASSWORD
      } else if (g_OID_equal(input_name_type, gss_nt_machine_uid_name)) {
	 if ((pw = getpwuid(*((uid_t *) input_name_buffer->value))))
	    stringrep = pw->pw_name;
	 else
	    *minor_status = (OM_uint32) G_NOUSER;
      } else if (g_OID_equal(input_name_type, gss_nt_string_uid_name)) {
	 if ((pw = getpwuid((uid_t) atoi(tmp))))
	    stringrep = pw->pw_name;
	 else
	    *minor_status = (OM_uint32) G_NOUSER;
#endif
      } else {
	 return(GSS_S_BAD_NAMETYPE);
      }

      /* at this point, stringrep is set, or if not, *minor_status is. */

      if (stringrep)
	 code = krb5_parse_name(context, (char *) stringrep, &princ);
      else
	 return(GSS_S_BAD_NAME);
      
      xfree(tmp);
   }

   /* at this point, a krb5 function has been called to set princ.  code
      contains the return status */

   if (code) {
      *minor_status = (OM_uint32) code;
      return(GSS_S_BAD_NAME);
   }

   /* save the name in the validation database */

   if (! kg_save_name((gss_name_t) princ)) {
      krb5_free_principal(context, princ);
      *minor_status = (OM_uint32) G_VALIDATE_FAILED;
      return(GSS_S_FAILURE);
   }

   /* return it */

   *output_name = (gss_name_t) princ;
   return(GSS_S_COMPLETE);
}
