/*
 * Copyright, OpenVision Technologies, Inc., 1996, All Rights Reserved
 *
 * WARNING:  Retrieving the OpenVision Kerberos Administration system
 * source code, as described below, indicates your acceptance of the
 * following terms.  If you do not agree to the following terms, do not
 * retrieve the OpenVision Kerberos administration system.
 *
 * You may freely use and distribute the Source Code and Object Code
 * compiled from it, but this Source Code is provided to you "AS IS"
 * EXCLUSIVE OF ANY WARRANTY, INCLUDING, WITHOUT LIMITATION, ANY
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, OR
 * ANY OTHER WARRANTY, WHETHER EXPRESS OR IMPLIED.  IN NO EVENT WILL
 * OPENVISION HAVE ANY LIABILITY FOR ANY LOST PROFITS, LOSS OF DATA OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY
 * SPECIAL, INDIRECT, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS
 * AGREEMENT, INCLUDING, WITHOUT LIMITATION, THOSE RESULTING FROM THE
 * USE OF THE SOURCE CODE, OR THE FAILURE OF THE SOURCE CODE TO PERFORM,
 * OR FOR ANY OTHER REASON.
 *
 * OpenVision retains all rights, title, and interest in the donated
 * Source Code.  With respect to OpenVision's copyrights in the donated
 * Source Code, OpenVision also retains rights to derivative works of
 * the Source Code whether created by OpenVision or a third party.
 *
 * OpenVision Technologies, Inc. has donated this Kerberos
 * Administration system to MIT for inclusion in the standard Kerberos 5
 * distribution. This donation underscores our commitment to continuing
 * Kerberos technology development and our gratitude for the valuable
 * work which has been performed by MIT and the Kerberos community.
 */

#include "gssapiP_krb5.h"

/*
 * $Id: util_seqnum.c,v 1.8 1996/07/22 20:34:43 marc Exp $
 */

krb5_error_code
kg_make_seq_num(context, ed, direction, seqnum, cksum, buf)
     krb5_context context;
     krb5_gss_enc_desc *ed;
     int direction;
     krb5_int32 seqnum;
     unsigned char *cksum;
     unsigned char *buf;
{
   unsigned char plain[8];

   plain[0] = (unsigned char) (seqnum&0xff);
   plain[1] = (unsigned char) ((seqnum>>8)&0xff);
   plain[2] = (unsigned char) ((seqnum>>16)&0xff);
   plain[3] = (unsigned char) ((seqnum>>24)&0xff);

   plain[4] = direction;
   plain[5] = direction;
   plain[6] = direction;
   plain[7] = direction;

   return(kg_encrypt(context, ed, cksum, plain, buf, 8));
}

krb5_error_code kg_get_seq_num(context, ed, cksum, buf, direction, seqnum)
     krb5_context context;
     krb5_gss_enc_desc *ed;
     unsigned char *cksum;
     unsigned char *buf;
     int *direction;
     krb5_int32 *seqnum;
{
   krb5_error_code code;
   unsigned char plain[8];

   if (code = kg_decrypt(context, ed, cksum, buf, plain, 8))
      return(code);

   if ((plain[4] != plain[5]) ||
       (plain[4] != plain[6]) ||
       (plain[4] != plain[7]))
      return((krb5_error_code) KG_BAD_SEQ);

   *direction = plain[4];

   *seqnum = ((plain[0]) |
	      (plain[1]<<8) |
	      (plain[2]<<16) |
	      (plain[3]<<24));

   return(0);
}
