--
-- logbld.sql, used to create the Oracle tables for the Kerberos log
-- format.
--

set termout on
prompt Building demonstration tables.  Please wait.
set feedback off

ALTER SESSION SET NLS_LANGUAGE = AMERICAN;
ALTER SESSION SET NLS_TERRITORY = AMERICA;

drop table log_tuple;
drop table log;
drop sequence log_sequence;
drop table priority_map;

create table log
        (logtime date not null, 
         priority number(2) not null,
         logger varchar2(128) not null,
         category varchar2(128),
         result varchar2(255),
         fromhost varchar2(128),
         loghost varchar2(128),
         log_id number primary key);

create table log_tuple
        (log_id number, 
         argname varchar2(128),
         argval varchar2(255), 
	 foreign key (log_id) references log);

create sequence log_sequence;

create table priority_map
        (priority number(2) primary key,
         pri_string varchar2(9));

-- populate priority table

insert into priority_map values (-1, 'Com_Err');

insert into priority_map values ( 1, 'EMERGENCY');
insert into priority_map values ( 2, 'ALERT');
insert into priority_map values ( 3, 'CRITICAL');
insert into priority_map values ( 4, 'Error');
insert into priority_map values ( 5, 'Warning');
insert into priority_map values ( 6, 'notice');
insert into priority_map values ( 7, 'info');
insert into priority_map values ( 8, 'debug');

-- convenience view(s)

create or replace view com_err
        as select logtime, logger whoami, priority, result code, argval msg
        from log, log_tuple where log.log_id = log_tuple.log_id and 
                                  log_tuple.argname = 'msg';

create or replace view log_view
	as select logtime, pri_string priority, substr(logger,1,8) logger,
		  substr(category,1,8) category, substr(result,1,30) result
	from log, priority_map where (log.priority = priority_map.priority);

-- commit all changes

commit;
exit;
