/* KerbNet 1.1
   Copyright (C) 1996-1997 Cygnus Solutions */

/*
 * Copyright 1991-1994 by The University of Texas at Austin
 * All rights reserved.
 *
 * For infomation contact:
 * Rick Watson
 * University of Texas
 * Computation Center, COM 1
 * Austin, TX 78712
 * r.watson@utexas.edu
 * 512-471-3241
 */

#include "Types.r"		/* To get system types */
#include "SysTypes.r"	/* get more system types */
#include "kconfig.vers"

include "ldef.rsrc";

type KCONFIG_CREATOR {
	pstring;
};

resource KCONFIG_CREATOR (0,purgeable) {
	"KerbNet Config"
};

resource 'vers' (1, purgeable) {
    VERSION,             /* version */
    VERSION2,			 /* 2nd part of version */
    0x60,                /* beta */
    BETAPART,            /* beta part */
    verUS,
    SHORTVERS,
	LONGVERS
    };

resource 'vers' (2, purgeable) {
    VERSION,             /* version */
    VERSION2,			 /* 2nd part of version */
    0x60,                /* beta */
    BETAPART,            /* beta part */
    verUS,
    SHORTVERS,
    "Program"
    };


resource 'SIZE' (-1) {
	dontSaveScreen,
	acceptSuspendResumeEvents,
	enableOptionSwitch,
	canBackground,
	doesActivateOnFGSwitch,
	backgroundAndForeground,
	dontGetFrontClicks,
	ignoreAppDiedEvents,
	not32BitCompatible,
	notHighLevelEventAware,
	onlyLocalHLEvents,
	notStationeryAware,
	dontUseTextEditServices,
	reserved,
	reserved,
	reserved,
	524288,
	524288
};

resource 'SIZE' (0) {
	dontSaveScreen,
	acceptSuspendResumeEvents,
	enableOptionSwitch,
	canBackground,
	doesActivateOnFGSwitch,
	backgroundAndForeground,
	dontGetFrontClicks,
	ignoreAppDiedEvents,
	not32BitCompatible,
	notHighLevelEventAware,
	onlyLocalHLEvents,
	notStationeryAware,
	dontUseTextEditServices,
	reserved,
	reserved,
	reserved,
	524288,
	524288
};

resource 'ALRT' (128) {
	{56, 90, 182, 426},
	128,
	{	/* array: 4 elements */
		/* [1] */
		OK, visible, sound1,
		/* [2] */
		OK, visible, sound1,
		/* [3] */
		OK, visible, sound1,
		/* [4] */
		OK, visible, sound1
	}
};

resource 'BNDL' (128) {
	'CSkn',
	0,
	{	/* array TypeArray: 2 elements */
		/* [1] */
		'FREF',
		{	/* array IDArray: 2 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129
		},
		/* [2] */
		'ICN#',
		{	/* array IDArray: 2 elements */
			/* [1] */
			0, 128,
			/* [2] */
			1, 129
		}
	}
};

data 'cicn' (128) {
	$"0000 0000 8010 0000 0000 0020 0020 0000"            /* .......... . .. */
	$"0000 0000 0000 0048 0000 0048 0000 0000"            /* .......H...H.... */
	$"0004 0001 0004 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0004 0000 0000 0020 0020"            /* ............. .  */
	$"0000 0000 0004 0000 0000 0020 0020 0000"            /* ........... . .. */
	$"0000 7FFF FFFE FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"            /*  */
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 7FFF"            /* . */
	$"FFFE 7FFF FFFE 8000 0001 8000 0001 8000"            /* ........ */
	$"0001 8F00 0001 9080 0001 AF40 0001 A940"            /* .......@..@ */
	$"0001 A940 0001 A940 0001 AF40 FC01 9081"            /* ..@..@..@. */
	$"0201 9702 0101 9404 C081 9407 2041 9479"            /* ....... Ay */
	$"FE3D 9408 C01D 9404 001D 97E2 001D 9021"            /* =.......! */
	$"801D 97E0 7F9D 97E0 007D 9020 001D 97E0"            /* ...} .. */
	$"0001 97E0 0001 9020 0001 9FE0 0001 8000"            /* .... ..... */
	$"0001 8000 0001 8000 0001 8000 0001 7FFF"            /* ............ */
	$"FFFE 0000 0000 0000 0006 0000 FFFF FFFF"            /* .......... */
	$"FFFF 0001 FC00 F37D 052F 0002 FFFF 648A"            /* ...}./..d */
	$"028C 0003 C000 C000 C000 0004 8000 8000"            /* .......... */
	$"8000 0005 4000 4000 4000 000F 0000 0000"            /* ...@.@.@....... */
	$"0000 0FFF FFFF FFFF FFFF FFFF FFFF FFFF"            /* ... */
	$"FFF0 F000 0000 0000 0000 0000 0000 0000"            /* ............. */
	$"000F F033 3333 3333 3333 3333 3333 3333"            /* ..3333333333333 */
	$"333F F033 3333 3333 3333 3333 3333 3333"            /* 3?3333333333333 */
	$"333F F033 FFFF 3333 3333 3333 3333 3333"            /* 3?33333333333 */
	$"333F F03F 1111 F333 3333 3333 3333 3333"            /* 3??..333333333 */
	$"333F F0F1 FFFF 1F33 3333 3333 3333 3333"            /* 3?.333333333 */
	$"333F F0F1 F33F 1F33 3333 3333 3333 3333"            /* 3??.333333333 */
	$"333F F0F1 F33F 1F33 3333 3333 3333 3333"            /* 3??.333333333 */
	$"333F F0F1 F33F 1F33 3333 3333 3333 3333"            /* 3??.333333333 */
	$"333F F0F1 FFFF 1F33 3334 FFFF FF33 3333"            /* 3?.334333 */
	$"333F F03F 1111 F333 334F 0202 02F3 3333"            /* 3??..33O...33 */
	$"333F F03F 1FFF 3333 34F0 2020 202F 3333"            /* 3??.334   /33 */
	$"333F F03F 1F33 3333 3F02 FF02 0202 F333"            /* 3??.333?....3 */
	$"333F F03F 1F33 3333 5FFF 3320 2020 2F33"            /* 3??.333_3   /3 */
	$"333F F03F 1F33 3FFF F20F FFFF FFF2 02FF"            /* 3??.3?.. */
	$"FF3F F03F 1F33 3333 F020 F020 2020 202F"            /* ??.333     / */
	$"FF3F F03F 1F33 3333 3F02 0202 0202 020F"            /* ??.333?....... */
	$"FF3F F03F 1FFF FFF3 33F0 2020 2020 202F"            /* ??.3     / */
	$"FF3F F03F 1111 11F3 333F F202 0202 020F"            /* ??...3?..... */
	$"FF3F F03F 1FFF FFF3 3333 5FFF FFFF F02F"            /* ??.33_/ */
	$"FF3F F03F 1FFF FFF3 3333 3555 5555 FFFF"            /* ??.335UUU */
	$"FF3F F03F 1111 11F3 3333 3333 3333 355F"            /* ??...3333335_ */
	$"FF3F F03F 1FFF FFF3 3333 3333 3333 3335"            /* ??.33333335 */
	$"553F F03F 1FFF FFF3 3333 3333 3333 3333"            /* U??.33333333 */
	$"333F F03F 1111 11F3 3333 3333 3333 3333"            /* 3??...33333333 */
	$"333F F03F FFFF FFF3 3333 3333 3333 3333"            /* 3??33333333 */
	$"333F F033 3333 3333 3333 3333 3333 3333"            /* 3?3333333333333 */
	$"333F F033 3333 3333 3333 3333 3333 3333"            /* 3?3333333333333 */
	$"333F F033 3333 3333 3333 3333 3333 3333"            /* 3?3333333333333 */
	$"333F F033 3333 3333 3333 3333 3333 3333"            /* 3?3333333333333 */
	$"333F 0FFF FFFF FFFF FFFF FFFF FFFF FFFF"            /* 3?. */
	$"FFF0"                                               /*  */
};

resource 'DITL' (128, "Alert") {
	{	/* array DITLarray: 3 elements */
		/* [1] */
		{96, 268, 116, 326},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{15, 56, 47, 323},
		StaticText {
			disabled,
			"^0^1^2^3"
		},
		/* [3] */
		{15, 10, 47, 42},
		Icon {
			disabled,
			128
		}
	}
};

resource 'DITL' (131, "Kerberos domain edit") {
	{	/* array DITLarray: 7 elements */
		/* [1] */
		{92, 281, 112, 339},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{92, 281, 112, 339},
		UserItem {
			disabled
		},
		/* [3] */
		{92, 213, 112, 271},
		Button {
			enabled,
			"Cancel"
		},
		/* [4] */
		{29, 115, 45, 341},
		EditText {
			enabled,
			""
		},
		/* [5] */
		{30, 21, 46, 107},
		StaticText {
			disabled,
			"Host/Domain"
		},
		/* [6] */
		{63, 115, 78, 341},
		EditText {
			enabled,
			""
		},
		/* [7] */
		{63, 64, 79, 107},
		StaticText {
			disabled,
			"Realm"
		}
	}
};

resource 'DITL' (132, "Kerberos server edit") {
	{	/* array DITLarray: 8 elements */
		/* [1] */
		{92, 281, 112, 339},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{92, 281, 112, 339},
		UserItem {
			disabled
		},
		/* [3] */
		{92, 213, 112, 271},
		Button {
			enabled,
			"Cancel"
		},
		/* [4] */
		{29, 115, 45, 341},
		EditText {
			enabled,
			""
		},
		/* [5] */
		{30, 4, 45, 111},
		StaticText {
			disabled,
			"Host IP address"
		},
		/* [6] */
		{63, 115, 78, 341},
		EditText {
			enabled,
			""
		},
		/* [7] */
		{62, 68, 78, 111},
		StaticText {
			disabled,
			"Realm"
		},
		/* [8] */
		{92, 58, 110, 164},
		CheckBox {
			enabled,
			"Admin server"
		}
	}
};

resource 'DITL' (134, "Kpasswd") {
	{	/* array DITLarray: 12 elements */
		/* [1] */
		{140, 295, 160, 353},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{140, 295, 160, 353},
		UserItem {
			disabled
		},
		/* [3] */
		{140, 224, 160, 282},
		Button {
			enabled,
			"Cancel"
		},
		/* [4] */
		{6, 90, 22, 273},
		StaticText {
			disabled,
			"Kerberos Password Change"
		},
		/* [5] */
		{32, 151, 48, 351},
		EditText {
			enabled,
			""
		},
		/* [6] */
		{32, 107, 48, 146},
		StaticText {
			disabled,
			"Name"
		},
		/* [7] */
		{57, 151, 73, 351},
		EditText {
			enabled,
			""
		},
		/* [8] */
		{57, 25, 73, 146},
		StaticText {
			disabled,
			"Current Password"
		},
		/* [9] */
		{82, 151, 98, 351},
		EditText {
			enabled,
			""
		},
		/* [10] */
		{82, 46, 98, 146},
		StaticText {
			disabled,
			"New Password"
		},
		/* [11] */
		{107, 151, 123, 351},
		EditText {
			enabled,
			""
		},
		/* [12] */
		{106, 26, 141, 146},
		StaticText {
			disabled,
			"     New Password\n(retype to verify)"
		}
	}
};

resource 'DITL' (130, "Main") {
	{	/* array DITLarray: 18 elements */
		/* [1] */
		{20, 155, 38, 379},
		UserItem {
			enabled
		},
		/* [2] */
		{22, 65, 38, 149},
		StaticText {
			disabled,
			"Local Realm:"
		},
		/* [3] */
		{41, 155, 57, 379},
		StaticText {
			disabled,
			"X"
		},
		/* [4] */
		{41, 16, 57, 149},
		StaticText {
			disabled,
			"Network username:"
		},
		/* [5] */
		{3, 169, 19, 359},
		StaticText {
			disabled,
			"KerbNet Configuration"
		},
		/* [6] */
		{270, 18, 290, 76},
		Button {
			enabled,
			"Login"
		},
		/* [7] */
		{270, 86, 290, 144},
		Button {
			enabled,
			"Logout"
		},
		/* [8] */
		{84, 16, 158, 426},
		UserItem {
			enabled
		},
		/* [9] */
		{186, 16, 260, 426},
		UserItem {
			enabled
		},
		/* [10] */
		{270, 154, 290, 284},
		Button {
			enabled,
			"Change password"
		},
		/* [11] */
		{84, 434, 104, 492},
		Button {
			enabled,
			"New"
		},
		/* [12] */
		{108, 434, 128, 492},
		Button {
			enabled,
			"Delete"
		},
		/* [13] */
		{131, 434, 151, 492},
		Button {
			enabled,
			"Edit"
		},
		/* [14] */
		{186, 434, 206, 492},
		Button {
			enabled,
			"New"
		},
		/* [15] */
		{210, 434, 230, 492},
		Button {
			enabled,
			"Delete"
		},
		/* [16] */
		{233, 434, 253, 492},
		Button {
			enabled,
			"Edit"
		},
		/* [17] */
		{67, 16, 83, 424},
		StaticText {
			disabled,
			"Domain/Hostname                  Realm"
		},
		/* [18] */
		{169, 16, 185, 424},
		StaticText {
			disabled,
			"Server IP address                  Realm"
		}
	}
};

resource 'DITL' (129, "About") {
	{	/* array DITLarray: 4 elements */
		/* [1] */
		{289, 397, 309, 455},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{289, 397, 309, 455},
		UserItem {
			disabled
		},
		/* [3] */
		{10, 20, 240, 454},
		UserItem {
			disabled
		},
		/* [4] */
		{252, 23, 318, 392},
		StaticText {
			disabled,
			"Enhanced by Cygnus Solutions to make KerbNet Config."
		}
	}
};

resource 'DITL' (133, "Kerberos tickets") {
	{	/* array DITLarray: 5 elements */
		/* [1] */
		{204, 341, 224, 399},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{10, 143, 26, 285},
		StaticText {
			disabled,
			"Kerberos Credentials"
		},
		/* [3] */
		{204, 269, 224, 327},
		Button {
			enabled,
			"Delete"
		},
		/* [4] */
		{40, 10, 189, 419},
		UserItem {
			disabled
		},
		/* [5] */
		{204, 341, 224, 399},
		UserItem {
			disabled
		}
	}
};

resource 'DITL' (-4081) {
	{	/* array DITLarray: 13 elements */
		/* [1] */
		{215, 281, 235, 352},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{214, 51, 234, 121},
		Button {
			enabled,
			"Cancel"
		},
		/* [3] */
		{9, 8, 41, 40},
		Picture {
			disabled,
			-4081
		},
		/* [4] */
		{27, 63, 61, 376},
		StaticText {
			disabled,
			"Please enter your Network ID\nand password:"
		},
		/* [5] */
		{79, 63, 96, 153},
		StaticText {
			disabled,
			"Network ID:"
		},
		/* [6] */
		{109, 63, 126, 136},
		StaticText {
			disabled,
			"Password:"
		},
		/* [7] */
		{79, 151, 95, 355},
		EditText {
			enabled,
			""
		},
		/* [8] */
		{109, 151, 125, 211},
		EditText {
			enabled,
			""
		},
		/* [9] */
		{142, 63, 162, 218},
		CheckBox {
			enabled,
			"Non-default lifetime"
		},
		/* [10] */
		{142, 226, 158, 276},
		EditText {
			enabled,
			""
		},
		/* [11] */
		{142, 284, 158, 359},
		StaticText {
			disabled,
			"minutes"
		},
		/* [12] */
		{169, 63, 189, 213},
		CheckBox {
			enabled,
			"Forwardable Ticket"
		},
		/* [13] */
		{212, 278, 238, 355},
		UserItem {
			disabled
		},
		/* [14] */
		{260, 151, 276, 211},
		EditText {
			enabled,
			""
		}
	}
};

resource 'DITL' (135, "krb5_prompter") {
	{	/* array DITLarray: 11 elements */
		/* [1] */
		{127, 281, 147, 352},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{127, 198, 147, 269},
		Button {
			enabled,
			"Cancel"
		},
		/* [3] */
		{124, 278, 150, 355},
		UserItem {
			disabled
		},
		/* [4] */
		{10, 10, 42, 42},
		Picture {
			disabled,
			-4081
		},
		/* [5] */
		{14, 55, 50, 355},
		UserItem {
			disabled
		},
		/* [6] */
		{65, 55, 81, 200},
		UserItem {
			disabled
		},
		/* [7] */
		{95, 55, 111, 200},
		UserItem {
			disabled
		},
		/* [8] */
		{65, 208, 81, 352},
		EditText {
			enabled,
			""
		},
		/* [9] */
		{95, 208, 111, 352},
		EditText {
			enabled,
			""
		},
		/* [10] */
		{65, 377, 81, 437},
		EditText {
			enabled,
			""
		},
		/* [11] */
		{95, 377, 111, 437},
		EditText {
			enabled,
			""
		}
	}
};

data 'DLGX' (133) {
	$"0743 6869 6361 676F 0000 0000 0000 0000"            /* .Chicago........ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"000C 0000 0000 0000 0004 0004 0000 0000"            /* ................ */
	$"0005 0000 0000 0000 0000 0000 0000 0006"            /* ................ */
	$"0000 0000 0000 0000 0000 0002 0000 0000"            /* ................ */
	$"0000 0000 0000 000A 0000 0000 0000 0000"            /* ................ */
	$"0000 000A 0000 0000 0000 0000 0000"                 /* .............. */
};

resource 'DLOG' (130, "Main") {
	{42, 4, 342, 502},
	noGrowDocProc,
	visible,
	goAway,
	0x0,
	130,
	""
};

resource 'DLOG' (131, "Kerberos domain edit") {
	{76, 70, 200, 424},
	dBoxProc,
	visible,
	goAway,
	0x0,
	131,
	""
};

resource 'DLOG' (132, "Kerberos server edit") {
	{76, 70, 200, 424},
	dBoxProc,
	visible,
	goAway,
	0x0,
	132,
	""
};

resource 'DLOG' (134, "Kpasswd") {
	{78, 100, 246, 459},
	dBoxProc,
	visible,
	goAway,
	0x0,
	134,
	""
};

resource 'DLOG' (129, "About") {
	{21, 13, 340, 488},
	altDBoxProc,
	visible,
	goAway,
	0x0,
	129,
	""
};

resource 'DLOG' (-4081, "Login") {
	{69, 70, 323, 450},
	dBoxProc,
	visible,
	noGoAway,
	0x0,
	-4081,
	""
};

resource 'DLOG' (133, "Kerberos tickets") {
	{40, 40, 276, 468},
	dBoxProc,
	invisible,
	noGoAway,
	0x0,
	133,
	""
};

resource 'DLOG' (135, "krb5_prompter") {
	{90, 90, 247, 455},
	dBoxProc,
	invisible,
	noGoAway,
	0x0,
	135,
	""
};

resource 'FREF' (128) {
	'APPL',
	0,
	""
};

resource 'FREF' (129) {
	'Pref',
	1,
	""
};

resource 'icl4' (128, purgeable) {
	$"0FFF FFFF FFFF FFFF FFFF FFFF FFFF FFF0"
	$"F000 0000 0000 0000 0000 0000 0000 000F"
	$"F0CC CCCC CCCC CCCC CCCC CCCC CCCC CCCF"
	$"F0CC CCCC CCCC CCCC CCCC CCCC CCCC CCCF"
	$"F0CC FFFF CCCC CCCC CCCC CCCC CCCC CCCF"
	$"F0CF 1111 FCCC CCCC CCCC CCCC CCCC CCCF"
	$"F0F1 FFFF 1FCC CCCC CCCC CCCC CCCC CCCF"
	$"F0F1 FCCF 1FCC CCCC CCCC CCCC CCCC CCCF"
	$"F0F1 FCCF 1FCC CCCC CCCC CCCC CCCC CCCF"
	$"F0F1 FCCF 1FCC CCCC CCCC CCCC CCCC CCCF"
	$"F0F1 FFFF 1FCC CCCD FFFF FFCC CCCC CCCF"
	$"F0CF 1111 FCCC CCDF 0202 02FC CCCC CCCF"
	$"F0CF 1FFF CCCC CDF0 2020 202F CCCC CCCF"
	$"F0CF 1FCC CCCC CF02 FF02 0202 FCCC CCCF"
	$"F0CF 1FCC CCCC EFFF CC20 2020 2FCC CCCF"
	$"F0CF 1FCC CFFF F20F FFFF FFF2 02FF FFCF"
	$"F0CF 1FCC CCCC F020 F020 2020 202F FFCF"
	$"F0CF 1FCC CCCC CF02 0202 0202 020F FFCF"
	$"F0CF 1FFF FFFC CCF0 2020 2020 202F FFCF"
	$"F0CF 1111 11FC CCCF F202 0202 020F FFCF"
	$"F0CF 1FFF FFFC CCCC EFFF FFFF F02F FFCF"
	$"F0CF 1FFF FFFC CCCC CEEE EEEE FFFF FFCF"
	$"F0CF 1111 11FC CCCC CCCC CCCC CEEF FFCF"
	$"F0CF 1FFF FFFC CCCC CCCC CCCC CCCE EECF"
	$"F0CF 1FFF FFFC CCCC CCCC CCCC CCCC CCCF"
	$"F0CF 1111 11FC CCCC CCCC CCCC CCCC CCCF"
	$"F0CF FFFF FFFC CCCC CCCC CCCC CCCC CCCF"
	$"F0CC CCCC CCCC CCCC CCCC CCCC CCCC CCCF"
	$"F0CC CCCC CCCC CCCC CCCC CCCC CCCC CCCF"
	$"F0CC CCCC CCCC CCCC CCCC CCCC CCCC CCCF"
	$"F0CC CCCC CCCC CCCC CCCC CCCC CCCC CCCF"
	$"0FFF FFFF FFFF FFFF FFFF FFFF FFFF FFF0"
};

resource 'icl4' (129, purgeable) {
	$"000F FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"000F 0C0C 0C0C 0C0C 0C0C 0FF0 0000 0000"
	$"000F C0C0 C0C0 C0C0 C0C0 CFCF 0000 0000"
	$"000F 0C0C 0C0C 0C0C 0C0C 0FCC F000 0000"
	$"000F C0C0 FFFF C0C0 C0C0 CFCC CF00 0000"
	$"000F 0C0F 1111 FC0C 0C0C 0FCC CCF0 0000"
	$"000F C0F1 FFFF 1FC0 C0C0 CFFF FFFF 0000"
	$"000F 0CF1 F00F 1F0C 0C0C 0C0C 0C0F 0000"
	$"000F C0F1 F00F 1FC0 C0C0 C0C0 C0CF 0000"
	$"000F 0CF1 F00F 1F0C 0C0C FFFC 0C0F 0000"
	$"000F C0F1 FFFF 1FC0 C0CF 000F C0CF 0000"
	$"000F 0C0F 1111 FC0C 0CF0 FFF0 FC0F 0000"
	$"000F C0CF 1FFF C0C0 C0F0 FFF0 F0CF 0000"
	$"000F 0C0F 1F0C 0C0C 0CF0 FFF0 FC0F 0000"
	$"000F C0CF 1FC0 C0C0 C0CF 000F C0CF 0000"
	$"000F 0C0F 1F0C 0C0C 0C0C FFFC 0C0F 0000"
	$"000F C0CF 1FC0 C0C0 C0C0 C0C0 C0CF 0000"
	$"000F 0C0F 1F0C 0C0C 0C0C 0C0C 0C0F 0000"
	$"000F C0CF 1FFF FFF0 C0FF FFFF F0CF 0000"
	$"000F 0C0F 1111 11FC 0CFF 000F FC0F 0000"
	$"000F C0CF 1FFF FFF0 C0F0 F0F0 F0CF 0000"
	$"000F 0C0F 1FFF FFFC 0CF0 0F00 FC0F 0000"
	$"000F C0CF 1111 11F0 C0F0 F0F0 F0CF 0000"
	$"000F 0C0F 1FFF FFFC 0CFF 000F FC0F 0000"
	$"000F C0CF 1FFF FFF0 C0FF FFFF F0CF 0000"
	$"000F 0C0F 1111 11FC 0C0C 0C0C 0C0F 0000"
	$"000F C0CF FFFF FFF0 C0C0 C0C0 C0CF 0000"
	$"000F 0C0C 0C0C 0C0C 0C0C 0C0C 0C0F 0000"
	$"000F C0C0 C0C0 C0C0 C0C0 C0C0 C0CF 0000"
	$"000F 0C0C 0C0C 0C0C 0C0C 0C0C 0C0F 0000"
	$"000F C0C0 C0C0 C0C0 C0C0 C0C0 C0CF 0000"
	$"000F FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'icl8' (128, purgeable) {
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
	$"FF00 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 00FF"
	$"FF00 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6F6 E0E0 E0E0 F6F6 F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6E0 0505 0505 E0F6 F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 E005 E0E0 E0E0 05FF F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 E005 E0F6 F6E0 05FF F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 E005 E0F6 F6E0 05FF F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 E005 E0F6 F6E0 05FF F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 E005 E0E0 E0E0 05FF F6F6 F6F6 F6FA"
	$"FFFF FFFF FFFF F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6E0 0505 0505 E0F6 F6F6 F6F6 FAFF"
	$"0000 0000 0000 FFF6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6E0 05E0 E0E0 F6F6 F6F6 F6FA FF00"
	$"3333 0808 0808 00FF F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6E0 05E0 F6F6 F6F6 F6F6 F6FF 0033"
	$"FFFF 3308 0808 0800 FFF6 F6F6 F6F6 F6FF"
	$"FF00 F6E0 05E0 F6F6 F6F6 F6F6 FCFD FDFD"
	$"F6F6 3308 0808 0808 08FF F6F6 F6F6 F6FF"
	$"FF00 F6E0 05E0 F6F6 F6FF E0FF FF08 00FD"
	$"FFFF FFFF FFFF FF08 0808 FFFF FFFF F6FF"
	$"FF00 F6E0 05E0 F6F6 F6F6 F6F6 FF33 0800"
	$"FFFA 0008 0808 0808 0808 08FF FFFF F6FF"
	$"FF00 F6E0 05E0 F6F6 F6F6 F6F6 F6FF 3308"
	$"0000 0808 0808 0808 0808 08FF FFFF F6FF"
	$"FF00 F6E0 05E0 E0E0 E0E0 FFF6 F6F6 FF33"
	$"3308 0808 0808 0808 0808 08FF FFFF F6FF"
	$"FF00 F6E0 0505 0505 0505 FFF6 F6F6 F6FF"
	$"FF33 3333 3333 3333 3308 08FF FFFF F6FF"
	$"FF00 F6E0 05E0 E0E0 E0E0 FFF6 F6F6 F6F8"
	$"FBFF FFFF FFFF FFFF FF33 33FF FFFF F6FF"
	$"FF00 F6E0 05E0 E0E0 E0E0 FFF6 F6F6 F6F6"
	$"F6FB FBFB FBFB FBFB FFFF FFFF FFFF F6FF"
	$"FF00 F6E0 0505 0505 0505 FFF6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6FB FBFF FFFF F6FF"
	$"FF00 F6E0 05E0 E0E0 E0E0 FFF6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6FB FBFB F6FF"
	$"FF00 F6E0 05E0 E0E0 E0E0 E0F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6E0 0505 0505 0505 E0F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6E0 E0E0 E0E0 E0E0 E0F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6"
	$"F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF"
};

resource 'icl8' (129, purgeable) {
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF 0000 0000 0000 0000 0000"
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF FF00 0000 0000 0000 0000"
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF 2BFF 0000 0000 0000 0000"
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5FF 2B2B FF00 0000 0000 0000"
	$"0000 00FF F5F5 F5F5 FFFF FFFF F5F5 F5F5"
	$"F5F5 F5F5 F5FF 2B2B 2BFF 0000 0000 0000"
	$"0000 00FF F5F5 F5FF 0505 0505 FFF5 F5F5"
	$"F5F5 F5F5 F5FF 2B2B 2B2B FF00 0000 0000"
	$"0000 00FF F5F5 FF05 FFFF FFFF 05FF F5F5"
	$"F5F5 F5F5 F5FF FFFF FFFF FFFF 0000 0000"
	$"0000 00FF F5F5 FF05 FF00 00FF 05FF F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 FF05 FF00 00FF 05FF F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 FF05 FF00 00FF 05FF F5F5"
	$"F5F5 F5F5 FFFF FFF5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 FF05 FFFF FFFF 05FF F5F5"
	$"F5F5 F5FF 0000 00FF F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 0505 0505 FFF5 F5F5"
	$"F5F5 FF00 FFFF FF00 FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF FFFF F5F5 F5F5"
	$"F5F5 FF00 FFFF FF00 FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF F5F5 F5F5 F5F5"
	$"F5F5 FF00 FFFF FF00 FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF F5F5 F5F5 F5F5"
	$"F5F5 F5FF 0000 00FF F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF F5F5 F5F5 F5F5"
	$"F5F5 F5F5 FFFF FFF5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF FFFF FFFF FFF5"
	$"F5F5 FFFF FFFF FFFF FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 0505 0505 0505 FFF5"
	$"F5F5 FFFF 0000 00FF FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF FFFF FFFF FFF5"
	$"F5F5 FF00 FF00 FF00 FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF FFFF FFFF FFF5"
	$"F5F5 FF00 00FF 0000 FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 0505 0505 0505 FFF5"
	$"F5F5 FF00 FF00 FF00 FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF FFFF FFFF FFF5"
	$"F5F5 FFFF 0000 00FF FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 05FF FFFF FFFF FFF5"
	$"F5F5 FFFF FFFF FFFF FFF5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF 0505 0505 0505 FFF5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5FF FFFF FFFF FFFF FFF5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5F5"
	$"F5F5 F5F5 F5F5 F5F5 F5F5 F5FF 0000 0000"
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'ICN#' (128, purgeable) {
	{	/* array: 2 elements */
		/* [1] */
		$"7FFF FFFE 8000 0001 8000 0001 8000 0001"
		$"8F00 0001 9080 0001 AF40 0001 A940 0001"
		$"A940 0001 A940 0001 AF40 FC01 9081 0201"
		$"9702 0101 9404 C081 9407 2041 9479 FE3D"
		$"9408 C01D 9404 001D 97E2 001D 9021 801D"
		$"97E0 7F9D 97E0 007D 9020 001D 97E0 0001"
		$"97E0 0001 9020 0001 9FE0 0001 8000 0001"
		$"8000 0001 8000 0001 8000 0001 7FFF FFFE",
		/* [2] */
		$"7FFF FFFE FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF 7FFF FFFE"
	}
};

resource 'ICN#' (129, purgeable) {
	{	/* array: 2 elements */
		/* [1] */
		$"1FFF FC00 1000 0600 1000 0500 1000 0480"
		$"10F0 0440 1108 0420 12F4 07F0 1294 0010"
		$"1294 0010 1294 0E10 12F4 1110 1108 2E90"
		$"1170 2E90 1140 2E90 1140 1110 1140 0E10"
		$"1140 0010 1140 0010 117E 3F90 1102 3190"
		$"117E 2A90 117E 2490 1102 2A90 117E 3190"
		$"117E 3F90 1102 0010 11FE 0010 1000 0010"
		$"1000 0010 1000 0010 1000 0010 1FFF FFF0",
		/* [2] */
		$"1FFF FC00 1FFF FE00 1FFF FF00 1FFF FF80"
		$"1FFF FFC0 1FFF FFE0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
	}
};

resource 'ICON' (128) {
	$"7FFF FFFE 8000 0001 8000 0001 8000 0001"
	$"8F00 0001 9080 0001 AF40 0001 A940 0001"
	$"A940 0001 A940 0001 AF40 FC01 9081 0201"
	$"9702 0101 9404 C081 9407 2041 9479 FE3D"
	$"9408 C01D 9404 001D 97E2 001D 9021 801D"
	$"97E0 7F9D 97E0 007D 9020 001D 97E0 0001"
	$"97E0 0001 9020 0001 9FE0 0001 8000 0001"
	$"8000 0001 8000 0001 8000 0001 7FFF FFFE"
};

resource 'ics#' (128, purgeable) {
	{	/* array: 2 elements */
		/* [1] */
		$"7FFE 8001 B801 C401 D401 C5E1 AA19 AFC7"
		$"AA07 A987 AC77 A40F AC01 A401 BC01 7FFE",
		/* [2] */
		$"7FFE FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF 7FFE"
	}
};

resource 'ics#' (129, purgeable) {
	{	/* array: 2 elements */
		/* [1] */
		$"7FE0 4030 5C28 623C 6A04 6264 5494 5494"
		$"5464 5404 56F4 52B4 56D4 52F4 5E04 7FFC",
		/* [2] */
		$"7FE0 7FF0 7FF8 7FFC 7FFC 7FFC 7FFC 7FFC"
		$"7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"
	}
};

resource 'ics4' (128, purgeable) {
	$"0FFF FFFF FFFF FFF0 F000 0000 0000 000F"
	$"F0FF FCCC CCCC CCCF FF11 1FCC CCCC CCCF"
	$"FF1F 1FCC CCCC CCCF FF11 1FCE EEEC CCCF"
	$"F0F1 FCE0 202E ECCF F0F1 FFFF FF02 0FFF"
	$"F0F1 FCE0 2020 2FFF F0F1 FCCE E202 0FFF"
	$"F0F1 FFCC CEEE EFFF F0F1 1FCC CCCC FFFF"
	$"F0F1 FFCC CCCC CCCF F0F1 1FCC CCCC CCCF"
	$"F0FF FFCC CCCC CCCF 0FFF FFFF FFFF FFF0"
};

resource 'ics4' (129, purgeable) {
	$"0FFF FFFF FFF0 0000 0F0C 0C0C 0CFF 0000"
	$"0FCF FFC0 C0FC F000 0FF1 11FC 0CFF FF00"
	$"0FF1 F1F0 C0C0 CF00 0FF1 11FC 0FFC 0F00"
	$"0FCF 1FC0 F00F CF00 0F0F 1F0C F00F 0F00"
	$"0FCF 1FC0 CFF0 CF00 0F0F 1F0C 0C0C 0F00"
	$"0FCF 1FF0 FFFF CF00 0F0F 11FC F0FF 0F00"
	$"0FCF 1FF0 FF0F CF00 0F0F 11FC FFFF 0F00"
	$"0FCF FFF0 C0C0 CF00 0FFF FFFF FFFF FF"
};

resource 'ics8' (128, purgeable) {
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FF00"
	$"FF00 0000 0000 0000 0000 0000 0000 00FF"
	$"FF00 FFFF FFF6 F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FFFF 0505 05FF F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FFFF 05FF 05FF F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FFFF 0505 05FF F6FC FCFC FCF6 F6F6 F6E0"
	$"FF00 FF05 FFF6 FC08 0808 08FC FCF6 F6E0"
	$"FF00 FF05 FFFF FFFF FFFF 0808 08FF FFE0"
	$"FF00 FF05 FFF6 FC33 0808 0808 08FE FEE0"
	$"FF00 FF05 FFF6 F6FC FC33 3308 08FF FFE0"
	$"FF00 FF05 FFFF F6F6 F6FC FDFF 08FF FFFF"
	$"FF00 FF05 05FF F6F6 F6F6 F6F6 FFFF FFFF"
	$"FF00 FF05 FFFF F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 FF05 05FF F6F6 F6F6 F6F6 F6F6 F6FF"
	$"FF00 FFFF FFFF F6F6 F6F6 F6F6 F6F6 F6FF"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF FF"
};

resource 'ics8' (129, purgeable) {
	$"00FF FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"00FF F5F5 F5F5 F5F5 F5F5 FFFF 0000 0000"
	$"00FF F5FF FFFF F5F5 F5F5 FF2B FF00 0000"
	$"00FF FF05 0505 FFF5 F5F5 FFFF FFFF 0000"
	$"00FF FF05 FF05 FFF5 F5F5 F5F5 F5FF 0000"
	$"00FF FF05 0505 FFF5 F5FF FFF5 F5FF 0000"
	$"00FF F5FF 05FF F5F5 FF00 00FF F5FF 0000"
	$"00FF F5FF 05FF F5F5 FF00 00FF F5FF 0000"
	$"00FF F5FF 05FF F5F5 F5FF FFF5 F5FF 0000"
	$"00FF F5FF 05FF F5F5 F5F5 F5F5 F5FF 0000"
	$"00FF F5FF 05FF FFF5 FFFF FFFF F5FF 0000"
	$"00FF F5FF 0505 FFF5 FF00 FFFF F5FF 0000"
	$"00FF F5FF 05FF FFF5 FFFF 00FF F5FF 0000"
	$"00FF F5FF 0505 FFF5 FFFF FFFF F5FF 0000"
	$"00FF F5FF FFFF FFF5 F5F5 F5F5 F5FF 0000"
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF"
};

resource 'MENU' (128) {
	128,
	textMenuProc,
	0x7FFFFFFD,
	enabled,
	apple,
	{	/* array: 2 elements */
		/* [1] */
		"About KerbNet Config", noIcon, noKey, noMark, plain,
		/* [2] */
		"-", noIcon, noKey, noMark, plain
	}
};

resource 'MENU' (129) {
	129,
	textMenuProc,
	0x7FFFFFEF,
	enabled,
	"File",
	{	/* array: 7 elements */
		/* [1] */
		"Login", noIcon, "I", noMark, plain,
		/* [2] */
		"Logout", noIcon, "O", noMark, plain,
		/* [3] */
		"Change Password", noIcon, "P", noMark, plain,
		/* [4] */
		"Show Credentials", noIcon, "L", noMark, plain,
		/* [5] */
		"-", noIcon, noKey, noMark, plain,
		/* [6] */
		"Close Window", noIcon, "W", noMark, plain,
		/* [7] */
		"Quit", noIcon, "Q", noMark, plain
	}
};

resource 'MENU' (130) {
	130,
	textMenuProc,
	allEnabled,
	enabled,
	"Edit",
	{	/* array: 6 elements */
		/* [1] */
		"Undo", noIcon, "Z", noMark, plain,
		/* [2] */
		"-", noIcon, noKey, noMark, plain,
		/* [3] */
		"Cut", noIcon, "X", noMark, plain,
		/* [4] */
		"Copy", noIcon, "C", noMark, plain,
		/* [5] */
		"Paste", noIcon, "V", noMark, plain,
		/* [6] */
		"Clear", noIcon, noKey, noMark, plain
	}
};

resource 'PICT' (128) {
	15266,
	{0, 0, 216, 360},
	$"0011 02FF 0C00 FFFE 0000 0048 0000 0048"
	$"0000 0000 0000 00D8 0168 0000 0000 0001"
	$"000A 0000 0000 00D8 0168 0098 8168 0000"
	$"0000 00D8 0168 0000 0000 0000 0000 0048"
	$"0000 0048 0000 0000 0008 0001 0008 0000"
	$"0000 0000 0000 0000 0000 0047 59E7 0000"
	$"00FF 0000 FFFF FFFF FFFF 0001 FFFF FFFF"
	$"CCCC 0002 FFFF FFFF 9999 0003 FFFF FFFF"
	$"6666 0004 FFFF FFFF 3333 0005 FFFF FFFF"
	$"0000 0006 FFFF CCCC FFFF 0007 FFFF CCCC"
	$"CCCC 0008 FFFF CCCC 9999 0009 FFFF CCCC"
	$"6666 000A FFFF CCCC 3333 000B FFFF CCCC"
	$"0000 000C FFFF 9999 FFFF 000D FFFF 9999"
	$"CCCC 000E FFFF 9999 9999 000F FFFF 9999"
	$"6666 0010 FFFF 9999 3333 0011 FFFF 9999"
	$"0000 0012 FFFF 6666 FFFF 0013 FFFF 6666"
	$"CCCC 0014 FFFF 6666 9999 0015 FFFF 6666"
	$"6666 0016 FFFF 6666 3333 0017 FFFF 6666"
	$"0000 0018 FFFF 3333 FFFF 0019 FFFF 3333"
	$"CCCC 001A FFFF 3333 9999 001B FFFF 3333"
	$"6666 001C FFFF 3333 3333 001D FFFF 3333"
	$"0000 001E FFFF 0000 FFFF 001F FFFF 0000"
	$"CCCC 0020 FFFF 0000 9999 0021 FFFF 0000"
	$"6666 0022 FFFF 0000 3333 0023 FFFF 0000"
	$"0000 0024 CCCC FFFF FFFF 0025 CCCC FFFF"
	$"CCCC 0026 CCCC FFFF 9999 0027 CCCC FFFF"
	$"6666 0028 CCCC FFFF 3333 0029 CCCC FFFF"
	$"0000 002A CCCC CCCC FFFF 002B CCCC CCCC"
	$"CCCC 002C CCCC CCCC 9999 002D CCCC CCCC"
	$"6666 002E CCCC CCCC 3333 002F CCCC CCCC"
	$"0000 0030 CCCC 9999 FFFF 0031 CCCC 9999"
	$"CCCC 0032 CCCC 9999 9999 0033 CCCC 9999"
	$"6666 0034 CCCC 9999 3333 0035 CCCC 9999"
	$"0000 0036 CCCC 6666 FFFF 0037 CCCC 6666"
	$"CCCC 0038 CCCC 6666 9999 0039 CCCC 6666"
	$"6666 003A CCCC 6666 3333 003B CCCC 6666"
	$"0000 003C CCCC 3333 FFFF 003D CCCC 3333"
	$"CCCC 003E CCCC 3333 9999 003F CCCC 3333"
	$"6666 0040 CCCC 3333 3333 0041 CCCC 3333"
	$"0000 0042 CCCC 0000 FFFF 0043 CCCC 0000"
	$"CCCC 0044 CCCC 0000 9999 0045 CCCC 0000"
	$"6666 0046 CCCC 0000 3333 0047 CCCC 0000"
	$"0000 0048 9999 FFFF FFFF 0049 9999 FFFF"
	$"CCCC 004A 9999 FFFF 9999 004B 9999 FFFF"
	$"6666 004C 9999 FFFF 3333 004D 9999 FFFF"
	$"0000 004E 9999 CCCC FFFF 004F 9999 CCCC"
	$"CCCC 0050 9999 CCCC 9999 0051 9999 CCCC"
	$"6666 0052 9999 CCCC 3333 0053 9999 CCCC"
	$"0000 0054 9999 9999 FFFF 0055 9999 9999"
	$"CCCC 0056 9999 9999 9999 0057 9999 9999"
	$"6666 0058 9999 9999 3333 0059 9999 9999"
	$"0000 005A 9999 6666 FFFF 005B 9999 6666"
	$"CCCC 005C 9999 6666 9999 005D 9999 6666"
	$"6666 005E 9999 6666 3333 005F 9999 6666"
	$"0000 0060 9999 3333 FFFF 0061 9999 3333"
	$"CCCC 0062 9999 3333 9999 0063 9999 3333"
	$"6666 0064 9999 3333 3333 0065 9999 3333"
	$"0000 0066 9999 0000 FFFF 0067 9999 0000"
	$"CCCC 0068 9999 0000 9999 0069 9999 0000"
	$"6666 006A 9999 0000 3333 006B 9999 0000"
	$"0000 006C 6666 FFFF FFFF 006D 6666 FFFF"
	$"CCCC 006E 6666 FFFF 9999 006F 6666 FFFF"
	$"6666 0070 6666 FFFF 3333 0071 6666 FFFF"
	$"0000 0072 6666 CCCC FFFF 0073 6666 CCCC"
	$"CCCC 0074 6666 CCCC 9999 0075 6666 CCCC"
	$"6666 0076 6666 CCCC 3333 0077 6666 CCCC"
	$"0000 0078 6666 9999 FFFF 0079 6666 9999"
	$"CCCC 007A 6666 9999 9999 007B 6666 9999"
	$"6666 007C 6666 9999 3333 007D 6666 9999"
	$"0000 007E 6666 6666 FFFF 007F 6666 6666"
	$"CCCC 0080 6666 6666 9999 0081 6666 6666"
	$"6666 0082 6666 6666 3333 0083 6666 6666"
	$"0000 0084 6666 3333 FFFF 0085 6666 3333"
	$"CCCC 0086 6666 3333 9999 0087 6666 3333"
	$"6666 0088 6666 3333 3333 0089 6666 3333"
	$"0000 008A 6666 0000 FFFF 008B 6666 0000"
	$"CCCC 008C 6666 0000 9999 008D 6666 0000"
	$"6666 008E 6666 0000 3333 008F 6666 0000"
	$"0000 0090 3333 FFFF FFFF 0091 3333 FFFF"
	$"CCCC 0092 3333 FFFF 9999 0093 3333 FFFF"
	$"6666 0094 3333 FFFF 3333 0095 3333 FFFF"
	$"0000 0096 3333 CCCC FFFF 0097 3333 CCCC"
	$"CCCC 0098 3333 CCCC 9999 0099 3333 CCCC"
	$"6666 009A 3333 CCCC 3333 009B 3333 CCCC"
	$"0000 009C 3333 9999 FFFF 009D 3333 9999"
	$"CCCC 009E 3333 9999 9999 009F 3333 9999"
	$"6666 00A0 3333 9999 3333 00A1 3333 9999"
	$"0000 00A2 3333 6666 FFFF 00A3 3333 6666"
	$"CCCC 00A4 3333 6666 9999 00A5 3333 6666"
	$"6666 00A6 3333 6666 3333 00A7 3333 6666"
	$"0000 00A8 3333 3333 FFFF 00A9 3333 3333"
	$"CCCC 00AA 3333 3333 9999 00AB 3333 3333"
	$"6666 00AC 3333 3333 3333 00AD 3333 3333"
	$"0000 00AE 3333 0000 FFFF 00AF 3333 0000"
	$"CCCC 00B0 3333 0000 9999 00B1 3333 0000"
	$"6666 00B2 3333 0000 3333 00B3 3333 0000"
	$"0000 00B4 0000 FFFF FFFF 00B5 0000 FFFF"
	$"CCCC 00B6 0000 FFFF 9999 00B7 0000 FFFF"
	$"6666 00B8 0000 FFFF 3333 00B9 0000 FFFF"
	$"0000 00BA 0000 CCCC FFFF 00BB 0000 CCCC"
	$"CCCC 00BC 0000 CCCC 9999 00BD 0000 CCCC"
	$"6666 00BE 0000 CCCC 3333 00BF 0000 CCCC"
	$"0000 00C0 0000 9999 FFFF 00C1 0000 9999"
	$"CCCC 00C2 0000 9999 9999 00C3 0000 9999"
	$"6666 00C4 0000 9999 3333 00C5 0000 9999"
	$"0000 00C6 0000 6666 FFFF 00C7 0000 6666"
	$"CCCC 00C8 0000 6666 9999 00C9 0000 6666"
	$"6666 00CA 0000 6666 3333 00CB 0000 6666"
	$"0000 00CC 0000 3333 FFFF 00CD 0000 3333"
	$"CCCC 00CE 0000 3333 9999 00CF 0000 3333"
	$"6666 00D0 0000 3333 3333 00D1 0000 3333"
	$"0000 00D2 0000 0000 FFFF 00D3 0000 0000"
	$"CCCC 00D4 0000 0000 9999 00D5 0000 0000"
	$"6666 00D6 0000 0000 3333 00D7 EEEE 0000"
	$"0000 00D8 DDDD 0000 0000 00D9 BBBB 0000"
	$"0000 00DA AAAA 0000 0000 00DB 8888 0000"
	$"0000 00DC 7777 0000 0000 00DD 5555 0000"
	$"0000 00DE 4444 0000 0000 00DF 2222 0000"
	$"0000 00E0 1111 0000 0000 00E1 0000 EEEE"
	$"0000 00E2 0000 DDDD 0000 00E3 0000 BBBB"
	$"0000 00E4 0000 AAAA 0000 00E5 0000 8888"
	$"0000 00E6 0000 7777 0000 00E7 0000 5555"
	$"0000 00E8 0000 4444 0000 00E9 0000 2222"
	$"0000 00EA 0000 1111 0000 00EB 0000 0000"
	$"EEEE 00EC 0000 0000 DDDD 00ED 0000 0000"
	$"BBBB 00EE 0000 0000 AAAA 00EF 0000 0000"
	$"8888 00F0 0000 0000 7777 00F1 0000 0000"
	$"5555 00F2 0000 0000 4444 00F3 0000 0000"
	$"2222 00F4 0000 0000 1111 00F5 EEEE EEEE"
	$"EEEE 00F6 DDDD DDDD DDDD 00F7 BBBB BBBB"
	$"BBBB 00F8 AAAA AAAA AAAA 00F9 8888 8888"
	$"8888 00FA 7777 7777 7777 00FB 5555 5555"
	$"5555 00FC 4444 4444 4444 00FD 2222 2222"
	$"2222 00FE 1111 1111 1111 00FF 0000 0000"
	$"0000 0000 0000 00D8 0168 0000 0000 00D8"
	$"0168 0000 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 0006 8100 8100 9900 0006 8100"
	$"8100 9900 001A 8F00 02F5 00F5 F600 ED00"
	$"02F5 00F5 C800 04F5 00F5 00F5 D600 9900"
	$"003F 9400 01F5 00FD F50C 00F5 00F5 00F5"
	$"00F5 00F5 00F5 F5FD F501 00F5 F700 07F5"
	$"00F5 00F5 00F5 00FD F503 00F5 00F5 D400"
	$"FDF5 0400 F500 F500 FDF5 0100 F5DD 0099"
	$"0000 4699 0000 F6F6 FA03 F9F5 F5F6 F9FA"
	$"FFFA 03F6 F500 F5FA 0003 F7FA ACFE FEFF"
	$"0CAC 81F8 F5F5 00F5 FDF8 00F5 00F5 D900"
	$"01F7 FCFE FF08 AC81 F6F5 F5FA FEFF FAFD"
	$"F5FF 0000 F5DF 0099 0000 4E99 0002 F6FA"
	$"ACF9 FF07 FCF9 F5F5 2BFA FBFE FCFF 1CAC"
	$"812B F5F5 00F5 F500 00F5 F7AC FFFF FE81"
	$"56F8 F8FA FEFF FE81 F881 FFF8 FCF5 0100"
	$"F5DD 000A FBFF FFFE F9F8 FDFF FEF7 F8FD"
	$"FF00 F8FC F5DE 0099 0000 4A96 0000 FCFB"
	$"FF00 F8FD F6FE F500 FAFE FF01 FA2B FFF6"
	$"FCF5 FF00 01F6 81FE FF01 ACF6 FDF5 03F6"
	$"F5F9 FEFD FF01 F8F6 FCF5 DD00 00F9 FEFF"
	$"07FB F5F6 FEFF FFFD 81FD FF02 FAF6 F6FC"
	$"F5E0 0099 0000 4E97 0001 F5F7 FCFF 00FD"
	$"FE2B FEF6 FFF5 05FC FFFE F7F6 F6FD F6FE"
	$"F502 00F6 ACFE FF00 FDFA F603 F5F6 F7FE"
	$"FEFF 00F8 FEF6 FEF5 0100 F5DF 0000 FEFE"
	$"FF02 FAF6 F9FD FF00 56FD FF00 56FE F6FE"
	$"F5DF 0099 0000 4D96 0000 F8FC FF00 ACFE"
	$"F7FF 2BFF F602 FBFF FDFD F6FE F6FD F501"
	$"F6AC FDFF 03F8 F6F6 2BFC F602 F5F6 F7FE"
	$"FF00 56FD F6FE F5DF 0000 F7FD FF02 812B"
	$"56FE FF05 AC2B 81FF FE81 FE2B FFF6 FEF5"
	$"E000 9900 0052 9800 02F5 00F7 FCFF 01FD"
	$"F8FE F704 2BF6 FBFF FDFE F6FF 2BFD F6FE"
	$"F500 81FD FF01 FEF6 FC2B FEF6 FFF5 08F6"
	$"FAFF FF56 F62B F6F6 FEF5 DF00 00F9 FDFF"
	$"1081 2BF7 FAAC FC56 F72B F7F7 2BF7 2B2B"
	$"F6F6 FEF5 E000 9900 0075 9600 00F8 FCFF"
	$"00AC FEF8 04F7 2BFB FFFB FBF6 002B FEF6"
	$"FFF5 00F7 FCFF 0581 F72B F72B 2BFE F601"
	$"F5F6 FEF5 04FD FF56 2B2B FEF6 FDF5 0700"
	$"F500 F500 F500 F5F7 000E F500 F500 F500"
	$"F500 F500 F500 F500 FAFD FF04 81F7 F7F8"
	$"F8FD F702 2BF7 F7FE 2BFF F6FD F50C 00F5"
	$"0000 F500 F500 F500 F500 F5EE 0099 0000"
	$"7996 0000 F7FC FF07 FD56 56F8 F7FC FFFB"
	$"FCF6 012B F6FF F6FD F500 FCFC FF00 F9FD"
	$"F7FF 2B00 F6FB F502 F8FF 56FC F6FE F518"
	$"F6F7 F7F5 F500 F500 F500 F500 F500 00F5"
	$"00F5 F500 F500 2BF7 F7FD F504 00F5 00F5"
	$"FAFD FF05 FBF7 F8F8 F7F8 FCF7 032B F72B"
	$"2BFE F6FF F501 00F5 FEF7 01F6 00FD F505"
	$"00F5 00F5 00F5 F100 9900 0076 9700 01F5"
	$"F8FC FF00 FDFE 5603 FCFF FC2B FAF6 00F6"
	$"FDF5 00F6 FBFF 07F8 F7F8 F7F7 2BF6 F6FA"
	$"F509 F9F7 F62B F6F6 F5F6 FAFE FDFF 01FD"
	$"F9FC F50A 2BAC FCAC FCAC FC56 F5F8 FDFD"
	$"FF01 81F6 FEF5 02F9 FCFD FDFF 05FE FDAC"
	$"FCF8 F9FB AC08 F92B 2BF6 F6F5 F5F9 FDFC"
	$"FF01 FD81 FDFA 002B FEF5 FF00 00F5 F300"
	$"9900 006D 9600 00F7 FCFF 0EFD 5656 FCFF"
	$"FF56 2B2B F62B F62B F6F6 FDF5 0100 56FB"
	$"FFFD F802 F72B F6FE F5FF 00FD F5FC F60B"
	$"F7FE FFFF F9F5 F681 FFFF ACF6 FDF5 01F7"
	$"FDFD FF01 FAF9 FAFF 04FC F6F6 F5FA F8FF"
	$"04FD F8F7 F9FE FDFF 0081 FE2B 09F6 2BFD"
	$"FFFF FDF8 F5F8 FEFB FF00 F8FC F5F2 0099"
	$"0000 7D96 0000 F7FC FF02 FDF9 ACFE FF01"
	$"FDF7 FD2B FEF6 FDF5 0100 FAFC FF07 ACF8"
	$"56F8 F82B 2BF6 FEF5 0300 F500 00FB F50E"
	$"F7FE FFFF FAF6 F5F6 F6AC FFFF FDF6 F6FE"
	$"F500 FAFD FF04 ACFF FAF8 81FC FF00 F7FD"
	$"F600 FAFD FF00 FBFE 5603 F8F7 F7FB FDFF"
	$"0581 2B2B F6F6 ACFE FF04 F9F5 F6F6 F9FE"
	$"FF09 FD81 FAF7 F6F6 F5F5 00F5 F300 9900"
	$"007B 9600 00F8 FCFF 01FD ACFC FF01 ACF7"
	$"FE2B FFF6 00F5 FFF5 FE00 00AC FCFF 09FD"
	$"5656 F8F7 F72B F6F5 F5FD 0001 F500 FCF5"
	$"00FD FEFF 002B FDF6 00F9 FEFF 0081 FDF6"
	$"00FA FDFF 01FE F8FE 2B00 FCFD FF00 F9FE"
	$"2B01 F681 FDFF 07FB 5656 F8F8 F7F7 81FD"
	$"FF04 81F7 2B2B F9FD FF00 F8FE F600 F8FD"
	$"FF00 F7FE 2BFF F6FE F5F3 0099 0000 7397"
	$"0001 F5F7 F4FF 06FB F7F7 2B2B F6F6 FFF5"
	$"0300 F500 ACFC FF0A FD56 56F8 F82B F6F6"
	$"F500 F5FB 00FE F500 F9FD FFFF F6FE 2B00"
	$"56FD FF04 F72B F6F6 81FD FF00 FBFD F700"
	$"81FD FF01 FBF7 FE2B 0081 FDFF 00FB FE56"
	$"03F8 F72B 81FD FF04 81F7 2BF7 FCFD FF00"
	$"F6FD 2BFD FF01 FBF7 FE2B FFF6 FFF5 F300"
	$"9900 0074 9600 00F7 FBFF 00FD FAFF 05FA"
	$"F7F7 2BF6 F5FF F5FE 0000 ACFC FF00 FDFE"
	$"56FF F700 F6FE F5F8 0001 F5AC FEFF 00FD"
	$"FC2B 00F7 FDFF 00FB FE2B 0081 FDFF 0081"
	$"FDF7 0081 FDFF 0081 FEF7 012B 81FD FF07"
	$"FB56 56F8 F8F7 2B81 FDFF 00FB FEF7 00AC"
	$"FDFF FF2B 02F7 2BF7 FDFF 00AC FEF7 042B"
	$"F6F6 F5F5 F300 9900 006F 9600 00F7 FCFF"
	$"02FD F9AC FAFF 04F9 F72B 2BF6 FEF5 0200"
	$"F5FC FCFF 08AC F956 F8F8 2BF6 F6F5 F800"
	$"01F5 00FD FF00 ACFB 2BFD FF04 ACF7 2B2B"
	$"81FD FF00 FBFD F800 FBFD FF01 FBF8 FEF7"
	$"0081 FDFF 07FB F856 F8F7 F72B 81FD FF04"
	$"81F7 F8F7 ACFD FFFC F7FD FF00 FDFE F702"
	$"2BF6 F6FE F5F4 0099 0000 7596 0000 F8FC"
	$"FF03 FDF9 F9FD FBFF 04FD 56F7 2BF6 00F6"
	$"FEF5 0100 FAFC FF00 FEFE 5602 F72B 2BFE"
	$"F5F8 0000 F7FD FF01 AC2B FEF7 FF2B FCFF"
	$"FEF7 0081 FDFF 00FB FDF8 0081 FDFF 05FB"
	$"F8F8 F7F7 81FD FF07 FB56 56F8 F72B 2B81"
	$"FDFF 04FB F8F8 F7FA FDFF 00F8 FEF7 00F8"
	$"FDFF 08FB F8F8 F7F7 2BF6 F5F5 F300 9900"
	$"0075 9700 01F5 F7FC FF04 FDF9 F9FA FEFB"
	$"FF03 ACF8 F72B FFF6 FEF5 00F9 FBFF 07F9"
	$"5656 F72B F6F6 F5F7 0000 F8FD FF00 ACFD"
	$"F7FF 2BFC FFFE F700 FBFD FF00 FBFE F801"
	$"F7FB FDFF 00FB FEF8 01F7 81FD FF00 FBFE"
	$"F803 F72B 2BFA FDFF 00FB FEF8 01F7 FDFE"
	$"FF04 F9F7 F8F7 F9FD FF08 F9F8 F7F7 2BF6"
	$"F6F5 F5F3 0099 0000 7696 0000 F7FC FF00"
	$"FDFE F900 81FA FF02 FBF8 2B01 2BF6 FDF5"
	$"FBFF 05FA 5656 F82B F6FE F5F8 0000 F7FD"
	$"FF06 ACF7 F8F7 F72B 2BFC FFFE F800 81FD"
	$"FF01 FB56 FEF8 0081 FDFF 00FB FEF8 01F7"
	$"81FD FF00 FBFE F803 F72B F681 FDFF 00FB"
	$"FEF8 09F7 F8FD FFFF FDF8 F7F8 FDFE FF0A"
	$"FBF7 F7F8 F72B 2BF6 F500 F5F4 0099 0000"
	$"7696 0000 F7FC FF00 FDFD F900 81FA FF01"
	$"FAF7 FF2B 00F6 FEF5 00FC FCFF 08FB 56F8"
	$"F7F7 2BF6 F5F5 F800 00F6 FDFF 06FD F7F8"
	$"F7F7 2B2B FDFF 04FD F7F8 F8FB FDFF 00FB"
	$"FEF8 01F7 FBFD FF00 FBFE F801 F781 FDFF"
	$"07FB F8F8 F7F7 2B2B FAFD FF00 FBFE F8FE"
	$"F700 FBFE FF00 ACFE FF01 FEF9 FCF7 012B"
	$"F6FE F5F3 0099 0000 7B96 0000 F8FC FF06"
	$"FD56 F9F9 5656 FCFA FF00 F901 F72B FEF6"
	$"01F5 F7FC FF09 FD56 56F8 F7F6 F6F5 00F5"
	$"FC00 04F7 F500 F5FD FEFF 06AC F7F8 F8F7"
	$"2BF7 FDFF 00FC FEF8 00FB FDFF 05FB 56F8"
	$"F8F7 81FD FF00 FBFE F801 F7FB FDFF 00FB"
	$"FEF8 03F7 2BF6 81FD FF00 FBFE F8FE F707"
	$"F9FE AC81 81FB F9F8 FBF7 042B F6F6 F5F5"
	$"F200 9900 007C 9700 01F5 F7FC FF01 FDF9"
	$"FE56 FFF8 00AC FBFF 00FD 0756 F72B 2BF6"
	$"F6F5 81FC FF12 FA56 F82B 2BF6 F5F5 0000"
	$"F500 0056 FFFA F5F5 FAFD FFFF F8FF F701"
	$"2B56 FDFF 04F9 F7F8 F881 FDFF 00FB FEF8"
	$"01F7 81FD FF00 FBFE F801 F781 FDFF 00FB"
	$"FEF8 03F7 2BF6 FAFD FF00 FBFE F807 F756"
	$"FDFF ACF7 F7F8 FAF7 FE2B FFF6 FFF5 F200"
	$"9900 0082 9600 00F7 FCFF 08FD 56F9 56F8"
	$"F7F7 F8FE FBFF 03AC F8F7 2BFD F600 ACFD"
	$"FF0E FDF8 F8F7 2BF6 F6F5 F500 00F5 56FF"
	$"FDFE F500 F6FD FF05 F8F7 F8F7 2BF9 FEFF"
	$"05AC F7F8 F8F7 FBFD FF00 FBFE F801 F7FB"
	$"FDFF 00FB FEF8 01F7 81FD FF07 FBF8 F8F7"
	$"F72B F681 FDFF 00FB FEF8 0056 FEFF 01FB"
	$"2BFE F700 F8FD F704 2BF7 2BF6 F6FE F501"
	$"00F5 F400 9900 007E 9600 0056 FCFF 00FE"
	$"FE56 04F8 F7F7 2B56 FBFF 04FF FBF7 2B2B"
	$"FEF6 012B FBFD FF05 ACF8 F7F7 F6F6 FEF5"
	$"032B FBFF FBFC F500 56FE FF00 FAFE F701"
	$"2BFC FEFF 00F8 FDF7 00FB FDFF 00FB FEF8"
	$"01F7 81FD FF00 FBFE F801 F781 FDFF 00FB"
	$"FEF8 03F7 2B2B FAFD FF00 FBFE F800 ACFD"
	$"FF09 FDAC ACFD ACAC FC81 56F7 FE2B 00F6"
	$"FEF5 F200 9900 0073 9700 00F8 FAFF 07AC"
	$"F9F8 F8F7 2B2B F7FB FFFF FF02 81F7 2BFC"
	$"F600 FAFD FF0A FE81 562B F62B 56FB FFFF"
	$"FAFC F5FF F600 F9FE FF03 56F7 2BF9 FEFF"
	$"01F8 2BFE F701 F8FD FDFF 01FD 56FE F800"
	$"ACFD FF05 ACF8 F8F7 F7FD FDFF 07FE 56F8"
	$"F7F7 2B2B FEFD FF00 ACFE F800 ACF4 FF02"
	$"FCF7 2BFE F6FF F5F2 0099 0000 6099 0000"
	$"F7F6 FF03 FDF7 2BAC F9FF FEFF 02FB 2B2B"
	$"FCF6 01F8 FBF7 FF01 FB2B FDF5 14F6 F5F6"
	$"F5F6 56AC FFFF ACFD FFFF FBF7 2B2B F7F7"
	$"56FE FBFF 03FE F956 FEFA FF02 F956 FEFA"
	$"FF04 FDFA F7F8 FEFA FF02 F9F7 F9F3 FF03"
	$"FC2B 2BF6 FEF5 0100 F5F4 0099 0000 6596"
	$"00FF F503 F62B 2BF7 FEF8 FFF7 FF2B FEF6"
	$"FF2B 02F7 F8F8 0856 F8F8 F72B 2BF6 F6F5"
	$"FEF6 FF2B 02F9 81FC FEAC 0B81 F9F6 F6F5"
	$"F6F5 F6F5 F6F5 F5FD F605 F8F9 8181 F9F7"
	$"F52B FBF7 FD2B FCF7 FC2B FCF7 FF2B FDF6"
	$"FF2B FCF7 01F9 ACF4 FF03 F72B 2BF6 FEF5"
	$"F300 9900 006E 9600 FFF5 FFF6 002B FCF7"
	$"FF2B FCF6 FF2B 01F7 F804 F7F8 F7F7 2BFE"
	$"F6FE F5FE F6FB 2BFA F603 F5F6 F5F6 FDF5"
	$"FFF6 FC2B 06F6 2BF6 2BF6 2B2B FCF6 FF2B"
	$"FFF7 FE2B 00F6 FD2B 02F7 2BF7 FE2B 00F6"
	$"FE2B FFF7 FF2B FBF6 FE2B FEF7 0381 FDFF"
	$"81FB FB01 FCFE FEFF 04F9 2B2B F6F6 FEF5"
	$"F400 9900 005E 9800 01F5 00FE F5FF F6FF"
	$"2BFF F7FF 2BFE F600 F5FE F6FE 2BFE F7FF"
	$"2BFF F6FC F5FD F6FF 2B01 F62B FCF6 FFF5"
	$"00F6 F9F5 EEF6 FC2B FDF6 FC2B FBF6 FC2B"
	$"FEF6 00F5 FEF6 FD2B 07AC FFFF F9F7 F7F8"
	$"F8FE 56FF F809 FDFF FFF9 F72B 2BF6 F5F5"
	$"F300 9900 0048 9600 FEF5 FEF6 022B F62B"
	$"FDF6 FDF5 FEF6 002B FF2B 03F6 2BF6 F6F9"
	$"F5F8 F603 F5F6 F5F6 F6F5 F7F6 FCF5 E6F6"
	$"FCF5 FCF6 00F8 FEFF 022B F7F7 FAF8 0A81"
	$"FFFF F7F7 2B2B F6F6 F5F5 F400 9900 005D"
	$"9500 FDF5 FBF6 FAF5 FFF6 00F5 FDF6 01F5"
	$"F6FE F502 00F5 00FD F501 F6F5 FEF6 01F5"
	$"F6FA F5FD 00F8 F500 F6F6 F5FE F6FA F5FE"
	$"F601 F5F6 FDF5 FDF6 FFF5 00F6 FBF5 FEF6"
	$"00F7 FEFF 06F8 2BF7 F7F8 F7F8 FEF7 07FD"
	$"FF81 F7F7 2B2B F6FE F5F4 0099 0000 3E93"
	$"00F5 F500 00FC F5F9 F5FE 0002 F500 00F2"
	$"F503 00F5 00F5 FC00 F7F5 0400 F500 F500"
	$"DBF5 04FB FFFF FEF9 FBF7 03F9 ACFF FCFE"
	$"F7FF 2BFF F602 F500 F5F5 0099 0000 6594"
	$"00FF F500 00FA F5FE 0000 F5FE 00FF F5FB"
	$"F5FA 0000 F5FE 00F7 F5F7 0004 F500 00F5"
	$"00FE F503 00F5 00F5 FE00 05F5 00F5 00F5"
	$"00FE F50F 00F5 00F5 00F5 F500 F500 F500"
	$"F500 F500 FEF5 FB00 01F5 00FD F501 FAFE"
	$"FEFF FEAC 04FD FFFF FC56 FC2B FFF6 FEF5"
	$"F400 9900 0055 9500 00F5 F600 00F5 FE00"
	$"00F5 FE00 F100 07F5 0000 F500 F500 F5FD"
	$"0000 F5FA 0005 F500 00F5 00F5 F200 00F5"
	$"FA00 03F5 0000 F5FA 0000 F5FD 0003 F500"
	$"00F5 FC00 FDF5 01F7 56FD 8104 F956 2B2B"
	$"F6FD 2BFE F6FF F5F3 0099 0000 1D92 0000"
	$"F5F1 0000 F5AB 0003 F500 F500 FDF5 FFF6"
	$"FE2B F6F6 FEF5 F300 9900 0015 8100 E900"
	$"00F5 BE00 FEF5 F3F6 FDF5 0100 F5F4 0099"
	$"0000 0E81 00A4 00FD F5FB F6F7 F5F2 0099"
	$"0000 0D81 00A6 0001 F500 EFF5 F000 9900"
	$"000E 8100 A200 F4F5 FE00 00F5 F100 9900"
	$"0015 8100 9F00 07F5 00F5 F500 F500 F5FE"
	$"0000 F5EF 0099 0000 1781 00A3 000D F500"
	$"00F5 00F5 0000 F500 F500 00F5 ED00 9900"
	$"0006 8100 8100 9900 0006 8100 8100 9900"
	$"0006 8100 8100 9900 0030 E400 0AF5 00F5"
	$"00F5 00F5 00F5 00F5 B300 06F5 00F5 00F5"
	$"00F5 FE00 E900 01F5 00FE F501 00F5 A000"
	$"EC00 04F5 00F5 00F5 B300 0070 E900 00F7"
	$"FBFA 01F6 F5FC FA04 5600 F500 F5F2 0000"
	$"56FE FAFD F501 00F5 D300 0DF8 81AC AC81"
	$"56F5 F5F9 0000 F500 F5EE 000C F6FB ACFC"
	$"F8F5 56AC 2BF5 F500 F5D4 0006 2BAC 5600"
	$"F500 F5E5 0005 F681 00F5 00F5 F700 F200"
	$"0056 FEFA FFF5 0700 81FB F600 F500 F5E9"
	$"0007 56AC 2BF5 00F5 00F5 D600 008E E800"
	$"05F7 FEFF FFFC 2BFE F509 FBFF FBF8 F5F5"
	$"00F5 00F5 F300 0AF5 FDFF FF00 F500 F5F5"
	$"00F5 D600 0F2B FDFF FAF5 F5F7 FBFF ACAC"
	$"F5F5 00F5 0000 F5F0 0009 F6FE FF2B 81FF"
	$"56FF FFAC FCF5 0100 F5DC 000D 2BF6 00F5"
	$"00AC FFFF F500 F500 F5F5 E700 07FA FFF6"
	$"00F5 00F5 F5F9 00F2 0009 F5FD FFFF 00F5"
	$"F8FF FFFA FEF5 0100 F5EF 000D F800 00F5"
	$"00FF FFFC F500 F500 00F5 D700 008C E700"
	$"09AC FFFF FAF5 F6F5 F7FE F9FA F501 00F5"
	$"F300 02AC FFFF FAF5 0100 F5D9 0003 2BFE"
	$"FFFA FCF5 02F9 FFFC FDF5 0000 02F5 00F5"
	$"F200 0981 FFFF F5AC FFF9 FBFF F9FB F5FF"
	$"0000 F5DF 0008 F5FE F700 F500 56FF FBFD"
	$"F503 00F5 00F5 E900 FFFF 0081 FEF5 0400"
	$"F5F5 00F5 FC00 F100 08AC FFFF F5F5 F6FD"
	$"FEF7 FBF5 0100 F5F3 0008 2BFF 00F5 00F5"
	$"FBFF 56FB F501 00F5 D900 010F E700 08FC"
	$"FFFF FAF6 F6F8 FEF9 FEF6 FDF5 0D00 F500"
	$"00F5 00F5 00F5 00F5 00F5 00FE F506 FCFF"
	$"FFF5 F6F5 F6FD F521 00F5 00F5 00F5 00F5"
	$"00F5 00F5 00F5 00F5 00F5 00F5 00F5 00F5"
	$"00F5 00F5 00F5 00F5 00F5 FB00 04F5 FEFF"
	$"FFF6 FBF5 01FC ACFC F5FF F5FF 0013 F500"
	$"F500 F500 F500 F500 F500 F5F5 FCFF FFF5"
	$"F6F7 FBF6 FBF5 FF00 FFF5 2100 F500 F500"
	$"F500 F500 F500 F500 F500 F500 F500 F500"
	$"F500 F500 F500 F500 F500 ACFF F7F5 F511"
	$"00F5 00F5 00F5 00F5 00F5 00F5 00F5 00F5"
	$"00F5 FA00 0456 FFFF FEF6 FBF5 FF00 03F5"
	$"00F5 0018 F500 F500 F500 F500 F500 F500"
	$"F500 F5F5 FCFF FFF5 F6F5 F6F5 F6FC F512"
	$"00F5 0000 F500 F500 F500 F500 F500 F500"
	$"F6FE FFF5 F512 00F5 0000 F500 F500 F500"
	$"F500 F500 F500 F500 F5E9 0001 32E8 0008"
	$"F5AC FFFF FAF6 F8FE F9FE F601 F5F6 FEF5"
	$"06F6 56FA F900 F500 FDF7 0DF5 F6FA F9F6"
	$"F5AC FFFF F6F9 FAF9 2BFD F506 F656 FA56"
	$"00F5 00FD F704 F5F6 FAF9 F6FE F5FE F9FF"
	$"F514 00F5 002B F9FA 2B2B F6F5 F500 F500"
	$"F5F9 FFFF ACF5 F5FD F602 F5F6 FCFD F500"
	$"5606 FAF9 2BF5 00F5 2BFE F70D F52B FAF9"
	$"2BF5 F5F7 FDFF FFF8 F8F6 FE56 00F8 FEF6"
	$"032B F9FA FAFE F8FF F604 F8F7 F8F5 2BFD"
	$"F701 002B FEF7 16F6 F5F9 FA2B F5F5 F6F9"
	$"FAF9 2BF5 00F5 F5FB FFFF F9F8 F6F7 FEF8"
	$"FDF5 072B F9FA F8F5 00F5 F5FE F704 2BF5"
	$"56FA F8FE F501 00F5 FB00 00AC FEFF 00F9"
	$"FEF6 FFF5 FFF7 04F8 F700 F8FA 33F9 F600"
	$"F52B F8F7 F800 56FA F9F6 F5F5 00AC FFFF"
	$"F62B F856 F8F7 F6F6 F5F5 56FA FAF7 F500"
	$"F500 F7FA FA56 F6F5 F500 F6AC FFFF F8F7"
	$"F5FE F800 F7FD F507 F7FA FAF7 F500 F5F6"
	$"FEF7 FFF6 02F9 FA2B FEF5 0100 F5EA 0001"
	$"34E7 0006 FCFF FF81 F8FE FCFE 2BFE F6FF"
	$"F508 F7FE ACF7 ACFD F6F5 F7FE FF19 81FE"
	$"FFFF FBF5 ACFF FFFC 81AC FFFE F8F6 F5F7"
	$"FEAC F7FD FDF6 F5F7 FEFF 1881 FEFF FFFB"
	$"F5F9 FEFC F881 FF56 F5F5 56FF 81F8 FBFF"
	$"F800 F5F5 FE00 03AC FFFF 81FA F6FE F503"
	$"F6F7 FDFD 22F8 F9FF 81F5 F5F8 FEFF FFF9"
	$"ACFE FFFE 2BF5 ACFE FFFF AC81 2BFA FFFF"
	$"AC2B F6F9 FEFE 56FB FEFF 29FA 2BAC FFFF"
	$"F82B FAFF FFAC F52B FDFF FFFB FDFF FFFE"
	$"F581 FFF9 F7FD FFAC F5F5 F8FD FFFF FDFC"
	$"F7F8 FEFF FFFE F611 81FF FAF8 FDFD F7F5"
	$"F6FB FFFF FBFC ACFF FF81 FBF5 FE00 05F6"
	$"FEF9 FFFF FDFD F607 F5F8 FEFF FF81 81FB"
	$"2DFF FEF7 F5F8 FEFF FF81 81FB FFFE F7F5"
	$"F5AC FFFF F62B FBFF FF81 F6F6 F8FD AC56"
	$"FCFF FAF5 F6AC FDF8 F8FF FFFA F5F5 FAFE"
	$"FFFF AC19 F5F9 FFFF ACF6 F62B ACFE F9F8"
	$"FEAC F6F5 2BFD FFFF FAAC FDFF FF56 FCF5"
	$"0100 F5ED 0001 34E7 000A ACFF FFFC FEFF"
	$"FFF9 F72B 2BFE F615 2BFE FFF8 F556 FFFB"
	$"F5F5 FCFF FFF9 F6FD FF81 F6AC FFFF FE2B"
	$"26AC FFFD F6F7 FEFF F8F5 56FF FBF5 F5AC"
	$"FFFF F9F6 FDFF 81F7 FFFF F6F5 F6FF FFF7"
	$"F5FD FFF6 F5F5 FBF8 FBF5 FEFF 03FA F6F6"
	$"2BFE F607 F5F6 F5F5 F6FD FF56 FFF5 12FD"
	$"FFF9 F5F5 ACFF FFF9 F5F9 FFFF F9F6 F5AC"
	$"FFFF FD2B FFFF 2EAC 2B2B FFFF 81F6 F6FF"
	$"FFF9 F6F6 FAFF FFF8 F5F5 FFFF ACF5 F5FA"
	$"FFFF FCF5 FBFF FDF7 FFFF F7F5 56FF FFF9"
	$"F5F6 FAFF FFF8 FEF6 18AC FFFF F6F6 FAFF"
	$"FDF6 F556 FFFD F6F5 F8FF FFFD F6F5 FEFF"
	$"FEF6 FCF5 0500 F500 FA81 2BFE FF0B 562B"
	$"2BF6 F6F5 ACFF FFF8 F5F5 30FB FFFE F6F5"
	$"ACFF FFF8 F5F5 FBFF FEF6 F6AC FFFF 2B2B"
	$"56FF FF81 2BF6 FDFF 56F5 FAFF FFF5 F9FF"
	$"FEF6 F581 FFFF 2BF6 F5FC FFFF FDF6 FFFF"
	$"15AC F6F6 FCFF 81F5 F681 FFFC F5F5 FAFF"
	$"FFFB F52B FFFF FCFB F5EC 0001 3BE7 0003"
	$"ACFF FFFE FEFF 1CFE F8F7 2B2B F6F6 F9FF"
	$"FFF5 F5F8 FFFF F6F6 ACFF FFF6 F62B F8F6"
	$"F6AC FFFF FE2B 18FA FFFF F9FA FFFF F6F6"
	$"56FF FFF6 F6AC FFFF F6F6 2BF8 F6FC FFAC"
	$"FEF6 0BFD FFFC F6FF FFFC 2BF6 2BF6 F6FC"
	$"F5FE FF04 FAF6 2BF6 2BFE F6FE F503 F9FF"
	$"FFF5 FFF6 1281 FFFE F6F6 ACFF FFF6 F6F8"
	$"FFFF 81F6 F6AC FFFF FE2B 4CF7 FFFF AC2B"
	$"56FF FF81 F6F6 FFFF ACF6 F681 FFFF F8F6"
	$"F6FF FFAC F6F6 FAFF FFF8 F6F6 F82B F7FF"
	$"FFF9 F6F8 FFFF FAF6 F6FA FFFF F82B F62B"
	$"ACFF FFF6 2BFE FFFA F6F6 2BFF FFF9 F6F8"
	$"FFFF FAF6 F6AC FFFF FEF6 FDF5 FF00 06FE"
	$"F6F5 FCFF FFFC FE2B FFF6 05AC FFFF F5F5"
	$"F607 F9FF FF56 F6AC FFFF FEF6 41F9 FFFF"
	$"56F6 ACFF FF2B 2BF9 FFFF 812B F9FF FF2B"
	$"F656 FEFC F6F9 FFFF F7F6 FAFF FFF8 F6F6"
	$"ACFF FFF6 F62B 2BFF FFAC F6F8 FFFF 56F6"
	$"F656 FFFF F7F6 FAFF FFF8 F6F6 FFFF ACFE"
	$"F6FE F501 00F5 EE00 0135 E800 05F5 FCFF"
	$"FF81 F9FE FF12 FDF8 F72B 2BF6 ACFF FFFA"
	$"81FB FFFF 56F6 ACFF FFFE F619 2BF6 2BAC"
	$"FFFF 2BF7 F7F9 FFFF 81AC FFFF 8181 FBFF"
	$"FF56 F6AC FFFF FEF6 042B F6FF FFAC FEF6"
	$"04AC FFFE F6AC FEFF 01FB F7FD F6FE F503"
	$"FEFF FF81 FD2B FFF6 FDF5 03FC FFFF F615"
	$"F5F6 FAFF FFF8 F6AC FFFF F62B 56FF FF81"
	$"2B2B ACFF FF2B FEF7 FFFF 2EAC 2BF8 FFFF"
	$"812B 2BFF FFFC 2B2B FAFF FF56 F62B FFFF"
	$"ACF6 2B81 FFFF 562B F62B F6F6 F9FA 2BF7"
	$"81FF FF81 2BF6 81FF FF56 FE2B 18AC FFFF"
	$"2BF8 FFFF 812B F6F6 FFFF FCF6 56FF FF81"
	$"F62B ACFF FF2B FDF6 FEF5 04F8 FCF5 F5F9"
	$"FEFF 00F8 FE2B 03F6 ACFF FFFE F607 56FF"
	$"FF81 F6AC FFFF FE2B 1256 FFFF 812B ACFF"
	$"FF2B F756 FFFF 812B FCFF FF2B FBF6 0CFA"
	$"F9F6 F8AC FFFF 56F6 2BAC FFFF FD2B FFFF"
	$"19AC 2BFA FFFF 56F6 2BF8 FFFF FAF6 81FF"
	$"FF56 F62B FFFF ACF6 2BF6 F6FE F5ED 0001"
	$"2BE7 0005 ACFF FF81 2B81 FEFF 11AC F72B"
	$"2BF6 ACFF FFF8 56F8 5656 2B2B ACFF FFFC"
	$"2B0D F6AC FFFF 2B2B F7F9 FFFF 81AC FFFF"
	$"FC56 04F7 F6AC FFFF FC2B FFFF 09AC 2B2B"
	$"F6AC FFFF 2B2B FDFD FF00 F8FE F6FE F503"
	$"FCFF FFFC FD2B FEF6 FEF5 03AC FFFF F6FF"
	$"F612 81FF FF56 F6AC FFFF 2B2B 56FF FF81"
	$"2B2B ACFF FFFD F7FF FF1B AC2B 2BFA FFFE"
	$"F7FA FFFF 562B 2B81 FFFF 562B 2BFF FFAC"
	$"2B2B 81FF FF56 FC2B 0DF6 F9AC AC81 FFFF"
	$"812B 2B81 FFFF 56FE 2B07 ACFF FF2B 56FF"
	$"FF81 FE2B FFFF 0AAC 2B56 FFFF 812B 2BAC"
	$"FFFF FE2B FFF6 FFF5 0100 FCFA FF01 FBF7"
	$"FE2B 05AC FFFF F6F6 2B07 56FF FF81 2BAC"
	$"FFFF FE2B 1156 FFFF 812B ACFF FFF7 F7F9"
	$"FFFF FBF7 ACFF FFFC 2BFF F60C 2BFA FDFB"
	$"FBFF FF56 2B2B ACFF FFFD 2BFF FF17 AC2B"
	$"81FF FF56 2B2B 56FF FF81 2B81 FFFF 562B"
	$"2BFF FFAC 2B2B FEF6 FEF5 EE00 0137 E900"
	$"08F5 00FC FFFF 81F7 F7FC FEFF 08FB F72B"
	$"2BFC FFFF F8F6 FC2B 02AC FFFF FB2B 0DAC"
	$"FFFF 2BF7 2BF9 FFFF FAFC FFFF 56FE F7FE"
	$"2B02 ACFF FFFC 2B08 FEFF ACF6 2B2B ACFF"
	$"FEFE 2B0E F9FE FFFF FC2B 2BF6 F6F5 F5F8"
	$"FFFF FEFC 2B00 F6FE F504 00FB FFFF F6FF"
	$"F612 81FF FFF7 2BAC FFFF F72B F9FF FF81"
	$"F7F7 ACFF FFFD F7FF FF1B ACF7 2BF7 FAFE"
	$"ACAC FBF8 F72B F781 FFFF 562B 2BFF FFAC"
	$"F72B 81FF FFF9 FC2B 43AC FFFC F656 FFFF"
	$"812B F781 FFFF F92B F7F7 ACFF FF2B F8FF"
	$"FF81 F72B 2BFF FFFB 2B56 FFFF 812B F7AC"
	$"FFFF F72B 2BF6 F6F5 F52B FEF6 F5F5 F681"
	$"FFFF FEF8 F72B 2BAC FFFF F62B 2B1E 56FF"
	$"FFF9 2BAC FFFF F7F7 2BF9 FFFF F92B ACFF"
	$"FFF7 F7F9 FFFF 81F7 ACFF FFF9 F7FD 2B29"
	$"F7FE FFFA 2B81 FFFF F92B F7AC FFFF F7F7"
	$"2BF7 FFFF AC2B FAFF FFF9 2B2B 56FF FFF9"
	$"2B81 FFFF F92B F7FF FFAC FE2B FFF6 FFF5"
	$"0100 F5EF 0001 38E7 0007 ACFF FF81 2BF7"
	$"F8FD FEFF 06FA F72B FAFF FF81 FE2B 05F8"
	$"F72B ACFF FFFB 2B02 ACFF FFFE 2B07 81FF"
	$"FFF7 81FF FF81 FEF7 07F8 F72B ACFF FF2B"
	$"F7FE 2B02 FBFF FDFE 2B0C FEFF FB2B FC2B"
	$"F7F7 FBFF AC2B 2BFE F6FF F503 FCFF FFFA"
	$"FE2B FFF6 07F5 F9AC F556 FFFF 2B14 F62B"
	$"FBFF FE2B 2BAC FFFF F7F7 F9FF FF81 F7F7"
	$"ACFF FFFD F7FF FF05 AC2B 2BFB FFF9 FAF7"
	$"4A81 FFFF F92B F7FF FFAC F7F7 81FF FF56"
	$"F7F7 2B2B F9FF FF56 2B56 FFFF 81F7 F781"
	$"FFFF F9F7 F72B ACFF FFF7 2BFE FFFB F72B"
	$"F8FF FFFA 2B56 FFFF 81F7 F7AC FFFF 2BF7"
	$"2B2B F6F6 F5FA FBF5 F5F6 F6F7 FEFF 06FA"
	$"F7F7 2BAC FFFF FE2B 07FA FFFF F8F7 ACFF"
	$"FFFE F713 FAFF FFF8 F7AC FFFF F7F7 F9FF"
	$"FF81 F7FA FFFF FBF7 FD2B 31FB FFFF F62B"
	$"81FF FF56 F7F7 ACFF FFF7 2BF7 2BFF FFAC"
	$"2BF8 FFFF F9F7 F7FA FFFF F82B 81FF FF56"
	$"F7F7 FFFF ACF7 F72B 2BF6 F6F5 F5EE 0001"
	$"3CE8 0008 F5AC FFFF 812B F7F7 56FD FF0E"
	$"562B F7FE FFFE 562B 56AC 2B2B ACFF FFFC"
	$"2B17 F6AC FFFF F72B F7AC FF81 F7F7 FEFF"
	$"FFF9 F7F9 AC2B F7AC FFFF FC2B 12F7 FEFF"
	$"F72B F7FF FEF7 2BFF 562B F7F9 FFFA 2B2B"
	$"FEF6 FFF5 0AF6 FCFF FFF9 2B2B F6F7 81FC"
	$"FEF5 02AC FFF9 20F6 2BFE FF56 2BF7 ACFF"
	$"FFF7 F7F9 FFFF FBF7 F7AC FFFF F7F7 2B2B"
	$"FFFF ACF7 56FF FFFE FEAC 12FC 56F7 F7FA"
	$"FFFF FAF7 FAFF FFFE F7F7 81FF FFF9 FD2B"
	$"2D81 FFFF 812B FCFF FFFB F8F7 81FF FFFA"
	$"5681 F7AC FFFF 2BF7 F9FF FEF7 F7FA FFAC"
	$"2B2B F9FF FF81 F7F7 ACFF FFF7 F72B 2BFE"
	$"F601 FDF8 FEF5 FFF6 0CAC FFFF FEF7 2B2B"
	$"ACFF FFF9 2BF7 51FD FFFB F72B ACFF FFFA"
	$"F7F8 FDFF FBF7 2BAC FFFF F7F7 F9FF FFFB"
	$"F7F7 FDFF FF81 F7F8 FBF7 ACFF FF56 F7FD"
	$"FFFF F9F8 F7FC FFFF 56FA F9F7 FFFF ACF7"
	$"F781 FFFC F72B FCFF 812B 2B81 FFFF F9F7"
	$"F7FF FFAC F72B 2BF6 F6FE F5EE 0001 3CE9"
	$"0001 F7FB FDFF 04FB F856 81FE FDFF 0356"
	$"2BF7 ACFE FF03 FCF7 2BFA FEFF 01AC 56FE"
	$"2B0D F6AC FAF9 FD81 ACFE FA2B 2BF7 F8AC"
	$"FEFF 03FC F82B FAFE FF01 AC56 FE2B 0FF6"
	$"F8AC FEFA FDAC 562B 2BFF FEFB 81FE FCFD"
	$"2B02 F6F5 F6FE F507 F9AC FFFD ACFD FDF9"
	$"FDF5 02F6 FBFE 0681 FCFE F92B 2BFA FEFF"
	$"07FC F8FD FFFF FEF9 FAFE FF03 ACF9 2BAC"
	$"FEFF 01FA F8F9 FF03 F8F7 F7AC FEFF 05FA"
	$"FFFD FCFA F9FE FF01 FEFA FE2B 11F7 FEFF"
	$"FFAC 56FE FFFF FAF7 F7FD FFFF ACF7 FAFE"
	$"FF0C FC2B 2BF9 FEAC 81FE FCF7 2BF8 FDFE"
	$"FF01 F9FA FEFF 00FC FE2B 0AF6 2BAC FFFD"
	$"56F5 F62B FBFE FEFF 08AC F82B ACFF FFFB"
	$"FDFE 0FFF FBF7 2BF7 ACFF FFFB FDFE FFFB"
	$"F72B 81FE FF09 ACF8 FDFF FFFE F9F7 F7AC"
	$"FEFF 0EAC F82B F9FE FFFF FBF9 FFFF FE56"
	$"F756 FEFF 02FB 2BFC FEFF 11FA 2BF7 81FF"
	$"FBFB FE81 2B2B F9FE FFFF FDF8 FCFE FF08"
	$"FAF7 2B2B F6F6 F500 F5EF 0000 EEE7 00FF"
	$"F5FF F6FE 2BFC F7FC 2B02 F856 F8FC 2B00"
	$"F6FD 2BFE F605 2BF6 F62B F856 FA2B 0256"
	$"F9F8 FC2B 00F6 FC2B FDF6 0BF7 56F7 2BF6"
	$"2B2B F72B F856 F7FE 2BFD F6FC F506 F62B"
	$"5656 F7F6 F6FB F500 2B03 56F8 F6F6 F82B"
	$"07F7 2BF7 2B2B F72B F7F8 2B16 F9FF ACAC"
	$"FDAC FFFF FBF7 F72B 5656 2B2B F72B F7F7"
	$"2B2B F7FC 2BFE F60C F8F7 F62B F756 F72B"
	$"F7F7 2B56 56F6 2BFF 5600 F7F8 2B06 F72B"
	$"F72B F72B 2BFE F6FB F5FE F6FB 2B05 ACFF"
	$"FF2B F8F9 0BF8 F72B F72B ACFF FFF7 F8F9"
	$"F8FE F7FE 2B1F F72B F72B F72B F72B 2BF7"
	$"F7F8 56F8 2B2B F6F6 2B56 2BF6 2BF8 56F7"
	$"2BF7 2BF7 56F8 F62B 01F9 56F8 2B04 F72B"
	$"F72B F7FE 2BFF F6FE F5EE 0000 A5E7 00FE"
	$"F5FF F6F4 2B03 F62B F62B F6F6 02F5 F6F5"
	$"FCF6 012B F6F8 2BF5 F600 F5FD F609 2BF6"
	$"F62B F6F6 2B2B F62B FEF6 FCF5 01F6 F5FC"
	$"F601 F5F6 FCF5 00F6 00F5 FEF6 022B F6F6"
	$"F02B 01F6 2BFE F603 F9FF F92B FEF7 03F8"
	$"FF81 F7F0 2BFE F600 F5FC F6F5 2B00 F6FB"
	$"2B02 F62B 2BFE F602 2BF6 F6F7 2BFF F6F8"
	$"F5FE F6FD 2B02 ACFF FFFE 2B00 F7FD 2B02"
	$"ACFF FFFC F7ED 2BFB F601 2BF6 F32B 00F6"
	$"FB2B 06F6 2B2B F62B F6F6 F72B FEF6 FEF5"
	$"EE00 0097 E800 03F5 00F5 F5FD F600 2BFD"
	$"F600 2BEE F6FC F5E9 F6FD F501 F6F5 F4F6"
	$"FCF5 0000 FDF5 04F6 F5F6 F5F6 FAF5 F5F6"
	$"002B FEF6 002B F5F6 0AFA FFFB 2B2B F7F7"
	$"FAFE F7F7 FE2B 09F6 2BF6 2BF6 2BF6 2BF6"
	$"2BFA F6FE F5FE F605 2BF6 2B2B F62B F4F6"
	$"002B EEF6 F8F5 01F6 F5FC F606 2BAC FFFF"
	$"F72B F7FC 2B05 ACFF FFF7 2BF7 FC2B 0AF6"
	$"2BF6 F62B F62B F62B F62B F7F6 00F5 FCF6"
	$"FF2B 01F6 2BDF F6FE F5ED 0000 9AE7 00FC"
	$"F5F0 F601 F5F6 FEF5 02F6 F5F6 F8F5 01F6"
	$"F5FE F600 F5FB F606 F5F6 F5F5 F6F5 F6F7"
	$"F509 F6F5 F6F5 F6F6 F5F6 F5F6 FCF5 0300"
	$"F500 00F2 F5FD F503 F6F5 F6F5 EFF6 00F5"
	$"FEF6 07F9 ACFE ACAC FCFB F7FD 2BF2 F6FA"
	$"F5EC F600 F5FD F600 F5F5 F601 F5F6 FDF5"
	$"0000 F9F5 FEF6 00F9 FEFF 02AC 562B FD2B"
	$"00FA FEFF 01AC 56FD 2BED F6FE F501 F6F5"
	$"F4F6 00F5 F6F6 02F5 F6F5 FEF6 00F5 F9F6"
	$"FDF5 0100 F5EE 0000 43E5 00B1 F506 00F5"
	$"0000 F500 00F4 F5E3 F5FD F6FA 2BFD F605"
	$"F5F6 F5F6 F5F6 F1F5 00F6 D9F5 0500 F500"
	$"00F5 00FA F5FC F6FF 2BFF 2BFB F6FC 2BFD"
	$"F6E8 F503 F6F5 F5F6 DBF5 ED00 005B E600"
	$"02F5 0000 E6F5 0100 F5FC 00EB F501 00F5"
	$"FD00 01F5 00F4 F501 00F5 FB00 01F5 00FD"
	$"F501 00F5 FC00 01F5 00E3 F5FD F602 2BF6"
	$"2BFC F6F1 F502 00F5 00E4 F500 00F4 F5FC"
	$"0006 F500 F500 00F5 00FB F5FD F6FD F602"
	$"F5F6 F5F9 F6BF F5EA 0000 DAE4 0012 F500"
	$"00F5 00F5 00F5 00F5 00F5 F500 F500 F500"
	$"F5F8 0005 F500 00F5 00F5 F500 00F5 F700"
	$"07F5 0000 F500 F500 F5E6 0006 F500 00F5"
	$"00F5 00F5 0010 F500 F500 F5F5 00F5 F500"
	$"F500 00F5 00F5 00FC F5FB F6F9 F507 00F5"
	$"00F5 00F5 00F5 FB00 16F5 0000 F500 F500"
	$"F5F5 00F5 00F5 00F5 00F5 00F5 00F5 00F5"
	$"FA00 00F5 FE00 06F5 00F5 00F5 00F5 FD00"
	$"03F5 0000 F5FD 0004 F500 00F5 00FC F5FE"
	$"F6FF F6FB F5FC F6FD F511 00F5 00F5 00F5"
	$"00F5 00F5 00F5 00F5 00F5 00F5 FC00 15F5"
	$"00F5 00F5 00F5 00F5 00F5 00F5 00F5 00F5"
	$"00F5 0000 F5F7 0006 F500 F500 F500 F5FE"
	$"0000 F5EC 0000 A2DA 0000 F5F9 0007 F500"
	$"F500 F500 00F5 F700 06F5 00F5 00F5 00F5"
	$"FE00 07F5 00F5 00F5 0000 F5F6 0008 F500"
	$"00F5 0000 F500 F5F3 0000 F5F8 0009 00F5"
	$"00F5 0000 F500 00F5 F400 00F5 FD00 02F5"
	$"0000 FBF5 03F6 F5F5 F6FE F5FD 0000 F5FA"
	$"0000 F5FE 0000 F5FA 0000 F5F1 0004 F500"
	$"F500 F5FD 0000 F5F8 0000 F5F0 00FC F500"
	$"F6F7 F500 F6FC F501 00F5 F000 02F5 00F5"
	$"FC00 00F5 F200 00F5 FE00 07F5 00F5 0000"
	$"F500 F5F8 0000 F5EA 0000 2F89 0000 F5FA"
	$"00E3 0002 F500 00FA F505 00F5 F500 00F5"
	$"FB00 00F5 BA00 FDF5 FDF5 0200 F500 F9F5"
	$"F900 00F5 F000 00F5 C300 0027 8100 E100"
	$"08F5 00F5 00F5 00F5 00F5 AF00 04F5 00F5"
	$"00F5 0D00 F500 F500 00F5 00F5 00F5 F500"
	$"F5A7 0000 1681 00DD 0003 F500 00F5 AB00"
	$"01F5 0000 F5F9 0000 F5A3 0000 0A81 0081"
	$"00F5 0000 F5A6 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0E81 00A8 0000 F5F9 0000 F5E4 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0EFA 0000 0789 0E81"
	$"0EA1 0E00 07FA 0000 0FFA 0000 0E89 D881"
	$"D8A2 D801 4715 FA00 0161 FA00 780E 3915"
	$"3915 1539 1515 3915 1539 1515 3915 1539"
	$"1515 3915 1539 1515 3915 1539 1515 3915"
	$"1539 1515 3915 1539 1515 3915 1539 1515"
	$"3915 1539 1515 3915 1539 1515 3915 1539"
	$"1515 3915 1539 1515 3915 1539 1515 3915"
	$"1539 1515 3915 1539 1515 3915 1539 1515"
	$"3915 1539 1515 3915 1539 1515 3915 1539"
	$"1515 3915 1539 FF15 7D39 1515 3915 1539"
	$"1515 3915 1539 1515 3915 1539 1515 3915"
	$"1539 1515 3915 1539 1515 3915 1539 1515"
	$"3915 1539 1515 3915 1539 1515 3915 1539"
	$"1515 3915 1539 1515 3915 1539 1515 3915"
	$"1539 1515 3915 1539 1515 3915 1539 1515"
	$"3915 1539 1515 3915 1539 1515 3915 1539"
	$"1515 3915 1539 1515 3915 1539 1515 3915"
	$"1539 1515 3915 1560 3915 1539 1515 3915"
	$"1539 1515 3915 1539 1515 3915 1539 1515"
	$"3915 1539 1515 3915 1539 1515 3915 1539"
	$"1515 3915 1539 1515 3915 1539 1515 3915"
	$"1539 1515 3915 1539 1515 3915 1539 1515"
	$"3915 1539 1515 3915 1539 1515 3915 1539"
	$"1515 3915 1539 1515 0EFA 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 0681 0081 0099 0000 0681 0081"
	$"0099 0000 5AE9 00FD FFE2 0000 FFF7 0000"
	$"FFFA 0000 FFF6 0000 FFFC 00FD FFFD 00FD"
	$"FFFE 00FB FFF8 00FF FFFC FFFF 0000 FFF0"
	$"0000 FFFD 0000 FFF7 0000 FFE2 0000 FFFD"
	$"0000 FFE9 00FF FFFC 00FA FFF6 00E2 0000"
	$"FFF6 0000 FFED 0000 FFFC 0000 FFE0 0000"
	$"54EA 0000 FFFD 0000 FFD8 0000 FFFA 0000"
	$"FFF7 00FF FFFD 0000 FFFD 0003 FF00 00FF"
	$"FD00 00FF FB00 00FF F500 0100 FFFC 0000"
	$"FFF0 0000 FFFD 0000 FFD2 0000 FFEA 0000"
	$"FFF7 0000 FFF3 00E2 0000 FFF6 0000 FFED"
	$"0000 FFDA 0000 D9EA 0000 FFF9 00FE FFFE"
	$"00FD FFFE 0000 FFFE 0004 FF00 00FF 00FE"
	$"FF02 00FF FFFD 00FD FFFF 0003 FF00 FFFF"
	$"FE00 FEFF F700 00FF FD00 00FF FD00 03FF"
	$"0000 FFFD 0000 FFFC 0000 FFF4 0001 00FF"
	$"FC00 03FF 00FF FFFD 00FE FFFA 0000 FFFD"
	$"0006 FF00 00FF 00FF FFFE 00FF FFFE 0000"
	$"FFFE 0000 FFFE 00FE FFFE 0001 FF00 FEFF"
	$"FF00 FEFF FE00 FFFF FE00 FEFF FE00 00FF"
	$"FE00 00FF FA00 FEFF FE00 FEFF F800 00FF"
	$"FB00 FEFF FE00 01FF 00FF 0000 FFFE 00FE"
	$"FFFD 00FE FFF9 00FE FFFE 00FE FFF8 0002"
	$"FF00 FFFD 0000 FFFE 0000 FFFE 00FE FFFE"
	$"00FE FFFE 00FF FFFE 0003 FF00 FFFF E700"
	$"00FF EA00 00FF FA00 00FF FE00 03FF 0000"
	$"FFFE 0003 FF00 00FF FE00 04FF 0000 FFFF"
	$"FC00 00FF FE00 00FF FE00 07FF 0000 FFFF"
	$"0000 FFFE 0000 FFF6 0000 FFFD 0000 FFFD"
	$"0003 FF00 00FF FD00 00FF FD00 FFFF F400"
	$"0100 FFFC 00FF FFFF 0003 FF00 00FF FE00"
	$"00FF FB00 00FF FD00 07FF 0000 FFFF 0000"
	$"FFFE 0000 FFFE 0000 FFFE 0003 FF00 00FF"
	$"FE00 04FF 0000 FFFF FD00 00FF FE00 00FF"
	$"FE00 00FF FD00 00FF FD00 00FF FE00 00FF"
	$"FB00 00FF FE00 00FF FE00 00FF F700 00FF"
	$"FC00 00FF FE00 04FF 0000 FF00 FF00 03FF"
	$"0000 FFFE 0003 FF00 00FF FE00 00FF FB00"
	$"00FF FE00 00FF FE00 00FF F700 02FF 00FF"
	$"FD00 00FF FE00 03FF 0000 FFFE 0000 FFFE"
	$"0000 FFFC 0000 FFFE 00FF FFFF 0000 FFE8"
	$"0000 ECEA 0000 FFFA 0000 FFFE 0003 FF00"
	$"00FF FE00 03FF 0000 FFFE 0003 FF00 00FF"
	$"FB00 00FF FE00 00FF FE00 03FF 0000 FFFE"
	$"0000 FFFE 0000 FFF6 0000 FFFD 0000 FFFD"
	$"0003 FF00 00FF FD00 00FF FB00 00FF F500"
	$"0100 FFFC 0000 FFFE 0003 FF00 00FF FE00"
	$"00FF FB00 00FF FD00 03FF 0000 FFFE 0000"
	$"FFFE 0000 FFFE 0000 FFFE 0003 FF00 00FF"
	$"FE00 03FF 0000 FFFC 0000 FFFA 0000 FFFD"
	$"0000 FFFD 0000 FFFE 0000 FFFB 0000 FFFE"
	$"0000 FFFE 0000 FFF7 0000 FFFC 0000 FFFE"
	$"0000 FFFE 0000 FF01 00FF FD00 FDFF FF00"
	$"00FF F600 FDFF FE00 00FF F800 00FF FE00"
	$"00FF FE00 00FF FE00 03FF 0000 FFFA 0000"
	$"FFFC 0000 FFFE 0000 FFFE 0000 FFE8 0000"
	$"E0EA 0000 FFFA 0000 FFFE 0003 FF00 00FF"
	$"FE00 03FF 0000 FFFE 0003 FF00 00FF FB00"
	$"00FF FE00 00FF FE00 03FF 0000 FFFE 0000"
	$"FFFE 0000 FFF6 0000 FFFC 00FC FFFE 00FC"
	$"FFFA 0000 FFF6 0001 00FF FC00 00FF FE00"
	$"02FF 0000 FCFF FB00 00FF FD00 03FF 0000"
	$"FFFE 0000 FFFE 0000 FFFD 0002 FF00 FFFE"
	$"00FC FFFF 0000 FFFB 00FE FFFD 0000 FFFD"
	$"0000 FFFD 0000 FFFE 0000 FFFB 0000 FFFE"
	$"0000 FFFE 0000 FFF7 0000 FFFC 00FC FFFD"
	$"0000 FFFD 0000 FFFE 0000 FFFE 00FE FFFA"
	$"0000 FFFE 0000 FFFE 0000 FFF8 0000 FFFE"
	$"0000 FFFE 0000 FFFE 0000 FFFE 00FE FFFD"
	$"0000 FFFC 0000 FFFE 0000 FFFE 0000 FFE8"
	$"0000 DEEA 0000 FFFA 0000 FFFE 0003 FF00"
	$"00FF FE00 03FF 0000 FFFE 0003 FF00 00FF"
	$"FB00 00FF FE00 00FF FE00 03FF 0000 FFFE"
	$"0000 FFFE 0000 FFF6 0000 FFF8 0000 FFFA"
	$"0000 FFFA 0000 FFF6 0001 00FF FC00 00FF"
	$"FE00 03FF 0000 FFF7 0000 FFFD 0003 FF00"
	$"00FF FE00 00FF FE00 00FF FD00 02FF 00FF"
	$"FE00 00FF FB00 00FF F800 00FF FE00 00FF"
	$"FD00 00FF FD00 00FF FE00 00FF FB00 00FF"
	$"FE00 00FF FE00 00FF F700 00FF FC00 00FF"
	$"FA00 00FF 0100 FFFE 0000 FFFE 0000 FFFB"
	$"0000 FFFB 0000 FFFE 0000 FFFE 0000 FFF9"
	$"00FA FFFF 0000 FFFE 0000 FFFB 0000 FFFE"
	$"0000 FFFC 0000 FFFE 0000 FFFE 0000 FFE8"
	$"0000 FBEA 0000 FFFD 0003 FF00 00FF FE00"
	$"03FF 0000 FFFE 0003 FF00 00FF FE00 03FF"
	$"0000 FFFB 0000 FFFE 0000 FFFE 0003 FF00"
	$"00FF FE00 00FF FE00 00FF F600 00FF F900"
	$"00FF FA00 00FF FE00 00FF FE00 00FF F500"
	$"0100 FFFC 0000 FFFE 0003 FF00 00FF FE00"
	$"00FF FB00 00FF FD00 03FF 0000 FFFE 0000"
	$"FFFE 0000 FFFC 0000 FFFD 0000 FFFE 0003"
	$"FF00 00FF FC00 00FF FE00 00FF FE00 00FF"
	$"FD00 00FF FD00 00FF FE00 00FF FB00 00FF"
	$"FE00 00FF FE00 00FF F700 00FF FC00 00FF"
	$"FE00 04FF 0000 FF00 FF00 03FF 0000 FFFE"
	$"0003 FF00 00FF FE00 00FF FB00 00FF FE00"
	$"00FF FE00 00FF F900 00FF FC00 0AFF 0000"
	$"FF00 00FF FF00 00FF FE00 00FF FE00 00FF"
	$"FC00 00FF FE00 00FF FE00 00FF E800 00C7"
	$"E900 FDFF FD00 FEFF FE00 FDFF FD00 FDFF"
	$"FF00 00FF FB00 00FF FD00 FDFF FF00 00FF"
	$"FE00 00FF FD00 FFFF F800 00FF FC00 FEFF"
	$"FC00 FEFF FC00 FEFF FC00 00FF FA00 0100"
	$"FFFC 0000 FFFE 0000 FFFE 00FE FFF9 00FD"
	$"FFFE 0000 FFFE 0000 FFFE 0000 FFFC 0000"
	$"FFFC 00FE FFFE 0000 FFFB 00FE FFFD 0000"
	$"FFFC 00FF FFFE 00FD FFFA 00FE FFFD 0000"
	$"FFF7 0000 FFFB 00FE FFFE 0001 FF00 FF00"
	$"00FF FE00 FDFF FE00 FEFF F900 FDFF FD00"
	$"FFFF FB00 00FF FC00 00FF FE00 FFFF 0100"
	$"FFFE 00FE FFFC 00FF FFFE 0000 FFFE 0000"
	$"FFFE 0000 FFE8 0000 1ADB 0000 FFF7 0000"
	$"FFF0 0000 FFCD 0000 FFFA 00AA 0000 FFD9"
	$"0099 0000 26DB 0000 FFFB 0000 FFFE 0000"
	$"FFF4 0000 FFFE 0000 FFCE 0000 FFF9 00AE"
	$"0000 FFFE 0000 FFD9 0099 0000 12D3 00FE"
	$"FFF2 00FE FFC4 00AD 00FE FFD8 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"0681 0081 0099 0000 0681 0081 0099 0000"
	$"1D8E 00FC FFFB 0001 FF00 FB00 00FF F700"
	$"00FF D600 00FF D300 00FF EE00 9900 0025"
	$"8E00 00FF FD00 00FF FC00 01FF 00FB 0000"
	$"FFF7 0000 FFE6 00FD FFF5 0000 FFD3 0000"
	$"FFEE 0099 0000 688E 0000 FFFD 0000 FFFC"
	$"0001 FF00 FF00 00FF FE00 00FF FE00 FEFF"
	$"FE00 FEFF FD00 FEFF FD00 FEFF FE00 03FF"
	$"00FF FFFD 0000 FFFD 0000 FFFE 0000 FFFE"
	$"0002 FF00 00FE FFFD 00FE FFFE 0000 FFFE"
	$"0000 FFFE 00FE FFFD 00FE FFFA 00FE FFFD"
	$"00FD FFFF 0000 FFFE 0000 FFF5 0099 0000"
	$"818E 0000 FFFD 0000 FFFB 0000 FFFF 0003"
	$"FF00 00FF FE00 00FF FE00 00FF FE00 00FF"
	$"FD00 00FF FE00 03FF 0000 FFFE 000C FF00"
	$"00FF FF00 00FF 0000 FF00 00FE FF04 00FF"
	$"0000 FFFE 0000 FFFE 0000 FFFD 0000 FFFE"
	$"0003 FF00 00FF FE00 03FF 0000 FFFE 0003"
	$"FF00 00FF FE00 00FF FC00 00FF FE00 03FF"
	$"0000 FFFE 0003 FF00 00FF FE00 00FF F500"
	$"9900 006F 8E00 FCFF FA00 00FF 0500 FF00"
	$"FF00 FFFD 00FD FFFE 0000 FFFD 0000 FFFB"
	$"0000 FFFE 0003 FF00 00FF FE00 0DFF 0000"
	$"FF00 FF00 00FF 00FF 0000 FFFE 0000 FFFE"
	$"0000 FFFD 0000 FFFE 0000 FFFE 0002 FF00"
	$"FFFD 00FD FFFF 0000 FFF8 0000 FFFE 0003"
	$"FF00 00FF FE00 03FF 0000 FFFE 0000 FFF5"
	$"0099 0000 708E 0002 FF00 FFF8 0000 FF05"
	$"00FF 00FF 00FF FE00 00FF FE00 00FF FE00"
	$"00FF FC00 FEFF FE00 00FF FE00 03FF 0000"
	$"FFFE 000D FF00 00FF 00FF 0000 FF00 FF00"
	$"00FF FE00 00FF FE00 00FF FD00 FCFF FD00"
	$"00FF FD00 00FF FE00 00FF FE00 FEFF FB00"
	$"FCFF FF00 00FF FE00 03FF 0000 FFFE 0000"
	$"FFF5 0099 0000 6D8E 0003 FF00 00FF F800"
	$"00FF FE00 00FF FD00 00FF FE00 00FF FE00"
	$"00FF F900 03FF 0000 FFFE 0003 FF00 00FF"
	$"FE00 05FF 0000 FF00 00FD FFFE 0000 FFFE"
	$"0000 FFFE 0000 FFFD 0000 FFFA 0002 FF00"
	$"FFFE 0000 FFFE 0000 FFFB 0000 FFFC 0000"
	$"FFFB 0000 FFFE 0003 FF00 00FF FE00 00FF"
	$"F500 9900 0079 8E00 00FF FE00 00FF F900"
	$"00FF FE00 00FF FD00 00FF FE00 00FF FE00"
	$"00FF FD00 00FF FE00 03FF 0000 FFFE 0003"
	$"FF00 00FF FE00 00FF FE00 00FF F900 04FF"
	$"0000 FFFF FE00 00FF FD00 00FF FE00 03FF"
	$"0000 FFFE 0003 FF00 00FF FE00 03FF 0000"
	$"FFFE 0000 FFFC 0000 FFFE 0003 FF00 00FF"
	$"FE00 07FF 0000 FF00 00FF FFF5 0099 0000"
	$"658E 0000 FFFD 0003 FF00 00FF FD00 00FF"
	$"FE00 00FF FC00 FDFF FD00 FFFF FE00 FEFF"
	$"FD00 FEFF FE00 00FF FE00 00FF FD00 FEFF"
	$"FB00 FFFF 0100 FFFD 00FF FFFE 00FE FFFE"
	$"0000 FFFE 0000 FFFE 00FD FFFE 00FE FFFE"
	$"0000 FFFE 00FE FFFD 00FD FFFE 00FF FF01"
	$"00FF F500 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 0006 8100 8100 9900 0006"
	$"8100 8100 9900 00FF"
};

resource 'PICT' (129) {
	2386,
	{0, 0, 216, 360},
	$"1101 0100 0A00 0000 0000 D801 6898 0030"
	$"0000 0000 00D8 0168 0000 0000 00D8 0168"
	$"0000 0000 00D8 0168 0000 02D1 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 02D1 0002"
	$"D100 02D1 0002 D100 02D1 0002 D100 02D1"
	$"0002 D100 02D1 0002 D100 02D1 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 11F3 0006"
	$"FFE1 FF80 07F0 20FC 0001 7E1C ED00 11F3"
	$"0006 3F80 3E00 3C1E 60FC 0001 E33E ED00"
	$"12F3 0006 1F00 3800 7007 E0FD 0002 01E7"
	$"BEED 0012 F300 061F 0020 00E0 01E0 FD00"
	$"0203 E7BE ED00 12F3 0006 1F00 4001 C000"
	$"E0FD 0002 03E7 1CED 0011 F300 061F 0080"
	$"03C0 00E0 FD00 0103 E0EC 0011 F300 061F"
	$"0100 07C0 0060 FD00 0103 E0EC 0016 F300"
	$"101F 0200 0780 0020 1F80 FE3C 0FFC FE03"
	$"FFC0 F000 16F3 0010 1F04 000F 8000 0078"
	$"E03E FE03 E07E 0F1F C0F0 0015 F300 0F1F"
	$"1800 0F80 0000 F0F0 3F3F 03E0 3E1E 0FEF"
	$"0015 F300 0F1F 3800 0F80 0001 E078 3E1F"
	$"03E0 3E1E 0FEF 0016 F300 101F 7C00 0F80"
	$"0001 E078 3E1F 03E0 3E3E 0F80 F000 16F3"
	$"0010 1FFE 000F 8000 03E0 7C3E 1F03 E03E"
	$"3E0F 80F0 0016 F300 101F 3F00 0F80 0003"
	$"E07C 3E1F 03E0 3E3E 0F80 F000 16F3 00FF"
	$"1F0E 800F 8000 03E0 7C3E 1F03 E03E 3E0F"
	$"80F0 0016 F300 101F 0FC0 0F80 0003 E07C"
	$"3E1F 03E0 3E1E 0F80 F000 15F3 000F 1F0F"
	$"E007 C000 03E0 7C3E 1F03 E03E 1E0F EF00"
	$"15F3 000F 1F07 F007 C000 03E0 7C3E 1F03"
	$"E03E 0F1E EF00 15F3 000F 1F03 F803 C000"
	$"33E0 7C3E 1F03 E03E 03F8 EF00 14F3 000E"
	$"1F01 FC01 E000 61E0 783E 1F03 E03E 06EE"
	$"0014 F300 0E1F 00FE 00F0 01C1 E078 3E1F"
	$"03E0 3E1E EE00 15F3 000F 1F00 7F00 7C07"
	$"80F0 F03E 1F03 E03E 3FFE EF00 16F3 0010"
	$"3F80 7F80 1FFF 0078 E03E 1F03 F03E 3FFF"
	$"80F0 0016 F300 10FF E3FF C007 F800 1F80"
	$"FF3F CFFC FFBF FF80 F000 08E5 0002 1FFF"
	$"C0F0 0008 E500 0207 FFC0 F000 08E5 0002"
	$"3803 C0F0 0008 E500 0260 01C0 F000 08E5"
	$"0002 6001 80F0 0008 E500 0260 0380 F000"
	$"07E5 0001 3806 EF00 07E5 0001 0FF8 EF00"
	$"02D1 0002 D100 02D1 0002 D100 02D1 0002"
	$"D100 02D1 0002 D100 02D1 0002 D100 02D1"
	$"0002 D100 02D1 0002 D100 02D1 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 25FE 0005"
	$"1FCF C000 0780 FC00 0503 E400 0001 EEFB"
	$"0000 70FE 0000 04FE 0001 1E38 FE00 0038"
	$"F900 25FE 0005 0703 0000 0380 FC00 050E"
	$"3C00 0003 3EFB 0000 70FE 0000 0CFE 0001"
	$"0E38 FE00 0038 F900 26FE 0005 0704 0000"
	$"0380 FC00 051C 0C00 0007 7EFC 0001 0870"
	$"FE00 000E FE00 050E 3800 0004 38F9 0024"
	$"FE00 0507 0800 0003 80FC 0005 180C 0000"
	$"0730 FC00 0018 FD00 000E FE00 000E FE00"
	$"000C F800 23FE 0005 0710 0000 0380 FC00"
	$"0438 0400 0007 FB00 0038 FD00 001F FE00"
	$"000E FE00 001C F800 2DFE 0027 0720 078F"
	$"73B8 3C7B 8F87 E038 007C 7B8F DE1F FEF3"
	$"DC7C 7EF0 F8F7 0017 07B8 F70E 783C 3E3F"
	$"787C 7B80 FC00 2DFE 0027 07F0 0CC7 BBDC"
	$"663D DCCE 2038 00E6 3DC7 0E71 8E71 EF8E"
	$"3871 CC7B 8017 03CC 798E 38EE C71C 38E6"
	$"3DC0 FC00 2DFE 0027 0778 1CE7 1B8E E738"
	$"F8EE 2038 01C7 39C7 0E71 CE71 C7CE 3873"
	$"8E73 8023 838E 71CE 38CE E71C 39C7 39C0"
	$"FC00 2DFE 0027 073C 1CE7 038E E738 38EF"
	$"8038 01C7 39C7 0E71 CE71 C1CE 3873 8E73"
	$"8023 838E 71CE 39CE E71C 39C7 39C0 FC00"
	$"2DFE 0027 071E 1FE7 038E FF38 38E7 C038"
	$"01C7 39C7 0E31 CE71 C03E 3873 8E73 807F"
	$"C38E 71CE 39C0 1F1C 39C7 39C0 FC00 2DFE"
	$"0027 070F 1C07 038E E038 38E1 E018 01C7"
	$"39C7 0E1F 0E71 C0EE 3873 8E73 8041 C38E"
	$"71CE 39C0 771C 39C7 39C0 FC00 2DFE 00FF"
	$"0725 1C07 038E E038 38E8 E01C 0DC7 39C7"
	$"0E30 0E71 C1CE 3873 8E73 8041 C38E 71CE"
	$"39E0 E71C 39C7 39C0 FC00 2DFE 00FF 0725"
	$"8E67 039C 7338 18C8 E00E 18C6 39C7 0E7F"
	$"8EF9 C1CE BA71 8C73 80C1 E39C 738E 38F2"
	$"E75D 38C6 39C0 FC00 2DFE 0027 1FCF E78F"
	$"8278 3C7C 0F8F C003 E07C 7DEF DF7F C763"
	$"E0FF 1CF8 F8FB C1E3 F3F8 7F1F 7C3C 7F8E"
	$"7C7C 7DE0 FC00 0DED 0001 3FC0 F800 0203"
	$"8070 F300 0DED 0001 40C0 F800 0203 8070"
	$"F300 0DED 0001 4080 F800 0203 8070 F300"
	$"0CED 0000 3FF7 0002 07C0 F8F3 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 02D1 0002"
	$"D100 02D1 0002 D100 02D1 0002 D100 02D1"
	$"0002 D100 02D1 0002 D100 02D1 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 02D1 0002"
	$"D100 02D1 0002 D100 02D1 0006 0000 D6FF"
	$"FD00 02D1 0002 D100 02D1 0002 D100 02D1"
	$"0002 D100 02D1 0002 D100 02D1 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 02D1 0002"
	$"D100 02D1 0002 D100 02D1 0002 D100 02D1"
	$"0002 D100 02D1 0002 D100 2AFE 0000 F0FE"
	$"000E 1002 0200 20F0 F1F8 03F9 0000 4200"
	$"40FE 0005 4200 0001 83F8 FD00 0501 0010"
	$"0000 82FA 0028 FF00 0101 08FD 00FF 0209"
	$"0061 0908 1000 4100 0042 FC00 0502 0000"
	$"0200 40FD 0005 0100 1000 0080 FA00 2DFF"
	$"0027 0100 E3C4 4BB0 F2C7 0021 0908 2000"
	$"4161 C042 58C4 4717 38C7 1101 C700 40E2"
	$"2387 00E3 8028 4471 C62C FB00 2DFF 00FF"
	$"0125 1224 4C11 1322 0021 0908 6000 4192"
	$"2042 6444 4898 4442 1102 2200 4112 2448"
	$"8111 0028 4488 8232 FB00 2DFF 00FF 0125"
	$"1224 4811 1222 0021 0908 1000 4112 2042"
	$"4444 4890 4042 1102 2200 4111 43C8 00F1"
	$"0044 4480 8222 FB00 2DFF 00FF 0125 1224"
	$"4811 1222 0020 F8F8 0800 4113 E042 4442"
	$"8F90 3842 1102 2200 41F0 8447 0111 0044"
	$"4470 8222 FB00 2DFF 00FF 0107 1224 4811"
	$"1222 0020 FE08 1A00 4112 0042 4442 8810"
	$"0442 1102 2200 4101 4440 8111 00FE 4408"
	$"8222 FB00 2DFF 0027 0109 1224 4811 1222"
	$"0020 1011 1000 4112 2042 4441 0890 4442"
	$"1102 2200 4112 2448 8111 0082 4C88 8222"
	$"FB00 2CFE 0008 F0E3 C3C8 10F2 2180 20FE"
	$"E01A 8041 11C0 3C44 4107 1038 418F 01C2"
	$"0040 E223 C700 F0C0 8234 7062 22FB 0012"
	$"FD00 0402 0040 0010 FB00 0080 F700 0001"
	$"EC00 12FD 0004 0204 4001 10FC 0000 01F6"
	$"0000 11EC 000D FC00 0303 8000 E0F0 0000"
	$"0EEC 0002 D100 02D1 0002 D100 02D1 0002"
	$"D100 02D1 0002 D100 02D1 0002 D100 02D1"
	$"0002 D100 02D1 0002 D100 02D1 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 02D1 0012"
	$"F300 041F 0202 0040 FD00 0004 FC00 0008"
	$"EF00 13F3 0009 1082 0200 4000 0007 8004"
	$"FC00 0008 EF00 16F3 0010 1082 2238 E1C3"
	$"8B08 444E 1C44 70E0 3879 10F0 0016 F300"
	$"1010 8124 4442 244C 93A4 4422 4489 1044"
	$"8910 F000 16F3 0010 1F01 543C 4204 4894"
	$"A444 2228 7900 4489 10F0 0016 F300 1014"
	$"0154 4441 C448 94A4 443E 1088 E07C 8910"
	$"F000 16F3 0010 1200 8844 4024 4893 C444"
	$"2028 8810 4089 10F0 0016 F300 1011 0088"
	$"4442 2448 8804 C422 4489 1044 8930 F000"
	$"16F3 0010 1090 883C 31C3 8887 0343 1C44"
	$"78E2 3878 D0F0 0002 D100 02D1 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 02D1 0002"
	$"D100 02D1 0002 D100 02D1 0002 D100 02D1"
	$"0002 D100 02D1 0002 D100 02D1 0002 D100"
	$"02D1 0002 D100 02D1 0002 D100 02D1 0002"
	$"D100 02D1 0002 D100 02D1 0002 D100 02D1"
	$"0002 D100 02D1 00FF"
};

resource 'PICT' (-4081) {
	492,
	{0, 0, 32, 32},
	$"0011 02FF 0C00 FFFF FFFF 0000 0000 0000"
	$"0000 0020 0000 0020 0000 0000 0000 0001"
	$"000A 0000 0000 0020 0020 0098 8020 0000"
	$"0000 0020 0020 0000 0000 0000 0000 0048"
	$"0000 0048 0000 0000 0008 0001 0008 0000"
	$"0000 0195 A4E0 0000 0000 0000 04EC 0000"
	$"0003 0000 FFFF FFFF FFFF 0001 DDDD DDDD"
	$"DDDD 0002 FFFF FFFF 0000 00FF 0000 0000"
	$"0000 0000 0000 0020 0020 0000 0000 0020"
	$"0020 0000 02E1 0002 E100 02E1 0002 E100"
	$"02E1 0002 E100 02E1 0006 EC00 FCFF FB00"
	$"0AFC 00F1 FFFC 0200 FFFC 000D FC00 00FF"
	$"F202 FCFF 0102 FFFD 0018 FC00 07FF 02FF"
	$"FF02 FFFF 02FA FF01 02FF FE01 02FF 02FF"
	$"FD00 1AFC 0008 FF02 FFFF 02FF FF02 FFFC"
	$"0002 FF02 FFFE 0102 FF02 FFFD 0018 FC00"
	$"08FF 02FF FF02 FFFF 02FF FC00 01FF 02FC"
	$"FF01 02FF FD00 16FC 0008 FF02 FFFF 02FF"
	$"FF02 FFFB 0000 FFFC 0200 FFFC 0012 FC00"
	$"08FF 02FF FF02 FFFF 02FF FA00 FCFF FB00"
	$"06FC 00F8 FFEF 0002 E100 02E1 FF08 0100"
	$"FFE5 0101 FF00 0701 0000 E5FF FF00 08EB"
	$"0002 FF01 FFFA 0008 EB00 02FF 01FF FA00"
	$"08EB 0002 FF01 FFFA 0008 EB00 02FF 01FF"
	$"FA00 06EC 00FC FFFB 000A EC00 00FF FE01"
	$"00FF FB00 0AEC 0000 FFFE 0100 FFFB 0006"
	$"EC00 FCFF FB00 0AEC 0004 FF01 FF01 FFFB"
	$"0012 0200 FF00 EFFF 0401 01FF 0101 FEFF"
	$"0200 FF00 0CFE 00EE 0102 FF00 FFFB 0100"
	$"000E 0200 FF00 EEFF FE00 FDFF 0200 FF00"
	$"00FF"
};
