/*
 * wconfig.c
 *
 * Copyright 1995,1996 by the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * Export of this software from the United States of America may
 *   require a specific license from the United States Government.
 *   It is the responsibility of any person or organization contemplating
 *   export to obtain such a license before exporting.
 *
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 *
 *
 * Program to take the place of the configure shell script under DOS.
 * The makefile.in files are constructed in such a way that all this
 * program needs to do is uncomment lines beginning ##DOS by removing the
 * first 5 characters of the line.  This will allow lines like:
 * ##DOS!include windows.in to become: !include windows.in
 *
 * We also turn any line beginning with '@' into a blank line.
 *
 * If a config directory is specified, then the output will be start with
 * config\pre.in, then the filtered stdin text, and will end with
 * config\post.in.
 *
 * Syntax: wconfig [config_directory] <input_file >output_file
 *
 */
#include <stdio.h>
#include <string.h>

static int copy_file (char *path, char *fname);

struct ignore {
  char *match;
  int   len;
  int   flags;
};

#ifdef _WIN32
#define SYSTYPE "win32"
#else
#ifdef _MSDOS
#define SYSTYPE "msdos"
#else
#ifdef _unix
#define SYSTYPE "unix"
#else
#define SYSTYPE "unknown"
#endif
#endif
#endif

#define FLAGS_DLL    0x0001U  /* only when compiling a DLL-making file */
#define FLAGS_NODLL  0x0002U  /* only when compiling a non-DLL making file */
#define FLAGS_ALWAYS 0xffffU

int strip_flags = FLAGS_NODLL;  /* default to standard build */
		
struct ignore ignore_list[] = {
  { "DOS##",        5, FLAGS_ALWAYS },
  { "DOS",          3, FLAGS_ALWAYS },
#ifdef _MSDOS
  { "WIN16##",      7, FLAGS_ALWAYS },
  { "WIN16DLL##",  10, FLAGS_DLL },
  { "WIN16STD##",  10, FLAGS_NODLL },
#endif
#ifdef _WIN32
  { "WIN32##",      7, FLAGS_ALWAYS },
  { "WIN32DLL##",  10, FLAGS_DLL },
  { "WIN32STD##",  10, FLAGS_NODLL },
#endif
  { NULL,           0, 0 }
};

int
main(int argc, char *argv[])
{
  char *filepath = NULL;
  
#if 0
  fprintf(stderr, "Configured for %s\n", SYSTYPE);
#endif
  
  switch (argc) {
  case 3:
    if (strcmp(argv[1], "-dll") == 0)
      strip_flags = FLAGS_DLL;
    filepath = argv[2];
    break;

  case 2:
    filepath = argv[1];
    break;

  case 1:
    break;

  default:
    fprintf(stderr, "Usage:  wconfig [-dll] [config-dir] < in > out\n");
    exit(1);
  }

  if (filepath != NULL)                         /* Config directory given */
    copy_file (filepath, "\\windows.in");       /* Send out prefix */

  copy_file("", "-");
  
  if (filepath != NULL)                         /* Config directory given */
    copy_file (filepath, "\\win-post.in");      /* Send out postfix */
  
  return 0;
}

int
is_ignored_prefix(char *p, int len)
{
  struct ignore *i;

  i = ignore_list;

  while (i->match != NULL) {
    if ((strip_flags & i->flags) && strncmp(i->match, p, i->len) == 0)
      return i->len;
    i++;
  }

  return 0;
}

/*
 * 
 * Copy_file
 * 
 * Copies file 'path\fname' to stdout.
 * 
 */
static int
copy_file (char *path, char *fname)
{
    FILE *fin;
    char buf[1024];
    char *ptr;
    char **cpp;
    
    int len;

    if (strcmp(fname, "-") == 0) {
	    fin = stdin;
    } else {
	    strcpy (buf, path);              /* Build up name to open */
	    strcat (buf, fname);
	    fin = fopen (buf, "r");                     /* File to read */
	    if (fin == NULL)
		    return 1;
    }
    

    while (fgets (buf, sizeof(buf), fin) != NULL) { /* Copy file over */
	    if (buf[0] == '@') {
		    fputs("\n", stdout);
		    continue;
	    }
	    if (buf[0] != '#' || buf[1] != '#') {
		    fputs(buf, stdout);
		    continue;
	    }
	    ptr = buf;
	    if (len = is_ignored_prefix(ptr + 2, strlen(ptr + 2)))
		    ptr += 2+len;
	    fputs(ptr, stdout);
    }

    fclose (fin);

    return 0;
}
