/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include <stdio.h>
#include "general.h"

#include "bbuf.h"
#include "cbio.h"
#include "new.h"
#include "util.h"

static int inputfd = 0;         /* standard input */
static int outputfd = 1;        /* standard output */
static int errorfd = 2;         /* standard error */

user_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(outputfd,bb));
}

struct bbuf *user_in()
{
    return(cbfdread(inputfd));
}

error_out(bb)
struct bbuf *bb;
{
    return(cbfdwrite(errorfd,bb));
}

main (argc, argv)
int argc;
char **argv;
{
    int ret = NOTOK;
    struct cbstruct iocbs;
    char **template = NULLVP;
    char **user = NULLVP;
    
    /* check args, display help */

    if (pem_init(argc, argv, &template) != OK) {
        (void) fprintf(stderr, "%s: initialization failure\n", argv[0]);
        goto cleanup;
    }

    if (argc < 2 || !strcasecmp (argv[1], "help") || template == NULLVP) {
        (void) fprintf(stderr, "TIS/PEM %s\n%s\n\n", VERSION, COPYRIGHT);
        (void) fprintf(stderr, "Usage: %s <tag> value [...]\n", myname);
	goto cleanup;
    }

    /* Set up cb for pem_parse */

    BZERO(&iocbs, sizeof (struct cbstruct));
    iocbs.in_user = user_in;
    iocbs.out_user = user_out;
    iocbs.out_errs = error_out;

    while ((user = get_tvt_user(template)) != NULLVP) {
	if ((ret=pem_disp(user, &iocbs)) != OK) {
	    (void) fprintf(stderr, "%s: Unable to display user\n", myname);
	    goto cleanup;
	}
	FREE_AV(user);
    }

 cleanup:

    return ret;
}
