/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "util.h"

decode_int(eint, dint, rlength)
struct bbuf *eint;
int *dint;
int *rlength;
{
    struct bbuf *bb = NULLBB;
    int length;
    int llen;
    int r = OK;
	
    if (eint == (struct bbuf *)0) {
	return(NOTOK);
    }
    if (dint == (int *)0) {
	return(NOTOK);
    }
    if (rlength == (int *)0) {
	return(NOTOK);
    }

    if (eint->length < 2) {
	return(ASN1_ERR01);
    }
    if (eint->data[0] != (CLASS_UNIV|FORM_PRIM|PRIM_INT)) {
	return(ASN1_ERR02);
    }

    r = decode_len(&(eint->data[1]), eint->length-1, &length, &llen);
    if (r != OK) return(r);
    *rlength = 1 + llen + length;

    if ((bb = alloc_bbuf()) == NULLBB)
	return(NOTOK);

    bb->data = &eint->data[1+llen];
    bb->length = length;

    if (prim2int(bb, dint) != OK) {
	r = ASN1_ERR21;
	goto cleanup;
    }

 cleanup:

    if (bb != NULLBB) {
	bb->data = (unsigned char *)0;
	(void) free_bbuf(bb);
    }

    return(r);
}
