/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "cert.h"
#include "util.h"

struct certificate *dup_cert(cert)
struct certificate *cert;
{
    struct certificate *p = NULL_CERT;

    if (cert == NULL_CERT) {
	return(NULL_CERT);
    }

    if (alloc_cert(&p) == NOTOK)
        return(NULL_CERT);

    p -> status = cert -> status;

    if (cert->tobesigned != NULL_TOBESIGNED)
	p->tobesigned = dup_tobesigned_cert(cert->tobesigned);
    if (cert->sig_alg != NULL_ALGID)
	p->sig_alg = dup_algid(cert->sig_alg);
    if (cert->sig != NULLBB)
	p->sig = dup_bbuf(cert->sig);

    return(p);
}

struct tobesigned *dup_tobesigned_cert(s)
struct tobesigned *s;
{
    struct tobesigned *d;

    if (s == (struct tobesigned *)0) {
	return((struct tobesigned *)0);
    }

    if ((d = alloc_tobesigned_cert()) == (struct tobesigned *)0)
	return(d);

    d->version = s->version;

    if (s->serial != NULLBB)
    	d->serial = dup_bbuf(s->serial);

    if (s->sig_alg != NULL_ALGID)
	d->sig_alg = dup_algid(s->sig_alg);

    if (s->issuer != NULLBB)
	d->issuer = dup_bbuf(s->issuer);

    if (s->valid != NULL_VALID)
	d->valid = dup_valid_cert(s->valid);

    if (s->subject != NULLBB)
	d->subject = dup_bbuf(s->subject);

    if (s->public != NULLBB)
	d->public = dup_bbuf(s->public);

    return(d);
}

struct valid *dup_valid_cert(s)
struct valid *s;
{
    struct valid *d= NULL_VALID;

    if (s != NULL_VALID && (d = alloc_valid_cert()) != NULL_VALID) {
        d->begin = s->begin;
        d->end = s->end;
    }

    return(d);
}
