/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "cert.h"
#include "util.h"

subject_cert(ecert, subject, mode)
struct bbuf **ecert;
struct bbuf **subject;
int mode;
{
    struct certificate *cert= NULL_CERT;

    if (ecert == (struct bbuf **)0) {
        return(NOTOK);
    }
    if (subject == (struct bbuf **)0) {
	return(NOTOK);
    }
    if (decode_cert(*ecert, &cert) != OK) {
        return(NOTOK);
    }

    switch (mode) {
    case READ:
	if (cert -> tobesigned == (struct tobesigned *)0) {
	    return(NOTOK);
	}

	if (*subject != NULLBB) {
	    (void) free_bbuf(*subject);
	    *subject = NULLBB;
	}

	if ((cert->tobesigned->subject != NULLBB) &&
	    ((*subject = dup_bbuf(cert->tobesigned->subject)) == NULLBB))
	    return(NOTOK);
	break;

    case WRITE:
	if (cert -> tobesigned == (struct tobesigned *)0) {
	    if ((cert -> tobesigned = alloc_tobesigned_cert())
		== (struct tobesigned *)0)
		return(NOTOK);
	}

	if (cert->tobesigned->subject != NULLBB) {
	    (void) free_bbuf(cert->tobesigned->subject);
	    cert->tobesigned->subject = NULLBB;
	}

	if ((*subject != NULLBB) &&
	    ((cert->tobesigned->subject=dup_bbuf(*subject)) == NULLBB))
	    return(NOTOK);

        if (encode_cert(cert, ecert) != OK) {
            return(NOTOK);
        }
 
	break;

    default:
	return(NOTOK);
	/* NOTREACHED */
    }

    return(OK);
}
