/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * decode_crl.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "crl.h"
#include "util.h"

static int _decode_rtbs(), _decode_rcl(), _decode_rcl_entry();

int decode_crl(ecrl,dcrl)
struct bbuf *ecrl;
struct crl **dcrl;
{
    struct bbuf *ptr, *bbufs= NULLBB;
    int dummy= 0, ret= NOTOK;

    /* CHECK PARAMETERS */
    if (ecrl == NULLBB) 
	return(NOTOK);

    if (dcrl == (struct crl **)0) 
	return(NOTOK);

    FREE_CRL(*dcrl);

    /* ALLOCATE MEMORY FOR DECODED CRL */
    if (alloc_crl(dcrl) != OK)
	return(NOTOK);

    (*dcrl)->status = ecrl->status;

    if (ecrl->length) {
        /* Check for valid tag */
        if ((ecrl->data[0] & TAG_MASK) != CONS_SEQ
	    || asn_parse(ecrl, &bbufs) != OK) 
            goto cleanup;

        /* DECODE CRLTOBESIGNED */
        if ((ptr = bbufs) == NULLBB) {
	    ret = OK;
	    goto cleanup;
        }
        if (ptr->length && _decode_rtbs(ptr, &((*dcrl)->tobesigned)) != OK)
	    goto cleanup;

        /* DECODE SIGNATURE ALGORITHM */
        if ((ptr = ptr->next) == NULLBB) {
	    ret = OK;
	    goto cleanup;
        }
        if (ptr->length
	    && decode_algid(ptr, &((*dcrl)->sig_alg), &dummy) != OK)
	    goto cleanup;

        /* DECODE SIGNATURE */
        if ((ptr = ptr->next) == NULLBB) {
	    ret = OK;
	    goto cleanup;
        }
        if (ptr->length && decode_bits(ptr, &((*dcrl)->sig), &dummy) != OK)
	    goto cleanup;
    }

    ret = OK;

 cleanup:

    FREE_BBUFS(bbufs);
    if (ret != OK) 
	FREE_CRL(*dcrl);

    return(ret);
}

/*****************************************************************************/

static int _decode_rtbs(etbs, dtbs)
struct bbuf *etbs;
struct crltobesigned **dtbs;
{
    int dummy;
    struct bbuf *ptr, *bbufs = NULLBB;
    int ret = NOTOK;

    /* Check for valid tag */
    if ((etbs->data[0] & TAG_MASK) != CONS_SEQ
	|| asn_parse(etbs, &bbufs) != OK) 
        goto cleanup;

    /* ALLOCATE CRL TOBESIGNED */
    *dtbs = alloc_crltobesigned();
	
    /* DECODE SIGNATURE ALGORITHM */
    if ((ptr = bbufs) == NULLBB) {
	ret = OK;
	goto cleanup;
    }

    if (ptr->length && decode_algid(ptr, &((*dtbs)->sig_alg), &dummy) != OK)
	goto cleanup;

    /* DECODE ISSUER DNAME */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length > 2 && ((*dtbs)->issuer=dup_bbuf(ptr)) == NULLBB) 
        goto cleanup;

    /* DECODE LASTUPDATE */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && decode_utct(ptr, &((*dtbs)->lastupdate), &dummy) != OK)
	goto cleanup;

    /* DECODE NEXTUPDATE */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && decode_utct(ptr, &((*dtbs)->nextupdate), &dummy) != OK)
	goto cleanup;

    /* DECODE REVOKED CERTIFICATE LIST */
    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && _decode_rcl(ptr, &((*dtbs)->rcl)) != OK)
	goto cleanup;

    ret = OK;

 cleanup:

    FREE_BBUFS(bbufs);
    if (ret != OK) 
	FREE_CRLTOBESIGNED(*dtbs);

    return(ret);
}

/*****************************************************************************/

static int _decode_rcl(ercl, drcl)
struct bbuf *ercl;
struct rcl_entry **drcl;
{
    int ret= NOTOK;
    struct bbuf *ptr, *bbufs = NULLBB;
    struct rcl_entry *trcl= NULL_RCL_ENTRY;

    /* Check for valid tag */
    if ((ercl->data[0] & TAG_MASK) != CONS_SEQ
	|| asn_parse(ercl, &bbufs) != OK) 
        goto cleanup;

    if ((ret = _rclinit(drcl)) != OK)
	goto cleanup;
	
    for (ptr=bbufs; ptr!=NULLBB; ptr=ptr->next) {
	if (_decode_rcl_entry(ptr, &trcl) != OK)
	    goto cleanup;
	if (_rclappend(*drcl,trcl) != OK)
	    goto cleanup;
	else 
	    (void) _rclnext(*drcl);
    }

    if (_rclend(drcl) != OK)
	goto cleanup;

    ret = OK;

 cleanup:

    FREE_BBUFS(bbufs);
    FREE_RCL(trcl);
    if (ret != OK)
	FREE_RCL(*drcl);

    return(ret);
}

/*****************************************************************************/

static int _decode_rcl_entry(ercl, drcl)
struct bbuf *ercl;
struct rcl_entry **drcl;
{
    struct bbuf *ptr, *bbufs = NULLBB;
    int dummy, ret = NOTOK;

    /* Check for valid tag */
    if ((ercl->data[0] & TAG_MASK) != CONS_SEQ
	|| asn_parse(ercl, &bbufs) != OK) 
        goto cleanup;

    /* DECODE REVOKED CERTIFICATE LIST ENTRY */
    *drcl = alloc_rcl_entry();
    if ((ptr = bbufs) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && decode_ints(ptr, &(*drcl)->serial, &dummy) != OK)
	goto cleanup;

    if ((ptr = ptr->next) == NULLBB) {
	ret = OK;
	goto cleanup;
    }
    if (ptr->length && decode_utct(ptr, &(*drcl)->date, &dummy) != OK)
	goto cleanup;

    ret = OK;

 cleanup:

    FREE_BBUFS(bbufs);
    if (ret != OK)
	FREE_RCL(*drcl);

    return(ret);
}

/*****************************************************************************/
