/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "algid.h"
#include "bbuf.h"
#include "crl.h"
#include "crypto.h"
#include "dname.h"
#include "util.h"

int validate_crl (crl, issuer_cert)
struct bbuf		*crl;
struct bbuf		*issuer_cert;
{
    long		last= 0, next= 0, current= TIME();
    int			ret = OK, slen;

    struct bbuf		*issuer_key= NULLBB;
    struct bbuf		*issuer = NULLBB;

    struct crltobesigned *tbs = NULL_CRLTOBESIGNED;
    struct bbuf		*etbs = NULLBB;

    struct bbuf		*mic = NULLBB;
    struct bbuf		*emic = NULLBB;
    struct bbuf		*sig = NULLBB;

    struct algid	*i_sig_aid = NULL_ALGID;
    struct algid	*o_sig_aid = NULL_ALGID;
    struct algid	*mic_aid = NULL_ALGID;

    /* check to see that we got a pointer to a crl */
    if (crl == NULLBB) 
	return(EINVAL);

    /* NULL issuer_cert is ok */

    /* Validation testing begins here.  It is invalid for this routine
     * to return until all tests have been completed.
     */

    /* get and check the CRL validity period */
    if (valid_crl(&crl, &last, &next, READ) != OK) 
        crl->status |= BNOVAL;
    else {
        crl->status &= ~BNOVAL;
	if (current <= last || current > next) 
	    crl->status |= BBADVAL;
	else
	    crl->status &= ~BBADVAL;
    }

    /* we set BNOSIG now instead of for each goto below */
    crl->status |= BNOSIG;

    /* get the signature from the signed crl */
    sig = alloc_bbuf();

    slen = sig->length;
    if (sig_crl(&crl, &sig->data, &slen, READ) != OK) {
	sig->length = (short)slen;
        goto skipsig;
    }
    sig->length = (short)slen;
    crl->status &= ~BNOSIG;

    /* we set BNOISS now instead of for each goto below */
    crl->status |= BNOISS;

    if (issuer_cert == NULLBB) 
	goto skipsig;

    /* get the issuer's public key */
    if (key_cert(&issuer_cert, &issuer_key, READ) != OK) 
        goto skipsig;

    crl->status &= ~BNOISS;

    /* we set BBADSIG now instead of for each goto below */
    crl->status |= BBADSIG;

    /* get the inner & outer signature algorithm identifier */
    if ((sig_alg_crl(&crl, &o_sig_aid, OUTER, READ) != OK)
	|| (sig_alg_crl(&crl, &i_sig_aid, INNER, READ) != OK)) 
	goto skipsig;

    /* TBD: check parameters too?? */

    if (i_sig_aid->alg != o_sig_aid->alg) 
	goto skipsig;

    mic_aid = alloc_algid();
    mic_aid->alg = i_sig_aid->alg & HASH_MASK;

    /* get the tobesigned field */
    if (tobesigned_crl(&crl, &tbs, READ) != OK || tbs == NULL_CRLTOBESIGNED) 
        goto skipsig;

    /* make sure issuer name in TBS is DER */
    if (issuer_crl(&crl, &issuer, READ) == OK && issuer != NULLBB
	&& (tbs->issuer = der_dn(issuer)) != NULLBB)
	crl->status &= ~BNOIDN;
    else
	crl->status |= BNOIDN;

    /* encode the crl.tobesigned field */
    if (encode_rtbs(tbs, &etbs) != OK) 
        goto skipsig;

    /* generate a mic for the encoded tobesigned field */
    if (gen_mic(mic_aid->alg, NULLBB, etbs, &mic) != OK) 
        goto skipsig;

    if (encode_mic(mic, mic_aid, &emic) != OK) 
        goto skipsig;

    if (set_key(issuer_key) != OK) 
        goto skipsig;

    if (verify(sig, emic) != OK) 
	goto skipsig;

    crl->status &= ~BBADSIG;

 skipsig:

    /* turn off bits we don't care about
     * BBADCHN is set/unset elsewhere to indicate issuer certificate is bad
     */
    crl->status &= BBADCHN|BNOIDN|BBADSIG|BNOISS|BNOSIG|BBADVAL|BNOVAL;

    FREE_BBUF(issuer_key);
    FREE_BBUF(issuer);

    FREE_CRLTOBESIGNED(tbs);
    FREE_BBUF(etbs);

    FREE_BBUF(mic);
    FREE_BBUF(emic);
    FREE_BBUF(sig);

    FREE_ALGID(i_sig_aid);
    FREE_ALGID(o_sig_aid);
    FREE_ALGID(mic_aid);

    return(ret);
}
