/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include <stdio.h>
#include "general.h"

#include "crypto.h"
#include "cryptocb.h"
#include "bbuf.h"
#include "util.h"

int fencipher(fplain, fcipher)
FILE *fplain;
FILE *fcipher;
{
    int r;
    struct algent *ae = NULL_ALGENT;
    struct ccbent *ce = NULL_CCBENT;

    /* DOUBLE-CHECK PARAMETERS */
    if (fplain == (FILE *)0 || fcipher == (FILE *)0) 
	return(NOTOK);

    /* CHECK THAT KEY IS SET */
    if (curdata == NULLBB) 
	return(NOTOK);

    /* GET ALGORITHM ENTRY FROM TABLE */
    if ((ae = getalgcode(algorithms, curalg, IK|DEK)) == NULL_ALGENT) 
        return(NOTOK);

    /* GET CALLBACK TABLE ENTRY */
    if ((ce = getccbcode(callbacks, ae->code)) == NULL_CCBENT) 
	return(NOTOK);

    if (ce->fencipher_X == NULL_FUNC) 
        return(NOTOK);

    /* PERFORM CRYPTO */
    (void) fseek(fplain, 0L, 0);
    r = (*(ce->fencipher_X))(fplain, fcipher);

    return(r);
}
