/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 *  deciph_des.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "crypto.h"
#include "bbuf.h"
#include "util.h"

#include "./des.h"

/*****************************************************************************/

int decipher_des(in, out)
struct bbuf *in;
struct bbuf **out;
{
    int r;
    struct bbuf *key = NULLBB;

    /* DOUBLE-CHECK PARAMETERS */
    if (in == NULLBB || out == (struct bbuf **)0) 
	return(NOTOK);

    /* DECODE DES KEY DATA */
    if ((r = decode_deskeydata(curdata, &key)) != OK)
	return(NOTOK);

    /* SET DES KEY FOR DECRYPTION */
    if (!setdeskey(CHECK, DECRYPT, key->data)) {
	r = NOTOK;
	goto cleanup;
    }

    /* DECRYPT WITH SPECIFIED MODE OF OPERATION */
    switch(curalg) {
    case DES_CBC:
	if ((r = decipher_descbc(in, out)) != OK)
	    goto cleanup;
	break;

    case DES_ECB:
    case DES_EDE:
	r = NOTOK;
	goto cleanup;

    default:
	r = NOTOK;
	goto cleanup;
    }

    r = OK;

cleanup:

    FREE_BBUF(key);

    return(r);
}

/****************************************************************************/

static int decipher_descbc(in, out)
struct bbuf *in;
struct bbuf **out;
{
    register int i;			/* in buffer index */
    unsigned char chain[DESBLKLEN];	/* intermediate block for chaining */
    struct bbuf *iv = NULLBB;		/* IV */
    int padlen;
    int inlen, outlen;
    unsigned char *indata, *outdata;

    if (in->length == 0 || (in->length % DESBLKLEN) != 0) 
	return(NOTOK);

    inlen = in->length;
    indata = in->data;

    *out = alloc_bbuf();
    (*out)->length = in->length;
    (*out) -> data = alloc_uchar((*out) -> length);
    outlen = (*out)->length;
    outdata = (*out)->data;

    if (decode_deskeyparms(curparms, &iv) != OK) {
	FREE_BBUF(*out);
	return(NOTOK);
    }
    BCOPY(iv->data, chain, DESBLKLEN);
    FREE_BBUF(iv);

    for (i=0; i<inlen; i+=DESBLKLEN) {
	(void) cryptodes(indata+i, outdata+i);
	(void) bxor(outdata+i, chain, outdata+i, DESBLKLEN);
	BCOPY(indata+i, chain, DESBLKLEN);
    }

    padlen = outdata[inlen-1];
    if (padlen < 1 || padlen > DESBLKLEN) {
	FREE_BBUF(*out);
	return(NOTOK);
    }
    if (((*out)->data =
	(unsigned char *)realloc((char *)(*out)->data,(unsigned)outlen-padlen)) 
	    == NULLUCP) {
	FREE_BBUF(*out);
	return(NOTOK);
    }
    (*out)->length = outlen-padlen;

    return(OK);
}

/****************************************************************************/
