/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/****************************************************************************
 * str2deskey.c
 ****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "key.h"
#include "util.h"

#include "./des.h"

#define PADCHAR 0xfe

int str2deskey(str, key)
char *str;
struct key **key;
{ 
    int r = NOTOK;
    struct bbuf *iv = NULLBB;
    struct bbuf *key2 = NULLBB;
    struct bbuf *hash = NULLBB;
    struct bbuf pw;

    if (str== NULLCP || key == (struct key **)0)
	goto cleanup;

    FREE_KEY(*key);

    /* Create hash of password */

    pw.data = (unsigned char *) str;
    pw.length = strlen (pw.data);

    if (gen_md5(NULL_KEY, &pw, &hash) != OK)
	goto cleanup;

    /* first 8 bytes of hash --> key, second 8 bytes --> iv */

    iv = alloc_bbuf();
    iv->data = alloc_uchar(DESBLKLEN);
    iv->length = DESBLKLEN;
    BCOPY(hash->data, iv->data, DESBLKLEN);
    
    key2 = alloc_bbuf();
    key2->data = alloc_uchar(DESKEYLEN);
    key2->length = DESKEYLEN;
    BCOPY(hash->data+DESBLKLEN, key2->data, DESBLKLEN);
    (void) setparity(key2);

    /* fill in key information */

    (void) alloc_key(key);
    (*key)->algid = alloc_algid();

    (*key)->algid->alg = DES_CBC;
    if ((r = encode_deskeyparms(iv, &((*key)->algid->parms))) != OK)
	goto cleanup;
    if ((r = encode_deskeydata(key2, &((*key)->data))) != OK)
	goto cleanup;

    r = OK;

cleanup:

    FREE_BBUF(hash);
    FREE_BBUF(iv);
    FREE_BBUF(key2);

    if (r != OK)
	FREE_KEY(*key);

    return(r);
}

/****************************************************************************/
