/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*****************************************************************************
 * dekdata2bbuf.c
 *****************************************************************************/

#include "config.h"
#include "general.h"

#include "bbuf.h"
#include "crypto.h"
#include "cryptocb.h"
#include "key.h"
#include "util.h"

int dekdata2bbuf(edek, dekbb)
struct bbuf *edek;
struct bbuf **dekbb;
{
    int ret = NOTOK;
    struct key *dek = NULL_KEY;
    struct ccbent *ce = NULL_CCBENT;

    if (edek == NULLBB || dekbb == (struct bbuf **)0)
	goto cleanup;

    if (decode_key(edek, &dek) != OK) 
	goto cleanup;

    if (dek->algid == NULL_ALGID) 
	return(NOTOK);

    /* GET ALGORITHM TABLE ENTRY */
    if ((ce = getccbcode(callbacks, dek->algid->alg)) == NULL_CCBENT) 
	goto cleanup;

    if (ce->Xdata2bbuf == NULL_FUNC)
	goto cleanup;

    /* CONVERT THE KEY DATA TO A BBUF */
    ret = (*(ce->Xdata2bbuf))(dek, dekbb);

 cleanup:

    FREE_KEY(dek);
    return(ret);
}

/*****************************************************************************/
