/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/


#include "config.h"
#include "general.h"

#include "asn1.h"
#include "bbuf.h"
#include "dname.h"
#include "oid.h"
#include "util.h"
#include "x500.h"

struct bbuf *der_dn(dn)
struct bbuf *dn;
{
    struct bbuf		*rdns= NULLBB, *avas= NULLBB, 
			*rptr= NULLBB, *retdn= NULLBB;
    int 		status = NOTOK;

    if (dn == NULLBB) 
        goto cleanup;

    if (rdns_dname(dn, &rdns, READ) != OK) 
        goto cleanup;

    for (rptr=rdns; rptr!=NULLBB; rptr=rptr->next) {
        if ((avas_rdn(rptr, &avas, READ) != OK) || (ava_sort(&avas) != OK)) 
            goto cleanup;

        if (ava_sort(&avas) != OK) 
            goto cleanup;

        if (avas_rdn(rptr, &avas, WRITE) != OK) 
            goto cleanup;
    }

    retdn=alloc_bbuf();
    if (rdns_dname(retdn, &rdns, WRITE) != OK)
        goto cleanup;

    status = OK;

 cleanup:
    FREE_BBUFS(rdns);
    if (status != OK)
	FREE_BBUF(retdn);

    return(retdn);
}
