/*
Copyright (C) 1992,1993,1994 Trusted Information Systems, Inc.

Export of this software from the United States of America or
Canada requires a specific license from the United States
Government.  This version of this software is not suitable for
export.

WITHIN THAT CONSTRAINT, the full text of the license agreement
that specifies the conditions under which this software may be
used is published in the file license.txt in the same directory
as that containing the TIS/PEM source.

Trusted Information Systems makes no representation about the
suitability of this software for any purpose.  It is provided
"as is" without express or implied warranty.
*/

/*
 * bbufcmp(bbuf1, bbuf2) 
 *
 * RETURNS
 *   zero or non-zero as to whether bbuf1 is equal or non-equal to bbuf2.
 *
 */


#include "config.h"

#include "bbuf.h"

bbufcmp(bbuf1, bbuf2)
struct bbuf *bbuf1, *bbuf2;
{
    if (bbuf1 == NULLBB && bbuf2 == NULLBB)
	return(0);

    if (bbuf1 == NULLBB || bbuf2 == NULLBB)
	return(1);

    if (bbuf1 -> length != bbuf2 -> length)
	return(1);

    return(BCMP(bbuf1->data, bbuf2->data, bbuf1->length));
}
