COMMENT |
============================================================================
  
  MDC.ASM v2.2.0, Message Digest 5 Cipher Transform (20 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl
  
  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General PUBLIC License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General PUBLIC License for more details.

  You should have received a copy of the GNU General PUBLIC License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
============================================================================
| Note: source has been assembled successfully with MASM 5.0 and TASM 3.2

; - MDC Assembly Options (Conditional Defines): ----------------------------

__LOCALVARS         EQU         1   ; Locals on stack (otherwise in cs:)
__NOPROCS           EQU         1   ; Use macros not procs for F-I funcs.
__FASTERMETHOD      EQU         1   ; Optimized calculations for F and G(?)
__OOP               EQU         1   ; Use OOP form of mdctransform()

; __FASTERMETHOD is based on recommendations in SHA implementation

                    DOSSEG
                    .MODEL      LARGE
                    .386

                    .CODE

; - MDC Unconditional Defines: ---------------------------------------------

__NOSTOR            EQU         1   ; Copy A,B,C,D regs. as block (faster?)
;;__SAVEEBX         EQU         1   ; Misc. optimization for F and G func(?)
__MISCOPT           EQU         1   ; Misc. optimization for H and I func


A         EQU       <DWORD PTR es: [di]>    ; Chaining variables
B         EQU       <DWORD PTR es: [di+4]>  ;
C         EQU       <DWORD PTR es: [di+8]>  ;
D         EQU       <DWORD PTR es: [di+12]> ;

X         EQU       <DWORD PTR ds: [si]>    ;

                    
; - Miscellaneous macros: --------------------------------------------------

        IFNDEF         __NOSTOR
STOR      MACRO     dest, src
           mov      eax,  src
          IFDEF     __LOCALVARS
            mov     dest, eax
          ELSE        
            mov     cs: dest, eax
          ENDIF       
         ENDM        
       ENDIF       

ADDD     MACRO      i, j      ; eax=j; i=i+eax
           mov      eax, j
           add      i, eax
         ENDM        

ADDCONST MACRO      t            ; add MagucConstant[step t] to eax
           IFDEF __OOP 
             push   es
             push   di           ; if not __MISCOPT or __SAVEEBX, we can use
             les    di,  constbl ; bx register (w/out saving) for improved
             add    di,  t*4     ; speed(?)
             add    eax, DWORD PTR es:[di]
             pop    di
             pop    es
           ELSE
             add    eax, DWORD PTR cs: [magicconstants][t*4]
           ENDIF
         ENDM        

; - Auxiliary function F(x,y,z)=xy v not(x)z -------------------------------

; According to MD5-A specs, we could use add instead of or, however there is                
; no difference in processor speed that it should matter which one is used.

; if __FASTERMETHOD is defined, F(x,y,z)=z xor (x)(y xor z)

; result = eax, x = ebx, y = ecx, z = edx

                    IFDEF          __NOPROCS
F                     MACRO     
                    ELSE        
F                     PROC      NEAR
                    ENDIF       
                    IFDEF          __FASTERMETHOD
                      mov         eax,      ecx
                      xor         eax,      edx
                      and         eax,      ebx
                      xor         eax,      edx
                    ELSE        
                      mov         eax,      ebx
                      and         eax,      ecx
                      IFDEF          __SAVEEBX
                        push        ebx
                      ENDIF       
                      not         ebx
                      and         ebx,      edx
                      or          eax,      ebx
                      IFDEF          __SAVEEBX
                        pop         ebx
                      ENDIF       
                    ENDIF       
                    IFDEF          __NOPROCS
                      ENDM        
                    ELSE        
                      ret         
F                     ENDP      
                    ENDIF       

; -------------------------------------------------------------------------
; FF(a,b,c,d,X[k],s,t) denotes a = b + ((a + F(b,c,d) + X[k] + t) <<< s)
; -------------------------------------------------------------------------
; Actually "t" is the MD5 step: the appropriate constant is added from a
; a table in this implementation.  This allows us to change the constants
; used for MDC encryption (based on the key).

FF                    MACRO     a, b, c, d, X, s, t
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF          __NOPROCS
                        F           
                      ELSE        
                        call        F
                      ENDIF       
                      add         eax,      a
                      add       eax,      X
                      ADDCONST  t
                      rol       eax,  s
                        IFDEF   __SAVEEBX or  __FASTERMETHOD
                          add       eax,  ebx
                        ELSE
                          add       eax,  b
                        ENDIF       
                      mov         a,        eax
                    ENDM        
                    
S11                     EQU     7
S12                     EQU     12
S13                     EQU     17
S14                     EQU     22

; - Auxiliary function G(x,y,z)=xz v y not(z) ------------------------------
                    
                    IFDEF          __NOPROCS
G                     MACRO     
                    ELSE        
G                     PROC      NEAR
                    ENDIF       
                    mov         eax,        ebx
                    and         eax,        edx
                    IFDEF          __SAVEEBX
                      push        edx
                    ENDIF       
                    not         edx
                    and         edx,        ecx
                    or          eax,        edx
                    IFDEF          __SAVEEBX
                      pop         edx
                    ENDIF       
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
G                     ENDP      
                    ENDIF       
; --------------------------------------------------------------------------
; GG(a,b,c,d,X[k],s,t) denotes a = b + ((a + G(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

GG                  MACRO       a, b, c, d, X, s, t
                    mov         ebx,        b
                    mov         ecx,        c
                    mov         edx,        d
                    IFDEF          __NOPROCS
                      G           
                    ELSE        
                      call        G
                    ENDIF       
                    add       eax, a
                    add       eax, X
                    ADDCONST  t
                    rol       eax, s
                    IFDEF          __SAVEEBX
                      add       eax,      ebx
                    ELSE        
                      add       eax, b
                    ENDIF       
                    mov         a,  eax
                  ENDM        

S21               EQU           5
S22               EQU           9
S23               EQU           14
S24               EQU           20

; - Auxiliary function H(x,y,z)=x xor y xor z ------------------------------
                    
                    IFDEF          __NOPROCS
H                      MACRO     
                    ELSE        
H                      PROC      NEAR
                    ENDIF       
                    mov         eax,        ebx
                    xor         eax,        ecx
                    xor         eax,        edx
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
H                      ENDP      
                    ENDIF       

; --------------------------------------------------------------------------
; HH(a,b,c,d,X[k],s,t) denotes a = b + ((a + H(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

HH                    MACRO     a, b, c, d, X, s, t
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF          __NOPROCS
                        H            
                      ELSE        
                        call        H 
                      ENDIF       
                      add         eax,      a
                      add       eax,      X
                      ADDCONST    t
                          rol         eax,      s
                        IFDEF          __MISCOPT
                          add         eax,  ebx
                        ELSE        
                          add         eax,  b
                        ENDIF       
                      mov         a,        eax
                    ENDM        
                    
S31                     EQU     4
S32                     EQU     11
S33                     EQU     16
S34                     EQU     23

; - Auxiliary function I(x,y,z)=y xor (x v not(z)) -------------------------
                    
                    IFDEF          __NOPROCS
I                     MACRO     
                    ELSE        
I                     PROC      NEAR
                    ENDIF       
                    mov         eax,        edx
                    not         eax
                    or          eax,        ebx
                    xor         eax,        ecx
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
I                     ENDP      
                    ENDIF       

; --------------------------------------------------------------------------
; II(a,b,c,d,X[k],s,t) denotes a = b + ((a + I(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

II                  MACRO       a, b, c, d, X, s, t
                    mov         ebx,        b
                    mov         ecx,        c
                    mov         edx,        d
                    IFDEF          __NOPROCS
                      I           
                    ELSE        
                      call        I
                    ENDIF       
                    add         eax,        a
                      add       eax,        X
                      ADDCONST    t
                      rol         eax,        s
                    IFDEF          __MISCOPT
                      add         eax,      ebx
                    ELSE        
                      add         eax,      b
                    ENDIF       
                    mov         a,  eax
                  ENDM        

S41               EQU           6
S42               EQU           10
S43               EQU           15
S44               EQU           21


; - Temporary Registers: ---------------------------------------------------
                    
                    IFNDEF         __LOCALVARS
AA                    LABEL     DWORD
                      DD          (?)
BB                    LABEL     DWORD
                      DD          (?)
CC                    LABEL     DWORD
                      DD          (?)
DD0                   LABEL     DWORD
                      DD          (?)
                    ENDIF       

; - MDC Transformation: ----------------------------------------------------

; IFDEF __OOP use: MDCTransform(constbl,data,hash);                    
;        ELSE use: MDCtransform(data,hash);
                    
                    PUBLIC      PASCAL MDCTransform
                  IFDEF         __OOP
MDCTransform        PROC        PASCAL FAR constbl: DWORD,hashdata: DWORD,digest: DWORD
                  ELSE
MDCTransform        PROC        PASCAL FAR hashdata: DWORD,digest: DWORD
                  ENDIF
                  IFDEF         __LOCALVARS
                    LOCAL       AA: DWORD, BB: DWORD, CC: DWORD, DD0: DWORD
                  ENDIF       
                    push        ds
                    IFDEF          __NOSTOR
                      lds         si,       digest
                      IFDEF          __LOCALVARS
                        lea         di,     OFFSET AA
                        mov         ax,     ss
                      ELSE        
                        mov         di,     OFFSET AA
                        mov         ax,     cs
                      ENDIF       
                      mov         es,       ax
                      mov         cx,       4
                      cld         
                      rep         movsd
                    ENDIF       
                    lds         si,         hashdata      ; *data[64]
                    les         di,         digest        ; *hash[16]
                    IFNDEF         __NOSTOR
                      STOR        AA,       A             ;
                      STOR        BB,       B
                      STOR        CC,       C
                      STOR        DD0,      D
                    ENDIF
; -Round 1 -----------------------------------------------------------------
                    FF          A, B, C, D, X.[4*0], S11, 0
                    FF          D, A, B, C, X.[4*1], S12, 1
                    FF          C, D, A, B, X.[4*2], S13, 2
                    FF          B, C, D, A, X.[4*3], S14, 3
                    FF          A, B, C, D, X.[4*4], S11, 4
                    FF          D, A, B, C, X.[4*5], S12, 5
                    FF          C, D, A, B, X.[4*6], S13, 6
                    FF          B, C, D, A, X.[4*7], S14, 7
                    FF          A, B, C, D, X.[4*8], S11, 8
                    FF          D, A, B, C, X.[4*9], S12, 9
                    FF          C, D, A, B, X.[4*10], S13, 10
                    FF          B, C, D, A, X.[4*11], S14, 11
                    FF          A, B, C, D, X.[4*12], S11, 12
                    FF          D, A, B, C, X.[4*13], S12, 13
                    FF          C, D, A, B, X.[4*14], S13, 14
                    FF          B, C, D, A, X.[4*15], S14, 15
; - Round 2 ----------------------------------------------------------------
                    GG          A, B, C, D, X.[4*1], S21, 16
                    GG          D, A, B, C, X.[4*6], S22, 17
                    GG          C, D, A, B, X.[4*11], S23, 18
                    GG          B, C, D, A, X.[4*0], S24, 19
                    GG          A, B, C, D, X.[4*5], S21, 20
                    GG          D, A, B, C, X.[4*10], S22, 21
                    GG          C, D, A, B, X.[4*15], S23, 22
                    GG          B, C, D, A, X.[4*4], S24, 23
                    GG          A, B, C, D, X.[4*9], S21, 24
                    GG          D, A, B, C, X.[4*14], S22, 25
                    GG          C, D, A, B, X.[4*3], S23, 26
                    GG          B, C, D, A, X.[4*8], S24, 27
                    GG          A, B, C, D, X.[4*13], S21, 28
                    GG          D, A, B, C, X.[4*2], S22, 29
                    GG          C, D, A, B, X.[4*7], S23, 30
                    GG          B, C, D, A, X.[4*12], S24, 31
; - Round 3 ----------------------------------------------------------------
                    HH          A, B, C, D, X.[4*5], S31, 32
                    HH          D, A, B, C, X.[4*8], S32, 33
                    HH          C, D, A, B, X.[4*11], S33, 34
                    HH          B, C, D, A, X.[4*14], S34, 35
                    HH          A, B, C, D, X.[4*1], S31, 36
                    HH          D, A, B, C, X.[4*4], S32, 37
                    HH          C, D, A, B, X.[4*7], S33, 38
                    HH          B, C, D, A, X.[4*10], S34, 39
                    HH          A, B, C, D, X.[4*13], S31, 40
                    HH          D, A, B, C, X.[4*0], S32, 41
                    HH          C, D, A, B, X.[4*3], S33, 42
                    HH          B, C, D, A, X.[4*6], S34, 43
                    HH          A, B, C, D, X.[4*9], S31, 44
                    HH          D, A, B, C, X.[4*12], S32, 45
                    HH          C, D, A, B, X.[4*15], S33, 46
                    HH          B, C, D, A, X.[4*2], S34, 47
; - Round 4 ----------------------------------------------------------------
                    II          A, B, C, D, X.[4*0], S41, 48
                    II          D, A, B, C, X.[4*7], S42, 49
                    II          C, D, A, B, X.[4*14], S43, 50
                    II          B, C, D, A, X.[4*5], S44, 51
                    II          A, B, C, D, X.[4*12], S41, 52
                    II          D, A, B, C, X.[4*3], S42, 53
                    II          C, D, A, B, X.[4*10], S43, 54
                    II          B, C, D, A, X.[4*1], S44, 55
                    II          A, B, C, D, X.[4*8], S41, 56
                    II          D, A, B, C, X.[4*15], S42, 57
                    II          C, D, A, B, X.[4*6], S43, 58
                    II          B, C, D, A, X.[4*13], S44, 59
                    II          A, B, C, D, X.[4*4], S41, 60
                    II          D, A, B, C, X.[4*11], S42, 61
                    II          C, D, A, B, X.[4*2], S43, 62
                    II          B, C, D, A, X.[4*9], S44, 63
; --------------------------------------------------------------------------
                    ADDD        A, AA   ;
                    ADDD        B, BB
                    ADDD        C, CC
                    ADDD        D, DD0
                    pop         ds               ;
                    ret
MDCTransform          ENDP

; - Constant Definitions for MagicConstantTable ----------------------------
const01             EQU       3614090360
const02             EQU       3905402710 
const03             EQU        606105819  
const04             EQU       3250441966  
const05             EQU       4118548399 
const06             EQU       1200080426 
const07             EQU       2821735955 
const08             EQU       4249261313
const09             EQU       1770035416 
const10             EQU       2336552879
const11             EQU       4294925233
const12             EQU       2304563134 
const13             EQU       1804603682 
const14             EQU       4254626195 
const15             EQU       2792965006 
const16             EQU       1236535329 
const17             EQU       4129170786 
const18             EQU       3225465664 
const19             EQU        643717713   
const20             EQU       3921069994 
const21             EQU       3593408605
const22             EQU         38016083  
const23             EQU       3634488961 
const24             EQU       3889429448 
const25             EQU        568446438  
const26             EQU       3275163606 
const27             EQU       4107603335  
const28             EQU       1163531501  
const29             EQU       2850285829  
const30             EQU       4243563512 
const31             EQU       1735328473 
const32             EQU       2368359562 
const33             EQU       4294588738  
const34             EQU       2272392833 
const35             EQU       1839030562  
const36             EQU       4259657740 
const37             EQU       2763975236 
const38             EQU       1272893353
const39             EQU       4139469664   
const40             EQU       3200236656     
const41             EQU        681279174    
const42             EQU       3936430074    
const43             EQU       3572445317   
const44             EQU         76029189    
const45             EQU       3654602809    
const46             EQU       3873151461  
const47             EQU        530742520     
const48             EQU       3299628645         
const49             EQU       4096336452        
const50             EQU       1126891415       
const51             EQU       2878612391           
const52             EQU       4237533241      
const53             EQU       1700485571   
const54             EQU       2399980690 
const55             EQU       4293915773  
const56             EQU       2240044497   
const57             EQU       1873313359  
const58             EQU       4264355552   
const59             EQU       2734768916   
const60             EQU       1309151649  
const61             EQU       4149444226 
const62             EQU       3174756917  
const63             EQU        718787259    
const64             EQU       3951481745  
; --------------------------------------------------------------------------

             IFDEF __OOP
                PUBLIC  PASCAL MDCDefault
MDCDefault      PROC    PASCAL FAR
                 mov    dx, cs
                 mov    ax, OFFSET OriginalConstants
                 ret
MDCDefault      ENDP
             ELSE

; - Set MDC constants ------------------------------------------------------
; a value of null (or nil in pascal) tells it to restore from the originals.
                      
                      PUBLIC      PASCAL MDCSetConst
MDCSetConst           PROC        PASCAL FAR userconsttbl: DWORD
                      push        ds
                      mov         eax,      userconsttbl
                      or          eax,      eax
                      jnz         SHORT userdefined
                      mov         ax,       cs
                      mov         ds,       ax
                      mov         si,       OFFSET OriginalConstants
                      jmp         SHORT copyconstants
userdefined:          lds         si, userconsttbl
copyconstants:        mov         ax, cs
                      mov         es,       ax
                      mov         di,       OFFSET MagicConstants
                      cld         
                      mov         cx,       64
                      rep         movsd
                      pop         ds
                      ret
mdcsetconst           ENDP      

; - MD5 "Magic Constant" Table ---------------------------------------------

MagicConstants LABEL DWORD
; - Round 1 ----------------------------------------------------------------
  DD          const01,  const02, const03, const04
  DD          const05,  const06, const07, const08
  DD          const09,  const10, const11, const12
  DD          const13,  const14, const15, const16
; - Round 2 ----------------------------------------------------------------
  DD          const17,  const18, const19, const20
  DD          const21,  const22, const23, const24
  DD          const25,  const26, const27, const28
  DD          const29,  const30, const31, const32
; - Round 3 ----------------------------------------------------------------
  DD          const33,  const34, const35, const36
  DD          const37,  const38, const39, const40
  DD          const41,  const42, const43, const44
  DD          const45,  const46, const47, const48
; - Round 4 ----------------------------------------------------------------
  DD          const49,  const50, const51, const52
  DD          const53,  const54, const55, const56
  DD          const57,  const58, const59, const60
  DD          const61,  const62, const63, const64
; --------------------------------------------------------------------------
               ENDIF

OriginalConstants   LABEL       DWORD
; - Round 1 ----------------------------------------------------------------
  DD          const01,  const02, const03, const04
  DD          const05,  const06, const07, const08
  DD          const09,  const10, const11, const12
  DD          const13,  const14, const15, const16
; - Round 2 ----------------------------------------------------------------
  DD          const17,  const18, const19, const20
  DD          const21,  const22, const23, const24
  DD          const25,  const26, const27, const28
  DD          const29,  const30, const31, const32
; - Round 3 ----------------------------------------------------------------
  DD          const33,  const34, const35, const36
  DD          const37,  const38, const39, const40
  DD          const41,  const42, const43, const44
  DD          const45,  const46, const47, const48
; - Round 4 ----------------------------------------------------------------
  DD          const49,  const50, const51, const52
  DD          const53,  const54, const55, const56
  DD          const57,  const58, const59, const60
  DD          const61,  const62, const63, const64
; --------------------------------------------------------------------------

                  END
