#ifndef ECBASIC_H
#define ECBASIC_H

#include "nbtheory.h"
#include "gf2n.h"

class EC2N
{
public:

	typedef GF2N Field;
	typedef Field::Element FieldElement;

	struct Point
	{
		Point() : identity(TRUE) {}
		Point(const Field::Element &x, const Field::Element &y)
			: identity(FALSE), x(x), y(y) {}

		boolean identity;
		Field::Element x, y;
	};

	typedef Point Element;

	EC2N(const Field &field, const Field::Element &a, const Field::Element &b)
		: field(field), a(a), b(b) {}

	boolean Equal(const Point &P, const Point &Q) const;
	Point Identity() const {return Point();}
	Point Inverse(const Point &P) const;
	Point Add(const Point &P, const Point &Q) const;
	Point Double(const Point &P) const;
	Point Multiply(const Integer &k, const Point &P) const;
	Point CascadeMultiply(const Integer &k1, const Point &P, const Integer &k2, const Point &Q) const;

//	Integer Cardinality() const;	TODO: implement this

	// compute order of a point, given the cardinality of this curve
	Integer Order(const Point &P, const Integer &cardinality) const;

	Field field;
	Field::Element a, b;
};

class ECP
{
public:

	struct Point
	{
		Point() : identity(TRUE) {}
		Point(const GFP::Element &x, const GFP::Element &y)
			: identity(FALSE), x(x), y(y) {}

		boolean identity;
		GFP::Element x, y;
	};

	typedef GFP Field;
	typedef GFP::Element FieldElement;
	typedef Point Element;

	ECP(const GFP &field, const GFP::Element &a, const GFP::Element &b)
		: field(field), a(a), b(b) {}

	boolean Equal(const Point &P, const Point &Q) const;
	Point Identity() const {return Point();}
	Point Inverse(const Point &P) const;
	Point Add(const Point &P, const Point &Q) const;
	Point Double(const Point &P) const;
	Point Multiply(const Integer &k, const Point &P) const;
	Point CascadeMultiply(const Integer &k1, const Point &P, const Integer &k2, const Point &Q) const;

//	Integer Cardinality() const;	TODO: implement this

	// compute order of a point, given the cardinality of this curve
	Integer Order(const Point &P, const Integer &cardinality) const;

	GFP field;
	GFP::Element a, b;
};

#endif
