#ifndef PKCSPAD_H
#define PKCSPAD_H

#include "cryptlib.h"
#include "integer.h"

class PublicKeyUsingPKCSPadding : public PK_Encryptor, public PK_Verifier
{
public:
    // encrypt and verify signature in PKCS #1 format
    void Encrypt(RandomNumberGenerator &rng, const byte *plainText, unsigned int plainTextLength, byte *cipherText);
    boolean Verify(const byte *message, unsigned int messageLen, const byte *signature);
protected:
    unsigned int PublicDecrypt(const byte *cipherText, byte *plainText);
    virtual void RawEncrypt(const Integer &in, Integer &out) const =0;
	virtual unsigned int PKCSBlockLen() const =0;
};

class PrivateKeyUsingPKCSPadding : public PK_Decryptor, public PK_Signer
{
public:
    // decrypt and sign in PKCS #1 format
    unsigned int Decrypt(const byte *cipherText, byte *plainText);
    void Sign(const byte *message, unsigned int messageLen, byte *signature)
        {PrivateEncrypt(message, messageLen, signature);}
    void Sign(RandomNumberGenerator &, const byte *message, unsigned int messageLen, byte *signature)
        {PrivateEncrypt(message, messageLen, signature);}
protected:
    void PrivateEncrypt(const byte *plainText, unsigned int plainTextLength, byte *cipherText);
    virtual void RawDecrypt(const Integer &in, Integer &out) const =0;
	virtual unsigned int PKCSBlockLen() const =0;
};

#endif
