#ifndef RABIN_H
#define RABIN_H

#include "pkcspad.h"

class RabinPublicKey : public PublicKeyUsingPKCSPadding
{
public:
    // you can use the default copy constructor to make a RabinPublicKey
    // out of a RabinPrivateKey
    RabinPublicKey(const Integer &n, const Integer &r, const Integer &s);
    RabinPublicKey(BufferedTransformation &bt);

    void DEREncode(BufferedTransformation &bt) const;

    unsigned int MaxPlainTextLength() const {return modulusLen-11;}
    unsigned int CipherTextLength() const {return modulusLen;}
    unsigned int MaxMessageLength() const {return modulusLen-11;}
    unsigned int SignatureLength() const {return modulusLen;}

protected:
    RabinPublicKey() {}
    void RawEncrypt(const Integer &in, Integer &out) const;
	unsigned int PKCSBlockLen() const {return modulusLen;}

    Integer n;           // these are only modified in constructors
	Integer r, s;
    unsigned int modulusLen;
};

class RabinPrivateKey : public RabinPublicKey, public PrivateKeyUsingPKCSPadding
{
public:
    RabinPrivateKey(const Integer &n, const Integer &r, const Integer &s,
                    const Integer &p, const Integer &q, const Integer &u);
    // generate a random private key
    RabinPrivateKey(RandomNumberGenerator &rng, unsigned int keybits);
    RabinPrivateKey(BufferedTransformation &bt);

    void DEREncode(BufferedTransformation &bt) const;

protected:
    void RawDecrypt(const Integer &in, Integer &out) const;
	unsigned int PKCSBlockLen() const {return modulusLen;}

    Integer p, q, u;
};

#endif
