VERSION 4.00
Begin VB.Form frmVBDemo 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "ViaCrypt PGP Visual Basic Toolkit Demo"
   ClientHeight    =   4950
   ClientLeft      =   1140
   ClientTop       =   1800
   ClientWidth     =   7695
   Height          =   5640
   Left            =   1080
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4950
   ScaleWidth      =   7695
   ShowInTaskbar   =   0   'False
   Top             =   1170
   Width           =   7815
   Begin VB.TextBox txtMain 
      Height          =   4935
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Text            =   "VBDEMO.frx":0000
      Top             =   0
      Width           =   7695
   End
   Begin MSComDlg.CommonDialog cdlSave 
      Left            =   0
      Top             =   0
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      CancelError     =   -1  'True
      Filter          =   "All Files (*.*)|*.*"
      Flags           =   2
   End
   Begin MSComDlg.CommonDialog cdlOpen 
      Left            =   2880
      Top             =   -120
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      CancelError     =   -1  'True
      Filter          =   "All Files (*.*)|*.*"
      Flags           =   4096
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuNew 
         Caption         =   "&New"
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuOpen 
         Caption         =   "&Open..."
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuSaveAs 
         Caption         =   "&Save..."
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuSep 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mnuCut 
         Caption         =   "Cu&t"
         Shortcut        =   ^X
      End
      Begin VB.Menu mnuCopy 
         Caption         =   "&Copy"
         Shortcut        =   ^C
      End
      Begin VB.Menu mnuPaste 
         Caption         =   "&Paste"
         Shortcut        =   ^V
      End
      Begin VB.Menu mnuDelete 
         Caption         =   "&Delete"
      End
      Begin VB.Menu mnuSep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSelectAll 
         Caption         =   "Select &All"
         Shortcut        =   ^A
      End
   End
   Begin VB.Menu mnuPGP 
      Caption         =   "&PGP"
      Begin VB.Menu mnuEncrypt 
         Caption         =   "&Encrypt"
      End
      Begin VB.Menu mnuSign 
         Caption         =   "&Sign"
      End
      Begin VB.Menu mnuEncSign 
         Caption         =   "Encrypt A&nd Sign"
      End
      Begin VB.Menu mnuDecrypt 
         Caption         =   "&Decrypt"
      End
      Begin VB.Menu mnuVerify 
         Caption         =   "&Verify Signature"
      End
   End
   Begin VB.Menu mnuKey 
      Caption         =   "&Key"
      Begin VB.Menu mnuGenerate 
         Caption         =   "&Generate"
      End
      Begin VB.Menu mnuExtract 
         Caption         =   "&Extract"
      End
      Begin VB.Menu mnuAdd 
         Caption         =   "&Add"
      End
      Begin VB.Menu mnuRemove 
         Caption         =   "&Remove"
      End
      Begin VB.Menu mnuCertify 
         Caption         =   "&Certify"
      End
   End
End
Attribute VB_Name = "frmVBDemo"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
DefInt A-Z

Option Explicit

Const MAX_LEN = 30000

Dim bCancel, bChanged





Sub PGPDecryptVerify(bExpectSig As Integer)
    Dim sRcptList As String, sSigner As String
    Dim sOutput As String, lOutputSize As Long
    Dim sDecryptPwd As String
    Dim sSignDate As String
    Dim iResult As Integer, iSigStat As Long
    
    ' We have to copy this value from the constant (MAX_LEN) to a regular
    ' variable (lOutputSize) so that the Simple DLL can write the actual
    ' output size back to it.
    lOutputSize = MAX_LEN
    
    ' Null these out
    sRcptList = String(1024, 0)
    sDecryptPwd = String(255, 0)
    sSigner = String(255, 0)
    sSignDate = String(255, 0)
    sOutput = String(MAX_LEN, 0)
    
    If Len(txtMain.Text) = 0 Then
        MsgBox "Please type or load some text into the text window before attempting a PGP operation.", vbInformation
        Exit Sub
    End If
        
    ' Decrypt / Verify Signature
    iResult = SimplePGPReceiveBuffer(Me.hwnd, txtMain.Text, Len(txtMain.Text), "Text Window", sOutput, lOutputSize, sDecryptPwd, 256, iSigStat, sSigner, 256, sSignDate, 255, "", "")
        
    If iResult = 0 Or iResult = 1 Then
        txtMain.Text = sOutput
        Select Case iSigStat
            Case SIGSTS_NOTSIGNED
                If bExpectSig Then MsgBox "Message was not signed!"
            Case SIGSTS_VERIFIED
                MsgBox "Good signature from " + TrimNulls(sSigner) + "." + Chr(13) + Chr(10) + "Signature was made " + TrimNulls(sSignDate) + ".", vbInformation
            Case SIGSTS_BADSIG
                MsgBox "Bad signature from " + TrimNulls(sSigner) + "!" + Chr(13) + Chr(10) + "Signature was made " + TrimNulls(sSignDate) + ".", vbExclamation
            Case SIGSTS_NOTVERIFIED
                MsgBox "Couldn't find public key." + Chr(13) + Chr(10) + "Can't check signature integrity.", vbInformation
        End Select
    Else
        MsgBox "Simple PGP Decrypt Buffer returned error code " + Trim(Str(iResult)) + ".", vbExclamation
    End If
End Sub



Sub PGPEncryptSign(SignFlag As Integer)
    Dim sRcptList As String, sSigner As String
    Dim sOutput As String, lOutputSize As Long
    Dim sSignerPwd As String, sDummyBuffer As String
    Dim iResult As Integer, iCount As Long
    Static bSign As Integer
    
'    scratch
    ' We have to copy this value from the constant (MAX_LEN) to a regular
    ' variable (lOutputSize) so that the Simple DLL can write the actual
    ' output size back to it.
    lOutputSize = MAX_LEN
    bSign = SignFlag
    
    ' Null these out
    sRcptList = String(1024, 0)
    sSigner = String(256, 0)
    sSignerPwd = String(256, 0)
    sDummyBuffer = String(256, 0)
    sOutput = String(MAX_LEN, 0)
    
    If Len(txtMain.Text) = 0 Then
        MsgBox "Please type or load some text into the text window before attempting a PGP operation.", vbInformation
        Exit Sub
    End If

    ' Prompt the user for recipients
    iResult = SimplePGPKeySel(Me.hwnd, "Select Recipients for the Message", True, KEYSEL_PUBLIC, sRcptList, 1024, iCount, INCLUDE_ONLYKEYIDS, Chr(0), KEYS_OLD Or KEYS_ENCR, Chr(0), False, KEYSEL_SHOW_GROUPS, KEYSEL_DISABLE_SHARED_BUTTONS, Chr(0))
        
'        KEYSEL_PUBLIC, sRcptList, 1024, iCount, INCLUDE_ONLYKEYIDS, Chr(0),
    If iResult = 0 Then
        If SignFlag <> 0 Then
            ' Prompt the user for a signing key
            ' If the private keyring contains only one key,
            ' this function will automatically return it,
            ' without prompting the user
            iResult = SimplePGPKeySel(Me.hwnd, "Select a Key to Sign the Message", False, KEYSEL_PRIVATE, sSigner, 1024, iCount, INCLUDE_ONLYKEYIDS, Chr(0), KEYS_OLD Or KEYS_SIGN, Chr(0), False, KEYSEL_SHOW_GROUPS, KEYSEL_DISABLE_SHARED_BUTTONS, Chr(0))
        End If

        If iResult = 0 Then
            If Len(Trim(sSigner)) Then
                ' We need to trim the leading code character (INCLUDE_ONLY...), and the
                ' trailing CRLF combination, and add a trailing null
                sSigner = Trim(Mid(sSigner, 2, Len(Trim(sSigner)) - 3)) + Chr(0)
            Else
                sSigner = Chr(0)
            End If
'            iResult = SimplePGPEncryptBuffer(0, txtMain.Text, Len(txtMain.Text), "Text Window", sOutput, lOutputSize, SignFlag, True, True, False, True, Trim(sRcptList), sSigner, 255, sSignerPwd, 255, sDummyBuffer, 1, "", "")
            iResult = SimplePGPEncryptBuffer(0, txtMain.Text, Len(txtMain.Text), "Text Window", sOutput, lOutputSize, False, True, True, False, True, Trim(sRcptList), sSigner, 255, sSignerPwd, 255, sDummyBuffer, 1, "", "")
                       
            If iResult = 0 Then
                txtMain.Text = sOutput
            Else
                MsgBox "Simple PGP Encrypt Buffer returned error code " + Trim(Str(iResult)) + ".", vbExclamation
            End If
        Else
            MsgBox "Simple PGP KeySel returned error code " + Trim(Str(iResult)) + ". (2)", vbExclamation
        End If
    Else
        MsgBox "Simple PGP KeySel returned error code " + Trim(Str(iResult)) + ".", vbExclamation
    End If
End Sub

Sub scratch()
    Dim sRcptList As String, sSigner As String
    Dim sOutput As String, lOutputSize As Long
    Dim sSignerPwd As String, sDummyBuffer As String
    Dim iResult As Integer, iCount As Integer
    Dim iSigStat As Long, sSignDate As String
    Static bSign As Integer
    
    sRcptList = String(1024, 0)
    sSigner = String(256, 0)
    sSignerPwd = String(256, 0)
    sDummyBuffer = String(256, 0)
    sSignDate = String(256, 0)
    sOutput = String(MAX_LEN, 0)
    
'    iResult = SimplePGPKeySel(Me.hWnd, "Select Recipients for the Message", True, KEYSEL_PUBLIC, sRcptList, 1024, iCount, INCLUDE_ONLYKEYIDS, Chr(0), KEYS_OLD Or KEYS_ENCR, Chr(0), False, KEYSEL_SHOW_GROUPS, KEYSEL_DISABLE_SHARED_BUTTONS, Chr(0))
    iResult = SimplePGPEncryptBuffer(0, txtMain.Text, Len(txtMain.Text), "Text Window", sOutput, lOutputSize, False, True, True, False, True, Trim(sRcptList), sSigner, 255, sSignerPwd, 255, sDummyBuffer, 1, "", "")
'    iResult = SimplePGPReceiveFile(0, "c:\autoexec.asc", "c:\autoexec.out", "", 0, iSigStat, sSigner, 256, sSignDate, 256, "", "")
                        '        hWnd   InputFileName    OutputFileName    DPP,DPBL SigStat   Sgnr    SBL SignDate, SDBL, PublicKeyRingName ,PrivateKeyRingName
    
End Sub


Private Sub Form_Load()
    ' If the DLLs aren't in the PATH, then they need to be in the
    ' current directory.  This changes the current directory
    ' to this demo's directory, and the DLL directory
    ChDir App.Path
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Dim iResponse As Integer
    
    bCancel = False
    If bChanged Then
        iResponse = MsgBox("Save changes?", vbQuestion Or vbYesNo)
        If iResponse = vbYes Then mnuSaveAs_Click
    End If
    
    ' mnuSaveAs_Click will set bCancel to TRUE if the user aborts.
    ' However, if Form_Unload was passed Cancel = TRUE, then
    ' we *know* we don't want the program to end, so don't override
    ' that.
    If Not Cancel Then Cancel = bCancel
End Sub

Private Sub mnuAdd_Click()
    Dim iResult As Integer
    
    On Error GoTo eCancelled
    cdlOpen.DialogTitle = "Specify the File Containing the Key to Add"
    cdlOpen.FileName = ""
    cdlOpen.ShowOpen
    On Error GoTo 0
    
    iResult = SimplePGPAddKey(Me.hwnd, cdlOpen.FileName, "")
    
    If iResult = 0 Then
        MsgBox "Key(s) successfully added from " + cdlOpen.FileName + ".", vbInformation
    Else
        MsgBox "Simple PGP Add Key returned error code " + Trim(Str(iResult)) + ".", vbExclamation
    End If
    
    Exit Sub
    
eCancelled:
    If Err = cdlCancel Then
        Exit Sub
    Else
        Error Err
    End If
End Sub

Private Sub mnuCertify_Click()
    Dim iResult As Integer
    Dim sKey2Certify As String, sKey2MakeCertification As String
    Dim sDummyBuffer As String
    
    ' Null this out
    sDummyBuffer = String(256, 0)
    sKey2Certify = String(20, 0)
    sKey2MakeCertification = String(20, 0)
    
    ' For this procedure, rather than simply using KeySel,
    ' we will use the Simple API's "Open...GetNext...Close"
    ' functions to build our own key selection dialog
    ' box, to illustrate the use of these functions
     
    sKey2Certify = MyOwnKeySel("Please Select a Public Key to Certify", KEYSEL_PUBLIC)
    
    If Len(sKey2Certify) Then
        sKey2MakeCertification = MyOwnKeySel("Please Select a Private Key to Certify This Public Key", KEYSEL_PRIVATE)
        
        If Len(sKey2MakeCertification) Then
            iResult = SimplePGPCertifyPublicKey(Me.hwnd, Trim(sKey2Certify), Trim(sKey2MakeCertification), 20, sDummyBuffer, 256, "", "")
            
            If iResult = 0 Then
                MsgBox "Certification successful!", vbInformation
            Else
                MsgBox "Simple PGP Certify Public Key returned error code " + Trim(Str(iResult)) + ".", vbExclamation
            End If
        End If
    End If
End Sub

Private Sub mnuCopy_Click()
    Clipboard.SetText txtMain.SelText
End Sub

Private Sub mnuCut_Click()
    Clipboard.SetText txtMain.SelText
    txtMain.SelText = ""
End Sub

Private Sub mnuDecrypt_Click()
    Call PGPDecryptVerify(False)
End Sub

Private Sub mnuDelete_Click()
    txtMain.SelText = ""
End Sub

Private Sub mnuEncrypt_Click()
    Call PGPEncryptSign(False)
End Sub


Private Sub mnuEncSign_Click()
    Call PGPEncryptSign(True)
End Sub

Private Sub mnuExit_Click()
    Unload Me
End Sub

Private Sub mnuExtract_Click()
    Dim sRcptList As String
    Dim iResult As Integer, iCount As Long
    
    sRcptList = String(1024, 0)
    
    ' Select the key to extract
    iResult = SimplePGPKeySel(Me.hwnd, "Select Key to Extract", False, KEYSEL_PUBLIC, sRcptList, 1024, iCount, INCLUDE_ONLYUSERIDS, Chr(0), KEYS_OLD Or KEYS_ENCR Or KEYS_SIGN, Chr(0), False, KEYSEL_SHOW_GROUPS, KEYSEL_DISABLE_SHARED_BUTTONS, Chr(0))
    
    If iResult = 0 Then
        sRcptList = Trim(Mid(sRcptList, 2, InStr(sRcptList, Chr(10)) - 2)) '+ Chr(0)
        On Error GoTo eCancelled1
        cdlSave.DialogTitle = "Specify a File Name for the Extracted Key"
        cdlSave.FileName = ""
        cdlSave.ShowSave
        On Error GoTo 0
        
        ' The "Could not open keyring" message
        ' is not fatal
        
        iResult = SimplePGPExtractKey(Me.hwnd, Trim(sRcptList), cdlSave.FileName, "")
                       
        If iResult = 0 Then
            MsgBox "Key for user ID " + Trim(sRcptList) + " successfully extracted to " + cdlSave.FileName + ".", vbInformation
        Else
            MsgBox "Simple PGP Extract Key returned error code " + Trim(Str(iResult)) + ".", vbExclamation
        End If
    Else
        MsgBox "Simple PGP Key Sel returned error code " + Trim(Str(iResult)) + ".", vbExclamation
    End If
    Exit Sub
    
eCancelled1:
    If Err = cdlCancel Then
        Exit Sub
    Else
        Error Err
    End If
End Sub





Private Sub mnuGenerate_Click()
    frmKeyGen.Show 1
End Sub

Private Sub mnuNew_Click()
    Dim iResponse As Integer
    
    Call Form_Unload(True)
    
    If bCancel Then
        bCancel = False
    Else
        txtMain.Text = ""
        bChanged = False
    End If
End Sub

Private Sub mnuOpen_Click()
    Dim lBytesRead As Long
    Dim sInput As String, sScratch As String, sFile2Open As String
    
    On Error GoTo eCancelled2
    cdlOpen.DialogTitle = "Open File"
    cdlOpen.FileName = ""
    cdlOpen.ShowOpen
    
    If bChanged Then
        sFile2Open = cdlOpen.FileName
        Call Form_Unload(True)
        If bCancel Then
            bCancel = False
            Exit Sub
        End If
        cdlOpen.FileName = sFile2Open
    End If
    
    txtMain.Text = ""
    Me.MousePointer = 11
    
    On Error GoTo eFileError
    Open cdlOpen.FileName For Input Shared As 1
    
    Do
        Line Input #1, sInput
        sScratch = sScratch + sInput + Chr(13) + Chr(10)
        lBytesRead = lBytesRead + Len(sInput)
        If lBytesRead > MAX_LEN Then
            MsgBox "Out of memory.  This demo can only load files up to " + Trim(Str(MAX_LEN)) + " bytes in length.  Please try a shorter file.", vbExclamation
            Exit Do
        End If
    Loop While Not EOF(1)
    
    Close 1
    txtMain.Text = sScratch
    On Error GoTo 0
    Me.MousePointer = 0
    bChanged = False
    
    Exit Sub
    
eCancelled2:
    If Err = cdlCancel Then
        Exit Sub
    Else
        Error Err
    End If
    
eFileError:
    If Err = 7 Then
        MsgBox "Out of memory.  This demo can only load files up to " + Trim(Str(MAX_LEN)) + " bytes in length.  Please try a shorter file.", vbExclamation
    Else
        MsgBox "Error number " + Trim(Str(Err)) + " occurred when operating on file " + cdlOpen.FileName + ".", vbExclamation
    End If
    Me.MousePointer = 0
    Exit Sub
End Sub

Private Sub mnuPaste_Click()
    txtMain.SelText = Clipboard.GetText
End Sub


Private Sub mnuRemove_Click()
    Dim sRcptList As String * 1024
    Dim iResult As Integer, iCount As Long
    
    ' Select the key to remove
    iResult = SimplePGPKeySel(Me.hwnd, "Select Key to Remove", False, KEYSEL_PUBLIC, sRcptList, 1024, iCount, INCLUDE_ONLYUSERIDS, Chr(0), KEYS_OLD Or KEYS_ENCR Or KEYS_SIGN, Chr(0), False, KEYSEL_SHOW_GROUPS, KEYSEL_DISABLE_SHARED_BUTTONS, Chr(0))
    
    If iResult = 0 Then
        sRcptList = Trim(Mid(sRcptList, 2, InStr(sRcptList, Chr(10)) - 2))
        iResult = MsgBox("Are you sure you want to remove the key for user ID " + Trim(sRcptList) + "?", vbQuestion + vbYesNo)
        
        If iResult = vbYes Then
            iResult = SimplePGPRemoveKey(Me.hwnd, Trim(sRcptList), "")
                           
            If iResult = 0 Then
                MsgBox "Key for user ID " + Trim(sRcptList) + " removed from keyring.", vbInformation
            Else
                MsgBox "Simple PGP Extract Key returned error code " + Trim(Str(iResult)) + ".", vbExclamation
            End If
        End If
    Else
        MsgBox "Simple PGP Key Sel returned error code " + Trim(Str(iResult)) + ".", vbExclamation
    End If
End Sub

Private Sub mnuSaveAs_Click()
    Dim lBytesRead As Long
    Dim sInput As String, sScratch As String
    
    On Error GoTo eCancelled4
    cdlSave.DialogTitle = "Save File"
    cdlSave.FileName = ""
    cdlSave.ShowSave
    
    Me.MousePointer = 11
    
    On Error GoTo eFileError
    Open cdlSave.FileName For Output Shared As 1
    Print #1, txtMain.Text
    Close 1
    On Error GoTo 0
    Me.MousePointer = 0
    bChanged = False
    
    Exit Sub
    
eCancelled4:
    If Err = cdlCancel Then
        bCancel = True
        Exit Sub
    Else
        Error Err
    End If
    
eFileError:
    If Err = 7 Then
        MsgBox "Out of memory.  This demo can only load files up to " + Trim(Str(MAX_LEN)) + " bytes in length.  Please try a shorter file.", vbExclamation
    Else
        MsgBox "Error number " + Trim(Str(Err)) + " occurred when operating on file " + cdlSave.FileName + ".", vbExclamation
    End If
    Me.MousePointer = 0
    Exit Sub
End Sub

Private Sub mnuSelectAll_Click()
    txtMain.SelStart = 0
    txtMain.SelLength = Len(txtMain.Text)
End Sub



Private Sub mnuSign_Click()
    Dim sRcptList As String * 1024, sSigner As String * 255
    Dim sOutput As String * MAX_LEN, lOutputSize As Long
    Dim sSignerPwd As String * 256
    Dim iResult As Integer, iCount As Long
    
    ' We have to copy this value from the constant (MAX_LEN) to a regular
    ' variable (lOutputSize) so that the Simple DLL can write the actual
    ' output size back to it.
    lOutputSize = MAX_LEN
    
    ' Null this out
    sSignerPwd = Chr(0)
    
    If Len(txtMain.Text) = 0 Then
        MsgBox "Please type or load some text into the text window before attempting a PGP operation.", vbInformation
        Exit Sub
    End If

    iResult = SimplePGPKeySel(Me.hwnd, "Select a Key to Sign the Message", False, KEYSEL_PRIVATE, sSigner, 1024, iCount, INCLUDE_ONLYKEYIDS, Chr(0), KEYS_OLD Or KEYS_SIGN, Chr(0), False, KEYSEL_SHOW_GROUPS, KEYSEL_DISABLE_SHARED_BUTTONS, Chr(0))

    If iResult = 0 Then
        ' We need to trim the leading code character (INCLUDE_ONLY...), and the
        ' trailing CRLF combination, and add a trailing null
        sSigner = Trim(Mid(sSigner, 2, Len(Trim(sSigner)) - 3)) + Chr(0)
        
        ' Sign it!
        iResult = SimplePGPSignBuffer(Me.hwnd, txtMain.Text, Len(txtMain.Text), "Text Window", sOutput, lOutputSize, True, True, False, True, sSigner, 255, sSignerPwd, 255, "")
'        iResult = SimplePGPSignBuffer(Me.hwnd, txtMain.Text, Len(txtMain.Text), "Text Window", sOutput, lOutputSize, True, True, False, True, sSigner, 255, sSignerPwd, 255, "h:\mab\secring.pgp")
                   

        If iResult = 0 Then
            txtMain.Text = sOutput
        Else
            MsgBox "Simple PGP Sign Buffer returned error code " + Trim(Str(iResult)) + ".", vbExclamation
        End If
    Else
        MsgBox "Simple PGP KeySel returned error code " + Trim(Str(iResult)) + ".", vbExclamation
    End If
End Sub


Private Sub mnuVerify_Click()
    Call PGPDecryptVerify(True)
End Sub

Private Sub txtMain_Change()
    bChanged = True
End Sub


