#include <stdio.h>
#include <string.h>
#include <rand.h>
#include <idea.h>

/*------------------------------------*/
/* conventional encryption to packet */
int cnvenc2(FILE * inf, FILE * outf, unsigned char *passwdhash)
{
  int j, len, fmark;
  unsigned char dbuf[4096];
  unsigned char ivec[8];
  IDEA_KEY_SCHEDULE iks;
  int ivc;

  idea_set_encrypt_key(passwdhash, &iks);
  fputc(0xa6, outf);
  fmark = ftell(outf);
  fwrite(dbuf, 1, 4, outf);     /* save space for packet length */
  RAND_bytes(dbuf, 8);
  dbuf[8] = dbuf[6];
  dbuf[9] = dbuf[7];
  ivc = 0;
  memset(ivec, 0, 8);
  idea_cfb64_encrypt(dbuf, dbuf, 10, &iks, ivec, &ivc, IDEA_ENCRYPT);
  fwrite(dbuf, 10, 1, outf);
  j = 10;
  ivc = 0;
  memcpy(ivec, &dbuf[2], 8);
  do {
    if ((len = fread(dbuf, 1, 4096, inf)))
      idea_cfb64_encrypt(dbuf, dbuf, len, &iks, ivec, &ivc, IDEA_ENCRYPT);
    j += len;
    fwrite(dbuf, 1, len, outf);
  } while (len == 4096);
  fseek(outf, fmark, SEEK_SET);
  fputc(j >> 24, outf);
  fputc(j >> 16, outf);
  fputc(j >> 8, outf);
  fputc(j, outf);
  return 0;
}
