package cryptix.pgp_examples;

import java.io.*;

import cryptix.math.RandomStream;
import cryptix.math.PseudoRandomStream;
import cryptix.crypt.*;
import cryptix.crypt.rsa.*;

import cryptix.pgp.*;

public final class esTest
{
	public static final void main( String argv[] )
		throws FileNotFoundException, IOException, DecryptException
	{
		FileInputStream in = new FileInputStream("secring.pgp");
		KeyRing publicKeyRing = new KeyRing( new DataInputStream( in ) );
		in.close();

		cryptix.crypt.rsa.SecretKey myKey = publicKeyRing.getUsersSecretKey("gary", argv[0]);

		String messageText = "The quick brown fox jumps over the lazy dog";
		String keySeed = "Some random data to seed PseudoRandomStream ^%$*&^$&!*!%&&^%";

		byte ideaKey[] = MD5.hash(keySeed);

		RandomStream rs = new PseudoRandomStream( SHA.hash( keySeed ) );

		System.err.println( "Creating PKE packet" );

		PublicKeyEncrypted PKE = new PublicKeyEncrypted ( myKey, ideaKey, rs );

		System.err.println( "Creating CKE packet" );
		byte buf[];
		// N.B. this is a binary file and thus a binary signature.
		LiteralData stuff = new LiteralData(buf = byteEncode( messageText ), "stuff.txt", 'b' );
		ByteArrayOutputStream out = new ByteArrayOutputStream( 4096 );
		DataOutputStream dout = new DataOutputStream( out );

		MD5 md = new MD5();
		md.add( stuff.data() ); // easy binary signature.

		//		  md.add( buf ); // easy binary signature.
		Signature sig = new Signature( myKey, md );

		PacketFactory.write( dout, sig );
		PacketFactory.write( dout, stuff );

		byte stuff_buf[] = out.toByteArray();

		ConvEncryptedData CKE = new ConvEncryptedData( stuff_buf , ideaKey, rs );
		System.err.println( "Writing file" );

		FileOutputStream fos = new FileOutputStream( "es-test.pgp" );
		DataOutputStream dos = new DataOutputStream( fos );
		PacketFactory.write( dos, PKE );
		PacketFactory.write( dos, CKE );
		fos.close();
	}

	private static byte[] byteEncode( String msg )
	{
		/**
		* These PGP classes work on byte arrays, not strings.
		* This function converts from one to the other.
		*@returns A byte array representing msg
		*/

		int len = msg.length();
		byte buf[];
		msg.getBytes( 0, len, buf = new byte[len], 0 );
		return buf;
	}
}
