import java.util.Random;
import java.awt.Event;

class RandSpinner implements Runnable {
static final boolean YIELDBUG = true; // true if yields won't let events run
StrongRandom rnd;
int delay;
boolean sleeper;

public RandSpinner (int delay, StrongRandom rnd, boolean sleeper)
{
    this.delay = delay;
    this.rnd = rnd;
    this.sleeper = sleeper;
}

public void run()
{
    if (sleeper) {
        for ( ; ; ) {
            try {Thread.sleep(delay);} catch (InterruptedException e) {}
            rnd.mixinb(rnd.count);
        }
    } else {
        for ( ; ; ) {
            rnd.count++;
            if (YIELDBUG) // less sleep than 5 shows same bug
                try {Thread.sleep(5);} catch (InterruptedException e) {}
            else
                Thread.yield();
        }
    }
}


}


public class StrongRandom extends Random {
static int BUFDATASIZE = 256;

// Hold random bytes to be returned
protected byte randdata[];
protected int randindex;

// Hold data fed back from one iteration of the hash to the next
protected byte feedback[];

// This array collects event and spinner data which is partially
// unpredictable.
protected byte bufdata[];
protected int bufptr;
protected int bufstart;

protected Digest hash;

protected RandSpinner spinner, sleeper;
protected Thread spinnerthread, sleeperthread;
public byte count;

public StrongRandom()
{
    this(System.currentTimeMillis());
}

public StrongRandom(long seed)
{
    init(seed, new MD5());
    startSpinner(50);
}

public StrongRandom(long seed, Digest hash)
{
    init (seed, hash);
}

protected void init(long seed, Digest hash)
{
    this.hash = hash;
    randdata = new byte[hash.outputLen()/2];
    feedback = new byte[hash.outputLen()/2];
    bufdata = new byte[BUFDATASIZE];
    setSeed(seed);
}

/*
synchronized public void setSeed(long seed)
{
    mixin((int)seed);
    mixin((int)(seed>>32));
}
*/

public int nextByte()
{
    int b = randdata[randindex++] & 0xff;
    if (randindex==randdata.length)
        hashbuffer();
    return b;
}

public int nextInt()
{
    return nextByte()<<24 | nextByte()<<16 | nextByte()<<8 | nextByte();
}

public long nextLong()
{
    // it's okay that the bottom word remains signed.
    return (long)nextInt()<<32 + nextInt();
}


public float nextFloat()
{
    int i = nextInt() & 0x3fffffff;
    return i / (float)0x40000000;
}

public double nextDouble()
{
    long l = nextLong() & 0x003fffffffffffffL;
    return l / (double)0x0040000000000000L;
}


public void startSpinner(int ms)
{
    RandSpinner spinner = new RandSpinner(ms, this, false);
    spinnerthread = new Thread(spinner);
    spinnerthread.setPriority(Thread.MIN_PRIORITY);     // let others run
    spinnerthread.start();
    RandSpinner sleeper = new RandSpinner(ms, this, true);
    sleeperthread = new Thread(sleeper);
    sleeperthread.start();
}

public void stopSpinner()
{
    spinnerthread.stop();
    sleeperthread.stop();
}


public void mixin(int data)
{
    mixinb((byte)data);
    mixinb((byte)(data>>8));
    mixinb((byte)(data>>16));
    mixinb((byte)(data>>24));
}


public synchronized void mixinb(byte bdata)
{
    bufdata[bufptr++] = bdata;
    if (bufptr >= bufdata.length)
        bufptr = 0;
    if (bufptr == bufstart)
        hashbuffer();
}

public void mixin (Event e)
{
    mixinb((byte)e.when);
    mixinb((byte)e.id);
    if (e.id==e.MOUSE_MOVE || e.id==e.MOUSE_DRAG ||
                e.id==e.MOUSE_ENTER || e.id==e.MOUSE_EXIT) {
        mixinb((byte)e.x);
        mixinb((byte)e.y);
    }
    if (e.id==e.KEY_PRESS)
        mixinb((byte)e.key);
}


private void hashbuffer()
{
    if (bufptr > bufstart) {
        hash.update(bufdata, bufstart, bufptr - bufstart);
//System.out.println("Hashing data (1): "+(bufptr-bufstart)+
//" bytes available");
    } else {
        hash.update(bufdata, bufstart, bufdata.length - bufstart);
        hash.update(bufdata, 0, bufptr);
//System.out.println("Hashing data (2): "+(bufdata.length-bufstart+bufptr)+
//" bytes available");
//System.out.println(bytes.BArrToStringBig(bufdata, 0, bufdata.length));
    }
    bufstart = bufptr;
    hash.update (feedback);
    byte digest[] = hash.getDigest();
    System.arraycopy(digest, 0, randdata, 0, randdata.length);
    System.arraycopy(digest, randdata.length, feedback, 0, feedback.length);
    hash.reset();
    randindex = 0;
}


}
