ORIGIN = PWB
ORIGIN_VER = 2.1.49
PROJ = PGP
PROJFILE = PGPPWB.MAK
DEBUG = 0

BSCMAKE  = bscmake
SBRPACK  = sbrpack
NMAKEBSC1  = set
NMAKEBSC2  = nmake
CC  = cl
CFLAGS_G  = /AL /W2 /DDYN_ALLOC /DSMALL_MEM /DMSDOS /BATCH /FR$*.sbr /Gt
CFLAGS_D  = /f /Od /Zi
CFLAGS_R  = /f- /Ot /Ol /Og /Oe /Oi /Gs
CXX  = cl
CXXFLAGS_G  = /W2 /BATCH /FR$*.sbr
CXXFLAGS_D  = /f /Zi /Od
CXXFLAGS_R  = /f- /Ot /Oi /Ol /Oe /Og /Gs
ASM  = ml
AFLAGS_G  = /Cp /W2 /WX /Zm /FR$*.sbr
AFLAGS_D  = /Zi
AFLAGS_R  = /nologo
MAPFILE_D  = NUL
MAPFILE_R  = NUL
LFLAGS_G  = /NOI /STACK:12288 /BATCH /ONERROR:NOEXE
LFLAGS_D  = /CO /FAR /PACKC
LFLAGS_R  = /EXE /FAR /PACKC
LINKER  = link
ILINK  = ilink
LRF  = echo > NUL
ILFLAGS  = /a /e
BRFLAGS  =  /o $(PROJ).bsc
BROWSE  = 1
PACK_SBRS  = 1

FILES  = 8086.ASM ARMOR.C CHARSET.C CONFIG.C CRYPTO.C CRYPTO.H FILEIO.C\
	FILEIO.H GENPRIME.C GENPRIME.H GETOPT.C IDEA.C IDEA.H KEYADD.C\
	KEYMAINT.C KEYMGMT.C KEYMGMT.H LANGUAGE.C LANGUAGE.H MD5.C MD5.H\
	MDFILE.C MDFILE.H MORE.C MPIIO.C MPILIB.C MPILIB.H PASSWD.C PGP.C\
	PGP.H RANDOM.C RANDOM.H RSAGEN.C RSAGEN.H STDLIB.H SYSTEM.C USUALS.H\
	ZBITS.C ZDEFLATE.C ZFILE_IO.C ZGLOBALS.C ZINFLATE.C ZIP.C ZIP.H\
	ZIPERR.H ZIPUP.C ZMATCH.ASM ZREVISIO.H ZTAILOR.H ZTREES.C ZUNZIP.C\
	ZUNZIP.H
OBJS  = 8086.obj ARMOR.obj CHARSET.obj CONFIG.obj CRYPTO.obj FILEIO.obj\
	GENPRIME.obj GETOPT.obj IDEA.obj KEYADD.obj KEYMAINT.obj KEYMGMT.obj\
	LANGUAGE.obj MD5.obj MDFILE.obj MORE.obj MPIIO.obj MPILIB.obj\
	PASSWD.obj PGP.obj RANDOM.obj RSAGEN.obj SYSTEM.obj ZBITS.obj\
	ZDEFLATE.obj ZFILE_IO.obj ZGLOBALS.obj ZINFLATE.obj ZIP.obj ZIPUP.obj\
	ZMATCH.obj ZTREES.obj ZUNZIP.obj
SBRS  = 8086.sbr ARMOR.sbr CHARSET.sbr CONFIG.sbr CRYPTO.sbr FILEIO.sbr\
	GENPRIME.sbr GETOPT.sbr IDEA.sbr KEYADD.sbr KEYMAINT.sbr KEYMGMT.sbr\
	LANGUAGE.sbr MD5.sbr MDFILE.sbr MORE.sbr MPIIO.sbr MPILIB.sbr\
	PASSWD.sbr PGP.sbr RANDOM.sbr RSAGEN.sbr SYSTEM.sbr ZBITS.sbr\
	ZDEFLATE.sbr ZFILE_IO.sbr ZGLOBALS.sbr ZINFLATE.sbr ZIP.sbr ZIPUP.sbr\
	ZMATCH.sbr ZTREES.sbr ZUNZIP.sbr

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES:
.SUFFIXES: .obj .sbr .c .asm

8086.obj : 8086.ASM
!IF $(DEBUG)
	$(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /Fo8086.obj 8086.ASM
!ELSE
	$(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /Fo8086.obj 8086.ASM
!ENDIF

8086.sbr : 8086.ASM
!IF $(DEBUG)
	$(ASM) /Zs $(AFLAGS_G) $(AFLAGS_D) /FR8086.sbr 8086.ASM
!ELSE
	$(ASM) /Zs $(AFLAGS_G) $(AFLAGS_R) /FR8086.sbr 8086.ASM
!ENDIF

ARMOR.obj : ARMOR.C MPILIB.H FILEIO.H mpiio.h LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoARMOR.obj ARMOR.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoARMOR.obj ARMOR.C
<<
!ENDIF

ARMOR.sbr : ARMOR.C MPILIB.H FILEIO.H mpiio.h LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRARMOR.sbr ARMOR.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRARMOR.sbr ARMOR.C
<<
!ENDIF

CHARSET.obj : CHARSET.C USUALS.H LANGUAGE.H FILEIO.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoCHARSET.obj CHARSET.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoCHARSET.obj CHARSET.C
<<
!ENDIF

CHARSET.sbr : CHARSET.C USUALS.H LANGUAGE.H FILEIO.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRCHARSET.sbr CHARSET.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRCHARSET.sbr CHARSET.C
<<
!ENDIF

CONFIG.obj : CONFIG.C USUALS.H PGP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoCONFIG.obj CONFIG.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoCONFIG.obj CONFIG.C
<<
!ENDIF

CONFIG.sbr : CONFIG.C USUALS.H PGP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRCONFIG.sbr CONFIG.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRCONFIG.sbr CONFIG.C
<<
!ENDIF

CRYPTO.obj : CRYPTO.C MPILIB.H mpiio.h RANDOM.H IDEA.H CRYPTO.H KEYMGMT.H\
	MDFILE.H FILEIO.H LANGUAGE.H PGP.H USUALS.H MD5.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoCRYPTO.obj CRYPTO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoCRYPTO.obj CRYPTO.C
<<
!ENDIF

CRYPTO.sbr : CRYPTO.C MPILIB.H mpiio.h RANDOM.H IDEA.H CRYPTO.H KEYMGMT.H\
	MDFILE.H FILEIO.H LANGUAGE.H PGP.H USUALS.H MD5.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRCRYPTO.sbr CRYPTO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRCRYPTO.sbr CRYPTO.C
<<
!ENDIF

FILEIO.obj : FILEIO.C RANDOM.H MPILIB.H mpiio.h FILEIO.H LANGUAGE.H PGP.H\
	USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoFILEIO.obj FILEIO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoFILEIO.obj FILEIO.C
<<
!ENDIF

FILEIO.sbr : FILEIO.C RANDOM.H MPILIB.H mpiio.h FILEIO.H LANGUAGE.H PGP.H\
	USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRFILEIO.sbr FILEIO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRFILEIO.sbr FILEIO.C
<<
!ENDIF

GENPRIME.obj : GENPRIME.C MPILIB.H GENPRIME.H RANDOM.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoGENPRIME.obj GENPRIME.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoGENPRIME.obj GENPRIME.C
<<
!ENDIF

GENPRIME.sbr : GENPRIME.C MPILIB.H GENPRIME.H RANDOM.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRGENPRIME.sbr GENPRIME.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRGENPRIME.sbr GENPRIME.C
<<
!ENDIF

GETOPT.obj : GETOPT.C
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoGETOPT.obj GETOPT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoGETOPT.obj GETOPT.C
<<
!ENDIF

GETOPT.sbr : GETOPT.C
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRGETOPT.sbr GETOPT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRGETOPT.sbr GETOPT.C
<<
!ENDIF

IDEA.obj : IDEA.C IDEA.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoIDEA.obj IDEA.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoIDEA.obj IDEA.C
<<
!ENDIF

IDEA.sbr : IDEA.C IDEA.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRIDEA.sbr IDEA.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRIDEA.sbr IDEA.C
<<
!ENDIF

KEYADD.obj : KEYADD.C MPILIB.H IDEA.H RANDOM.H CRYPTO.H FILEIO.H KEYMGMT.H\
	GENPRIME.H RSAGEN.H mpiio.h LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoKEYADD.obj KEYADD.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoKEYADD.obj KEYADD.C
<<
!ENDIF

KEYADD.sbr : KEYADD.C MPILIB.H IDEA.H RANDOM.H CRYPTO.H FILEIO.H KEYMGMT.H\
	GENPRIME.H RSAGEN.H mpiio.h LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRKEYADD.sbr KEYADD.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRKEYADD.sbr KEYADD.C
<<
!ENDIF

KEYMAINT.obj : KEYMAINT.C MPILIB.H RANDOM.H CRYPTO.H FILEIO.H KEYMGMT.H\
	mpiio.h LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoKEYMAINT.obj KEYMAINT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoKEYMAINT.obj KEYMAINT.C
<<
!ENDIF

KEYMAINT.sbr : KEYMAINT.C MPILIB.H RANDOM.H CRYPTO.H FILEIO.H KEYMGMT.H\
	mpiio.h LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRKEYMAINT.sbr KEYMAINT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRKEYMAINT.sbr KEYMAINT.C
<<
!ENDIF

KEYMGMT.obj : KEYMGMT.C MPILIB.H IDEA.H RANDOM.H CRYPTO.H FILEIO.H KEYMGMT.H\
	GENPRIME.H RSAGEN.H mpiio.h LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoKEYMGMT.obj KEYMGMT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoKEYMGMT.obj KEYMGMT.C
<<
!ENDIF

KEYMGMT.sbr : KEYMGMT.C MPILIB.H IDEA.H RANDOM.H CRYPTO.H FILEIO.H KEYMGMT.H\
	GENPRIME.H RSAGEN.H mpiio.h LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRKEYMGMT.sbr KEYMGMT.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRKEYMGMT.sbr KEYMGMT.C
<<
!ENDIF

LANGUAGE.obj : LANGUAGE.C USUALS.H FILEIO.H LANGUAGE.H PGP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoLANGUAGE.obj LANGUAGE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoLANGUAGE.obj LANGUAGE.C
<<
!ENDIF

LANGUAGE.sbr : LANGUAGE.C USUALS.H FILEIO.H LANGUAGE.H PGP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRLANGUAGE.sbr LANGUAGE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRLANGUAGE.sbr LANGUAGE.C
<<
!ENDIF

MD5.obj : MD5.C MD5.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoMD5.obj MD5.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoMD5.obj MD5.C
<<
!ENDIF

MD5.sbr : MD5.C MD5.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRMD5.sbr MD5.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRMD5.sbr MD5.C
<<
!ENDIF

MDFILE.obj : MDFILE.C MPILIB.H MDFILE.H LANGUAGE.H PGP.H USUALS.H MD5.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoMDFILE.obj MDFILE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoMDFILE.obj MDFILE.C
<<
!ENDIF

MDFILE.sbr : MDFILE.C MPILIB.H MDFILE.H LANGUAGE.H PGP.H USUALS.H MD5.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRMDFILE.sbr MDFILE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRMDFILE.sbr MDFILE.C
<<
!ENDIF

MORE.obj : MORE.C MPILIB.H LANGUAGE.H FILEIO.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoMORE.obj MORE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoMORE.obj MORE.C
<<
!ENDIF

MORE.sbr : MORE.C MPILIB.H LANGUAGE.H FILEIO.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRMORE.sbr MORE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRMORE.sbr MORE.C
<<
!ENDIF

MPIIO.obj : MPIIO.C MPILIB.H mpiio.h PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoMPIIO.obj MPIIO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoMPIIO.obj MPIIO.C
<<
!ENDIF

MPIIO.sbr : MPIIO.C MPILIB.H mpiio.h PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRMPIIO.sbr MPIIO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRMPIIO.sbr MPIIO.C
<<
!ENDIF

MPILIB.obj : MPILIB.C MPILIB.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoMPILIB.obj MPILIB.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoMPILIB.obj MPILIB.C
<<
!ENDIF

MPILIB.sbr : MPILIB.C MPILIB.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRMPILIB.sbr MPILIB.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRMPILIB.sbr MPILIB.C
<<
!ENDIF

PASSWD.obj : PASSWD.C RANDOM.H MD5.H LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoPASSWD.obj PASSWD.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoPASSWD.obj PASSWD.C
<<
!ENDIF

PASSWD.sbr : PASSWD.C RANDOM.H MD5.H LANGUAGE.H PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRPASSWD.sbr PASSWD.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRPASSWD.sbr PASSWD.C
<<
!ENDIF

PGP.obj : PGP.C MPILIB.H RANDOM.H CRYPTO.H FILEIO.H KEYMGMT.H LANGUAGE.H PGP.H\
	USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoPGP.obj PGP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoPGP.obj PGP.C
<<
!ENDIF

PGP.sbr : PGP.C MPILIB.H RANDOM.H CRYPTO.H FILEIO.H KEYMGMT.H LANGUAGE.H PGP.H\
	USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRPGP.sbr PGP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRPGP.sbr PGP.C
<<
!ENDIF

RANDOM.obj : RANDOM.C RANDOM.H LANGUAGE.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoRANDOM.obj RANDOM.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoRANDOM.obj RANDOM.C
<<
!ENDIF

RANDOM.sbr : RANDOM.C RANDOM.H LANGUAGE.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRRANDOM.sbr RANDOM.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRRANDOM.sbr RANDOM.C
<<
!ENDIF

RSAGEN.obj : RSAGEN.C MPILIB.H GENPRIME.H RSAGEN.H RANDOM.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoRSAGEN.obj RSAGEN.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoRSAGEN.obj RSAGEN.C
<<
!ENDIF

RSAGEN.sbr : RSAGEN.C MPILIB.H GENPRIME.H RSAGEN.H RANDOM.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRRSAGEN.sbr RSAGEN.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRRSAGEN.sbr RSAGEN.C
<<
!ENDIF

SYSTEM.obj : SYSTEM.C PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoSYSTEM.obj SYSTEM.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoSYSTEM.obj SYSTEM.C
<<
!ENDIF

SYSTEM.sbr : SYSTEM.C PGP.H USUALS.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRSYSTEM.sbr SYSTEM.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRSYSTEM.sbr SYSTEM.C
<<
!ENDIF

ZBITS.obj : ZBITS.C ZIP.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZBITS.obj ZBITS.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZBITS.obj ZBITS.C
<<
!ENDIF

ZBITS.sbr : ZBITS.C ZIP.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZBITS.sbr ZBITS.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZBITS.sbr ZBITS.C
<<
!ENDIF

ZDEFLATE.obj : ZDEFLATE.C ZIP.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZDEFLATE.obj ZDEFLATE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZDEFLATE.obj ZDEFLATE.C
<<
!ENDIF

ZDEFLATE.sbr : ZDEFLATE.C ZIP.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZDEFLATE.sbr ZDEFLATE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZDEFLATE.sbr ZDEFLATE.C
<<
!ENDIF

ZFILE_IO.obj : ZFILE_IO.C ZUNZIP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZFILE_IO.obj ZFILE_IO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZFILE_IO.obj ZFILE_IO.C
<<
!ENDIF

ZFILE_IO.sbr : ZFILE_IO.C ZUNZIP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZFILE_IO.sbr ZFILE_IO.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZFILE_IO.sbr ZFILE_IO.C
<<
!ENDIF

ZGLOBALS.obj : ZGLOBALS.C ZIP.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZGLOBALS.obj ZGLOBALS.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZGLOBALS.obj ZGLOBALS.C
<<
!ENDIF

ZGLOBALS.sbr : ZGLOBALS.C ZIP.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZGLOBALS.sbr ZGLOBALS.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZGLOBALS.sbr ZGLOBALS.C
<<
!ENDIF

ZINFLATE.obj : ZINFLATE.C ZUNZIP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZINFLATE.obj ZINFLATE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZINFLATE.obj ZINFLATE.C
<<
!ENDIF

ZINFLATE.sbr : ZINFLATE.C ZUNZIP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZINFLATE.sbr ZINFLATE.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZINFLATE.sbr ZINFLATE.C
<<
!ENDIF

ZIP.obj : ZIP.C USUALS.H FILEIO.H LANGUAGE.H PGP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZIP.obj ZIP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZIP.obj ZIP.C
<<
!ENDIF

ZIP.sbr : ZIP.C USUALS.H FILEIO.H LANGUAGE.H PGP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZIP.sbr ZIP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZIP.sbr ZIP.C
<<
!ENDIF

ZIPUP.obj : ZIPUP.C ZIP.H ZREVISIO.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZIPUP.obj ZIPUP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZIPUP.obj ZIPUP.C
<<
!ENDIF

ZIPUP.sbr : ZIPUP.C ZIP.H ZREVISIO.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZIPUP.sbr ZIPUP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZIPUP.sbr ZIPUP.C
<<
!ENDIF

ZMATCH.obj : ZMATCH.ASM
!IF $(DEBUG)
	$(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /FoZMATCH.obj ZMATCH.ASM
!ELSE
	$(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /FoZMATCH.obj ZMATCH.ASM
!ENDIF

ZMATCH.sbr : ZMATCH.ASM
!IF $(DEBUG)
	$(ASM) /Zs $(AFLAGS_G) $(AFLAGS_D) /FRZMATCH.sbr ZMATCH.ASM
!ELSE
	$(ASM) /Zs $(AFLAGS_G) $(AFLAGS_R) /FRZMATCH.sbr ZMATCH.ASM
!ENDIF

ZTREES.obj : ZTREES.C ZIP.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZTREES.obj ZTREES.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZTREES.obj ZTREES.C
<<
!ENDIF

ZTREES.sbr : ZTREES.C ZIP.H ZTAILOR.H ZIPERR.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZTREES.sbr ZTREES.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZTREES.sbr ZTREES.C
<<
!ENDIF

ZUNZIP.obj : ZUNZIP.C ZUNZIP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /FoZUNZIP.obj ZUNZIP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /FoZUNZIP.obj ZUNZIP.C
<<
!ENDIF

ZUNZIP.sbr : ZUNZIP.C ZUNZIP.H
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FRZUNZIP.sbr ZUNZIP.C
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FRZUNZIP.sbr ZUNZIP.C
<<
!ENDIF


$(PROJ).bsc : $(SBRS)
	$(BSCMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).exe : $(OBJS)
	-$(NMAKEBSC1) MAKEFLAGS=
	-$(NMAKEBSC2) $(NMFLAGS) -f $(PROJFILE) $(PROJ).bsc
!IF $(DEBUG)
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LIBS: = +^
) +
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
	$(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LIBS: = +^
) +
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
	$(LINKER) @$(PROJ).lrf


.c.obj :
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_D) /Fo$@ $<
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/c $(CFLAGS_G)
$(CFLAGS_R) /Fo$@ $<
<<
!ENDIF

.c.sbr :
!IF $(DEBUG)
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_D) /FR$@ $<
<<
!ELSE
	@$(CC) @<<$(PROJ).rsp
/Zs $(CFLAGS_G)
$(CFLAGS_R) /FR$@ $<
<<
!ENDIF

.asm.obj :
!IF $(DEBUG)
	$(ASM) /c $(AFLAGS_G) $(AFLAGS_D) /Fo$@ $<
!ELSE
	$(ASM) /c $(AFLAGS_G) $(AFLAGS_R) /Fo$@ $<
!ENDIF

.asm.sbr :
!IF $(DEBUG)
	$(ASM) /Zs $(AFLAGS_G) $(AFLAGS_D) /FR$@ $<
!ELSE
	$(ASM) /Zs $(AFLAGS_G) $(AFLAGS_R) /FR$@ $<
!ENDIF


run: $(PROJ).exe
	$(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
	CV $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
